/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.MatlabArrayTableModel;
import com.mathworks.mlwidgets.array.UpdatableData;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.spreadsheet.IClipboardOpProvider;
import com.mathworks.widgets.spreadsheet.IPrintingOpProvider;
import com.mathworks.widgets.spreadsheet.ISaveOpProvider;
import com.mathworks.widgets.spreadsheet.ISelectionOpProvider;
import com.mathworks.widgets.text.print.MultiHeaderTextPrinter;
import com.mathworks.widgets.text.print.PrintUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Scanner;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class UnsupportedClassTextArea
extends MJTextArea
implements IClipboardOpProvider,
ISelectionOpProvider,
ISaveOpProvider,
IPrintingOpProvider,
UpdatableData {
    protected final WorkspaceVariable fVar;
    protected Color fNormalForegroundColor;
    private boolean fCurrentlyDisplayingError = false;
    private final MJAbstractAction fSaveAction;
    private final TextAreaCopyAction fCopyAction;
    private final SelectAllAction fSelectAllAction;
    private final MJAbstractAction fPageSetupAction;
    private final MJAbstractAction fPrintAction;
    private final MJAbstractAction fPrintSelectionAction;
    private final MInputMap fInputMap;
    private static final String DOESNOTEXISTPLACEHOLDER = "DOESNOTEXISTPLACEHOLDER";

    UnsupportedClassTextArea(MatlabArrayTableModel matlabArrayTableModel) {
        this(matlabArrayTableModel.getVariable());
    }

    UnsupportedClassTextArea(WorkspaceVariable workspaceVariable) {
        this.fVar = workspaceVariable;
        this.fNormalForegroundColor = this.getForeground();
        this.setEditable(false);
        TextAreaActionProvider textAreaActionProvider = new TextAreaActionProvider();
        this.fInputMap = MInputMap.createMInputMap((JComponent)((Object)this));
        this.fSaveAction = ArrayUtils.getSaveAction(this.fVar.getWorkspaceVariableNameTemp(), textAreaActionProvider);
        this.fCopyAction = new TextAreaCopyAction();
        this.fSelectAllAction = new SelectAllAction();
        this.fPageSetupAction = new ArrayUtils.PageSetupAction(textAreaActionProvider);
        this.fPrintSelectionAction = new TextAreaPrintSelectionAction(textAreaActionProvider);
        this.fPrintAction = new ArrayUtils.PrintAction(textAreaActionProvider);
    }

    public String getVariableName() {
        return this.fVar.getVariableName();
    }

    private void updateDataDefaultWorkspace() {
        String string = "builtin('exist','" + this.fVar + "', 'var')";
        String string2 = "builtin('exist',arrayviewfunc('getBaseVariableName', '" + this.fVar + "'), 'var')";
        String string3 = "arrayviewfunc('isPossibleIndexedEntityName', '" + this.fVar + "')";
        String string4 = "eval(['arrayviewfunc(''valueHasAppropriateIndexing'', ''" + this.fVar + "'',' arrayviewfunc('getBaseVariableName', '" + this.fVar + "') ')' ])";
        String string5 = string + " || " + '(' + string2 + " && " + string3 + " && " + string4 + ')';
        if (ArrayUtils.isLogging()) {
            ArrayUtils.log(this.getClass(), 1, string5);
        }
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("eval", (Object[])new String[]{string5}, 1, (CompletionObserver)new PITACO());
    }

    private void updateDataNonDefaultWorkspace() {
        String string = "arrayviewfunc";
        Object[] objectArray = new Object[]{"uctaUpdateData", this.fVar};
        if (ArrayUtils.isLogging()) {
            ArrayUtils.log(this.getClass(), 1, string + Arrays.toString(objectArray));
        }
        WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval(string, objectArray, 1, (CompletionObserver)new PITACO());
    }

    @Override
    public void updateData() {
        if (Matlab.isMatlabAvailable()) {
            if (this.fVar.isDefaultWorkspace()) {
                this.updateDataDefaultWorkspace();
            } else {
                this.updateDataNonDefaultWorkspace();
            }
        }
    }

    void rename(String string) {
        this.fVar.setVariableName(string);
        this.updateData();
    }

    void clear() {
        this.setText("");
    }

    public void setForeground(Color color) {
        this.fNormalForegroundColor = color;
        if (!this.fCurrentlyDisplayingError) {
            super.setForeground(color);
        }
    }

    public Color getForeground() {
        return this.fNormalForegroundColor;
    }

    void setNonExistentVariableName() {
        this.setText(ArrayUtils.getResource("status.Nonexistent.Named", this.fVar.getWorkspaceVariableNameTemp()));
    }

    public final Action getCutAction() {
        return null;
    }

    public final Action getCopyAction() {
        return this.fCopyAction;
    }

    public final Action getPasteAction() {
        return null;
    }

    public final Action getExcelPasteAction() {
        return null;
    }

    public final Action getSelectAllAction() {
        return this.fSelectAllAction;
    }

    private void registerWithInputMap(MJAbstractAction mJAbstractAction) {
        assert (MatlabKeyBindings.getManager().containsActionAndContext((Action)mJAbstractAction)) : "Action is not registered in keybinding manager";
        MatlabKeyBindings.getManager().addKeyBindings((ExtendedAction)mJAbstractAction, (ExtendedInputMap)this.fInputMap);
        MatlabKeyBindings.getManager().addToActionMap((ExtendedAction)mJAbstractAction, this.getActionMap());
    }

    public final Action getSaveAction() {
        return this.fSaveAction;
    }

    private static String getMainHeaderText(String string) {
        return ArrayUtils.getResource("printing.pageTitle", string) + "\t" + ArrayUtils.getResource("printing.header.pg") + " ";
    }

    protected void printTextArea() {
        String string = this.getVariableName();
        MultiHeaderTextPrinter.printPlainText((JTextArea)((Object)this), (Font)this.getFont(), (String)ArrayUtils.getResource("printing.pageTitle", string), (String)UnsupportedClassTextArea.getMainHeaderText(string));
    }

    protected void printSelection() {
        String string = this.getVariableName();
        MultiHeaderTextPrinter.printPlainTextSelection((JTextArea)((Object)this), (Font)this.getFont(), (String)ArrayUtils.getResource("printing.pageTitle", string), (String)UnsupportedClassTextArea.getMainHeaderText(string));
    }

    protected void pageSetup() {
        PrintUtils.showPageSetupDialog((String)ArrayUtils.getResource("printing.pageTitle"));
    }

    public final Action getPrintAction() {
        return this.fPrintAction;
    }

    public final Action getPrintSelectionAction() {
        return this.fPrintSelectionAction;
    }

    public final Action getPageSetupAction() {
        return this.fPageSetupAction;
    }

    private class TextAreaActionProvider
    implements ArrayUtils.PrintActionProvider,
    ArrayUtils.SaveActionProvider {
        private TextAreaActionProvider() {
        }

        @Override
        public void printSelection() {
            UnsupportedClassTextArea.this.printSelection();
        }

        @Override
        public void print() {
            UnsupportedClassTextArea.this.printTextArea();
        }

        @Override
        public void pageSetup() {
            UnsupportedClassTextArea.this.pageSetup();
        }

        @Override
        public void registerWithInputAndActionMaps(MJAbstractAction mJAbstractAction) {
            UnsupportedClassTextArea.this.registerWithInputMap(mJAbstractAction);
        }

        @Override
        public Component getComponentForDialog() {
            return UnsupportedClassTextArea.this;
        }
    }

    private class TextAreaPrintSelectionAction
    extends ArrayUtils.PrintSelectionAction
    implements CaretListener {
        TextAreaPrintSelectionAction(ArrayUtils.PrintActionProvider printActionProvider) {
            super(printActionProvider);
            UnsupportedClassTextArea.this.addCaretListener(this);
            this.updateEnabledState();
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            this.updateEnabledState();
        }

        private void updateEnabledState() {
            this.setEnabled(UnsupportedClassTextArea.this.getSelectedText() != null);
        }
    }

    private class SelectAllAction
    extends ArrayUtils.BaseAction {
        SelectAllAction() {
            super("select-all", "SelectAll");
            UnsupportedClassTextArea.this.registerWithInputMap(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            UnsupportedClassTextArea.this.selectAll();
        }
    }

    private class TextAreaCopyAction
    extends MJAbstractAction
    implements CaretListener {
        TextAreaCopyAction() {
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("SpreadsheetTable", "copy-to-clipboard", (ExtendedAction)this);
            this.setComponentName("Copy");
            UnsupportedClassTextArea.this.registerWithInputMap(this);
            UnsupportedClassTextArea.this.addCaretListener(this);
            this.updateEnabledState();
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            this.updateEnabledState();
        }

        private void updateEnabledState() {
            this.setEnabled(UnsupportedClassTextArea.this.getSelectedText() != null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = UnsupportedClassTextArea.this.getSelectedText();
            if (PlatformInfo.isXWindows()) {
                MJClipboard.getMJClipboard().setXSelectionContents(string);
            }
            MJClipboard.getMJClipboard().setContents(string, null);
        }
    }

    private class ValueCO
    implements CompletionObserver {
        private ValueCO() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void completed(int n, Object object) {
            if (Matlab.getExecutionStatus((int)n) == 0) {
                UnsupportedClassTextArea.this.fCurrentlyDisplayingError = false;
                UnsupportedClassTextArea.this.setForeground(UnsupportedClassTextArea.this.fNormalForegroundColor);
            } else {
                UnsupportedClassTextArea.this.fCurrentlyDisplayingError = true;
                UnsupportedClassTextArea.this.setForeground(Color.red);
            }
            String string = object instanceof String ? (((String)object).startsWith(UnsupportedClassTextArea.DOESNOTEXISTPLACEHOLDER) ? ArrayUtils.getResource("status.Nonexistent.Named", UnsupportedClassTextArea.this.fVar.getWorkspaceVariableNameTemp()) : (String)object) : ArrayUtils.getResource("error.unexpected");
            StringBuilder stringBuilder = new StringBuilder();
            try (Scanner scanner = new Scanner(string);){
                while (scanner.hasNextLine()) {
                    String string2 = scanner.nextLine();
                    if (string2.contains("<a href=\"matlab:")) continue;
                    stringBuilder.append(string2).append(System.getProperty("line.separator"));
                }
            }
            UnsupportedClassTextArea.this.setText(stringBuilder.toString());
        }
    }

    private class PITACO
    implements CompletionObserver {
        private PITACO() {
        }

        public void completed(int n, Object object) {
            ValueCO valueCO = new ValueCO();
            if (Matlab.getExecutionStatus((int)n) != 0 || !(object instanceof boolean[])) {
                valueCO.completed(n, object);
                return;
            }
            boolean[] blArray = (boolean[])object;
            if (blArray.length != 1) {
                valueCO.completed(n, ArrayUtils.getResource("error.unexpected"));
                return;
            }
            if (!blArray[0]) {
                valueCO.completed(n, UnsupportedClassTextArea.DOESNOTEXISTPLACEHOLDER);
                return;
            }
            String string = Integer.toString(524288);
            if (UnsupportedClassTextArea.this.fVar.isDefaultWorkspace()) {
                String string2 = "arrayviewfunc('getUnsupportedString', '" + ArrayUtils.getResource("status.TooLarge", string) + "'" + "," + " '" + ArrayUtils.getResource("status.CannotReference") + "'," + string + "," + UnsupportedClassTextArea.this.fVar.getWorkspaceVariableNameTemp() + ");";
                if (ArrayUtils.isLogging()) {
                    ArrayUtils.log(this.getClass(), 2, string2);
                }
                WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval("eval", (Object[])new String[]{string2}, 1, (CompletionObserver)valueCO);
            } else {
                String string3 = "arrayviewfunc";
                Object[] objectArray = new Object[]{"getUnsupportedVariableString", ArrayUtils.getResource("status.TooLarge", string), string, UnsupportedClassTextArea.this.fVar};
                if (ArrayUtils.isLogging()) {
                    ArrayUtils.log(this.getClass(), 1, string3 + Arrays.toString(objectArray));
                }
                WorkspaceMCRProvider.getMCRForWorkspaceRefresh().feval(string3, objectArray, 1, (CompletionObserver)new PITACO());
            }
        }
    }
}

