/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.ArrayEditorProvider;
import com.mathworks.mlwidgets.array.CalendarDurationEditorProvider;
import com.mathworks.mlwidgets.array.CategoricalVariableProvider;
import com.mathworks.mlwidgets.array.CellEditorProvider;
import com.mathworks.mlwidgets.array.CharArrayEditorProvider;
import com.mathworks.mlwidgets.array.DatasetEditorProvider;
import com.mathworks.mlwidgets.array.DatetimeEditorProvider;
import com.mathworks.mlwidgets.array.DurationEditorProvider;
import com.mathworks.mlwidgets.array.NonExistentVariableProvider;
import com.mathworks.mlwidgets.array.ObjArrayEditorProvider;
import com.mathworks.mlwidgets.array.ReadonlyArrayEditorProvider;
import com.mathworks.mlwidgets.array.StructArrayEditorProvider;
import com.mathworks.mlwidgets.array.TableObjectProvider;
import com.mathworks.mlwidgets.array.UnsupportedEditorProvider;
import com.mathworks.mlwidgets.array.ValueEditorProvider;
import com.mathworks.mlwidgets.array.ValueMetaInfo;
import com.mathworks.mlwidgets.array.editors.MCOSEditorProvider;
import com.mathworks.mlwidgets.array.editors.StructureEditorProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.Nullable;

public class ValueEditorProviderRegistry {
    private static final String TIMESERIES_CLASS = "com.mathworks.toolbox.timeseries.TimeSeriesArrayEditorProvider";
    private static final int MAX_COLUMNS_TO_DISPLAY = 5000;

    private ValueEditorProviderRegistry() {
    }

    static void renameValueEditorProvider(String string, ValueEditorProvider valueEditorProvider) {
        valueEditorProvider.rename(string);
    }

    static ValueEditorProvider getValueEditorProvider(WorkspaceVariable workspaceVariable, ValueMetaInfo valueMetaInfo, ValueEditorProvider valueEditorProvider) {
        int n = valueMetaInfo.getAttributes();
        int n2 = valueMetaInfo.getDims();
        if ((n & 2) == 2 || n2 > 2) {
            return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, valueEditorProvider);
        }
        int n3 = valueMetaInfo.getClassID();
        int n4 = valueMetaInfo.getRowCount();
        int n5 = valueMetaInfo.getColumnCount();
        switch (n3) {
            case 1: {
                if (n4 > 0 && n5 > 0 && n5 <= 10000 || n4 == 0 && n5 == 0) {
                    return ValueEditorProviderRegistry.getCellViewer(workspaceVariable, valueEditorProvider, valueMetaInfo);
                }
                return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, valueEditorProvider);
            }
            case 2: {
                if (n4 == 1) {
                    return ValueEditorProviderRegistry.getStructureViewer(workspaceVariable, valueEditorProvider);
                }
                if (n4 == 0 || n5 == 0) {
                    return ValueEditorProviderRegistry.getObjArrayViewer(workspaceVariable, valueEditorProvider);
                }
                return ValueEditorProviderRegistry.getStructArrayViewer(workspaceVariable, valueEditorProvider, valueMetaInfo);
            }
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                return ValueEditorProviderRegistry.getArrayViewer(workspaceVariable, valueEditorProvider, valueMetaInfo);
            }
            case 4: {
                if (n4 == 1) {
                    return ValueEditorProviderRegistry.getCharArrayViewer(workspaceVariable, valueEditorProvider);
                }
                return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, valueEditorProvider);
            }
        }
        String string = valueMetaInfo.getClassString();
        if (string.equals("dataset")) {
            if (n4 > 0 && n5 > 0 && n5 < 5000 || n4 == 0 && n5 == 0) {
                return ValueEditorProviderRegistry.getDatasetArrayViewer(workspaceVariable, valueEditorProvider, valueMetaInfo);
            }
            return ValueEditorProviderRegistry.getMCOSViewer(workspaceVariable, valueEditorProvider);
        }
        if (string.equals("table")) {
            if (n4 > 0 && n5 > 0 && n5 < 5000 || n4 == 0 && n5 == 0) {
                return ValueEditorProviderRegistry.getTableObjectArrayViewer(workspaceVariable, valueEditorProvider, valueMetaInfo);
            }
            return ValueEditorProviderRegistry.getMCOSViewer(workspaceVariable, valueEditorProvider);
        }
        if (string.equals("nominal") || string.equals("ordinal") || string.equals("categorical")) {
            if (n4 > 0 && n5 > 0 && n5 < 5000 || n4 == 0 && n5 == 0) {
                return ValueEditorProviderRegistry.getCategoicalArrayViewer(workspaceVariable, valueEditorProvider, valueMetaInfo);
            }
            return ValueEditorProviderRegistry.getMCOSViewer(workspaceVariable, valueEditorProvider);
        }
        if (string.equals("datetime")) {
            return ValueEditorProviderRegistry.getDatetimeArrayViewer(workspaceVariable, valueEditorProvider, valueMetaInfo);
        }
        if (string.equals("duration")) {
            return ValueEditorProviderRegistry.getDurationArrayViewer(workspaceVariable, valueEditorProvider, valueMetaInfo);
        }
        if (string.equals("calendarDuration")) {
            return ValueEditorProviderRegistry.getCalendarDurationArrayViewer(workspaceVariable, valueEditorProvider, valueMetaInfo);
        }
        if (string.equals("timeseries")) {
            return ValueEditorProviderRegistry.getTimeseriesViewer(workspaceVariable, valueEditorProvider);
        }
        if (string.equals("embedded.fi") && (n4 > 1 || n5 > 1)) {
            return ValueEditorProviderRegistry.getReadonlyArrayViewer(workspaceVariable, valueEditorProvider, valueMetaInfo);
        }
        if (ValueEditorProviderRegistry.revertToUnsupportedForClass(valueMetaInfo)) {
            return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, valueEditorProvider);
        }
        if (n4 > 1 || n5 > 1) {
            return ValueEditorProviderRegistry.getObjArrayViewer(workspaceVariable, valueEditorProvider);
        }
        if (valueMetaInfo.isMCOS()) {
            return ValueEditorProviderRegistry.getMCOSViewer(workspaceVariable, valueEditorProvider);
        }
        if (valueMetaInfo.isNonexistentInstance()) {
            return ValueEditorProviderRegistry.getNonExistentVariableProvider(workspaceVariable, valueEditorProvider);
        }
        return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, valueEditorProvider);
    }

    private static boolean revertToUnsupportedForClass(ValueMetaInfo valueMetaInfo) {
        String string = valueMetaInfo.getClassString();
        return valueMetaInfo.isSystemObject() || string.equals("fints") || string.equals("distributed") || string.equalsIgnoreCase("gpuarray");
    }

    private static UnsupportedEditorProvider getUnsupportedViewer(WorkspaceVariable workspaceVariable, @Nullable ValueEditorProvider valueEditorProvider) {
        if (valueEditorProvider instanceof UnsupportedEditorProvider) {
            return (UnsupportedEditorProvider)valueEditorProvider;
        }
        return UnsupportedEditorProvider.createProvider(workspaceVariable);
    }

    private static NonExistentVariableProvider getNonExistentVariableProvider(WorkspaceVariable workspaceVariable, @Nullable ValueEditorProvider valueEditorProvider) {
        if (valueEditorProvider instanceof NonExistentVariableProvider) {
            return (NonExistentVariableProvider)valueEditorProvider;
        }
        return NonExistentVariableProvider.createProvider(workspaceVariable);
    }

    private static CellEditorProvider getCellViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider, ValueMetaInfo valueMetaInfo) {
        if (valueEditorProvider instanceof CellEditorProvider) {
            CellEditorProvider cellEditorProvider = (CellEditorProvider)valueEditorProvider;
            cellEditorProvider.removeEmptyRowsAndColumns(valueMetaInfo);
            return cellEditorProvider;
        }
        return CellEditorProvider.createProvider(workspaceVariable);
    }

    private static ObjArrayEditorProvider getObjArrayViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider) {
        if (valueEditorProvider instanceof ObjArrayEditorProvider) {
            return (ObjArrayEditorProvider)valueEditorProvider;
        }
        return ObjArrayEditorProvider.createProvider(workspaceVariable);
    }

    private static ValueEditorProvider getDatasetArrayViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider, ValueMetaInfo valueMetaInfo) {
        if (valueEditorProvider instanceof DatasetEditorProvider) {
            DatasetEditorProvider datasetEditorProvider = (DatasetEditorProvider)valueEditorProvider;
            datasetEditorProvider.removeEmptyRowsAndColumns(valueMetaInfo);
            return datasetEditorProvider;
        }
        if (!workspaceVariable.isDefaultWorkspace()) {
            return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, null);
        }
        return DatasetEditorProvider.createProvider(workspaceVariable);
    }

    private static ValueEditorProvider getCategoicalArrayViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider, ValueMetaInfo valueMetaInfo) {
        if (valueEditorProvider instanceof CategoricalVariableProvider) {
            CategoricalVariableProvider categoricalVariableProvider = (CategoricalVariableProvider)valueEditorProvider;
            categoricalVariableProvider.removeEmptyRowsAndColumns(valueMetaInfo);
            return categoricalVariableProvider;
        }
        if (!workspaceVariable.isDefaultWorkspace()) {
            return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, null);
        }
        return CategoricalVariableProvider.createProvider(workspaceVariable);
    }

    private static StructureEditorProvider getStructureViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider) {
        if (valueEditorProvider instanceof StructureEditorProvider) {
            return (StructureEditorProvider)valueEditorProvider;
        }
        return StructureEditorProvider.createProvider(workspaceVariable);
    }

    private static StructArrayEditorProvider getStructArrayViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider, ValueMetaInfo valueMetaInfo) {
        if (valueEditorProvider instanceof StructArrayEditorProvider) {
            StructArrayEditorProvider structArrayEditorProvider = (StructArrayEditorProvider)valueEditorProvider;
            structArrayEditorProvider.removeEmptyRowsAndColumns(valueMetaInfo);
            return structArrayEditorProvider;
        }
        return StructArrayEditorProvider.createProvider(workspaceVariable);
    }

    private static ArrayEditorProvider getArrayViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider, ValueMetaInfo valueMetaInfo) {
        if (valueEditorProvider instanceof CharArrayEditorProvider) {
            return ArrayEditorProvider.createProvider(workspaceVariable);
        }
        if (valueEditorProvider instanceof ArrayEditorProvider) {
            ArrayEditorProvider arrayEditorProvider = (ArrayEditorProvider)valueEditorProvider;
            arrayEditorProvider.removeEmptyRowsAndColumns(valueMetaInfo);
            return arrayEditorProvider;
        }
        return ArrayEditorProvider.createProvider(workspaceVariable);
    }

    private static ArrayEditorProvider getReadonlyArrayViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider, ValueMetaInfo valueMetaInfo) {
        if (valueEditorProvider instanceof CharArrayEditorProvider) {
            return ReadonlyArrayEditorProvider.createProvider(workspaceVariable);
        }
        if (valueEditorProvider instanceof ReadonlyArrayEditorProvider) {
            ArrayEditorProvider arrayEditorProvider = (ArrayEditorProvider)valueEditorProvider;
            arrayEditorProvider.removeEmptyRowsAndColumns(valueMetaInfo);
            return arrayEditorProvider;
        }
        return ReadonlyArrayEditorProvider.createProvider(workspaceVariable);
    }

    private static ValueEditorProvider getTableObjectArrayViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider, ValueMetaInfo valueMetaInfo) {
        if (valueEditorProvider instanceof TableObjectProvider) {
            TableObjectProvider tableObjectProvider = (TableObjectProvider)valueEditorProvider;
            tableObjectProvider.removeEmptyRowsAndColumns(valueMetaInfo);
            return tableObjectProvider;
        }
        if (!workspaceVariable.isDefaultWorkspace()) {
            return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, null);
        }
        return TableObjectProvider.createProvider(workspaceVariable);
    }

    private static CharArrayEditorProvider getCharArrayViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider) {
        if (valueEditorProvider instanceof CharArrayEditorProvider) {
            return (CharArrayEditorProvider)valueEditorProvider;
        }
        return CharArrayEditorProvider.createProvider(workspaceVariable);
    }

    private static MCOSEditorProvider getMCOSViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider) {
        if (valueEditorProvider instanceof MCOSEditorProvider) {
            return (MCOSEditorProvider)valueEditorProvider;
        }
        return MCOSEditorProvider.createProvider(workspaceVariable);
    }

    private static ValueEditorProvider getTimeseriesViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider) {
        if (ValueEditorProviderRegistry.isTimeseriesEditorProvider(valueEditorProvider)) {
            return valueEditorProvider;
        }
        if (workspaceVariable.getWorkspaceID() != 0) {
            return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, null);
        }
        ValueEditorProvider valueEditorProvider2 = ValueEditorProviderRegistry.createTimeseriesEditorProvider(workspaceVariable);
        return valueEditorProvider2 == null ? ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, null) : valueEditorProvider2;
    }

    private static boolean isTimeseriesEditorProvider(ValueEditorProvider valueEditorProvider) {
        return valueEditorProvider != null && valueEditorProvider.getClass().getName().equals(TIMESERIES_CLASS);
    }

    private static ValueEditorProvider createTimeseriesEditorProvider(WorkspaceVariable workspaceVariable) {
        try {
            Class<?> clazz = Class.forName(TIMESERIES_CLASS);
            Class<ValueEditorProvider> clazz2 = clazz.asSubclass(ValueEditorProvider.class);
            Constructor<ValueEditorProvider> constructor = clazz2.getConstructor(String.class);
            return constructor.newInstance(workspaceVariable.getWorkspaceVariableNameTemp());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    private static ValueEditorProvider getDatetimeArrayViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider, ValueMetaInfo valueMetaInfo) {
        if (valueEditorProvider instanceof DatetimeEditorProvider) {
            DatetimeEditorProvider datetimeEditorProvider = (DatetimeEditorProvider)valueEditorProvider;
            datetimeEditorProvider.removeEmptyRowsAndColumns(valueMetaInfo);
            return datetimeEditorProvider;
        }
        if (!workspaceVariable.isDefaultWorkspace()) {
            return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, null);
        }
        return DatetimeEditorProvider.createProvider(workspaceVariable);
    }

    private static ValueEditorProvider getDurationArrayViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider, ValueMetaInfo valueMetaInfo) {
        if (valueEditorProvider instanceof DurationEditorProvider) {
            DurationEditorProvider durationEditorProvider = (DurationEditorProvider)valueEditorProvider;
            durationEditorProvider.removeEmptyRowsAndColumns(valueMetaInfo);
            return durationEditorProvider;
        }
        if (!workspaceVariable.isDefaultWorkspace()) {
            return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, null);
        }
        return DurationEditorProvider.createDurationProvider(workspaceVariable);
    }

    private static ValueEditorProvider getCalendarDurationArrayViewer(WorkspaceVariable workspaceVariable, ValueEditorProvider valueEditorProvider, ValueMetaInfo valueMetaInfo) {
        if (valueEditorProvider instanceof CalendarDurationEditorProvider) {
            CalendarDurationEditorProvider calendarDurationEditorProvider = (CalendarDurationEditorProvider)valueEditorProvider;
            calendarDurationEditorProvider.removeEmptyRowsAndColumns(valueMetaInfo);
            return calendarDurationEditorProvider;
        }
        if (!workspaceVariable.isDefaultWorkspace()) {
            return ValueEditorProviderRegistry.getUnsupportedViewer(workspaceVariable, null);
        }
        return CalendarDurationEditorProvider.createCalDurProvider(workspaceVariable);
    }
}

