/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.configeditor;

import com.mathworks.jmi.MatlabPath;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.data.PublishConfiguration;
import com.mathworks.mlwidgets.configeditor.data.PublishOptions;
import com.mathworks.mlwidgets.dialog.filters.MatlabProductFileExtensionFilter;
import com.mathworks.mwswing.FilePatternFilter;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import java.io.File;
import java.io.InputStream;
import java.util.ResourceBundle;

public final class ConfigurationUtils {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle(ConfigurationUtils.class.getPackage().getName() + ".resources.RES_Config_Editor");
    private static MJFileChooserPerPlatform sFileChooser;

    private ConfigurationUtils() {
    }

    public static String lookup(String string) {
        return BUNDLE.getString(string);
    }

    public static synchronized MJFileChooserPerPlatform getFileChooser() {
        if (sFileChooser == null) {
            sFileChooser = new MJFileChooserPerPlatform();
            sFileChooser.addChoosableFileFilter((FilePatternFilter)MatlabProductFileExtensionFilter.getMatlabCodeFileFilter());
            sFileChooser.setAcceptAllFileFilterUsed(false);
            sFileChooser.setFileMustExist(true);
        }
        return sFileChooser;
    }

    public static synchronized MJFileChooserPerPlatform getFileChooser(File file) {
        ConfigurationUtils.getFileChooser();
        sFileChooser.setCurrentDirectory(file);
        sFileChooser.setSelectedFile(file);
        return sFileChooser;
    }

    public static InputStream getPublishPropertiesXMLInputStream() {
        return ConfigurationUtils.class.getResourceAsStream("resources/publish_properties.xml");
    }

    public static String generateDefaultMatlabExpression(File file) {
        return ConfigurationUtils.lookup("configuration.example") + MatlabPath.getQualifiedFunctionOrMethodName((File)file);
    }

    public static String getConfigurationNameOrFileName(File file, AbstractFileConfiguration.Type<?> type) {
        String string = file.getName();
        Object obj = ConfigurationManager.getInstance().getMostRecentlyActionedConfigurationForFileOrDefault(file, type, false, false);
        if (obj != null) {
            string = ((AbstractFileConfiguration)obj).getName();
        }
        return string;
    }

    public static File getDefaultPublishOuputLocation(PublishConfiguration publishConfiguration) {
        return new File(publishConfiguration.getAssociatedFile().getParentFile(), "html");
    }

    public static PublishOptions.ImageFormat[] getDefaultImageFormat(PublishOptions.FigureCaptureMethod figureCaptureMethod, PublishOptions.FileFormat fileFormat) {
        if (figureCaptureMethod == null) {
            throw new IllegalArgumentException("The figure capture method cannot be null.");
        }
        if (fileFormat == null) {
            throw new IllegalArgumentException("The file format cannot be null.");
        }
        PublishOptions.ImageFormat[] imageFormatArray = fileFormat == PublishOptions.FileFormat.LATEX && figureCaptureMethod == PublishOptions.FigureCaptureMethod.ENTIREGUIWINDOW ? new PublishOptions.ImageFormat[]{PublishOptions.ImageFormat.EPSC2, PublishOptions.ImageFormat.PNG} : (fileFormat == PublishOptions.FileFormat.LATEX && figureCaptureMethod == PublishOptions.FigureCaptureMethod.PRINT ? new PublishOptions.ImageFormat[]{PublishOptions.ImageFormat.EPSC2} : (fileFormat == PublishOptions.FileFormat.PDF ? new PublishOptions.ImageFormat[]{PublishOptions.ImageFormat.BMP} : new PublishOptions.ImageFormat[]{PublishOptions.ImageFormat.PNG}));
        return imageFormatArray;
    }
}

