/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.dialog;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.common.icons.IconContainer;
import com.mathworks.jmi.MLFileUtils;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabLanguage;
import com.mathworks.mlwidgets.util.UIFileUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.validation.Validatable;
import com.mathworks.mwswing.validation.ValidatableTextField;
import com.mathworks.mwswing.validation.Validity;
import com.mathworks.util.FileUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.Validate;

public class SpecifyNewFilenameDialog {
    public static final String DIALOG_NAME = "SpecifyNewFilenameDialog";
    public static final String FILE_FIELD_NAME = "NewFileField";
    public static final String CANCEL_BUTTON_NAME = "CancelButton";
    public static final String SAVE_BUTTON_NAME = "SaveButton";
    private static final int NAME_FIELD_COLUMNS = 20;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.dialog.resources.RES_dialog");
    private static final String INDENT_DLU = "6dlu";
    private final String fInputFilePath;
    private final File fInputFile;
    private final MJLabel fErrorlabel;
    private final ValidatableTextField fNewFilenameField;
    private final JPanel fNewFilenamePanel;
    private final JComponent fInfoLabel;
    private final JButton fSaveButton;
    private final JPanel fMessagePanel;
    private JDialog fDialog;
    private String fNewFilename;
    private static final String DOT_M = ".m";
    private static JDialog sLastDialogShown = null;

    public static boolean shouldShowDialog(File file) {
        return MLFileUtils.isMFile((String)file.getAbsolutePath()) && !SpecifyNewFilenameDialog.isValidMatlabName(FilenameUtils.getBaseName((String)file.getAbsolutePath()));
    }

    public static File getNewFilenameForBadFilename(File file, String string, Frame frame) {
        Validate.notNull((Object)file, (String)"the input file cannot be null");
        Validate.notNull((Object)string, (String)"the dialog title cannot be null");
        SpecifyNewFilenameDialog specifyNewFilenameDialog = new SpecifyNewFilenameDialog(file);
        specifyNewFilenameDialog.showDialog(frame, string);
        return specifyNewFilenameDialog.getUpdatedFile();
    }

    private SpecifyNewFilenameDialog(File file) {
        this.fInputFile = file;
        this.fInputFilePath = file.getAbsolutePath();
        this.fErrorlabel = new MJLabel();
        this.fErrorlabel.setHorizontalAlignment(2);
        this.setErrorLabel((IconContainer)DialogIcon.WARNING_10x10, BUNDLE.getString("newfilename.invalidId"));
        this.fSaveButton = new MJButton((Action)new MJAbstractAction(MJOptionPane.SAVE_STRING){

            public void actionPerformed(ActionEvent actionEvent) {
                SpecifyNewFilenameDialog.this.fNewFilename = SpecifyNewFilenameDialog.this.fNewFilenameField.getText();
                SpecifyNewFilenameDialog.this.fDialog.dispose();
            }
        });
        this.fSaveButton.setName(SAVE_BUTTON_NAME);
        this.fInfoLabel = this.makeInfoTextPanel();
        this.fNewFilenameField = this.makeNewFilenameField();
        this.fNewFilenameField.setText(FilenameUtils.getBaseName((String)this.fInputFilePath));
        this.fNewFilenamePanel = this.makeNewFilenamePanel();
        this.fMessagePanel = this.makeOptionPanePanel();
    }

    public File getUpdatedFile() {
        return this.fNewFilename != null ? new File(this.fInputFile.getParentFile(), this.fNewFilename + DOT_M) : null;
    }

    private void showDialog(Component component, String string) {
        MJButton mJButton = new MJButton((Action)new MJAbstractAction(MJOptionPane.CANCEL_STRING){

            public void actionPerformed(ActionEvent actionEvent) {
                SpecifyNewFilenameDialog.this.fDialog.dispose();
            }
        });
        mJButton.setName(CANCEL_BUTTON_NAME);
        MJOptionPane mJOptionPane = new MJOptionPane((Object)this.fMessagePanel, 1, 2, null, new Object[]{this.fSaveButton, mJButton}, (Object)this.fSaveButton);
        this.fDialog = mJOptionPane.createDialog(component, string);
        this.fDialog.setName(DIALOG_NAME);
        this.fDialog.setResizable(false);
        sLastDialogShown = this.fDialog;
        this.fDialog.setVisible(true);
    }

    private JPanel makeOptionPanePanel() {
        FormLayout formLayout = new FormLayout("l:p", "p, 4dlu, p, p, 6dlu");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.fInfoLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.fNewFilenamePanel, cellConstraints.xy(1, 3));
        PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout("6dlu, p:g", "p"));
        panelBuilder2.add((Component)this.fErrorlabel, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)panelBuilder2.getPanel(), cellConstraints.xy(1, 4));
        return panelBuilder.getPanel();
    }

    private JComponent makeInfoTextPanel() {
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("p", "p, 4dlu, p"));
        CellConstraints cellConstraints = new CellConstraints();
        String string = FilenameUtils.getName((String)this.fInputFilePath);
        MJLabel mJLabel = new MJLabel(MessageFormat.format(BUNDLE.getString("newfilename.cannotRun"), string));
        mJLabel.setFont(mJLabel.getFont().deriveFont(1));
        MJLabel mJLabel2 = new MJLabel(BUNDLE.getString("newfilename.saveBelow"));
        mJLabel2.setFont(mJLabel2.getFont().deriveFont(0));
        panelBuilder.add((Component)mJLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)mJLabel2, cellConstraints.xy(1, 3));
        return panelBuilder.getPanel();
    }

    private JPanel makeNewFilenamePanel() {
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("6dlu, p, 2dlu, p:g, 2dlu, p", "p"));
        CellConstraints cellConstraints = new CellConstraints();
        String string = FileUtils.truncatePathname((String)FilenameUtils.getFullPath((String)this.fInputFilePath));
        MJLabel mJLabel = new MJLabel(string);
        panelBuilder.add((Component)mJLabel, cellConstraints.xy(2, 1));
        panelBuilder.add((Component)this.fNewFilenameField, cellConstraints.xy(4, 1));
        MJLabel mJLabel2 = new MJLabel(DOT_M);
        panelBuilder.add((Component)mJLabel2, cellConstraints.xy(6, 1));
        return panelBuilder.getPanel();
    }

    private ValidatableTextField makeNewFilenameField() {
        ValidatableTextField validatableTextField = new ValidatableTextField(new Validatable(){

            public Validity validateText(String string) {
                String string2 = UIFileUtils.validateNameChars(string);
                boolean bl = string2 == null;
                SpecifyNewFilenameDialog.this.fSaveButton.setEnabled(bl);
                DialogIcon dialogIcon = null;
                Validity validity = Validity.VALID;
                String string3 = " ";
                if (!bl) {
                    validity = Validity.INVALID;
                    dialogIcon = DialogIcon.ERROR_10x10;
                    string3 = string2;
                } else if (!SpecifyNewFilenameDialog.isValidMatlabName(string)) {
                    validity = Validity.WARNING;
                    dialogIcon = DialogIcon.WARNING_10x10;
                    string3 = BUNDLE.getString("newfilename.invalidId");
                }
                SpecifyNewFilenameDialog.this.setErrorLabel((IconContainer)dialogIcon, string3);
                return validity;
            }

            public Validity getValidityWhenBlank() {
                SpecifyNewFilenameDialog.this.fSaveButton.setEnabled(false);
                SpecifyNewFilenameDialog.this.setErrorLabel((IconContainer)DialogIcon.ERROR_10x10, BUNDLE.getString("newfilename.blankName"));
                return Validity.INVALID;
            }
        });
        validatableTextField.setIconPaintingEnabled(false);
        validatableTextField.setColumns(20);
        validatableTextField.setName(FILE_FIELD_NAME);
        return validatableTextField;
    }

    private void setErrorLabel(IconContainer iconContainer, String string) {
        this.fErrorlabel.setIcon((Icon)(iconContainer != null ? iconContainer.getIcon() : null));
        this.fErrorlabel.setText(string);
    }

    private static boolean isValidMatlabName(String string) {
        return string != null && (!Matlab.isMatlabAvailable() || MatlabLanguage.isValidVariableName((String)string));
    }

    public static JDialog getLastDialogShown() {
        return sLastDialogShown;
    }
}

