/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.dialog.filters;

import com.mathworks.mlwidgets.dialog.filters.AbstractToolboxFileFilterContributor;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.FileExtensionFilterUtils;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.api.FileExtensionFilterContributor;
import com.mathworks.services.mlx.MlxFileUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MatlabProductFileExtensionFilter
implements FileExtensionFilterContributor {
    private static final String MATLAB_APPS_EXTENSION = "mlappinstall";
    private static final String MATLAB_MLX_EXTENSION = "mlx";
    private static final String MATLAB_REQ_EXTENSION = "req";
    private static final String[] MATLAB_CORE_EXTENSIONS = new String[]{"m", "mdl", "slx", "fig", "mat"};
    private static final FileExtensionFilter MATLAB_APPS_FILTER = new FileExtensionFilter(AbstractToolboxFileFilterContributor.intlString("filter.App"), "mlappinstall", true);
    private static final FileExtensionFilter MATLAB_MLX_FILTER = new FileExtensionFilter(AbstractToolboxFileFilterContributor.intlString("filter.Mlx"), "mlx", true);
    private static final FileExtensionFilter MATLAB_CODE_FILE_FILTER = new FileExtensionFilter(MJUtilities.intlString((String)"filter.MFiles"), Arrays.asList("m", "mlx"), true);
    private static final FileExtensionFilter MATLAB_M_FILE_FILTER = new FileExtensionFilter(MJUtilities.intlString((String)"filter.MFiles"), "m", true);

    public FileExtensionFilterContributor.FileFilterPriority getPriority() {
        return FileExtensionFilterContributor.FileFilterPriority.CORE_PRODUCT;
    }

    public List<String> getProductFilterExtensions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (MlxFileUtils.isMlxEnabled()) {
            arrayList.add(MATLAB_MLX_EXTENSION);
        }
        Collections.addAll(arrayList, MATLAB_CORE_EXTENSIONS);
        arrayList.add(MATLAB_APPS_EXTENSION);
        arrayList.add(MATLAB_REQ_EXTENSION);
        return arrayList;
    }

    public List<FileExtensionFilter> getDialogFilters() {
        return Arrays.asList(MatlabProductFileExtensionFilter.getMatlabCodeFileFilter(), MatlabProductFileExtensionFilter.getFigFileFilter(), MatlabProductFileExtensionFilter.getMatFileFilter(), MATLAB_APPS_FILTER);
    }

    public static FileExtensionFilter getMLXFileFilter() {
        return MATLAB_MLX_FILTER;
    }

    public static FileExtensionFilter getMFileFilter() {
        return FileExtensionFilterUtils.getMatlabFileFilter();
    }

    public static FileExtensionFilter getMatlabCodeFileFilter() {
        if (MlxFileUtils.isMlxEnabled()) {
            return MATLAB_CODE_FILE_FILTER;
        }
        return MATLAB_M_FILE_FILTER;
    }

    public static FileExtensionFilter getFigFileFilter() {
        return FileExtensionFilterUtils.getFigFileFilter();
    }

    public static FileExtensionFilter getMatFileFilter() {
        return FileExtensionFilterUtils.getMatFileFilter();
    }

    public static FileExtensionFilter getAppInstallFilter() {
        return MATLAB_APPS_FILTER;
    }
}

