/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer;

import com.mathworks.mlwidgets.explorer.DetailViewer;
import com.mathworks.mlwidgets.explorer.ExplorerSplitPanePrefs;
import com.mathworks.mwswing.MJSplitPane;
import com.mathworks.mwswing.MJUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.Semaphore;
import javax.swing.JComponent;

public final class ExplorerSplitPane {
    private final MJSplitPane fSplitPane;
    private final ExplorerSplitPanePrefs fPrefs;
    private final Semaphore fDetailViewerChangeLock;
    private boolean fDividerSavingEnabled;
    private DetailViewer fDetailViewer;

    public ExplorerSplitPane(ExplorerSplitPanePrefs explorerSplitPanePrefs) {
        this.fPrefs = explorerSplitPanePrefs;
        this.fDetailViewerChangeLock = new Semaphore(1);
        this.fSplitPane = new MJSplitPane(0, true){

            public Dimension getMinimumSize() {
                return new Dimension(1, (int)super.getMinimumSize().getHeight());
            }
        };
        this.fSplitPane.setDividerSize(2);
        this.fSplitPane.setBorder(null);
        this.fSplitPane.setResizeWeight(1.0);
        this.fSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (!ExplorerSplitPane.this.fDividerSavingEnabled) {
                    return;
                }
                if (ExplorerSplitPane.this.fDetailViewer != null && ExplorerSplitPane.this.fDetailViewerChangeLock.tryAcquire()) {
                    try {
                        if (ExplorerSplitPane.this.fSplitPane.getDividerLocation() == ExplorerSplitPane.this.fDetailViewer.getCollapsedLocation() || ExplorerSplitPane.this.fSplitPane.getHeight() < ExplorerSplitPane.this.fDetailViewer.getCollapsedLocation()) {
                            ExplorerSplitPane.this.fPrefs.setCollapsed(true);
                        } else if (!ExplorerSplitPane.this.fPrefs.isCollapsed()) {
                            ExplorerSplitPane.this.saveDetailViewerSize();
                        }
                    }
                    finally {
                        ExplorerSplitPane.this.fDetailViewerChangeLock.release();
                    }
                }
            }
        });
    }

    public void initialize() {
        if (!this.fDividerSavingEnabled) {
            this.syncDetailViewerSizeFromPrefs();
            this.fDividerSavingEnabled = true;
        }
    }

    public void setTop(JComponent jComponent) {
        this.fSplitPane.setTopComponent((Component)jComponent);
    }

    public void setDetailViewer(DetailViewer detailViewer) {
        this.fDetailViewer = detailViewer;
        this.fSplitPane.setBottomComponent((Component)detailViewer.getComponent());
    }

    private void saveDetailViewerSize() {
        this.fPrefs.setSize(this.fSplitPane.getMaximumDividerLocation() - this.fSplitPane.getDividerLocation());
        this.fPrefs.setRatio(100.0 * ((double)this.fSplitPane.getDividerLocation() / (double)this.fSplitPane.getMaximumDividerLocation()));
    }

    private void syncDetailViewerSizeFromPrefs() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ExplorerSplitPane.this.fDetailViewer != null) {
                    if (ExplorerSplitPane.this.fPrefs.isCollapsed()) {
                        ExplorerSplitPane.this.fDetailViewer.collapse();
                    } else {
                        ExplorerSplitPane.this.fDetailViewer.expand(false);
                    }
                }
            }
        });
    }

    public MJSplitPane getComponent() {
        return this.fSplitPane;
    }
}

