/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.basic;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.matlab.api.explorer.ActionConfiguration;
import com.mathworks.matlab.api.explorer.ActionInput;
import com.mathworks.matlab.api.explorer.ActionProvider;
import com.mathworks.matlab.api.explorer.ActionRegistry;
import com.mathworks.matlab.api.explorer.CoreActionID;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SelectionMode;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.matlab.api.explorer.StatusRunnable;
import com.mathworks.mlwidgets.explorer.extensions.basic.CoreActionProvider;
import com.mathworks.mlwidgets.explorer.model.actions.ActionPredicates;
import com.mathworks.mlwidgets.explorer.model.actions.TableActionInput;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.util.Predicate;
import com.mathworks.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;

public class CoreReadActionProvider
implements ActionProvider {
    private static final Matlab sMatlab = new Matlab();

    public boolean isApplicable(FileSystemEntry fileSystemEntry) {
        return true;
    }

    public void configureActions(ActionRegistry actionRegistry) {
        ActionConfiguration actionConfiguration = actionRegistry.getAction(CoreActionID.FIND_FILES);
        actionConfiguration.setCode(SelectionMode.NOT_SELECTION_SENSITIVE, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                fileTable.startFileSearch();
                return Status.COMPLETED;
            }
        });
        ActionConfiguration actionConfiguration2 = actionRegistry.getAction(CoreActionID.REFRESH);
        actionConfiguration2.setCode(SelectionMode.MULTIPLE_FOLDER_SELECTION_OR_CURRENT_LOCATION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                int n = ((TableActionInput)actionInput).getParentRowIndex();
                if (n == -1) {
                    fileTable.getGroupingModel().refreshAllExpansionContexts();
                } else {
                    fileTable.getGroupingModel().refreshExpansionContext(fileTable.getRowAt(n));
                }
                return Status.COMPLETED;
            }
        });
        ActionConfiguration actionConfiguration3 = actionRegistry.getAction(CoreActionID.COPY);
        actionConfiguration3.setEnabled((Predicate)ActionPredicates.CAN_COPY);
        actionConfiguration3.setVisibleOnContextMenu(ActionConfiguration.ALWAYS);
        actionConfiguration3.setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                FileTable fileTable = ((TableActionInput)actionInput).getTable();
                fileTable.copy();
                return Status.COMPLETED;
            }
        });
        actionRegistry.getAction(CoreActionID.OPEN).setCode(SelectionMode.EXPLICIT_MULTIPLE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                return CoreReadActionProvider.open(actionInput);
            }
        });
        actionRegistry.getAction(CoreActionID.OPEN).setEnabled(ActionPredicates.either(ActionPredicates.and(ActionPredicates.SINGLE_SELECTION, ActionPredicates.ALL_REAL_FILE_SYSTEM_LOCATIONS), ActionPredicates.NO_DIRECTORIES));
        actionRegistry.getAction(CoreActionID.OPEN_AS_TEXT).setCode(SelectionMode.EXPLICIT_MULTIPLE_FILE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                return CoreReadActionProvider.openAsText(actionInput);
            }
        });
        actionRegistry.getAction(CoreActionID.IMPORT_DATA).setCode(SelectionMode.EXPLICIT_MULTIPLE_FILE_SELECTION, (StatusRunnable)new StatusRunnable<ActionInput>(){

            public Status run(ActionInput actionInput) {
                return CoreReadActionProvider.importData(actionInput);
            }
        });
    }

    private static Status open(ActionInput actionInput) {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        String string = CoreActionProvider.formatLabel("progress.open", "progress.open.multiple", actionInput.getSelection());
        for (FileSystemEntry fileSystemEntry : FileSystemUtils.getUnderlyingEntries(actionInput.getSelection())) {
            final Status status = new Status(string, true);
            arrayList.add(status);
            try {
                if (fileSystemEntry.isFolder()) {
                    MatlabPath.setCWD((String)fileSystemEntry.getLocation().toString());
                    status.markCompleted();
                    continue;
                }
                fileSystemEntry = fileSystemEntry.getSystem().followShortcutOrLink(fileSystemEntry);
                if ((fileSystemEntry = MLFileSystemUtils.getMatlabAccessibleEntry(fileSystemEntry)).isFolder()) {
                    MatlabPath.setCWD((String)fileSystemEntry.getLocation().toString());
                    status.markCompleted();
                    continue;
                }
                String string2 = "uiopen('" + StringUtils.quoteSingleQuotes((String)fileSystemEntry.getLocation().toString()) + "',1)";
                new Matlab().evalConsoleOutput(string2, new CompletionObserver(){

                    public void completed(int n, Object object) {
                        status.markCompleted();
                    }
                });
            }
            catch (IOException iOException) {
                status.markCompleted();
            }
        }
        return new Status(arrayList);
    }

    private static Status openAsText(ActionInput actionInput) {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        for (FileSystemEntry fileSystemEntry : FileSystemUtils.getUnderlyingEntries(actionInput.getSelection())) {
            final Status status = new Status();
            arrayList.add(status);
            try {
                fileSystemEntry = fileSystemEntry.getSystem().followShortcutOrLink(fileSystemEntry);
                fileSystemEntry = MLFileSystemUtils.getMatlabAccessibleEntry(fileSystemEntry);
                sMatlab.evalConsoleOutput("edit('" + StringUtils.quoteSingleQuotes((String)fileSystemEntry.getLocation().toString()) + "')", new CompletionObserver(){

                    public void completed(int n, Object object) {
                        status.markCompleted();
                    }
                });
            }
            catch (IOException iOException) {
                status.markCompleted();
            }
        }
        return new Status(arrayList);
    }

    private static Status importData(ActionInput actionInput) {
        ArrayList<Status> arrayList = new ArrayList<Status>();
        for (FileSystemEntry fileSystemEntry : actionInput.getSelection()) {
            final Status status = new Status();
            arrayList.add(status);
            try {
                fileSystemEntry = fileSystemEntry.getSystem().followShortcutOrLink(fileSystemEntry);
                fileSystemEntry = MLFileSystemUtils.getMatlabAccessibleEntry(fileSystemEntry);
                String string = "uiimport('" + StringUtils.quoteSingleQuotes((String)fileSystemEntry.getLocation().toString()) + "')";
                sMatlab.evalConsoleOutput(string, new CompletionObserver(){

                    public void completed(int n, Object object) {
                        status.markCompleted();
                    }
                });
            }
            catch (IOException iOException) {
                status.markCompleted();
            }
        }
        return new Status(arrayList);
    }
}

