/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.matlab;

import com.mathworks.common.icons.ProjectIcon;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.DetailPanel;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlwidgets.explorer.extensions.matlab.StructureUtils;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.UiFileSystemUtils;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.MouseUtils;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.tree.Tree;
import com.mathworks.widgets.text.mcode.MTree;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.Scrollable;

public final class MatlabCodeFileDetailPanel
implements DetailPanel {
    private final FileSystemEntry fFile;
    private final FileDecorations fDecorations;
    private final JComponent fComponent;

    public MatlabCodeFileDetailPanel(FileSystemEntry fileSystemEntry, FileDecorations fileDecorations) {
        this.fFile = fileSystemEntry;
        this.fDecorations = fileDecorations;
        MJPanel mJPanel = null;
        try {
            String string;
            Object object;
            Object object2;
            Object object3;
            MTree mTree = MTree.parse((String)FileSystemUtils.readText(this.fFile));
            Tree tree = mTree.findAsTree(new MTree.NodeType[]{MTree.NodeType.COMMENT, MTree.NodeType.BLOCK_COMMENT});
            Tree tree2 = mTree.findAsTree(new MTree.NodeType[]{MTree.NodeType.FUNCTION, MTree.NodeType.CELL_TITLE, MTree.NodeType.PROPERTIES, MTree.NodeType.ENUMERATION, MTree.NodeType.EVENT});
            LinkedList<CodeElement> linkedList = new LinkedList<CodeElement>();
            for (int i = 0; i < tree2.getChildCount(tree2.getRoot()); ++i) {
                object3 = (MTree.Node)tree2.getChild(tree2.getRoot(), i);
                if (object3.getType() == MTree.NodeType.CELL_TITLE) {
                    object2 = StructureUtils.getCellName(object3);
                    if (object2 == null) continue;
                    linkedList.add(new CodeElement((String)object2, ProjectIcon.CELL.getIcon(), this.fFile, object3.getStartLine()));
                    continue;
                }
                if (object3.getType() == MTree.NodeType.PROPERTIES) {
                    for (object2 = object3.getRight(); object2 != MTree.NULL_NODE; object2 = object2.getNext()) {
                        object = object2.getLeft();
                        if (!object.isTextSupported() || (string = object.getText()) == null) continue;
                        linkedList.add(new CodeElement(string, ProjectIcon.PROPERTY.getIcon(), this.fFile, object3.getStartLine()));
                    }
                    continue;
                }
                if (object3.getType() == MTree.NodeType.FUNCTION) {
                    object2 = StructureUtils.getFunctionHeader(object3, true);
                    if (object2 == null) continue;
                    linkedList.add(new CodeElement((String)object2, ProjectIcon.FUNCTION.getIcon(), this.fFile, object3.getStartLine()));
                    continue;
                }
                if (object3.getType() == MTree.NodeType.ENUMERATION) {
                    for (object2 = object3.getRight(); object2 != MTree.NULL_NODE; object2 = object2.getNext()) {
                        if (object2.isTextSupported()) {
                            linkedList.add(new CodeElement(object2.getText(), ProjectIcon.ENUMERATION_ELEMENT.getIcon(), this.fFile, object2.getStartLine()));
                            continue;
                        }
                        if (object2.getLeft().equals(MTree.NULL_NODE)) continue;
                        linkedList.add(new CodeElement(object2.getLeft().getText(), ProjectIcon.ENUMERATION_ELEMENT.getIcon(), this.fFile, object2.getStartLine()));
                    }
                    continue;
                }
                if (object3.getType() != MTree.NodeType.EVENT || object3.getLeft().equals(MTree.NULL_NODE)) continue;
                object2 = object3.getLeft().getText();
                linkedList.add(new CodeElement((String)object2, ProjectIcon.EVENT.getIcon(), this.fFile, object3.getStartLine()));
            }
            MJList mJList = null;
            if (!linkedList.isEmpty()) {
                mJList = new MJList();
                MJUtilities.addPageKeyBindingsToMacJList((JList)mJList);
                mJList.setName("MFileDetailPanelList");
                mJPanel = new ScrollablePanel(mJList);
            } else {
                mJPanel = new MJPanel();
            }
            mJPanel.setLayout((LayoutManager)new GridBagLayout());
            object3 = new GridBagConstraints();
            object3.gridx = 0;
            object3.gridy = 0;
            object3.weightx = 1.0;
            object3.weighty = 0.0;
            object3.fill = 2;
            object3.anchor = 17;
            object3.insets = new Insets(3, 0, 3, 0);
            if (tree.getChildCount(tree.getRoot()) > 0) {
                object2 = new MJPanel((LayoutManager)new BorderLayout());
                object = new MJTextArea(1, 10);
                object.setFont(new MJLabel().getFont());
                string = (String)UiFileSystemUtils.getDecorationSynchronously(this.fDecorations, false, CoreFileDecoration.DESCRIPTION);
                if (string != null) {
                    while (string.startsWith("%")) {
                        string = string.substring(1).trim();
                    }
                    if (string.length() > 0) {
                        object.setText(string);
                        object.setEditable(false);
                        object.setLineWrap(true);
                        object.setWrapStyleWord(true);
                        object2.add((Component)object, (Object)"Center");
                        mJPanel.add((Component)object2, object3);
                    }
                    ++object3.gridy;
                }
            }
            if (!linkedList.isEmpty() && mJList != null) {
                mJList.setCellRenderer((ListCellRenderer)new CodeElementRenderer());
                mJList.setCellViewerEnabled(true);
                mJList.setListData(linkedList.toArray());
                mJPanel.add((Component)mJList, object3);
                object2 = new OpenAction(mJList);
                object = mJList.getInputMap(0);
                string = new MInputMap();
                string.setParent((InputMap)object);
                MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("Explorer", "open-selection", (ExtendedAction)object2);
                mJList.getActionMap().put("open-selection", (Action)object2);
                MatlabKeyBindings.getManager().addKeyBindings("Explorer", "open-selection", (ExtendedInputMap)string);
                mJList.setInputMap(0, (InputMap)((Object)string));
                mJList.addMouseListener((MouseListener)new MouseAdapter((OpenAction)((Object)object2)){
                    final /* synthetic */ OpenAction val$openAction;
                    {
                        this.val$openAction = openAction;
                    }

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (MouseUtils.isDoubleClickEvent((MouseEvent)mouseEvent)) {
                            this.val$openAction.actionPerformed(null);
                        }
                    }
                });
            }
            ++object3.gridy;
            object3.fill = 1;
            object3.weighty = 1.0;
            object2 = new MJPanel();
            mJPanel.add((Component)object2, object3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fComponent = mJPanel;
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    public Status getLoadStatus() {
        return Status.COMPLETED;
    }

    public boolean isScrollBarNeeded() {
        return true;
    }

    private static class ScrollablePanel
    extends MJPanel
    implements Scrollable {
        private final MJList fList;

        ScrollablePanel(MJList mJList) {
            this.fList = mJList;
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    if (ScrollablePanel.this.fList.getSelectedIndex() == -1 && ScrollablePanel.this.fList.getModel().getSize() > 0) {
                        ScrollablePanel.this.fList.setSelectedIndex(0);
                    }
                    ScrollablePanel.this.fList.requestFocus();
                }
            });
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            return this.fList.getScrollableUnitIncrement(rectangle, n, n2);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
            return this.fList.getScrollableBlockIncrement(rectangle, n, n2);
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return this.fList.getScrollableTracksViewportHeight();
        }
    }

    private static class OpenAction
    extends MJAbstractAction {
        private final MJList fList;

        OpenAction(MJList mJList) {
            super("");
            this.fList = mJList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this.fList.getSelectedValue();
            if (object != null) {
                CodeElement codeElement = (CodeElement)object;
                try {
                    FileSystemEntry fileSystemEntry = MLFileSystemUtils.getMatlabAccessibleEntry(codeElement.getFile());
                    Editor editor = MLEditorServices.getEditorApplication().openEditor(fileSystemEntry.getLocation().toFile());
                    editor.goToLine(codeElement.getLine(), false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private static class CodeElementRenderer
    extends DefaultListCellRenderer {
        private CodeElementRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            CodeElement codeElement = (CodeElement)object;
            this.setText(codeElement.getHeader());
            this.setIcon(codeElement.getIcon());
            this.setIconTextGap(6);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    private static class CodeElement {
        private final String fHeader;
        private final Icon fIcon;
        private final FileSystemEntry fFile;
        private final int fLine;

        CodeElement(String string, Icon icon, FileSystemEntry fileSystemEntry, int n) {
            this.fHeader = string;
            this.fIcon = icon;
            this.fFile = fileSystemEntry;
            this.fLine = n;
        }

        int getLine() {
            return this.fLine;
        }

        String getHeader() {
            return this.fHeader;
        }

        FileSystemEntry getFile() {
            return this.fFile;
        }

        Icon getIcon() {
            return this.fIcon;
        }
    }
}

