/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model;

import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileDecoration;
import com.mathworks.matlab.api.explorer.FileDecorationThreadingMode;
import com.mathworks.matlab.api.explorer.FileDecorations;
import com.mathworks.matlab.api.explorer.FileDecorators;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.Converter;
import com.mathworks.util.DeferrableRetriever;
import com.mathworks.util.Holder;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.RequestQueue;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class FileDecorationModel {
    private final ExtensionRegistry fExtensions;
    private final Map<FileDecoration<?>, List<DeferrableRetriever<?>>> fRetrievers;
    private final Map<FileDecoration<?>, Object> fValues;
    private final Map<FileDecoration<?>, MulticastChangeListener> fValueNotifiers;
    private final Map<FileDecoration<?>, Object> fPreliminaryValues;
    private final Object fLock;
    private final RequestQueue fRequestQueue;
    private final MulticastChangeListener fAsyncResponseListeners;

    public FileDecorationModel(ExtensionRegistry extensionRegistry, RequestQueue requestQueue, FileSystemEntry fileSystemEntry) {
        this.fExtensions = extensionRegistry;
        this.fRetrievers = new TreeMap();
        this.fValues = new TreeMap();
        this.fPreliminaryValues = new TreeMap();
        this.fValueNotifiers = new TreeMap();
        this.fLock = new Object();
        this.fRequestQueue = requestQueue;
        this.fAsyncResponseListeners = new MulticastChangeListener();
        this.installExtensions(fileSystemEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installExtensions(FileSystemEntry fileSystemEntry) {
        Object object = this.fLock;
        synchronized (object) {
            fileSystemEntry = VirtualFileSystem.getUnderlyingEntryIfMountPoint(fileSystemEntry);
            this.fValues.clear();
            this.fRetrievers.clear();
            for (FileInfoProvider fileInfoProvider : this.fExtensions.getInfoProviders()) {
                if (!fileInfoProvider.isApplicable(fileSystemEntry)) continue;
                fileInfoProvider.configureDecorations(fileSystemEntry, this.getDecorators(), this.getDecorations());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markStale(FileSystemEntry fileSystemEntry) {
        Object object = this.fLock;
        synchronized (object) {
            this.fValueNotifiers.clear();
            HashMap hashMap = new HashMap(this.fPreliminaryValues);
            this.installExtensions(fileSystemEntry);
            this.fPreliminaryValues.putAll(hashMap);
        }
    }

    public FileDecorators getDecorators() {
        return new FileDecorators(){

            public ExtensionRegistry getExtensions() {
                return FileDecorationModel.this.fExtensions;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <T> void setPreliminary(FileDecoration<T> fileDecoration, T t) {
                Object object = FileDecorationModel.this.fLock;
                synchronized (object) {
                    FileDecorationModel.this.fPreliminaryValues.put(fileDecoration, t);
                }
            }

            public <T> void set(FileDecoration<T> fileDecoration, DeferrableRetriever<T> deferrableRetriever) {
                this.set(fileDecoration, fileDecoration.getDefaultThreadingMode(), deferrableRetriever);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <T> void set(FileDecoration<T> fileDecoration, FileDecorationThreadingMode fileDecorationThreadingMode, DeferrableRetriever<T> deferrableRetriever) {
                Object object = FileDecorationModel.this.fLock;
                synchronized (object) {
                    ArrayList<DeferrableRetriever> arrayList = (ArrayList<DeferrableRetriever>)FileDecorationModel.this.fRetrievers.get(fileDecoration);
                    if (arrayList == null) {
                        arrayList = new ArrayList<DeferrableRetriever>();
                        FileDecorationModel.this.fRetrievers.put(fileDecoration, arrayList);
                    }
                    arrayList.add(FileDecorationModel.this.convertToMode(fileDecorationThreadingMode, deferrableRetriever));
                    FileDecorationModel.this.fValues.remove(fileDecoration);
                }
            }

            public <T> void set(FileDecoration<T> fileDecoration, Class<? extends T> clazz, Object ... objectArray) {
                this.set(fileDecoration, fileDecoration.getDefaultThreadingMode(), clazz, objectArray);
            }

            public <T> void set(FileDecoration<T> fileDecoration, FileDecorationThreadingMode fileDecorationThreadingMode, Class<? extends T> clazz, Object ... objectArray) {
                this.set(fileDecoration, (T)new DecorationResolvingInstantiator<T>(fileDecoration, clazz, fileDecorationThreadingMode, objectArray));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public <T> void set(FileDecoration<T> fileDecoration, final T t) {
                Object object = FileDecorationModel.this.fLock;
                synchronized (object) {
                    this.set(fileDecoration, (T)new DeferrableRetriever<T>(){

                        public void run(ParameterRunnable<T> parameterRunnable, Runnable runnable) {
                            parameterRunnable.run(t);
                        }
                    });
                }
            }

            public <T, D> void set(FileDecoration<T> fileDecoration, final FileDecoration<D> fileDecoration2, final Converter<D, T> converter) {
                this.set(fileDecoration, (T)new DeferrableRetriever<T>(){

                    public void run(final ParameterRunnable<T> parameterRunnable, final Runnable runnable) {
                        FileDecorationModel.this.getDecorations().get(fileDecoration2, false, new ParameterRunnable<D>(){

                            public void run(D d) {
                                if (d == null) {
                                    runnable.run();
                                } else {
                                    parameterRunnable.run(converter.convert(d));
                                }
                            }
                        });
                    }
                });
            }
        };
    }

    public FileDecorations getDecorations() {
        return new FileDecorations(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            public <T> void get(final FileDecoration<T> fileDecoration, boolean bl, final ParameterRunnable<T> parameterRunnable) {
                MulticastChangeListener multicastChangeListener;
                Thread thread;
                MulticastChangeListener multicastChangeListener2;
                Object var5_10;
                Holder holder;
                block13: {
                    holder = null;
                    Object object = FileDecorationModel.this.fLock;
                    // MONITORENTER : object
                    if (!FileDecorationModel.this.fValues.containsKey(fileDecoration)) break block13;
                    Object v = FileDecorationModel.this.fValues.get(fileDecoration);
                    holder = new Holder(v);
                    // MONITOREXIT : object
                    if (holder == null) return;
                    parameterRunnable.run(holder.get());
                    return;
                }
                List list = (List)FileDecorationModel.this.fRetrievers.get(fileDecoration);
                if (list == null) {
                    Object var5_9 = bl ? FileDecorationModel.this.fPreliminaryValues.get(fileDecoration) : null;
                    holder = var5_9 != null ? new Holder(var5_9) : new Holder(fileDecoration.getDefaultValue());
                    // MONITOREXIT : object
                    if (holder == null) return;
                    parameterRunnable.run(holder.get());
                    return;
                }
                Object v0 = var5_10 = bl ? FileDecorationModel.this.fPreliminaryValues.get(fileDecoration) : null;
                if (var5_10 != null) {
                    holder = new Holder(var5_10);
                }
                if ((multicastChangeListener2 = (MulticastChangeListener)FileDecorationModel.this.fValueNotifiers.get(fileDecoration)) != null) {
                    multicastChangeListener2.addChangeListener(new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent changeEvent) {
                            parameterRunnable.run(((Holder)changeEvent.getSource()).get());
                        }
                    });
                    // MONITOREXIT : object
                    if (holder == null) return;
                    parameterRunnable.run(holder.get());
                    return;
                }
                try {
                    thread = Thread.currentThread();
                    multicastChangeListener = new MulticastChangeListener();
                    FileDecorationModel.this.fValueNotifiers.put(fileDecoration, multicastChangeListener);
                    // MONITOREXIT : object
                }
                finally {
                    if (holder != null) {
                        parameterRunnable.run(holder.get());
                    }
                }
                new DeferHandler<T>(fileDecoration, var5_10 != null, list, new ParameterRunnable<T>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(T t) {
                        Object object = FileDecorationModel.this.fLock;
                        synchronized (object) {
                            FileDecorationModel.this.fValueNotifiers.remove(fileDecoration);
                            FileDecorationModel.this.fValues.put(fileDecoration, t);
                            FileDecorationModel.this.fPreliminaryValues.put(fileDecoration, t);
                        }
                        parameterRunnable.run(t);
                        object = new Holder();
                        object.set(t);
                        multicastChangeListener.stateChanged(new ChangeEvent(object));
                        if (!Thread.currentThread().equals(thread)) {
                            FileDecorationModel.this.fAsyncResponseListeners.stateChanged(new ChangeEvent(fileDecoration));
                        }
                    }
                }).run();
            }
        };
    }

    public void addAsyncResponseListener(ChangeListener changeListener) {
        this.fAsyncResponseListeners.addChangeListener(changeListener);
    }

    public void removeAsyncResponseListener(ChangeListener changeListener) {
        this.fAsyncResponseListeners.removeChangeListener(changeListener);
    }

    public void dispose() {
        this.fAsyncResponseListeners.dispose();
    }

    private <T> DeferrableRetriever<T> convertToMode(FileDecorationThreadingMode fileDecorationThreadingMode, final DeferrableRetriever<T> deferrableRetriever) {
        switch (fileDecorationThreadingMode) {
            case SYNCHRONOUS_WITH_REQUEST: {
                return deferrableRetriever;
            }
            case BACKGROUND_THREAD: {
                return new DeferrableRetriever<T>(){

                    public void run(final ParameterRunnable<T> parameterRunnable, final Runnable runnable) {
                        FileDecorationModel.this.fRequestQueue.request(new Runnable(){

                            @Override
                            public void run() {
                                deferrableRetriever.run(parameterRunnable, runnable);
                            }
                        });
                    }
                };
            }
            case EDT: {
                return new DeferrableRetriever<T>(){

                    public void run(final ParameterRunnable<T> parameterRunnable, final Runnable runnable) {
                        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                deferrableRetriever.run(parameterRunnable, runnable);
                            }
                        });
                    }
                };
            }
        }
        throw new IllegalArgumentException(fileDecorationThreadingMode.toString());
    }

    private class SimpleInstantiator<T>
    implements DeferrableRetriever<T> {
        private final Class<? extends T> fClass;
        private final Object[] fParameters;

        SimpleInstantiator(Class<? extends T> clazz, Object[] objectArray) {
            this.fClass = clazz;
            this.fParameters = (Object[])objectArray.clone();
        }

        public void run(ParameterRunnable<T> parameterRunnable, Runnable runnable) {
            try {
                Constructor<T> constructor = this.findConstructor();
                parameterRunnable.run(constructor.newInstance(this.fParameters));
            }
            catch (InstantiationException instantiationException) {
                throw new IllegalStateException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalStateException(invocationTargetException);
            }
        }

        private Constructor<T> findConstructor() {
            for (Constructor<?> constructor : this.fClass.getConstructors()) {
                if (!this.matchesParameters(constructor)) continue;
                return constructor;
            }
            throw new IllegalArgumentException("The class " + this.fClass.getName() + " has no public constructor matching the types of the parameters: " + Arrays.toString(this.fParameters));
        }

        private boolean matchesParameters(Constructor<T> constructor) {
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length != this.fParameters.length) {
                return false;
            }
            for (int i = 0; i < this.fParameters.length; ++i) {
                if (this.fParameters[i] == null || classArray[i].isInstance(this.fParameters[i])) continue;
                return false;
            }
            return true;
        }
    }

    private class DecorationResolvingInstantiator<T>
    implements DeferrableRetriever<T> {
        private final FileDecoration<T> iDecoration;
        private final Class<? extends T> iClass;
        private final FileDecorationThreadingMode iMode;
        private final Object[] iParameters;

        DecorationResolvingInstantiator(FileDecoration<T> fileDecoration, Class<? extends T> clazz, FileDecorationThreadingMode fileDecorationThreadingMode, Object[] objectArray) {
            this.iDecoration = fileDecoration;
            this.iClass = clazz;
            this.iMode = fileDecorationThreadingMode;
            this.iParameters = (Object[])objectArray.clone();
        }

        public void run(final ParameterRunnable<T> parameterRunnable, final Runnable runnable) {
            final Object[] objectArray = new Object[this.iParameters.length];
            ArrayList<Status> arrayList = new ArrayList<Status>();
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.iParameters[i] instanceof FileDecoration && !this.iParameters[i].equals(this.iDecoration)) {
                    final Status status = new Status();
                    arrayList.add(status);
                    final int n = i;
                    FileDecorationModel.this.getDecorations().get((FileDecoration)this.iParameters[i], false, (ParameterRunnable)new ParameterRunnable<Object>(){

                        public void run(Object object) {
                            objectArray[n] = object;
                            status.markCompleted();
                        }
                    });
                    continue;
                }
                objectArray[i] = this.iParameters[i];
            }
            new Status(arrayList).addCompletionOrCancellationRunnable(new Runnable(){

                @Override
                public void run() {
                    FileDecorationModel.this.convertToMode(DecorationResolvingInstantiator.this.iMode, new SimpleInstantiator(DecorationResolvingInstantiator.this.iClass, objectArray)).run(parameterRunnable, runnable);
                }
            });
        }
    }

    private class DeferHandler<T>
    implements Runnable {
        private final Iterator<DeferrableRetriever<T>> fIterator;
        private final ParameterRunnable<T> fOutput;
        private final FileDecoration<T> fDecoration;
        private final boolean fHasPreliminary;

        DeferHandler(FileDecoration<T> fileDecoration, boolean bl, List<DeferrableRetriever<T>> list, ParameterRunnable<T> parameterRunnable) {
            this.fOutput = parameterRunnable;
            this.fHasPreliminary = bl;
            this.fIterator = list.iterator();
            this.fDecoration = fileDecoration;
        }

        @Override
        public void run() {
            if (this.fIterator.hasNext()) {
                DeferrableRetriever deferrableRetriever = this.fIterator.next();
                if (this.fHasPreliminary) {
                    deferrableRetriever = FileDecorationModel.this.convertToMode(FileDecorationThreadingMode.BACKGROUND_THREAD, deferrableRetriever);
                }
                deferrableRetriever.run(this.fOutput, (Runnable)this);
            } else {
                this.fOutput.run(this.fDecoration.getDefaultValue());
            }
        }
    }
}

