/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.actions;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.DebuggingIcon;
import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.common.icons.FolderIcon;
import com.mathworks.matlab.api.explorer.ActionDefinition;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.actions.CoreMenuSection;
import com.mathworks.util.PlatformInfo;
import javax.swing.Icon;

enum CoreActionDefinition {
    OPEN("open-selection", true, CoreMenuSection.OPEN, "context.open"),
    RUN("evaluate-selection", true, CoreMenuSection.OPEN, "context.run", DebuggingIcon.PLAY_DOCUMENT.getIcon()),
    CD_TO_LOCATION("change-current-folder", true, CoreMenuSection.OPEN, "context.cd.containing"),
    VIEW_HELP("help-on-selection", true, CoreMenuSection.OPEN, "context.viewHelp"),
    OPEN_AS_TEXT("openAsText", CoreMenuSection.OPEN, "context.openAsText"),
    OPEN_OUTSIDE_MATLAB("openOutsideMatlab", CoreMenuSection.OPEN, "context.openOutsideMatlab"),
    SHOW_FOLDER_IN_FILESYSTEM("showFolderInBrowser", CoreMenuSection.OPEN, CoreActionDefinition.getOpenCurrentFolderOutsideMatlab()),
    LOCATE_ON_DISK("open-with-system-browser", true, CoreMenuSection.OPEN, CoreActionDefinition.getPlatformLocateActionLabelResource()),
    IMPORT_DATA("importData", CoreMenuSection.OPEN, "context.importData"),
    RENAME("rename", true, CoreMenuSection.NEW_RENAME_DELETE, "context.rename"),
    DELETE("delete-next", true, CoreMenuSection.NEW_RENAME_DELETE, "context.delete", CommonIcon.DELETE.getIcon()),
    PERMANENT_DELETE("permanent-delete", true, CoreMenuSection.NEW_RENAME_DELETE, "context.delete.permanent"),
    NEW_FOLDER("newfolder", CoreMenuSection.NEW_RENAME_DELETE, "context.newfolder", DocumentIcon.NEW_FOLDER.getIcon()),
    NEW_FILE_MENU("newFileSubmenu", CoreMenuSection.NEW_RENAME_DELETE, "tooltip.newfile"),
    BACK("jump-list-prev", true, CoreMenuSection.MISC, "context.back", DocumentIcon.BACK.getIcon(), true),
    FORWARD("jump-list-next", true, CoreMenuSection.MISC, "context.forward", DocumentIcon.FORWARD.getIcon(), true),
    BACK_NO_TEXT("back_no_text", true, CoreMenuSection.MISC, "context.back", DocumentIcon.BACK.getIcon(), true),
    FORWARD_NO_TEXT("forward_no_text", true, CoreMenuSection.MISC, "context.forward", DocumentIcon.FORWARD.getIcon(), true),
    ADD_SELECTED_FOLDERS_TO_PATH("addSelectedToPath", CoreMenuSection.ADD_TO_PATH, "context.submenu.path.selected"),
    ADD_SELECTED_FOLDERS_RECURSIVE("addSelectedToPathRecursive", CoreMenuSection.ADD_TO_PATH, "context.submenu.path.selected.recursive"),
    ADD_CONTAINING_FOLDER_TO_PATH("addContainingFolderToPath", CoreMenuSection.ADD_TO_PATH, "context.submenu.path.containing"),
    ADD_CURRENT_FOLDER_TO_PATH("addCurrentFolderToPath", CoreMenuSection.ADD_TO_PATH, "context.submenu.path.currentfolder"),
    REMOVE_SELECTED_FOLDERS_FROM_PATH("removeSelectedFromPath", CoreMenuSection.REMOVE_FROM_PATH, "context.submenu.path.selected"),
    REMOVE_SELECTED_FOLDERS_RECURSIVE("removeSelectedFromPathRecursive", CoreMenuSection.REMOVE_FROM_PATH, "context.submenu.path.selected.recursive"),
    REMOVE_CONTAINING_FOLDER_FROM_PATH("removeContainingFolderFromPath", CoreMenuSection.REMOVE_FROM_PATH, "context.submenu.path.containing"),
    REMOVE_CURRENT_FOLDER_FROM_PATH("removeCurrentFolderFromPath", CoreMenuSection.REMOVE_FROM_PATH, "context.submenu.path.currentfolder"),
    FIND_FILES("find-files", true, CoreMenuSection.MISC, "context.FindinFiles", CommonIcon.FIND_FILES.getIcon(), true),
    REFRESH("refresh", true, CoreMenuSection.REFRESH, "context.refresh", true),
    UP_ONE_LEVEL("up-one-level", true, CoreMenuSection.MISC, "context.up", FolderIcon.DIR_UP.getIcon(), true),
    UP_ONE_LEVEL_NO_TEXT("up-one-level-no-text", true, CoreMenuSection.MISC, "context.up", FolderIcon.DIR_UP.getIcon(), true),
    CUT("cut-to-clipboard", true, CoreMenuSection.DATA_TRANSFER, "context.cut", CommonIcon.CUT.getIcon()),
    COPY("copy-to-clipboard", true, CoreMenuSection.DATA_TRANSFER, "context.copy", CommonIcon.COPY.getIcon()),
    PASTE("paste-from-clipboard", true, CoreMenuSection.DATA_TRANSFER, "context.paste", CommonIcon.PASTE.getIcon());

    private final ActionDefinition fDefinition;

    private CoreActionDefinition(String string2, CoreMenuSection coreMenuSection, String string3, Icon icon) {
        this.fDefinition = new ActionDefinition(string2, coreMenuSection.getSection(), ExplorerResources.getString(string3), icon);
    }

    private CoreActionDefinition(String string2, boolean bl, CoreMenuSection coreMenuSection, String string3, Icon icon) {
        this.fDefinition = new ActionDefinition(string2, bl, coreMenuSection.getSection(), ExplorerResources.getString(string3), icon, string3);
    }

    private CoreActionDefinition(String string2, boolean bl, CoreMenuSection coreMenuSection, String string3, Icon icon, boolean bl2) {
        this.fDefinition = new ActionDefinition(string2, bl, coreMenuSection.getSection(), ExplorerResources.getString(string3), icon, string3, bl2);
    }

    private CoreActionDefinition(String string2, boolean bl, CoreMenuSection coreMenuSection, String string3) {
        this.fDefinition = new ActionDefinition(string2, bl, coreMenuSection.getSection(), ExplorerResources.getString(string3));
    }

    private CoreActionDefinition(String string2, CoreMenuSection coreMenuSection, String string3) {
        this.fDefinition = new ActionDefinition(string2, coreMenuSection.getSection(), ExplorerResources.getString(string3));
    }

    private CoreActionDefinition(String string2, boolean bl, CoreMenuSection coreMenuSection, String string3, boolean bl2) {
        this.fDefinition = new ActionDefinition(string2, bl, coreMenuSection.getSection(), ExplorerResources.getString(string3), bl2);
    }

    public ActionDefinition getDefinition() {
        return this.fDefinition;
    }

    private static String getPlatformLocateActionLabelResource() {
        if (PlatformInfo.isWindows()) {
            return "context.locate.windows";
        }
        if (PlatformInfo.isMacintosh()) {
            return "context.locate.mac";
        }
        return "context.locate.unix";
    }

    private static String getOpenCurrentFolderOutsideMatlab() {
        if (PlatformInfo.isWindows()) {
            return "context.openCurrentFolderOutsideMatlab.windows";
        }
        if (PlatformInfo.isMacintosh()) {
            return "context.openCurrentFolderOutsideMatlab.mac";
        }
        return "context.openCurrentFolderOutsideMatlab.linux";
    }
}

