/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.actions;

import com.mathworks.matlab.api.explorer.MenuSection;
import com.mathworks.mlwidgets.explorer.model.actions.Context;
import com.mathworks.mlwidgets.explorer.model.actions.DynamicMenuContext;
import com.mathworks.mlwidgets.explorer.model.actions.DynamicMenuContributor;
import com.mathworks.mlwidgets.explorer.model.actions.PopupMenu;
import com.mathworks.mlwidgets.explorer.model.actions.RegularMenu;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJUtilities;
import java.awt.Component;
import java.awt.Point;
import java.util.Comparator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class DynamicMenuUtils {
    private DynamicMenuUtils() {
    }

    public static <T> void showPopupMenu(final JComponent jComponent, final Point point, final List<DynamicMenuContributor<T>> list, final T[] TArray, final Comparator<MenuSection> comparator, final MenuSection ... menuSectionArray) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PopupMenu popupMenu = new PopupMenu();
                Context context = (Context)DynamicMenuUtils.createMenuContext(list, TArray, comparator, menuSectionArray);
                context.createMenu(popupMenu);
                if (popupMenu.getComponent().getComponentCount() > 0) {
                    popupMenu.getComponent().setCleanupUponClose(true);
                    popupMenu.getComponent().show((Component)jComponent, (int)point.getX(), (int)point.getY());
                }
            }
        });
    }

    public static <T> MJPopupMenu createPopupMenu(List<DynamicMenuContributor<T>> list, T[] TArray, Comparator<MenuSection> comparator, MenuSection ... menuSectionArray) {
        PopupMenu popupMenu = new PopupMenu();
        Context context = (Context)DynamicMenuUtils.createMenuContext(list, TArray, comparator, menuSectionArray);
        context.createMenu(popupMenu);
        return popupMenu.getComponent();
    }

    public static <T> void updateMenu(final MJMenu mJMenu, final List<DynamicMenuContributor<T>> list, final T[] TArray, final Comparator<MenuSection> comparator, final MenuSection ... menuSectionArray) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                mJMenu.removeAll();
                RegularMenu regularMenu = new RegularMenu(mJMenu);
                Context context = (Context)DynamicMenuUtils.createMenuContext(list, TArray, comparator, menuSectionArray);
                context.createMenu(regularMenu);
            }
        });
    }

    public static <T> void updateMenu(final JPopupMenu jPopupMenu, final List<DynamicMenuContributor<T>> list, final T[] TArray, final Comparator<MenuSection> comparator, final MenuSection ... menuSectionArray) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                jPopupMenu.removeAll();
                PopupMenu popupMenu = new PopupMenu(jPopupMenu);
                Context context = (Context)DynamicMenuUtils.createMenuContext(list, TArray, comparator, menuSectionArray);
                context.createMenu(popupMenu);
            }
        });
    }

    public static <T> DynamicMenuContext<T> createMenuContext(List<DynamicMenuContributor<T>> list, T[] TArray, Comparator<MenuSection> comparator, MenuSection ... menuSectionArray) {
        Context<T> context = new Context<T>(TArray, comparator, menuSectionArray);
        for (DynamicMenuContributor<T> dynamicMenuContributor : list) {
            dynamicMenuContributor.contribute(context);
        }
        return context;
    }

    public static <T> DynamicMenuContext<T> updateActionMap(final JComponent jComponent, final DynamicMenuContext<T> dynamicMenuContext, List<DynamicMenuContributor<T>> list, T[] TArray, MenuSection ... menuSectionArray) {
        final DynamicMenuContext<T> dynamicMenuContext2 = DynamicMenuUtils.createMenuContext(list, TArray, null, menuSectionArray);
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string;
                KeyStroke keyStroke;
                Action action;
                int n;
                Action[] actionArray;
                if (dynamicMenuContext != null) {
                    actionArray = dynamicMenuContext.getAllActions();
                    for (n = 0; n < actionArray.length; ++n) {
                        action = actionArray[n];
                        keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                        if (keyStroke == null) continue;
                        string = n + ":" + action.getValue("Name");
                        jComponent.getInputMap().remove(keyStroke);
                        jComponent.getActionMap().remove(string);
                    }
                }
                actionArray = dynamicMenuContext2.getAllActions();
                for (n = 0; n < actionArray.length; ++n) {
                    action = actionArray[n];
                    keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                    if (keyStroke == null) continue;
                    string = n + ":" + action.getValue("Name");
                    jComponent.getInputMap().put(keyStroke, string);
                    jComponent.getActionMap().put(string, action);
                }
            }
        });
        return dynamicMenuContext2;
    }
}

