/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.navigation;

import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlwidgets.explorer.model.navigation.InvalidLocationException;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationListener;
import com.mathworks.mlwidgets.explorer.model.table.ExplorerRefreshDaemon;
import com.mathworks.mlwidgets.explorer.model.table.RefreshDaemon;
import com.mathworks.util.Predicate;
import com.mathworks.util.RequestQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public final class NavigationContext {
    private final FileSystem fSystem;
    private final boolean fSupportsAsyncFileSystemAccess;
    private final ExtensionRegistry fExtensions;
    private final Stack<FileLocation> fPastLocations;
    private final Stack<FileLocation> fFutureLocations;
    private final List<NavigationListener> fNavigationListeners;
    private final RequestQueue fRequestQueue;
    private final RefreshDaemon fRefreshDaemon;
    private final boolean fSimulinkProject;
    private volatile int iCurrentSearchId;
    private volatile State fState;

    public NavigationContext(FileSystem fileSystem, ExtensionRegistry extensionRegistry, FileLocation fileLocation) throws InvalidLocationException {
        this(fileSystem, true, extensionRegistry, fileLocation, ExplorerRefreshDaemon.getInstance(), false);
    }

    public NavigationContext(FileSystem fileSystem, boolean bl, ExtensionRegistry extensionRegistry, FileLocation fileLocation) throws InvalidLocationException {
        this(fileSystem, bl, extensionRegistry, fileLocation, ExplorerRefreshDaemon.getInstance(), false);
    }

    public NavigationContext(FileSystem fileSystem, boolean bl, ExtensionRegistry extensionRegistry, FileLocation fileLocation, RefreshDaemon refreshDaemon, boolean bl2) throws InvalidLocationException {
        this.fSupportsAsyncFileSystemAccess = bl;
        this.fNavigationListeners = new ArrayList<NavigationListener>();
        this.fPastLocations = new Stack();
        this.fFutureLocations = new Stack();
        this.fSystem = fileSystem;
        this.fExtensions = extensionRegistry;
        this.fRefreshDaemon = refreshDaemon;
        this.fSimulinkProject = bl2;
        this.fRequestQueue = new RequestQueue("Explorer NavigationContext request queue");
        try {
            this.fState = new State(fileSystem.getList(fileLocation));
        }
        catch (IOException iOException) {
            throw new InvalidLocationException(fileLocation, iOException);
        }
    }

    public RefreshDaemon getRefreshDaemon() {
        return this.fRefreshDaemon;
    }

    public RequestQueue getRequestQueue() {
        return this.fRequestQueue;
    }

    public FileSystem getSystem() {
        return this.fSystem;
    }

    public boolean supportsAsyncFileSystemAccess() {
        return this.fSupportsAsyncFileSystemAccess;
    }

    public ExtensionRegistry getExtensions() {
        return this.fExtensions;
    }

    public FileList getList() {
        return this.fState.getList();
    }

    public boolean isSearching() {
        return this.getSearchCriteria() != null;
    }

    public SearchCriteria getSearchCriteria() {
        return this.fState.getCriteria();
    }

    public synchronized void addNavigationListener(NavigationListener navigationListener) {
        this.fNavigationListeners.add(navigationListener);
    }

    public synchronized void removeNavigationListener(NavigationListener navigationListener) {
        this.fNavigationListeners.remove(navigationListener);
    }

    public FileLocation getLocation() {
        return this.fState.getList().getLocationEntry().getLocation();
    }

    public FileSystemEntry getLocationEntry() {
        return this.fState.getList().getLocationEntry();
    }

    public void setLocation(FileLocation fileLocation) throws InvalidLocationException {
        this.setLocation(fileLocation, false);
    }

    private synchronized void setLocation(FileLocation fileLocation, boolean bl) throws InvalidLocationException {
        FileLocation fileLocation2 = this.getLocation();
        if (fileLocation == null || this.getLocation().equals((Object)fileLocation)) {
            return;
        }
        this.fState.getList().close();
        if (!(bl || !this.fPastLocations.empty() && this.fPastLocations.peek().equals((Object)fileLocation2))) {
            this.fPastLocations.push(fileLocation2);
        }
        if (!bl) {
            if (!this.fFutureLocations.empty() && !this.fFutureLocations.peek().equals((Object)fileLocation)) {
                this.fFutureLocations.clear();
            } else if (!this.fFutureLocations.empty()) {
                this.fFutureLocations.pop();
            }
        }
        try {
            this.fState = new State(this.fSystem.getList(fileLocation));
        }
        catch (IOException iOException) {
            throw new InvalidLocationException(fileLocation, iOException);
        }
        ArrayList<NavigationListener> arrayList = new ArrayList<NavigationListener>(this.fNavigationListeners);
        for (NavigationListener navigationListener : arrayList) {
            navigationListener.navigationChange(fileLocation2, fileLocation);
        }
    }

    public int getSearchId() {
        return this.iCurrentSearchId;
    }

    public boolean isSimulinkProjectTable() {
        return this.fSimulinkProject;
    }

    public synchronized FileList search(SearchCriteria searchCriteria, Predicate<FileSystemEntry> predicate) throws InvalidLocationException {
        if (searchCriteria.getSimplePattern().equalsIgnoreCase("")) {
            return this.fState.getList();
        }
        ++this.iCurrentSearchId;
        FileLocation fileLocation = this.getLocation();
        this.fState.getList().close();
        try {
            this.fState = new State(this.fSystem.search(fileLocation, searchCriteria, predicate), searchCriteria);
        }
        catch (IOException iOException) {
            throw new InvalidLocationException(fileLocation, iOException);
        }
        ArrayList<NavigationListener> arrayList = new ArrayList<NavigationListener>(this.fNavigationListeners);
        for (NavigationListener navigationListener : arrayList) {
            navigationListener.searchStarted(searchCriteria);
        }
        return this.fState.getList();
    }

    public synchronized void endSearch() throws InvalidLocationException {
        if (this.isSearching()) {
            FileLocation fileLocation = this.getLocation();
            this.fState.getList().close();
            try {
                this.fState = new State(this.fSystem.getList(fileLocation));
            }
            catch (IOException iOException) {
                throw new InvalidLocationException(fileLocation, iOException);
            }
            ArrayList<NavigationListener> arrayList = new ArrayList<NavigationListener>(this.fNavigationListeners);
            for (NavigationListener navigationListener : arrayList) {
                navigationListener.searchEnded();
            }
        }
    }

    public synchronized FileLocation getLastLocation() {
        this.popInvalidLocations(this.fPastLocations);
        return this.fPastLocations.empty() ? null : this.fPastLocations.peek();
    }

    public synchronized void goBack() throws InvalidLocationException {
        FileLocation fileLocation;
        if (this.fFutureLocations.empty() || !this.fFutureLocations.peek().equals((Object)this.getLocation())) {
            this.fFutureLocations.push(this.getLocation());
        }
        if ((fileLocation = this.getLastLocation()) != null) {
            this.setLocation(fileLocation, true);
        }
    }

    public synchronized FileLocation getNextLocation() {
        this.popInvalidLocations(this.fFutureLocations);
        return this.fFutureLocations.empty() ? null : this.fFutureLocations.peek();
    }

    private synchronized void popInvalidLocations(Stack<FileLocation> stack) {
        while (!stack.empty() && stack.peek().equals((Object)this.getLocation())) {
            stack.pop();
        }
    }

    public String toString() {
        return this.getList() == null ? super.toString() : this.getLocation().toString();
    }

    private static class State {
        private FileList fList;
        private SearchCriteria fCriteria;

        State(FileList fileList) {
            this(fileList, null);
        }

        State(FileList fileList, SearchCriteria searchCriteria) {
            this.fList = fileList;
            this.fCriteria = searchCriteria;
        }

        FileList getList() {
            return this.fList;
        }

        SearchCriteria getCriteria() {
            return this.fCriteria;
        }
    }
}

