/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.util;

import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.SwingUtilities;

public enum UiFileTransferType {
    MOVE,
    COPY,
    UPDATE_ARCHIVE,
    EXTRACT_ARCHIVE,
    DELETE,
    RECYCLE_OR_TRASH;


    public String getConfirmPromptText(String string, boolean bl) {
        if (this == DELETE || this == RECYCLE_OR_TRASH) {
            String string2 = this == DELETE || PlatformInfo.isMacintosh() ? "deleteconfirm.prompt" : (PlatformInfo.isWindows() ? "recycleconfirm.prompt.win" : "recycleconfirm.prompt.unix");
            String string3 = bl ? "confirm.folder" : "confirm.file";
            return MessageFormat.format(ExplorerResources.getString(string2), ExplorerResources.getString(string3));
        }
        String string4 = bl ? "replaceconfirm.prompt.folder" : "replaceconfirm.prompt.file";
        String string5 = ExplorerResources.getString(this == UPDATE_ARCHIVE ? "confirm.archive" : "confirm.folder");
        return MessageFormat.format(ExplorerResources.getString(string4), string5, string);
    }

    public boolean isCopy() {
        return this == COPY || this == UPDATE_ARCHIVE || this == EXTRACT_ARCHIVE;
    }

    public boolean isDeleteOrRecycle() {
        return this == DELETE || this == RECYCLE_OR_TRASH;
    }

    public void showError(final Component component, final FileSystemEntry fileSystemEntry) {
        final String string = VirtualFileSystem.getUnderlyingEntryIfMountPoint(fileSystemEntry).getName();
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                String string3;
                String string2;
                if (UiFileTransferType.this.isCopy()) {
                    if (UiFileTransferType.this == EXTRACT_ARCHIVE) {
                        string2 = "extract.error.title";
                        string3 = MessageFormat.format(ExplorerResources.getString("extract.error"), string);
                    } else if (fileSystemEntry.isFolder()) {
                        string2 = "copydir.error.title";
                        string3 = MessageFormat.format(ExplorerResources.getString("copydir.error"), string);
                    } else {
                        string2 = "copyfile.error.title";
                        string3 = MessageFormat.format(ExplorerResources.getString("copyfile.error"), string);
                    }
                } else if (UiFileTransferType.this.isDeleteOrRecycle()) {
                    string2 = "delete.error.title";
                    string3 = MessageFormat.format(ExplorerResources.getString("delete.error"), string);
                } else if (UiFileTransferType.this == MOVE) {
                    string2 = "move.error.title";
                    string3 = MessageFormat.format(ExplorerResources.getString("move.error"), string);
                } else {
                    throw new IllegalArgumentException("Unhandled transfer type: " + (Object)((Object)UiFileTransferType.this));
                }
                MJOptionPane.showMessageDialog((Component)SwingUtilities.getRoot(component), (Object)string3, (String)ExplorerResources.getString(string2), (int)0);
            }
        });
    }
}

