/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.mathworks.mlwidgets.graphics.ModelStateFactory;
import com.mathworks.mlwidgets.graphics.PlotAction;
import com.mathworks.mlwidgets.graphics.PlotCatalogPanel;
import com.mathworks.mlwidgets.graphics.PlotItemCellRenderer;
import com.mathworks.mlwidgets.graphics.PlotPickerRenderer;
import com.mathworks.mlwidgets.graphics.StateNode;
import com.mathworks.mwswing.MJList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

final class PlotCatalogCellRenderer
extends PlotItemCellRenderer
implements ListCellRenderer {
    private boolean fLegacyStyle = false;
    private PlotItemCellRenderer.CurrentButton fCurrentButton = PlotItemCellRenderer.CurrentButton.NONE;
    private ButtonState fCurrentButtonState = ButtonState.NONE;

    PlotCatalogCellRenderer() {
    }

    void setLegacyStyle(boolean bl) {
        this.fLegacyStyle = bl;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        Object e = jList.getModel().getElementAt(n);
        PlotCatalogPanel.PlotCatalogSignature plotCatalogSignature = (PlotCatalogPanel.PlotCatalogSignature)e;
        StateNode stateNode = plotCatalogSignature.getStateNode();
        PlotAction plotAction = (PlotAction)stateNode.getUserObject();
        boolean bl3 = stateNode.isEnabledByUnswappedVariables() && stateNode.isEnabledBySwappedVariables();
        boolean bl4 = plotCatalogSignature.isSwapped();
        this.fPlotActionRenderer.resetLabelsForeground();
        this.fPlotActionRenderer.setEnabled(this.fLegacyStyle || stateNode.isEnabled());
        this.fPlotActionRenderer.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.fPlotActionRenderer.setIcon(plotAction.getIcon());
        this.fPlotActionRenderer.setDescription(plotAction.getDescription());
        if (stateNode.getCustomLabelText() != null && stateNode.getCustomLabelText().length() > 0) {
            this.fPlotActionRenderer.setPlotName(stateNode.getCustomLabelText());
        } else if (bl3 && bl4) {
            this.fPlotActionRenderer.setPlotName(plotAction.getSwappedPlotLabel(this.fVarNames));
        } else {
            this.fPlotActionRenderer.setPlotName(plotAction.getPlotLabel(this.fVarNames));
        }
        if (!this.fLegacyStyle && bl3) {
            if (!bl) {
                this.fPlotActionRenderer.getSwapLabel().setIcon((Icon)(bl4 ? YX_WATERMARK : XY_WATERMARK));
            } else if (this.fCurrentButton == PlotItemCellRenderer.CurrentButton.SWAP && this.fCurrentButtonState == ButtonState.PRESSED) {
                this.fPlotActionRenderer.getSwapLabel().setIcon((Icon)(bl4 ? YX_BUTTONPRESSED : XY_BUTTONPRESSED));
            } else if (this.fCurrentButton == PlotItemCellRenderer.CurrentButton.SWAP && this.fCurrentButtonState == ButtonState.HIGHLIGHTED) {
                this.fPlotActionRenderer.getSwapLabel().setIcon((Icon)(bl4 ? YX_BUTTONHOVER : XY_BUTTONHOVER));
            } else {
                this.fPlotActionRenderer.getSwapLabel().setIcon((Icon)(bl4 ? YX_BUTTON : XY_BUTTON));
            }
            this.fPlotActionRenderer.getSwapLabel().setVisible(true);
        } else {
            this.fPlotActionRenderer.getSwapLabel().setVisible(false);
        }
        if (!this.fLegacyStyle && bl) {
            if (this.fCurrentButton == PlotItemCellRenderer.CurrentButton.ICON && this.fCurrentButtonState == ButtonState.PRESSED) {
                ((PlotPickerRenderer.PlotIcon)this.fPlotActionRenderer.getIconLabel().getIcon()).setState(PlotPickerRenderer.PlotIcon.PRESSED);
            } else if (this.fCurrentButton == PlotItemCellRenderer.CurrentButton.ICON && this.fCurrentButtonState == ButtonState.HIGHLIGHTED) {
                ((PlotPickerRenderer.PlotIcon)this.fPlotActionRenderer.getIconLabel().getIcon()).setState(PlotPickerRenderer.PlotIcon.HOVER);
            } else {
                ((PlotPickerRenderer.PlotIcon)this.fPlotActionRenderer.getIconLabel().getIcon()).setState(PlotPickerRenderer.PlotIcon.UP);
            }
        } else {
            ((PlotPickerRenderer.PlotIcon)this.fPlotActionRenderer.getIconLabel().getIcon()).setState(PlotPickerRenderer.PlotIcon.INACTIVE);
        }
        if (bl) {
            if (jList.hasFocus()) {
                if (!sIsHighContrast) {
                    this.fPlotActionRenderer.setBackground(UIManager.getColor("List.selectionBackground"));
                    this.fPlotActionRenderer.setForeground(UIManager.getColor("List.selectionForeground"));
                } else {
                    this.fPlotActionRenderer.setBackground(Color.black);
                    this.fPlotActionRenderer.setForeground(Color.white);
                }
            } else if (sIsHighContrast) {
                this.fPlotActionRenderer.setForeground(Color.white);
                this.fPlotActionRenderer.setBackground(Color.black);
            } else {
                this.fPlotActionRenderer.setBackground(SELECTION_COLOR);
                this.fPlotActionRenderer.setForeground(FOREGROUND_COLOR);
            }
        } else if (sIsHighContrast) {
            this.fPlotActionRenderer.setForeground(Color.white);
            this.fPlotActionRenderer.setBackground(Color.black);
        } else {
            this.fPlotActionRenderer.setForeground(FOREGROUND_COLOR);
            this.fPlotActionRenderer.setBackground(Color.white);
        }
        if (!jList.hasFocus() || !bl) {
            this.hilight();
        } else {
            this.clearhilight();
        }
        return this.fPlotActionRenderer;
    }

    private PlotItemCellRenderer.CurrentButton getHoverButton(JList jList, Point point) {
        if (PlotCatalogCellRenderer.isMouseInHoverButton(jList, this.fSwapLabelBounds, point)) {
            return PlotItemCellRenderer.CurrentButton.SWAP;
        }
        if (PlotCatalogCellRenderer.isMouseInHoverButton(jList, this.fIconLabelBounds, point)) {
            return PlotItemCellRenderer.CurrentButton.ICON;
        }
        return PlotItemCellRenderer.CurrentButton.NONE;
    }

    void clearButtonState() {
        this.fCurrentButton = PlotItemCellRenderer.CurrentButton.NONE;
        this.fCurrentButtonState = ButtonState.NONE;
    }

    private void setButtonState(PlotItemCellRenderer.CurrentButton currentButton, ButtonState buttonState) {
        this.fCurrentButton = currentButton;
        this.fCurrentButtonState = buttonState;
    }

    void mouseMovedCallback(JList jList, MouseEvent mouseEvent) {
        int n = jList.locationToIndex(mouseEvent.getPoint());
        if (n < 0) {
            return;
        }
        PlotItemCellRenderer.CurrentButton currentButton = this.getHoverButton(jList, mouseEvent.getPoint());
        if (currentButton == this.fCurrentButton && this.fCurrentButtonState == ButtonState.HIGHLIGHTED) {
            return;
        }
        PlotCatalogPanel.PlotCatalogSignature plotCatalogSignature = (PlotCatalogPanel.PlotCatalogSignature)jList.getModel().getElementAt(n);
        StateNode stateNode = plotCatalogSignature.getStateNode();
        PlotAction plotAction = (PlotAction)stateNode.getUserObject();
        if (currentButton == PlotItemCellRenderer.CurrentButton.NONE || currentButton == PlotItemCellRenderer.CurrentButton.ICON && !stateNode.isEnabled()) {
            this.clearButtonState();
        } else {
            this.setButtonState(currentButton, ButtonState.HIGHLIGHTED);
        }
        switch (currentButton) {
            case SWAP: {
                if (stateNode.isEnabledByUnswappedVariables() && stateNode.isEnabledBySwappedVariables()) {
                    jList.setToolTipText(ModelStateFactory.getResourceString("PlotPickerCellRenderer", "SwitchOrder"));
                    break;
                }
                jList.setToolTipText(null);
                break;
            }
            case ICON: {
                if (stateNode.isEnabled()) {
                    jList.setToolTipText(ModelStateFactory.getResourceString("PlotPickerCellRenderer", "Create"));
                    break;
                }
                jList.setToolTipText(null);
                break;
            }
            case NONE: {
                jList.setToolTipText(null);
            }
        }
        if (((Component)mouseEvent.getSource()).getCursor().getType() != 3) {
            if (currentButton == PlotItemCellRenderer.CurrentButton.NONE) {
                jList.setCursor(new Cursor(12));
            } else {
                jList.setCursor(new Cursor(0));
            }
        }
        jList.repaint();
    }

    void mousePressedCallback(JList jList, MouseEvent mouseEvent) {
        int n = jList.locationToIndex(mouseEvent.getPoint());
        PlotCatalogPanel.PlotCatalogSignature plotCatalogSignature = (PlotCatalogPanel.PlotCatalogSignature)jList.getModel().getElementAt(n);
        StateNode stateNode = plotCatalogSignature.getStateNode();
        if (!stateNode.isEnabled()) {
            return;
        }
        PlotItemCellRenderer.CurrentButton currentButton = this.getHoverButton(jList, mouseEvent.getPoint());
        this.setButtonState(currentButton, ButtonState.PRESSED);
        jList.repaint();
    }

    void mouseReleasedCallback(JList jList, MouseEvent mouseEvent) {
        this.clearButtonState();
    }

    void mouseClickedCallback(PlotCatalogPanel plotCatalogPanel, MouseEvent mouseEvent) {
        MJList mJList = plotCatalogPanel.fPlotTypeList;
        int n = mJList.locationToIndex(mouseEvent.getPoint());
        PlotCatalogPanel.PlotCatalogSignature plotCatalogSignature = (PlotCatalogPanel.PlotCatalogSignature)mJList.getModel().getElementAt(n);
        StateNode stateNode = plotCatalogSignature.getStateNode();
        PlotAction plotAction = (PlotAction)stateNode.getUserObject();
        boolean bl = stateNode.isEnabledByUnswappedVariables() && stateNode.isEnabledBySwappedVariables();
        boolean bl2 = plotCatalogSignature.isSwapped();
        if (!this.fLegacyStyle && stateNode.isEnabledByUnswappedVariables() && stateNode.isEnabledBySwappedVariables() && PlotCatalogCellRenderer.isMouseInHoverButton((JList)mJList, this.fSwapLabelBounds, mouseEvent.getPoint())) {
            plotCatalogSignature.setSwapped(!plotCatalogSignature.isSwapped());
            mJList.repaint();
        } else if (!this.fLegacyStyle && stateNode.isEnabled() && PlotCatalogCellRenderer.isMouseInHoverButton((JList)mJList, this.fIconLabelBounds, mouseEvent.getPoint()) && mouseEvent.getButton() == 1) {
            if (bl && bl2) {
                plotAction.execute(plotCatalogPanel.fPlottedVars, true, mJList);
            } else {
                plotAction.execute(plotCatalogPanel.fPlottedVars, mJList);
            }
        }
    }

    protected static boolean isMouseInHoverButton(JList jList, Rectangle rectangle, Point point) {
        int n = jList.locationToIndex(point);
        if (rectangle == null) {
            return false;
        }
        Rectangle rectangle2 = jList.getCellBounds(n, n);
        if (rectangle2 == null) {
            return false;
        }
        rectangle2.x += rectangle.x;
        rectangle2.y += rectangle.y;
        rectangle2.width = rectangle.width;
        rectangle2.height = rectangle.height;
        return rectangle2.contains(point);
    }

    public static enum ButtonState {
        PRESSED,
        HIGHLIGHTED,
        NONE;

    }
}

