/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlwidgets.help.DemoInfoItem;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.util.productinfo.ProductInfoUtils;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.TreeNode;
import org.apache.commons.io.FilenameUtils;

public class DemoInfoUtils {
    private DemoInfoUtils() {
    }

    public static String getAbsolutePath(String string, String string2) {
        return DemoInfoUtils.getAbsolutePath(string, string2, HelpUtils.getDemosDirectoryName());
    }

    public static String getAbsolutePath(String string, String string2, String[] stringArray) {
        String string3 = string2;
        if (string != null) {
            int n;
            if (string3.startsWith("$docroot") || string3.startsWith("http://")) {
                return string3;
            }
            File file = new File(string);
            String string4 = file.getParent();
            if (stringArray != null) {
                string4 = DemoInfoUtils.removeLanguageDirNameFromPath(string4, stringArray);
            }
            String string5 = "";
            String string6 = HTMLUtils.getFilenameFromURL(string3);
            if (!string3.equals(string6) && (n = string3.lastIndexOf(35)) != -1) {
                string5 = string3.substring(n);
            }
            string3 = DemoInfoUtils.getLocalizedDemoFilename(string4 + File.separator + string6);
            string3 = string3.concat(string5);
        }
        return string3;
    }

    private static String removeLanguageDirNameFromPath(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            Pattern pattern = Pattern.compile("(.*)[\\\\/]" + Pattern.quote(string2) + "$");
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            return matcher.group(1);
        }
        return string;
    }

    public static String getLocalizedDemoFilename(String string) {
        return DemoInfoUtils.getLocalizedDemoFilename(string, HelpUtils.getDemosDirectoryName());
    }

    public static String getLocalizedDemoFilename(String string, String[] stringArray) {
        if (stringArray != null) {
            for (String string2 : stringArray) {
                File file = new File(string);
                String string3 = file.getParent();
                String string4 = FilenameUtils.separatorsToSystem((String)(string3 + "/" + string2 + "/" + file.getName()));
                File file2 = new File(string4);
                if (!file2.exists()) continue;
                return file2.getPath();
            }
        }
        return string;
    }

    public static boolean shouldShowDemo(DemoInfoItem demoInfoItem) {
        return DemoInfoUtils.shouldShowDemoProduct(DemoInfoUtils.getDemoProductFullName(demoInfoItem));
    }

    public static boolean shouldShowDemoProduct(String string) {
        return true;
    }

    public static String getFileToIndex(DemoInfoItem demoInfoItem, String[] stringArray) {
        return DemoInfoUtils.getFileForDemo(demoInfoItem, stringArray, false);
    }

    public static String getFileForDisplay(DemoInfoItem demoInfoItem, String[] stringArray) {
        return DemoInfoUtils.getFileForDemo(demoInfoItem, stringArray, true);
    }

    private static String getFileForDemo(DemoInfoItem demoInfoItem, String[] stringArray, boolean bl) {
        String string = demoInfoItem.getType();
        if (!"".equals(string)) {
            String string2;
            String string3 = string2 = stringArray != null ? demoInfoItem.getFilename(stringArray) : demoInfoItem.getFilename();
            if (!"".equals(string2)) {
                return string2;
            }
            if ("M-file".equals(string)) {
                String string4 = DemoInfoUtils.getDemosroot(demoInfoItem.getXmlFilename(), stringArray) + "/html/" + demoInfoItem.getSource() + ".html";
                return DemoInfoUtils.getLocalizedFile(string4, stringArray).getAbsolutePath();
            }
            if (!"".equals(demoInfoItem.getSource()) && !bl) {
                String string5 = demoInfoItem.getSource();
                String string6 = DemoInfoUtils.getDemosroot(demoInfoItem.getXmlFilename(), stringArray) + "/" + string5 + ".m";
                File file = DemoInfoUtils.getLocalizedFile(string6, stringArray);
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
                String string7 = DemoInfoUtils.getDemosroot(demoInfoItem.getXmlFilename(), stringArray) + "/" + string5 + ".mdl";
                File file2 = DemoInfoUtils.getLocalizedFile(string7, stringArray);
                if (file2.exists()) {
                    return file2.getAbsolutePath();
                }
            }
        } else {
            if (!"".equals(demoInfoItem.getCallback()) && !bl) {
                return null;
            }
            if (!"".equals(demoInfoItem.getFilename())) {
                return demoInfoItem.getFilename();
            }
        }
        return null;
    }

    public static String getDemosroot(String string, String[] stringArray) {
        String string2 = string.substring(0, string.length() - "/demos.xml".length());
        if (stringArray != null) {
            return DemoInfoUtils.removeLanguageDirNameFromPath(string2, stringArray);
        }
        return string2;
    }

    public static File getLocalizedFile(String string, String[] stringArray) {
        if (stringArray == null) {
            return new File(string);
        }
        File file = new File(string);
        String string2 = file.getName();
        for (String string3 : stringArray) {
            File file2 = new File(file.getParentFile(), string3);
            if (!(file2 = new File(file2, string2)).exists()) continue;
            return file2;
        }
        return file;
    }

    public static String getDemoProductFullName(DemoInfoItem demoInfoItem) {
        return DemoInfoUtils.getDemoProductFullName(demoInfoItem.getProduct(), demoInfoItem.getProductType());
    }

    public static String getDemoProductFullName(String string, String string2) {
        if (string2 == null) {
            return string;
        }
        String string3 = ProductInfoUtils.appendCategoryToProductName(string, string2);
        if (HelpInfo.getHelpInfoItemByName(string3) != null) {
            return string3;
        }
        if (HelpInfo.getHelpInfoItemByName(string) != null) {
            return string;
        }
        return string3;
    }

    public static String getIdentifier(DemoInfoItem demoInfoItem) {
        if (demoInfoItem.getFilename() != null && demoInfoItem.getFilename().length() > 0) {
            return demoInfoItem.getFilename();
        }
        if (demoInfoItem.getSource() != null && demoInfoItem.getSource().length() > 0) {
            return demoInfoItem.getSource();
        }
        return demoInfoItem.getCallback();
    }

    public static String getIdentifierForTreeNode(DemoTreeItem demoTreeItem) {
        StringBuilder stringBuilder = new StringBuilder(DemoInfoUtils.getIdentifier(demoTreeItem));
        if (stringBuilder.length() == 0) {
            for (TreeNode treeNode = demoTreeItem; treeNode != null; treeNode = treeNode.getParent()) {
                stringBuilder.insert(0, ((Object)treeNode).toString());
            }
        }
        return stringBuilder.toString();
    }
}

