/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabPath;
import com.mathworks.mlwidgets.help.AbstractAddOnFileProvider;
import com.mathworks.mlwidgets.help.AddOnFileProvider;
import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.DemoParser;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.mlwidgets.help.DemosDataHolder;
import com.mathworks.mlwidgets.help.DemosDataListener;
import com.mathworks.mlwidgets.help.HelpDataObserver;
import com.mathworks.mlwidgets.help.HelpDataWorker;
import com.mathworks.mlwidgets.help.HelpDataWorkerStrategy;
import com.mathworks.util.FileUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DemosData {
    public static final String ML_IMAGE_PATH = "$toolbox/matlab/icons/matlabicon.gif";
    public static final String SL_IMAGE_PATH = "$toolbox/simulink/simulink/simulinkicon.gif";
    public static final String LINKS_IMAGE_PATH = "$toolbox/matlab/icons/linkproduct.png";
    public static final String INTRO_IMAGE_PATH = "$toolbox/matlab/icons/greencircleicon.gif";
    private static final String MATLAB_NAME = "matlab";
    private static final String SIMULINK_NAME = "simulink";
    private static final String TOOLBOXES_NAME = "toolboxes";
    private static final String BLOCKSETS_NAME = "blocksets";
    private static final String LINKS_NAME = "links and targets";
    private static final String NO_CATEGORY_NAME = "default";
    private static final String DEMOS_FILE_NAME = "demos.xml";
    private static DocumentBuilder sDocBuilder = null;
    private static DemosXmlFileProvider sXmlFileProvider = null;
    private static final HelpDataWorker<DemosDataHolder> HELP_DATA_WORKER = new HelpDataWorker();
    private static DemosDataHolder sCurrentDemosData = null;
    private static List<String> sDemoFilesFromPath = null;
    private static List<DemosDataListener> sListeners = null;

    private DemosData() {
    }

    public static DemoTreeItem findProduct(String string, String string2) {
        DemosDataHolder demosDataHolder;
        if ((string == null || string.isEmpty()) && (string2 == null || string2.isEmpty())) {
            string2 = MATLAB_NAME;
        }
        if ((demosDataHolder = DemosData.getCurrentDemosData()) != null && demosDataHolder.isPopulated()) {
            return demosDataHolder.getDemoTreeItem(string, string2);
        }
        return null;
    }

    public static DemoTreeItem getItemById(String string) {
        DemosDataHolder demosDataHolder = DemosData.getCurrentDemosData();
        if (demosDataHolder != null && demosDataHolder.isPopulated()) {
            return demosDataHolder.getDemoTreeItemById(string);
        }
        return null;
    }

    public static synchronized void addDemosDataListener(DemosDataListener demosDataListener) {
        DemosData.addDemosDataListener(demosDataListener, false);
    }

    public static synchronized void addDemosDataListener(DemosDataListener demosDataListener, boolean bl) {
        if (sListeners == null) {
            sListeners = new ArrayList<DemosDataListener>();
        }
        sListeners.add(demosDataListener);
        if (bl) {
            if (DemosData.isPopulated()) {
                demosDataListener.demosPopulated();
            } else {
                demosDataListener.demosCleared();
            }
        }
    }

    public static void reload() {
        DemosData.repopulate(DemosData.getDemoFilesFromPath(), true);
    }

    public static List<DemoTreeItem> getUserDemos() {
        DemosDataHolder demosDataHolder = DemosData.getCurrentDemosData();
        if (demosDataHolder != null && demosDataHolder.isPopulated()) {
            return demosDataHolder.getUserDemos();
        }
        return null;
    }

    public static List<String> getDemosXmlFiles() {
        DemosDataHolder demosDataHolder = DemosData.getCurrentDemosData();
        if (demosDataHolder != null && demosDataHolder.isPopulated()) {
            return Collections.unmodifiableList(demosDataHolder.getDemosXmlFiles());
        }
        return null;
    }

    public static synchronized void removeDemosDataListener(DemosDataListener demosDataListener) {
        if (sListeners != null) {
            sListeners.remove(demosDataListener);
        }
    }

    private static synchronized List<DemosDataListener> getDemosDataListeners() {
        return sListeners;
    }

    private static void initialize(List<String> list) {
        if (list != null) {
            DemosData.populate(list);
        }
    }

    private static synchronized void repopulate(List<String> list, boolean bl) {
        if (list != null && (bl || DemosData.needsRefresh(list))) {
            DemosData.populate(list);
        }
    }

    private static synchronized List<String> getDemoFilesFromPath() {
        if (sDemoFilesFromPath == null) {
            List<String> list = DemosData.getXmlFileProvider().getDemosXmlFiles();
            DemosData.setDemoFilesFromPath(DemosData.cleanupDemosXmlFiles(list));
        }
        return Collections.unmodifiableList(sDemoFilesFromPath);
    }

    private static synchronized void setDemoFilesFromPath(List<String> list) {
        sDemoFilesFromPath = list;
    }

    static boolean hasThirdPartyDemos() {
        List<String> list = DemosData.getDemoFilesFromPath();
        return list != null && !list.isEmpty();
    }

    private static List<String> cleanupDemosXmlFiles(List<String> list) {
        if (list != null) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(list);
            return new ArrayList<String>(linkedHashSet);
        }
        return Collections.emptyList();
    }

    private static boolean needsRefresh(Collection<String> collection) {
        DemosDataHolder demosDataHolder = DemosData.getCurrentDemosData();
        if (demosDataHolder != null) {
            List<String> list = demosDataHolder.getDemosXmlFiles();
            return DemosData.checkForFileListChanges(list, collection);
        }
        return true;
    }

    private static boolean checkForFileListChanges(Collection<String> collection, Collection<String> collection2) {
        if (collection2.size() == collection.size()) {
            for (String string : collection2) {
                if (collection.contains(string)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static synchronized void populate(final List<String> list) {
        HelpDataWorkerStrategy<DemosDataHolder> helpDataWorkerStrategy = new HelpDataWorkerStrategy<DemosDataHolder>(){
            private final DemosDataHolder iHolder;
            {
                this.iHolder = new DemosDataHolder(list);
            }

            @Override
            public void beforePopulateEdt() {
                boolean bl = DemosData.isPopulated();
                DemosData.setCurrentDemosData(this.iHolder);
                if (bl) {
                    DemosData.notifyListeners();
                }
            }

            @Override
            public void populate(HelpDataObserver<DemosDataHolder> helpDataObserver) {
                FinishPopulateRunnable finishPopulateRunnable = new FinishPopulateRunnable(helpDataObserver, this.iHolder);
                finishPopulateRunnable.setXmlFileList(list);
                if (DemosData.isActiveHolder(this.iHolder)) {
                    if (Matlab.isMatlabAvailable()) {
                        Matlab.whenMatlabReady((Runnable)new FindDemosRunnable(finishPopulateRunnable, this.iHolder));
                    } else {
                        new Thread(finishPopulateRunnable).start();
                    }
                }
            }

            @Override
            public void afterPopulateEdt(DemosDataHolder demosDataHolder) {
                demosDataHolder.setPopulated(true);
                DemosData.notifyListeners();
            }
        };
        HELP_DATA_WORKER.populate(helpDataWorkerStrategy);
    }

    private static void notifyListeners() {
        List<DemosDataListener> list = DemosData.getDemosDataListeners();
        if (list != null) {
            ArrayList<DemosDataListener> arrayList = new ArrayList<DemosDataListener>(DemosData.getDemosDataListeners());
            for (DemosDataListener demosDataListener : arrayList) {
                if (DemosData.isPopulated()) {
                    demosDataListener.demosPopulated();
                    continue;
                }
                demosDataListener.demosCleared();
            }
        }
    }

    public static synchronized boolean isPopulated() {
        DemosDataHolder demosDataHolder = DemosData.getCurrentDemosData();
        return demosDataHolder != null && demosDataHolder.isPopulated();
    }

    public static DemoTreeItem getItemForXmlFile(String string) {
        DemoTreeItem demoTreeItem = null;
        String string2 = FileUtils.normalizePathname((String)string);
        String string3 = DemoInfoUtils.getLocalizedDemoFilename(string2);
        DemosDataHolder demosDataHolder = DemosData.getCurrentDemosData();
        if (demosDataHolder != null && demosDataHolder.isPopulated()) {
            demoTreeItem = demosDataHolder.getDemoTreeItemForXmlFile(string3);
        }
        if (demoTreeItem == null) {
            demoTreeItem = DemosData.processXmlFilename(string3, demosDataHolder);
        }
        return demoTreeItem;
    }

    private static void createProductItems(Iterable<String> iterable, Document[] documentArray, DemosDataHolder demosDataHolder) {
        for (String string : iterable) {
            DemosData.parseAndAddXmlFile(demosDataHolder, string);
        }
        if (documentArray != null) {
            for (Document document : documentArray) {
                DemosData.parseAndAddDemosMFile(demosDataHolder, document);
            }
        }
    }

    private static void parseAndAddXmlFile(DemosDataHolder demosDataHolder, String string) {
        try {
            String string2 = FileUtils.normalizePathname((String)string);
            DemoTreeItem demoTreeItem = demosDataHolder.getDemoTreeItemForXmlFile(string2);
            if (demoTreeItem == null) {
                demoTreeItem = DemosData.processXmlFilename(string2, demosDataHolder);
            }
            if (demoTreeItem != null) {
                DemosData.addDemosXmlItem(demoTreeItem, demosDataHolder);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void parseAndAddDemosMFile(DemosDataHolder demosDataHolder, Document document) {
        try {
            DemoTreeItem demoTreeItem = DemoParser.processDocument("", document, demosDataHolder);
            DemosData.addDemosXmlItem(demoTreeItem, demosDataHolder);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addDemosXmlItem(DemoTreeItem demoTreeItem, DemosDataHolder demosDataHolder) {
        String string = demoTreeItem.getProductType();
        String string2 = NO_CATEGORY_NAME;
        if (string == null) {
            string2 = NO_CATEGORY_NAME;
        } else if (string.equalsIgnoreCase(MATLAB_NAME)) {
            string2 = MATLAB_NAME;
        } else if (string.equalsIgnoreCase("toolbox")) {
            string2 = TOOLBOXES_NAME;
        } else if (string.equalsIgnoreCase(SIMULINK_NAME)) {
            string2 = SIMULINK_NAME;
        } else if (string.equalsIgnoreCase("blockset")) {
            string2 = BLOCKSETS_NAME;
        } else if (string.equalsIgnoreCase("links_targets")) {
            string2 = LINKS_NAME;
        }
        demosDataHolder.addProductItem(string2, demoTreeItem);
    }

    private static synchronized DemoTreeItem processXmlFilename(String string, DemosDataHolder demosDataHolder) {
        try {
            return DemosData.parseDemosXmlFile(string, demosDataHolder);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("Warning: In file " + string + ", line " + sAXParseException.getLineNumber() + ", column " + sAXParseException.getColumnNumber() + ": " + sAXParseException.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static DemoTreeItem parseDemosXmlFile(String string, DemosDataHolder demosDataHolder) throws IOException, SAXException {
        File file = new File(string);
        DocumentBuilder documentBuilder = DemosData.getDocumentBuilder();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Document document = documentBuilder.parse(new InputSource(fileInputStream));
            DemoTreeItem demoTreeItem = DemoParser.processDocument(string, document, demosDataHolder);
            return demoTreeItem;
        }
    }

    private static synchronized DocumentBuilder getDocumentBuilder() {
        if (sDocBuilder == null) {
            block3: {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                try {
                    sDocBuilder = documentBuilderFactory.newDocumentBuilder();
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError((Object)("Could not configure parser: " + parserConfigurationException.getMessage()));
                }
            }
            sDocBuilder.setErrorHandler(new DemoErrorHandler());
        }
        return sDocBuilder;
    }

    private static synchronized void setCurrentDemosData(DemosDataHolder demosDataHolder) {
        sCurrentDemosData = demosDataHolder;
    }

    private static synchronized DemosDataHolder getCurrentDemosData() {
        return sCurrentDemosData;
    }

    private static boolean isActiveHolder(DemosDataHolder demosDataHolder) {
        DemosDataHolder demosDataHolder2 = DemosData.getCurrentDemosData();
        return demosDataHolder2 != null && demosDataHolder2.equals(demosDataHolder);
    }

    private static File findDemosFile(File file) {
        File file2 = new File(file, DEMOS_FILE_NAME);
        if (FileUtils.fileExists((File)file2)) {
            return file2;
        }
        return null;
    }

    public static synchronized void setXmlFileProvider(DemosXmlFileProvider demosXmlFileProvider) {
        sXmlFileProvider = demosXmlFileProvider;
        DemosData.setDemoFilesFromPath(null);
        List<String> list = DemosData.getXmlFileProvider().getDemosXmlFiles();
        DemosData.setDemoFilesFromPath(DemosData.cleanupDemosXmlFiles(list));
        DemosData.initialize(DemosData.getDemoFilesFromPath());
    }

    private static synchronized DemosXmlFileProvider getXmlFileProvider() {
        if (sXmlFileProvider == null) {
            sXmlFileProvider = new DefaultDemosXmlFileProvider();
        }
        return sXmlFileProvider;
    }

    static {
        DemosData.initialize(DemosData.getDemoFilesFromPath());
        DemosInfoListener demosInfoListener = new DemosInfoListener();
        MatlabPath.addActionListener((ActionListener)demosInfoListener);
    }

    private static class DefaultDemosXmlFileProvider
    extends AbstractAddOnFileProvider
    implements DemosXmlFileProvider {
        private DefaultDemosXmlFileProvider() {
        }

        @Override
        public List<String> getDemosXmlFiles() {
            ArrayList<String> arrayList = new ArrayList<String>();
            List<File> list = this.getSearchPath();
            if (list != null) {
                for (File file : list) {
                    File file2 = DemosData.findDemosFile(file);
                    if (file2 == null) continue;
                    arrayList.add(DemoInfoUtils.getLocalizedDemoFilename(file2.getAbsolutePath()));
                }
                return arrayList;
            }
            return null;
        }
    }

    public static interface DemosXmlFileProvider
    extends AddOnFileProvider {
        public List<String> getDemosXmlFiles();
    }

    private static class DemoErrorHandler
    implements ErrorHandler {
        private DemoErrorHandler() {
        }

        @Override
        public void error(SAXParseException sAXParseException) {
            System.out.println(sAXParseException.getLocalizedMessage());
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) {
            System.out.println(sAXParseException.getLocalizedMessage());
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            System.out.println(sAXParseException.getLocalizedMessage());
        }
    }

    private static class DemosInfoListener
    implements ActionListener {
        private DemosInfoListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    DemosData.setDemoFilesFromPath(null);
                    List<String> list = DemosData.getXmlFileProvider().getDemosXmlFiles();
                    DemosData.setDemoFilesFromPath(DemosData.cleanupDemosXmlFiles(list));
                    DemosData.repopulate(DemosData.getDemoFilesFromPath(), false);
                }
            }, "Repopulate Demo");
            thread.setDaemon(true);
            thread.start();
        }
    }

    private static class FinishPopulateRunnable
    implements Runnable {
        private final HelpDataObserver<DemosDataHolder> iObserver;
        private final DemosDataHolder iHolder;
        private List<String> iXmlFileList;
        private Document[] iOldDocuments;

        private FinishPopulateRunnable(HelpDataObserver<DemosDataHolder> helpDataObserver, DemosDataHolder demosDataHolder) {
            this.iObserver = helpDataObserver;
            this.iHolder = demosDataHolder;
        }

        private void setXmlFileList(List<String> list) {
            this.iXmlFileList = list;
        }

        private void setDemosMFiles(Document[] documentArray) {
            this.iOldDocuments = documentArray;
        }

        @Override
        public void run() {
            if (DemosData.isActiveHolder(this.iHolder)) {
                DemosData.createProductItems(this.iXmlFileList, this.iOldDocuments, this.iHolder);
            }
            if (DemosData.isActiveHolder(this.iHolder)) {
                this.iObserver.dataPopulated(this.iHolder);
            }
        }
    }

    private static class FindDemosRunnable
    implements Runnable {
        private final FinishPopulateRunnable iFinishRunnable;
        private final DemosDataHolder iHolder;

        private FindDemosRunnable(FinishPopulateRunnable finishPopulateRunnable, DemosDataHolder demosDataHolder) {
            this.iFinishRunnable = finishPopulateRunnable;
            this.iHolder = demosDataHolder;
        }

        @Override
        public void run() {
            Object object;
            Object object2 = null;
            if (DemosData.isActiveHolder(this.iHolder)) {
                try {
                    object = Matlab.mtFeval((String)"convertdemostodom", null, (int)1);
                    object2 = object instanceof Document ? new Document[]{(Document)object} : (object instanceof Document[] ? (Document[])object : null);
                }
                catch (Exception exception) {
                    object2 = null;
                }
            }
            if (DemosData.isActiveHolder(this.iHolder)) {
                this.iFinishRunnable.setDemosMFiles(object2);
                object = new Thread((Runnable)this.iFinishRunnable, "Demos Runnable");
                ((Thread)object).setDaemon(true);
                ((Thread)object).start();
            }
        }
    }
}

