/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocRoot;
import com.mathworks.helpsearch.index.LocaleFileLocator;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.html.UrlBuilder;
import com.mathworks.html.UrlTransformer;
import com.mathworks.html.WebUrl;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.actionbrowser.FunctionReferenceUtils;
import com.mathworks.mlwidgets.help.CSHelpTopicMap;
import com.mathworks.mlwidgets.help.ClassicHelpDataAccessor;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.mlwidgets.help.DocLocaleValidator;
import com.mathworks.mlwidgets.help.HelpInfoItem;
import com.mathworks.mlwidgets.help.HelpLocale;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpTopic;
import com.mathworks.mlwidgets.help.LocalizationFilter;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.LanguageLocale;
import com.mathworks.util.LanguageUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HelpUtils {
    private static LanguageLocaleInfo sLanguageLocaleInfo = null;
    private static final String RESDIR = "com.mathworks.mlwidgets.help.resources.";
    private static final ResourceBundle RES = ResourceBundle.getBundle("com.mathworks.mlwidgets.help.resources.RES_HelpInfo");
    private static HelpDependencyProvider sDependencyProvider = new DefaultDependencyProvider();
    private static final Map<String, String> HELP_DIRECTORIES_TO_REPLACE = new LinkedHashMap<String, String>();
    private static final Map<String, String> HELP_MAPFILES_TO_REPLACE;

    static void setLanguageLocale(Locale locale) {
        HelpUtils.setLanguageLocale(LanguageLocale.getSupportedLanguageLocale(locale));
    }

    private static void setLanguageLocale(String string) {
        HelpUtils.setLanguageLocale(string, null);
    }

    private static void setLanguageLocale(String string, String string2) {
        HelpUtils.setLanguageLocale(LanguageLocale.getSupportedLanguageLocale(string, string2));
    }

    private static void setLanguageLocale(LanguageLocale languageLocale) {
        LanguageLocaleInfo languageLocaleInfo = HelpUtils.getValidatedLanguageLocaleInfo(languageLocale);
        if (languageLocaleInfo == null) {
            throw new IllegalArgumentException("LanguageLocale " + (Object)((Object)languageLocale) + " is not allowed for " + HelpPrefs.getDocCenterLocation().toString() + ".");
        }
        HelpUtils.setLanguageLocaleInfo(languageLocaleInfo);
    }

    public static LanguageLocale getLanguageLocale() {
        return HelpUtils.getLanguageLocaleInfo().getLanguageLocale();
    }

    static synchronized LanguageLocaleInfo getLanguageLocaleInfo() {
        if (sLanguageLocaleInfo == null) {
            HelpUtils.setLanguageLocaleInfo(HelpUtils.getInitialLanguageLocaleInfo());
        }
        return sLanguageLocaleInfo;
    }

    private static LanguageLocaleInfo getInitialLanguageLocaleInfo() {
        LanguageLocale languageLocale;
        Locale locale = HelpUtils.getDependencyProvider().getHelpLocale();
        DocLocaleValidator docLocaleValidator = new DocLocaleValidator(HelpPrefs.getDocCenterLocation(), locale);
        Locale locale2 = HelpPrefs.getDocLocale();
        if (locale2 != null && docLocaleValidator.isAllowed(languageLocale = LanguageLocale.fromLocale(locale2))) {
            if (docLocaleValidator.isLocaleForcedEnglish(languageLocale.getLocale())) {
                LanguageLocale languageLocale2 = LanguageLocale.fromLocale(locale);
                return new LanguageLocaleInfo(LanguageLocale.ENGLISH, languageLocale2.getLocale());
            }
            return new LanguageLocaleInfo(languageLocale);
        }
        languageLocale = LanguageLocale.getSupportedLanguageLocale(locale);
        if (docLocaleValidator.isAllowed(languageLocale)) {
            return new LanguageLocaleInfo(languageLocale);
        }
        return new LanguageLocaleInfo(LanguageLocale.ENGLISH, languageLocale.getLocale());
    }

    private static LanguageLocaleInfo getValidatedLanguageLocaleInfo(LanguageLocale languageLocale) {
        DocLocaleValidator docLocaleValidator = new DocLocaleValidator(HelpPrefs.getDocCenterLocation(), languageLocale.getLocale());
        return HelpUtils.getValidatedLanguageLocaleInfo(languageLocale, docLocaleValidator);
    }

    private static LanguageLocaleInfo getValidatedLanguageLocaleInfo(LanguageLocale languageLocale, DocLocaleValidator docLocaleValidator) {
        if (docLocaleValidator.isAllowed(languageLocale)) {
            Locale locale = HelpUtils.getDependencyProvider().getHelpLocale();
            DocLocaleValidator docLocaleValidator2 = new DocLocaleValidator(HelpPrefs.getDocCenterLocation(), locale);
            if (docLocaleValidator2.isLocaleForcedEnglish(languageLocale.getLocale())) {
                LanguageLocale languageLocale2 = LanguageLocale.fromLocale(locale);
                return new LanguageLocaleInfo(LanguageLocale.ENGLISH, languageLocale2.getLocale());
            }
            return new LanguageLocaleInfo(languageLocale);
        }
        return null;
    }

    private static synchronized void setLanguageLocaleInfo(LanguageLocaleInfo languageLocaleInfo) {
        sLanguageLocaleInfo = languageLocaleInfo;
    }

    public static boolean isEnglish() {
        return HelpUtils.getLanguageLocale().isEnglish();
    }

    public static boolean isJapanese() {
        return HelpUtils.getLanguageLocale() == LanguageLocale.JAPANESE;
    }

    public static String getLocaleString() {
        return HelpUtils.getLanguageLocale().getLocaleString();
    }

    public static String getDocDirectoryName() {
        return HelpLocale.getDocDirectoryName(HelpUtils.getLanguageLocale());
    }

    public static String[] getDemosDirectoryName() {
        return HelpLocale.getDemosDirectoryName(HelpUtils.getLanguageLocale());
    }

    public static File getLocalizedFile(File file) {
        if (file == null) {
            return null;
        }
        return new File(HelpUtils.getLocalizedDocCenterFilename(file.getAbsolutePath(), false));
    }

    public static String getLocalizedFilename(String string) {
        if (string == null || string.equals("about:blank")) {
            return string;
        }
        return HelpUtils.getLocalizedDocCenterFilename(string, true);
    }

    private static String getLocalizedDocCenterFilename(String string, boolean bl) {
        Url url = HelpUtils.convertClassicDocPath(string);
        if (url == null) {
            return string;
        }
        if (!HelpUtils.needsLocalization(url)) {
            return url.toString();
        }
        if (url.getType() != Url.UrlType.FILE) {
            return url.toString();
        }
        FileUrl fileUrl = (FileUrl)url;
        if (!HelpUtils.isEnglish()) {
            fileUrl = HelpUtils.getLocalizedFile(fileUrl, HelpUtils.getLanguageLocale());
        }
        if (!HelpUtils.isValidFile(fileUrl)) {
            return string;
        }
        File file = fileUrl.getFile();
        String string2 = HelpUtils.getFilePath(file);
        string2 = string2.replaceAll("\\\\", "/");
        if (bl) {
            String string3;
            String string4 = fileUrl.getQueryString();
            if (string4 != null && !string4.isEmpty()) {
                string2 = string2 + '?' + string4;
            }
            if ((string3 = fileUrl.getTarget()) != null && !string3.isEmpty()) {
                string2 = string2 + '#' + string3;
            }
        }
        return string2;
    }

    private static String getFilePath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static Url getLocalizedUrl(Url url) {
        if (!HelpUtils.needsLocalization(url)) {
            return url;
        }
        UrlTransformer<String> urlTransformer = new UrlTransformer<String>(){

            protected String transformWebUrl(WebUrl webUrl) {
                return webUrl.toString();
            }

            protected String transformFileUrl(FileUrl fileUrl) {
                String string;
                StringBuilder stringBuilder = new StringBuilder(fileUrl.getFile().getAbsolutePath());
                String string2 = fileUrl.getQueryString();
                if (string2 != null && !string2.isEmpty()) {
                    stringBuilder.append('?').append(string2);
                }
                if ((string = fileUrl.getTarget()) != null && !string.isEmpty()) {
                    stringBuilder.append('#').append(string);
                }
                return stringBuilder.toString();
            }

            protected String transformCustomProtocolUrl(CustomProtocolUrl customProtocolUrl) {
                return customProtocolUrl.toString();
            }
        };
        String string = (String)urlTransformer.transformUrl(url);
        String string2 = HelpUtils.getLocalizedFilename(string);
        if (string2.equals(string)) {
            return url;
        }
        try {
            return Url.parse((String)string2);
        }
        catch (MalformedURLException malformedURLException) {
            return url;
        }
    }

    private static boolean needsLocalization(Url url) {
        String string = url.getParameterValue("lang");
        return string == null || !string.equalsIgnoreCase("en");
    }

    public static Url convertClassicDocPath(String string) {
        String string2 = string;
        Url url = HelpUtils.getUrlUnderDocroot(string);
        if (url != null) {
            string2 = url.toString();
            for (Map.Entry<String, String> entry : HELP_DIRECTORIES_TO_REPLACE.entrySet()) {
                string2 = HelpUtils.replaceDirectoryNameInPath(string2, entry.getKey(), entry.getValue());
            }
            if (string.endsWith(".map")) {
                for (Map.Entry<String, String> entry : HELP_MAPFILES_TO_REPLACE.entrySet()) {
                    string2 = HelpUtils.replaceDirectoryNameInPath(string2, entry.getKey(), entry.getValue());
                }
            }
        }
        return Url.parseSilently((String)string2);
    }

    private static Url getUrlUnderDocroot(String string) {
        try {
            Url url = Url.parse((String)string);
            return HelpUtils.getDependencyProvider().isUrlUnderDocroot(url) ? url : null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static boolean isValidFile(FileUrl fileUrl) {
        return fileUrl != null && fileUrl.getFile().exists();
    }

    private static FileUrl getLocalizedFile(FileUrl fileUrl, LanguageLocale languageLocale) {
        Locale locale = languageLocale.getLocale();
        locale = HelpUtils.correctLocale(locale);
        return HelpUtils.getLocalizedFile(fileUrl, locale);
    }

    private static Locale correctLocale(Locale locale) {
        LanguageLocale languageLocale = LanguageLocale.fromLocale(locale);
        return languageLocale == null ? locale : languageLocale.getLocaleForLangLocaleString();
    }

    private static FileUrl getLocalizedFile(FileUrl fileUrl, Locale locale) {
        LocaleFileLocator localeFileLocator = new LocaleFileLocator(locale);
        File file = fileUrl.getFile();
        File file2 = localeFileLocator.findLocalizedFile(file);
        if (!file2.equals(file)) {
            UrlBuilder urlBuilder = UrlBuilder.fromFile((File)file2);
            Map map = fileUrl.getParameters();
            if (map != null) {
                urlBuilder.setParameters(map);
            }
            urlBuilder.setTarget(fileUrl.getTarget());
            return (FileUrl)urlBuilder.toUrl();
        }
        return fileUrl;
    }

    public static String getAlternateLanguagePath(String string) {
        return HelpUtils.convertToNonLocalizedPath(HelpUtils.getLanguageLocale(), string);
    }

    public static String removeLocalizedPath(String string) {
        return HelpUtils.convertToNonLocalizedPath(HelpUtils.getLanguageLocale(), string);
    }

    static String convertToNonLocalizedPath(LanguageLocale languageLocale, String string) {
        return string.replace("_" + HelpUtils.getLocaleString() + ".", ".");
    }

    public static String getMapfileName(String string, String string2) {
        return CSHelpTopicMap.findLocalizedMapFileName(string, string2);
    }

    public static boolean isDocInstalled() {
        return HelpPrefs.isDocInstalled();
    }

    public static String getInputFilename(String string, String string2, String string3) {
        String string4 = string + string2;
        String string5 = string + string3;
        String string6 = null;
        if (HelpUtils.getDependencyProvider().isStudentVersion()) {
            string6 = HelpUtils.getLocalizedFilename(string5);
        }
        if (string6 == null) {
            string6 = HelpUtils.getLocalizedFilename(string4);
        }
        return string6;
    }

    public static String getLocalizedString(String string) {
        return RES.getString(string);
    }

    public static String getPrefixForHtmlPath(String string) {
        HelpInfoItem[] helpInfoItemArray = HelpUtils.getDependencyProvider().getInstalledProductHelpInfo();
        if (helpInfoItemArray == null || string == null) {
            return string;
        }
        String string2 = HTMLUtils.getCanonicalUrl(string);
        if (!HelpUtils.isUnderDocroot(string2, HelpUtils.getDependencyProvider().getDocRoot())) {
            return string2;
        }
        String string3 = HelpUtils.findFileInProductHelp(string2);
        if (string3 == null) {
            string3 = HelpUtils.getLocalizedFilename(string2);
        }
        return string3 == null ? string2 : string3;
    }

    public static String getProductHelpPage(HelpInfoItem helpInfoItem, String string) {
        FileExistsFilter fileExistsFilter = new FileExistsFilter(string, true);
        return HelpUtils.findLocalizedOrAlternateFile(helpInfoItem.getUrlPrefix(), fileExistsFilter);
    }

    private static String findFileInProductHelp(String string) {
        HelpInfoItem[] helpInfoItemArray;
        String string2 = HTMLUtils.getCanonicalFilepath(string);
        RelativePathFilter relativePathFilter = new RelativePathFilter(string2);
        for (HelpInfoItem helpInfoItem : helpInfoItemArray = HelpUtils.getDependencyProvider().getInstalledProductHelpInfo()) {
            String string3;
            String string4;
            if (helpInfoItem == null || (string4 = HelpUtils.findLocalizedOrAlternateFile(helpInfoItem.getHelpLoc(), relativePathFilter)) == null || (string3 = HelpUtils.getProductHelpPage(helpInfoItem, string4)) == null) continue;
            return string3;
        }
        return null;
    }

    private static boolean isUnderDocroot(String string, String string2) {
        return StringUtils.startsWith((String)string, (String)string2, (int)0, (boolean)PlatformInfo.isUnix());
    }

    static boolean isUnderDocroot(String string) {
        string = string.replace("\\", "/");
        String string2 = HelpUtils.getDependencyProvider().getDocRoot();
        return HelpUtils.isUnderDocroot(string, string2);
    }

    public static String convertPathToUrlPrefix(String string) {
        String string2 = string.replace('\\', '/');
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return string2;
    }

    static String findLocalizedOrAlternateFile(String string, LocalizationFilter localizationFilter) {
        Map.Entry<String, String> entry;
        if (string == null || localizationFilter == null) {
            return null;
        }
        String string2 = HelpUtils.findLocalizedOrAlternateFileForPath(string, localizationFilter);
        if (string2 != null) {
            return string2;
        }
        Iterator<Map.Entry<String, String>> iterator = HELP_DIRECTORIES_TO_REPLACE.entrySet().iterator();
        while (iterator.hasNext() && (string2 = HelpUtils.convertPathAndFindLocalizedOrAlternate(string, localizationFilter, (entry = iterator.next()).getKey(), entry.getValue())) == null) {
        }
        return string2;
    }

    private static String convertPathAndFindLocalizedOrAlternate(String string, LocalizationFilter localizationFilter, String string2, String string3) {
        String string4 = HelpUtils.replaceDirectoryNameInPath(string, string2, string3);
        if (!string.equalsIgnoreCase(string4)) {
            return HelpUtils.findLocalizedOrAlternateFileForPath(string4, localizationFilter);
        }
        return null;
    }

    static String replaceDirectoryNameInPath(String string, String string2, String string3) {
        String string4 = string.replace('\\', '/');
        Pattern pattern = Pattern.compile("/" + Pattern.quote(string2) + "(?=/|$)");
        Matcher matcher = pattern.matcher(string4);
        if (matcher.find()) {
            String string5 = string3 != null ? "/" + string3 : "";
            return matcher.replaceFirst(string5);
        }
        return string;
    }

    private static String findLocalizedOrAlternateFileForPath(String string, LocalizationFilter localizationFilter) {
        if (string == null || localizationFilter == null) {
            return null;
        }
        if (localizationFilter.accept(string)) {
            return localizationFilter.getAcceptedPath();
        }
        String string2 = HelpUtils.getAlternateLanguagePath(string);
        if (string2 != null && localizationFilter.accept(string2)) {
            return localizationFilter.getAcceptedPath();
        }
        if (!HelpUtils.isEnglish() && (string2 = HelpUtils.convertToNonLocalizedPath(LanguageLocale.ENGLISH, string2)) != null && localizationFilter.accept(string2)) {
            return localizationFilter.getAcceptedPath();
        }
        return null;
    }

    private static synchronized void setDependencyProvider(HelpDependencyProvider helpDependencyProvider) {
        sDependencyProvider = helpDependencyProvider;
    }

    static synchronized HelpDependencyProvider getDependencyProvider() {
        return sDependencyProvider;
    }

    public static String getDocCommandArg(String string, boolean bl) {
        HelpTopic helpTopic = new HelpTopic(string).methodOrProperty(bl);
        return helpTopic.getDocCommandArgument();
    }

    public static List<ReferenceData> getReferenceData(String string, boolean bl) {
        HelpTopic helpTopic = new HelpTopic(string).methodOrProperty(bl);
        return helpTopic.getReferenceData();
    }

    static {
        HELP_DIRECTORIES_TO_REPLACE.put("toolbox", null);
        HELP_DIRECTORIES_TO_REPLACE.put("techdoc", "matlab");
        HELP_DIRECTORIES_TO_REPLACE.put("base", null);
        HELP_DIRECTORIES_TO_REPLACE.put("physmod/drive", "physmod/sdl/drive");
        HELP_DIRECTORIES_TO_REPLACE.put("physmod/mech", "physmod/sm/mech");
        HELP_DIRECTORIES_TO_REPLACE.put("physmod/powersys", "physmod/sps/powersys");
        HELP_MAPFILES_TO_REPLACE = new LinkedHashMap<String, String>();
        HELP_MAPFILES_TO_REPLACE.put("mapfiles/creating_guis.map", "matlab/creating_guis/creating_guis.map");
        HELP_MAPFILES_TO_REPLACE.put("mapfiles/creating_plots.map", "matlab/creating_plots/creating_plots.map");
        HELP_MAPFILES_TO_REPLACE.put("mapfiles/matlab_env_csh.map", "matlab/env_csh/env_csh.map");
        HELP_MAPFILES_TO_REPLACE.put("mapfiles/learn_matlab.map", "matlab/learn_matlab/learn_matlab.map");
        HELP_MAPFILES_TO_REPLACE.put("mapfiles/matlab_env.map", "matlab/matlab_env/matlab_env.map");
        HELP_MAPFILES_TO_REPLACE.put("mapfiles/matlab_prog.map", "matlab/matlab_prog/matlab_prog.map");
        HELP_MAPFILES_TO_REPLACE.put("mapfiles/ref.map", "matlab/ref/matlab_ref.map");
        HELP_MAPFILES_TO_REPLACE.put("mapfiles/visualize.map", "matlab/visualize/matlab_visualize.map");
        HELP_MAPFILES_TO_REPLACE.put("mapfiles/control.map", "control/control.map");
        HELP_MAPFILES_TO_REPLACE.put("mapfiles/finderiv.map", "finderiv/helptargets.map");
        HELP_MAPFILES_TO_REPLACE.put("mapfiles/simulink.map", "simulink/helptargets.map");
        HELP_MAPFILES_TO_REPLACE.put("mapfiles/stateflow.map", "stateflow/stateflow.map");
        HELP_MAPFILES_TO_REPLACE.put("mapfiles/xpc.map", "xpc/xpc.map");
    }

    public static class DefaultDependencyProvider
    implements HelpDependencyProvider {
        @Override
        public String getDocRoot() {
            return MLHelpServices.getDocRoot().replace("\\", "/");
        }

        @Override
        public boolean isStudentVersion() {
            return Matlab.isStudentVersion();
        }

        @Override
        public HelpInfoItem[] getInstalledProductHelpInfo() {
            return ClassicHelpDataAccessor.getInstalledProductHelpInfo();
        }

        @Override
        public List<String> getInstalledProductShortNames() {
            return FunctionReferenceUtils.getInstalledProductShortNames(false);
        }

        @Override
        public String getHelpLanguage() {
            return LanguageUtils.getHelpLanguage();
        }

        @Override
        public Locale getHelpLocale() {
            return LanguageUtils.getHelpLocale();
        }

        @Override
        public boolean isUrlUnderDocroot(Url url) {
            try {
                return DefaultDependencyProvider.isUrlUnderDocCenterDocroot(url);
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }

        private static boolean isUrlUnderDocCenterDocroot(Url url) throws MalformedURLException {
            DocRoot[] docRootArray;
            for (DocRoot docRoot : docRootArray = new DocRoot[]{DocCenterDocConfig.getLocalConfig().getDocRoot(), DocCenterDocConfig.getWebConfig().getDocRoot()}) {
                if (!docRoot.isUnderDocRoot(url)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface HelpDependencyProvider {
        public String getDocRoot();

        public boolean isStudentVersion();

        public HelpInfoItem[] getInstalledProductHelpInfo();

        public List<String> getInstalledProductShortNames();

        public String getHelpLanguage();

        public Locale getHelpLocale();

        public boolean isUrlUnderDocroot(Url var1);
    }

    static class RelativePathFilter
    implements LocalizationFilter {
        private String iAcceptedPath;
        private String iPath;

        RelativePathFilter(String string) {
            this.iPath = string != null ? string : "";
        }

        @Override
        public boolean accept(String string) {
            if (StringUtils.startsWith((String)this.iPath, (String)string, (int)0, (boolean)PlatformInfo.isUnix())) {
                this.iAcceptedPath = this.iPath.substring(string.length());
                return true;
            }
            this.iAcceptedPath = null;
            return false;
        }

        @Override
        public String getAcceptedPath() {
            return this.iAcceptedPath;
        }
    }

    private static class FileExistsFilter
    implements LocalizationFilter {
        private String iAcceptedPath;
        private String iRelativePathToFile;
        private boolean iConvertPathToUrlPrefix = false;

        FileExistsFilter() {
        }

        FileExistsFilter(String string, boolean bl) {
            this.iRelativePathToFile = string;
            this.iConvertPathToUrlPrefix = bl;
        }

        @Override
        public boolean accept(String string) {
            String string2;
            String string3 = string2 = this.iConvertPathToUrlPrefix ? HelpUtils.convertPathToUrlPrefix(string) : string;
            if (this.iRelativePathToFile != null) {
                string2 = string2 + this.iRelativePathToFile;
            }
            if (HTMLUtils.doesFileExist(string2)) {
                this.iAcceptedPath = string2;
                return true;
            }
            this.iAcceptedPath = null;
            return false;
        }

        @Override
        public String getAcceptedPath() {
            return this.iAcceptedPath;
        }
    }

    public static class LanguageLocaleInfo {
        private final LanguageLocale iLanguageLocale;
        private final Locale iLandingPageLocale;

        private LanguageLocaleInfo(LanguageLocale languageLocale) {
            this(languageLocale, (Locale)null);
        }

        private LanguageLocaleInfo(LanguageLocale languageLocale, Locale locale) {
            this.iLanguageLocale = languageLocale;
            this.iLandingPageLocale = locale;
        }

        LanguageLocale getLanguageLocale() {
            return this.iLanguageLocale;
        }

        Locale getLocale() {
            return this.iLanguageLocale.getLocale();
        }

        Locale getLandingPageLocale() {
            return this.iLandingPageLocale;
        }

        boolean isForceEnglish() {
            return this.iLandingPageLocale != null;
        }
    }
}

