/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.DocRoot;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.html.FileUrl;
import com.mathworks.html.Url;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.help.DocCenterDocConfig;
import com.mathworks.product.AbstractProduct;
import com.mathworks.product.Product;
import com.mathworks.product.dao.DaoFactory;
import com.mathworks.product.dao.DaoStrategyType;
import com.mathworks.product.dao.DefaultDaoFactory;
import com.mathworks.product.dao.ProductDao;
import com.mathworks.product.dao.config.DaoConfig;
import com.mathworks.product.dao.config.file.AbstractFileDaoConfig;
import com.mathworks.product.util.ProductIdentifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class InstalledProductUtils {
    private static final List<ProductIdentifier> INSTALLED_PRODUCT_IDS = InstalledProductUtils.findInstalledProducts();
    private static final List<ProductIdentifier> UNINSTALLED_PRODUCT_IDS = InstalledProductUtils.findUninstalledProducts(INSTALLED_PRODUCT_IDS);

    private InstalledProductUtils() {
    }

    public static String[] getClassNames() {
        return new String[]{InstalledProductUtils.class.getName()};
    }

    static List<ProductIdentifier> getInstalledProducts() {
        return Collections.unmodifiableList(INSTALLED_PRODUCT_IDS);
    }

    static List<ProductIdentifier> getUninstalledProducts() {
        return Collections.unmodifiableList(UNINSTALLED_PRODUCT_IDS);
    }

    static List<DocProduct> getInstalledDocProducts() {
        return Collections.unmodifiableList(InstalledProductUtils.findInstalledDocProducts());
    }

    private static List<ProductIdentifier> findInstalledProducts() {
        DaoConfiguration daoConfiguration = new DaoConfiguration(Matlab.matlabRoot());
        DaoFactory daoFactory = DefaultDaoFactory.getDao((DaoConfig)daoConfiguration);
        ProductDao productDao = daoFactory.getProductDao();
        Collection collection = productDao.getInstalledProducts();
        TreeSet treeSet = new TreeSet(collection);
        LinkedList<ProductIdentifier> linkedList = new LinkedList<ProductIdentifier>();
        for (Product product : treeSet) {
            ProductIdentifier productIdentifier = ProductIdentifier.get((int)product.getBitNumber());
            if (productIdentifier == null) continue;
            linkedList.add(productIdentifier);
        }
        if (linkedList.isEmpty()) {
            linkedList.add(ProductIdentifier.MATLAB);
        }
        return linkedList;
    }

    private static List<ProductIdentifier> findUninstalledProducts(Collection<ProductIdentifier> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (ProductIdentifier object2 : collection) {
            hashSet.add(object2.getName());
        }
        LinkedList linkedList = new LinkedList();
        List<ProductIdentifier> list = InstalledProductUtils.getSortedProductIdentifiers();
        for (ProductIdentifier productIdentifier : list) {
            if (hashSet.contains(productIdentifier.getName())) continue;
            linkedList.add(productIdentifier);
        }
        return linkedList;
    }

    /*
     * WARNING - void declaration
     */
    private static List<ProductIdentifier> getSortedProductIdentifiers() {
        ProductIdentifier productIdentifier;
        void product;
        ProductIdentifier[] productIdentifierArray = ProductIdentifier.values();
        TreeSet<ProdIdentifierProduct> treeSet = new TreeSet<ProdIdentifierProduct>();
        Object linkedList = productIdentifierArray;
        int n = ((ProductIdentifier[])linkedList).length;
        boolean bl = false;
        while (product < n) {
            productIdentifier = linkedList[product];
            treeSet.add(new ProdIdentifierProduct(productIdentifier.getBitNum(), productIdentifier.getName()));
            ++product;
        }
        linkedList = new LinkedList();
        for (Product product2 : treeSet) {
            productIdentifier = ProductIdentifier.get((int)product2.getBitNumber());
            if (productIdentifier == null) continue;
            linkedList.add(productIdentifier);
        }
        return linkedList;
    }

    private static List<DocProduct> findInstalledDocProducts() {
        DocCenterDocConfig<Url> docCenterDocConfig = DocCenterDocConfig.getInstance();
        DocumentationSet documentationSet = docCenterDocConfig.getDocumentationSet();
        List list = documentationSet.getAllProducts();
        return InstalledProductUtils.getDocProductsWithDocInstalled(list);
    }

    private static List<DocProduct> getDocProductsWithDocInstalled(Collection<DocProduct> collection) {
        LinkedList<DocProduct> linkedList = new LinkedList<DocProduct>();
        if (collection != null && !collection.isEmpty()) {
            for (DocProduct docProduct : collection) {
                if (!InstalledProductUtils.isDocInstalledForDocProduct(docProduct)) continue;
                linkedList.add(docProduct);
            }
        }
        return linkedList;
    }

    private static boolean isDocInstalledForDocProduct(DocProduct docProduct) {
        DocRoot<FileUrl> docRoot = DocCenterDocConfig.getLocalConfig().getDocRoot();
        FileUrl fileUrl = (FileUrl)docRoot.buildDocSetItemUrl((DocSetItem)docProduct, "doccenter.properties");
        return fileUrl.getFile().exists();
    }

    private static class DaoConfiguration
    extends AbstractFileDaoConfig {
        private DaoConfiguration(String string) {
            super(string);
        }

        public DaoStrategyType getType() {
            return DaoStrategyType.WRAPPER;
        }
    }

    private static class ProdIdentifierProduct
    extends AbstractProduct {
        private final int iBitNumber;
        private final String iName;

        private ProdIdentifierProduct(int n, String string) {
            this.iBitNumber = n;
            this.iName = string;
        }

        public Integer getBitNumber() {
            return this.iBitNumber;
        }

        public String getName() {
            return this.iName;
        }

        public String getVersion() {
            return null;
        }

        public String getRelease() {
            return null;
        }

        public String getDate() {
            return null;
        }
    }
}

