/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.addon;

import com.mathworks.help.helpui.DocSetItemProperties;
import com.mathworks.helpsearch.HelpLocation;
import com.mathworks.helpsearch.HybridHelpLocation;
import com.mathworks.helpsearch.RelativeHelpLocation;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;

public class InstalledSupportPackage {
    private final String fShortName;
    private final String fDisplayName;
    private final String fLegalName;
    private final HelpLocation fHelpLoc;
    private final String fBaseProduct;
    private final File fLocalDocRoot;

    private InstalledSupportPackage(HelpLocation helpLocation, String string, String string2, String string3, String string4, File file) {
        this.fHelpLoc = helpLocation;
        this.fDisplayName = string;
        this.fShortName = string2;
        this.fLegalName = string3;
        this.fBaseProduct = string4;
        this.fLocalDocRoot = file;
    }

    static InstalledSupportPackage buildSupportPackage(DocSetItemProperties docSetItemProperties, String string) throws IllegalStateException {
        String string2 = docSetItemProperties.getDisplayName();
        String string3 = docSetItemProperties.getShortName();
        String string4 = docSetItemProperties.getLegalName();
        String string5 = docSetItemProperties.getBaseProductShortName();
        String string6 = docSetItemProperties.getPathFromDocRoot();
        File file = InstalledSupportPackage.getSupportPackageDocRoot(string, string6);
        HelpLocation helpLocation = InstalledSupportPackage.getHelpLocation(file, string6);
        return new InstalledSupportPackage(helpLocation, string2, string3, string4, string5, file);
    }

    private static HelpLocation getHelpLocation(File file, String string) {
        assert (file != null && string != null);
        RelativeHelpLocation relativeHelpLocation = new RelativeHelpLocation(string);
        return new HybridHelpLocation(file, relativeHelpLocation);
    }

    private static File getSupportPackageDocRoot(String string, String string2) throws IllegalStateException {
        if (string == null || string2 == null) {
            throw new IllegalStateException("Cannot create a support package with null directory and/or null path from doc root.");
        }
        File file = new File(string);
        String[] stringArray = string2.replaceFirst("^[\\\\/]", "").split("[\\\\/]", -1);
        Collections.reverse(Arrays.asList(stringArray));
        for (String string3 : stringArray) {
            if (string3.isEmpty()) continue;
            if (file.getName().equalsIgnoreCase(string3)) {
                file = file.getParentFile();
                continue;
            }
            throw new IllegalStateException("Support package directory does not match path from doc root for directory " + string + " path " + string2);
        }
        return file;
    }

    public String getShortName() {
        return this.fShortName;
    }

    public String getDisplayName() {
        return this.fDisplayName;
    }

    public String getLegalName() {
        return this.fLegalName;
    }

    public HelpLocation getHelpLoc() {
        return this.fHelpLoc;
    }

    public String getBaseProduct() {
        return this.fBaseProduct;
    }

    public File getLocalDocRoot() {
        return this.fLocalDocRoot;
    }
}

