/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.functioncall;

import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceDataRetriever;
import com.mathworks.helpsearch.reference.ReferenceEntityRequest;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabLanguage;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlwidgets.help.DocCenterReferenceRetrievalStrategy;
import com.mathworks.mlwidgets.help.functioncall.Signature;
import com.mathworks.util.Log;
import com.mathworks.util.tree.Visitor;
import com.mathworks.widgets.Tokenizer;
import com.mathworks.widgets.TokenizerFactory;
import com.mathworks.widgets.text.mcode.MDocumentUtils;
import com.mathworks.widgets.text.mcode.MTree;
import com.mathworks.widgets.text.mcode.MTreeUtils;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class MFunctionCall {
    private String fFuncName = null;
    private String fFirstArgClassName = "";
    private String[] fAllClassNames = null;
    private int fCallPosition;
    private String fMFilePath;
    public static final String M_FILE_EXTENSION = ".m";
    private static final String RES_STR = "com.mathworks.mlwidgets.help.resources.RES_FunctionCall";
    private static ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mlwidgets.help.resources.RES_FunctionCall");
    private static HashMap<String, String> sFunctionSignatureMap = new HashMap();

    public static MFunctionCall getInstance(String string) throws ParseException {
        Object object;
        int n;
        int n2;
        Tokenizer.TokenInfo[] tokenInfoArray = TokenizerFactory.getMTokenizer().tokenize(string);
        int n3 = MFunctionCall.getFunctionBreakToken(tokenInfoArray, string);
        if (n3 < 0) {
            throw new ParseException(resources.getString("MFunctionCall.InvParens"), 0);
        }
        Tokenizer.TokenInfo[] tokenInfoArray2 = MFunctionCall.subTokenArrayToEnd(tokenInfoArray, n3 + 1);
        Tokenizer.TokenInfo[] tokenInfoArray3 = MFunctionCall.subTokenArray(tokenInfoArray, 0, n3);
        int n4 = MFunctionCall.getFirstOpenArrayParen(tokenInfoArray2);
        if (n4 >= 0) {
            tokenInfoArray2 = MFunctionCall.subTokenArray(tokenInfoArray2, 0, n4);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (tokenInfoArray2 != null && tokenInfoArray2.length > 0) {
            int n5 = 0;
            for (int i = 0; i < tokenInfoArray2.length; ++i) {
                Tokenizer.TokenInfo[] tokenInfoArray4 = MFunctionCall.subTokenArray(tokenInfoArray2, n5, i + 1);
                if (tokenInfoArray4[tokenInfoArray4.length - 1].getTokenID().getNumericID() != 51 || MFunctionCall.parenCount(tokenInfoArray4, 52, 53) != 0 || MFunctionCall.parenCount(tokenInfoArray4, 54, 55) != 0 || MFunctionCall.parenCount(tokenInfoArray4, 56, 57) != 0) continue;
                n5 = i + 1;
                arrayList.add(string.substring(tokenInfoArray4[0].getOffset(), tokenInfoArray4[tokenInfoArray4.length - 1].getOffset() + tokenInfoArray4[tokenInfoArray4.length - 1].getLength() - 1));
            }
        }
        String string2 = "";
        String string3 = "";
        boolean bl = false;
        for (n2 = tokenInfoArray3.length - 1; n2 >= 0; --n2) {
            n = tokenInfoArray3[n2].getTokenID().getNumericID();
            if (n == 40) {
                object = string.substring(tokenInfoArray3[n2].getOffset(), tokenInfoArray3[n2].getOffset() + tokenInfoArray3[n2].getLength());
                if (!bl) {
                    string2 = (String)object + string2;
                    continue;
                }
                string3 = (String)object + string3;
                continue;
            }
            if (n == 111 || n == 116 || n == 102) continue;
            if (string.charAt(tokenInfoArray3[n2].getOffset()) != '.') break;
            if (bl) {
                throw new ParseException(resources.getString("MFunctionCall.ExcessDots"), 0);
            }
            bl = true;
        }
        n2 = 0;
        if (bl) {
            if (string3 == null || string3.isEmpty()) {
                return null;
            }
            if (MFunctionCall.isVariableName(string3)) {
                arrayList.add(0, string3);
                n2 = 1;
            } else {
                string2 = string3 + "." + string2;
            }
        } else if (string2 != null) {
            string2 = string2.trim();
            n = 0;
            if (Matlab.isMatlabAvailable()) {
                n = MatlabLanguage.isKeyword((String)string2) ? 1 : 0;
            }
            if (n != 0 || "properties".equals(string2) || "methods".equals(string2) || "events".equals(string2)) {
                throw new ParseException(resources.getString("MFunctionCall.PropMethodKeywords"), 0);
            }
        }
        if (MFunctionCall.isVariableName(string2)) {
            throw new ParseException(resources.getString("MFunctionCall.VarName"), 0);
        }
        MFunctionCall mFunctionCall = new MFunctionCall();
        mFunctionCall.fFuncName = string2.trim();
        mFunctionCall.fCallPosition = arrayList.size();
        mFunctionCall.fAllClassNames = MFunctionCall.getClassNamesForMethod(mFunctionCall.fFuncName);
        mFunctionCall.fFirstArgClassName = "";
        if (mFunctionCall.fCallPosition >= 1 && arrayList.size() > 0 && NativeMatlab.nativeIsMatlabThread()) {
            try {
                if (MFunctionCall.isVariableName((String)arrayList.get(0))) {
                    object = (boolean[])Matlab.mtEval((String)("isobject(" + (String)arrayList.get(0) + ") " + "|| (all(ishandle(" + (String)arrayList.get(0) + "(:))) && ~any(ishghandle(" + (String)arrayList.get(0) + "(:)))) && ~isjava(" + (String)arrayList.get(0) + ");"), (int)1);
                    if (object != null && ((Object)object).length > 0 && object[0] != false) {
                        mFunctionCall.fFirstArgClassName = (String)Matlab.mtEval((String)("class(" + (String)arrayList.get(0) + ");"), (int)1);
                        boolean[] blArray = (boolean[])Matlab.mtEval((String)("isjava(" + (String)arrayList.get(0) + ")"), (int)1);
                        boolean[] blArray2 = (boolean[])Matlab.mtEval((String)("iscom(" + (String)arrayList.get(0) + ")"), (int)1);
                        if (blArray != null && blArray.length > 0 && blArray[0]) {
                            throw new ParseException(resources.getString("MFunctionCall.External"), 0);
                        }
                        if (blArray2 != null && blArray2.length > 0 && blArray2[0]) {
                            throw new ParseException(resources.getString("MFunctionCall.External"), 0);
                        }
                    } else if (n2 != 0) {
                        throw new ParseException(resources.getString("MFunctionCall.External"), 0);
                    }
                } else if (n2 != 0) {
                    throw new ParseException(resources.getString("MFunctionCall.External"), 0);
                }
            }
            catch (Exception exception) {
                throw new ParseException(resources.getString("MFunctionCall.CatchAll"), 0);
            }
        }
        if (mFunctionCall.fFirstArgClassName.length() > 0) {
            return mFunctionCall;
        }
        try {
            if (NativeMatlab.nativeIsMatlabThread()) {
                mFunctionCall.fMFilePath = (String)Matlab.mtFeval((String)"which", (Object[])new String[]{mFunctionCall.fFuncName}, (int)1);
                if (mFunctionCall.fMFilePath != null) {
                    mFunctionCall.fMFilePath = mFunctionCall.fMFilePath.trim();
                    if (mFunctionCall.fMFilePath.matches("built-in\\s*\\(.*\\)")) {
                        mFunctionCall.fMFilePath = mFunctionCall.fMFilePath.replaceAll("^built-in\\s*\\(", "");
                        mFunctionCall.fMFilePath = mFunctionCall.fMFilePath.replaceAll("\\)$", "");
                    }
                    if (mFunctionCall.fMFilePath.matches(".*.p$")) {
                        mFunctionCall.fMFilePath = mFunctionCall.fMFilePath.replaceAll(".p$", M_FILE_EXTENSION);
                    }
                    if (!mFunctionCall.fMFilePath.matches(".*.m$")) {
                        mFunctionCall.fMFilePath = mFunctionCall.fMFilePath + M_FILE_EXTENSION;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new ParseException(resources.getString("MFunctionCall.CatchAll"), 0);
        }
        return mFunctionCall;
    }

    public String createSignatureString() throws ParseException {
        String string = this.getSignatureString();
        Signature[] signatureArray = this.parseRefPageSignatures(string);
        if (!(this.fAllClassNames != null && this.fAllClassNames.length != 0 || signatureArray != null && signatureArray.length != 0 || this.fMFilePath != null && !this.fMFilePath.equals(M_FILE_EXTENSION))) {
            throw new ParseException(resources.getString("MFunctionCall.NoRef"), 0);
        }
        String string2 = "";
        if (signatureArray != null) {
            for (Signature object : signatureArray) {
                String string3;
                if (object.areInputArgsEllipsis() || (string3 = object.createHTML(this.fCallPosition)) == null) continue;
                string2 = string2 + "<div>" + string3 + "</div>";
            }
        } else if (this.fFirstArgClassName.length() == 0 && this.fMFilePath != null && new File(this.fMFilePath).exists()) {
            String string4;
            Object[] objectArray = this.parseMFileSignatures();
            if (objectArray != null && objectArray.length > 0 && (string4 = ((Signature)objectArray[0]).createHTML(this.fCallPosition)) != null) {
                string2 = string2 + "<div>" + string4 + "</div>";
            }
        } else if (this.fFirstArgClassName.length() > 0 && this.fAllClassNames != null) {
            for (String string4 : this.fAllClassNames) {
                if (!this.fFirstArgClassName.equals(string4)) continue;
                string2 = string2 + "<div>" + this.fFuncName + "(<b><font color=#3775B9>" + this.fFirstArgClassName + " object...</font></b>)</div>";
                break;
            }
        }
        if (this.fCallPosition <= 0 && this.fAllClassNames != null) {
            for (String string5 : this.fAllClassNames) {
                string2 = string2 + "<div>" + this.fFuncName + "(<b><font color=#3775B9>" + (String)string5 + " object...</font></b>)</div>";
            }
        }
        if (string2.length() <= 0) {
            throw new ParseException(resources.getString("MFunctionCall.NoParse"), 0);
        }
        string2 = "<html>" + string2 + "</html>";
        return string2;
    }

    public boolean equals(MFunctionCall mFunctionCall) {
        return this.fFuncName.equals(mFunctionCall.fFuncName) && this.fFirstArgClassName.equals(mFunctionCall.fFirstArgClassName) && this.fCallPosition == mFunctionCall.fCallPosition && Arrays.equals(this.fAllClassNames, mFunctionCall.fAllClassNames);
    }

    public String getFunctionName() {
        return this.fFuncName;
    }

    public String getFullyQualifiedFuncionName() {
        if (this.fFirstArgClassName.length() > 0) {
            return this.fFirstArgClassName + "." + this.fFuncName;
        }
        return this.fFuncName;
    }

    public static boolean isValidOpeningString(String string) {
        Tokenizer.TokenInfo[] tokenInfoArray = TokenizerFactory.getMTokenizer().tokenize(string);
        if (tokenInfoArray == null || tokenInfoArray.length < 2) {
            return false;
        }
        if (tokenInfoArray[tokenInfoArray.length - 1].getTokenID().getNumericID() != 52) {
            return false;
        }
        for (int i = tokenInfoArray.length - 2; i >= 0; --i) {
            int n = tokenInfoArray[i].getTokenID().getNumericID();
            if (n == 40) {
                return !MFunctionCall.isVariableName(string.substring(tokenInfoArray[i].getOffset(), tokenInfoArray[i].getOffset() + tokenInfoArray[i].getLength()));
            }
            if (n != 111 && n != 116 && n != 102) break;
        }
        return false;
    }

    private static boolean isVariableName(String string) {
        if (NativeMatlab.nativeIsMatlabThread()) {
            try {
                boolean[] blArray = (boolean[])Matlab.mtEval((String)("exist('" + string + "','var')==1;"), (int)1);
                if (blArray != null && blArray.length > 0 && blArray[0]) {
                    return true;
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private static int getFunctionBreakToken(Tokenizer.TokenInfo[] tokenInfoArray, String string) {
        for (int i = tokenInfoArray.length - 1; i >= 1; --i) {
            if (MFunctionCall.isTerminatedByIdentifier(tokenInfoArray, i - 1) && MFunctionCall.isVariableName(string.substring(tokenInfoArray[i - 1].getOffset(), tokenInfoArray[i - 1].getOffset() + tokenInfoArray[i - 1].getLength())) || !MFunctionCall.isTerminatedByIdentifier(tokenInfoArray, i - 1) || tokenInfoArray[i].getTokenID().getNumericID() != 52 || MFunctionCall.getMinUnclosedParenCount(MFunctionCall.subTokenArrayToEnd(tokenInfoArray, i), 52, 53) <= 0) continue;
            return i;
        }
        return -1;
    }

    private static int getFirstOpenArrayParen(Tokenizer.TokenInfo[] tokenInfoArray) {
        for (int i = tokenInfoArray.length - 1; i >= 0; --i) {
            if ((tokenInfoArray[i].getTokenID().getNumericID() != 54 || MFunctionCall.parenCount(MFunctionCall.subTokenArrayToEnd(tokenInfoArray, i + 1), 54, 55) < 0) && (tokenInfoArray[i].getTokenID().getNumericID() != 56 || MFunctionCall.parenCount(MFunctionCall.subTokenArrayToEnd(tokenInfoArray, i + 1), 56, 57) < 0)) continue;
            return i;
        }
        return -1;
    }

    private static Tokenizer.TokenInfo[] subTokenArrayToEnd(Tokenizer.TokenInfo[] tokenInfoArray, int n) {
        Tokenizer.TokenInfo[] tokenInfoArray2 = new Tokenizer.TokenInfo[tokenInfoArray.length - n];
        System.arraycopy(tokenInfoArray, n, tokenInfoArray2, 0, tokenInfoArray.length - n);
        return tokenInfoArray2;
    }

    private static Tokenizer.TokenInfo[] subTokenArray(Tokenizer.TokenInfo[] tokenInfoArray, int n, int n2) {
        Tokenizer.TokenInfo[] tokenInfoArray2 = new Tokenizer.TokenInfo[n2 - n];
        System.arraycopy(tokenInfoArray, n, tokenInfoArray2, 0, n2 - n);
        return tokenInfoArray2;
    }

    private static int parenCount(Tokenizer.TokenInfo[] tokenInfoArray, int n, int n2) {
        if (tokenInfoArray == null || tokenInfoArray.length == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        for (Tokenizer.TokenInfo tokenInfo : tokenInfoArray) {
            if (tokenInfo.getTokenID().getNumericID() == n) {
                ++n3;
            }
            if (tokenInfo.getTokenID().getNumericID() != n2) continue;
            ++n4;
        }
        return n3 - n4;
    }

    private static int getMinUnclosedParenCount(Tokenizer.TokenInfo[] tokenInfoArray, int n, int n2) {
        if (tokenInfoArray == null || tokenInfoArray.length == 0) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = Integer.MAX_VALUE;
        for (Tokenizer.TokenInfo tokenInfo : tokenInfoArray) {
            if (tokenInfo.getTokenID().getNumericID() == n) {
                ++n3;
            }
            if (tokenInfo.getTokenID().getNumericID() == n2) {
                ++n4;
            }
            n5 = n5 > n3 - n4 ? n3 - n4 : n5;
        }
        return n5;
    }

    private static boolean isTerminatedByIdentifier(Tokenizer.TokenInfo[] tokenInfoArray, int n) {
        if (tokenInfoArray == null) {
            return false;
        }
        for (int i = n = n > tokenInfoArray.length - 1 ? tokenInfoArray.length - 1 : n; i >= 0; --i) {
            if (tokenInfoArray[i].getTokenID().getNumericID() == 40) {
                return true;
            }
            if (tokenInfoArray[i].getTokenID().getNumericID() == 116) continue;
            return false;
        }
        return false;
    }

    private static String[] getClassNamesForMethod(String string) {
        try {
            if (NativeMatlab.nativeIsMatlabThread()) {
                return (String[])Matlab.mtFeval((String)"functionhintsfunc", (Object[])new String[]{string}, (int)1);
            }
        }
        catch (Exception exception) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Log.log((String)"functionhintsfunc not on the path, try rehash toolboxreset");
                }
            });
        }
        return null;
    }

    private String getSignatureString() {
        String string = this.fFirstArgClassName.length() > 0 ? this.fFirstArgClassName + "." + this.fFuncName : this.fFuncName;
        String string2 = sFunctionSignatureMap.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = "";
        ReferenceEntityRequest referenceEntityRequest = new ReferenceEntityRequest(string, new RefEntityType[]{RefEntityType.FUNCTION, RefEntityType.METHOD, RefEntityType.CLASS});
        List<ReferenceData> list = MFunctionCall.getReferenceData((ReferenceRequest)referenceEntityRequest);
        if (!list.isEmpty()) {
            List list2 = list.get(0).getSyntaxLines();
            for (String string3 : list2) {
                string2 = string2 + string3 + "\n";
            }
        } else {
            return null;
        }
        sFunctionSignatureMap.put(string, string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<ReferenceData> getReferenceData(ReferenceRequest referenceRequest) {
        ReferenceDataRetriever referenceDataRetriever = DocCenterReferenceRetrievalStrategy.createDataRetriever();
        try {
            List list = referenceDataRetriever.getReferenceData(referenceRequest);
            return list;
        }
        finally {
            try {
                referenceDataRetriever.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Signature[] parseRefPageSignatures(String string) {
        if (string == null) {
            return null;
        }
        string = string.replaceAll("(\n)", " ");
        Vector<String> vector = new Vector<String>();
        string = string.replaceAll("\\b[a-zA-Z\\_]+\\." + this.fFuncName + "\\s*\\(", this.fFuncName + "(h,");
        String[] stringArray = string.split("\\[\\b[^\\]]*?\\b\\]\\s*?=\\s*?\\b" + this.fFuncName + "\\b|[a-zA-Z0-9\\_]+?\\s*?=\\s*?\\b" + this.fFuncName + "\\b|\\b" + this.fFuncName + "\\b");
        for (int i = 1; i < stringArray.length; ++i) {
            String string2;
            String string3 = stringArray[i];
            int n = string3.indexOf("(");
            int n2 = string3.lastIndexOf(")");
            if (n >= 0 && n2 >= 0 && n2 > n) {
                string2 = string3.substring(n, n2 + 1);
                if (string2.indexOf("=") >= 0 || vector.contains(string2)) continue;
                vector.add(string2);
                continue;
            }
            if (n >= 0 || n2 >= 0) continue;
            string2 = string3.trim();
            string2 = "('" + string2.replaceAll(" ++", "','") + "')";
            string2 = string2.replace("('')", "()");
            if (vector.contains(string2 = string2.replaceAll("'\\.\\.\\.'", "..."))) continue;
            vector.add(string2);
        }
        Vector<Signature> vector2 = new Vector<Signature>();
        for (int i = 0; i < vector.size(); ++i) {
            if (this.fFirstArgClassName.length() > 0) {
                try {
                    vector2.add(new Signature(this.fFirstArgClassName, this.fFuncName, (String)vector.elementAt(i)));
                }
                catch (Signature.SignatureParseException signatureParseException) {}
                continue;
            }
            try {
                vector2.add(new Signature(this.fFuncName, (String)vector.elementAt(i)));
                continue;
            }
            catch (Signature.SignatureParseException signatureParseException) {
                // empty catch block
            }
        }
        return vector2.toArray(new Signature[0]);
    }

    private Signature[] parseMFileSignatures() {
        if (this.fMFilePath == null || this.fMFilePath.length() == 0) {
            return null;
        }
        try {
            MTree mTree = MTree.parse((File)new File(this.fMFilePath));
            String string = MFunctionCall.getFunctionSignature(mTree, this.fFuncName);
            if (string != null) {
                Signature[] signatureArray = new Signature[1];
                try {
                    signatureArray[0] = new Signature(this.fFuncName, string.replaceAll("varargin", "..."));
                }
                catch (Signature.SignatureParseException signatureParseException) {
                    return null;
                }
                return signatureArray;
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static String getFunctionSignature(MTree mTree, String string) {
        ArrayList<String> arrayList;
        MTree.Node node;
        Object object;
        if (string != null && string.matches(".+\\..+")) {
            object = string.replaceAll(".*\\.", "");
            node = new FunctionVisitor((String)object);
            MTreeUtils.visit((MTree)mTree, (Visitor)node);
            MTree.Node node2 = ((FunctionVisitor)node).getFirstNode();
            if (node2 == null) {
                return null;
            }
            MTree.Node node3 = node2.getLeft().getRight().getRight();
            if (node3 == MTree.NULL_NODE) {
                return null;
            }
            arrayList = new ArrayList<String>();
            if (node3.isTextSupported()) {
                arrayList.add(node3.getText());
            } else if (node3.getType() == MTree.NodeType.NOT) {
                arrayList.add("~");
            } else {
                return null;
            }
            while (node3.getNext() != MTree.NULL_NODE) {
                if ((node3 = node3.getNext()).isTextSupported()) {
                    arrayList.add(node3.getText());
                    continue;
                }
                if (node3.getType() == MTree.NodeType.NOT) {
                    arrayList.add("~");
                    continue;
                }
                return null;
            }
        } else if (string != null) {
            object = MDocumentUtils.getSemanticalRoot((MTree)mTree);
            if (object != null && object.getType().isClass()) {
                node = MTreeUtils.getClassConstructorNode((MTree.Node)object);
                MTree.Node node4 = object = node != null && node.getFunctionName().isTextSupported() && string.equals(node.getFunctionName().getText()) ? node : null;
            }
            if (object == null) {
                return null;
            }
            arrayList = MDocumentUtils.getFunctionArgumentList((MTree.Node)object);
        } else {
            return null;
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return string + "()";
        }
        object = string + "(" + (String)arrayList.get(0);
        for (int i = 1; i < arrayList.size(); ++i) {
            object = (String)object + "," + (String)arrayList.get(i);
        }
        return (String)object + ")";
    }

    private static class FunctionVisitor
    implements Visitor<MTree.Node> {
        private MTree.Node fFirstNode;
        private String fMethodName;

        private FunctionVisitor(String string) {
            this.fMethodName = string;
        }

        public void visit(MTree.Node node) {
            MTree.Node node2;
            if (this.fFirstNode == null && node.getType() == MTree.NodeType.FUNCTION && (node2 = node.getLeft().getRight().getLeft()).isTextSupported() && this.fMethodName.equals(node2.getText())) {
                this.fFirstNode = node;
            }
        }

        private MTree.Node getFirstNode() {
            return this.fFirstNode;
        }
    }
}

