/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.functionregistry;

import com.mathworks.helpsearch.HelpPathBuilder;
import com.mathworks.helpsearch.WebHelpPathBuilder;
import com.mathworks.helpsearch.product.DocSetItem;
import com.mathworks.helpsearch.reference.RefEntityType;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceDataRetriever;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.mlwidgets.help.functionregistry.UnlicensedFunction;
import com.mathworks.search.SearchExpression;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FunctionDataRetriever {
    private final ReferenceDataRetriever fRetriever;
    private final Set<String> fMatlabFunctions = new HashSet<String>();
    private final Map<String, List<UnlicensedFunction>> fNonMatlabFunctions = new HashMap<String, List<UnlicensedFunction>>();

    public FunctionDataRetriever(ReferenceDataRetriever referenceDataRetriever) {
        this.fRetriever = referenceDataRetriever;
    }

    public Collection<UnlicensedFunction> getFunctionsForRegistry() throws IOException {
        List<ReferenceData> list = this.getAllFunctions();
        this.categorizeFunctions(list);
        LinkedList<UnlicensedFunction> linkedList = new LinkedList<UnlicensedFunction>();
        for (List<UnlicensedFunction> list2 : this.fNonMatlabFunctions.values()) {
            linkedList.addAll(list2);
        }
        return linkedList;
    }

    public void close() throws IOException {
        this.fRetriever.close();
    }

    private List<ReferenceData> getAllFunctions() throws IOException {
        return this.fRetriever.getReferenceData((ReferenceRequest)new AllFunctionsRequest());
    }

    private void categorizeFunctions(List<ReferenceData> list) {
        for (ReferenceData referenceData : list) {
            UnlicensedFunction unlicensedFunction = this.parseReferenceData(referenceData);
            if (unlicensedFunction == null) continue;
            List<UnlicensedFunction> list2 = this.fNonMatlabFunctions.get(unlicensedFunction.getName());
            if (list2 == null) {
                list2 = new LinkedList<UnlicensedFunction>();
                this.fNonMatlabFunctions.put(unlicensedFunction.getName(), list2);
            }
            list2.add(unlicensedFunction);
        }
    }

    private UnlicensedFunction parseReferenceData(ReferenceData referenceData) {
        RefEntityType refEntityType;
        DocSetItem docSetItem;
        String string = referenceData.getTopic();
        if (!this.includeReferenceData(string, docSetItem = referenceData.getDocSetItem(), refEntityType = referenceData.getType())) {
            return null;
        }
        if (docSetItem.getShortName().equals("matlab")) {
            this.fMatlabFunctions.add(string);
            this.fNonMatlabFunctions.remove(string);
            return null;
        }
        String string2 = docSetItem.getDisplayName();
        String string3 = referenceData.getRelativePath();
        String string4 = (String)docSetItem.getHelpLocation().buildHelpPath((Object)"", (HelpPathBuilder)new WebHelpPathBuilder(), new String[]{string3});
        if (string4.startsWith("/")) {
            string4 = string4.substring(1);
        }
        return new UnlicensedFunction(string, string2, string4);
    }

    private boolean includeReferenceData(String string, DocSetItem docSetItem, RefEntityType refEntityType) {
        return string != null && docSetItem != null && (refEntityType == RefEntityType.FUNCTION || refEntityType == RefEntityType.CLASS) && string.matches("^\\S+$") && !this.fMatlabFunctions.contains(string);
    }

    public static class AllFunctionsRequest
    extends ReferenceRequest {
        protected AllFunctionsRequest() {
            this.addReferenceTypes(new RefEntityType[]{RefEntityType.FUNCTION});
            this.addReferenceTypes(new RefEntityType[]{RefEntityType.CLASS});
        }

        protected SearchExpression getBaseExpression() {
            return null;
        }
    }
}

