/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.functionregistry;

import com.mathworks.helpsearch.reference.ReferenceDataRetriever;
import com.mathworks.mlwidgets.help.DocCenterReferenceRetrievalStrategy;
import com.mathworks.mlwidgets.help.functionregistry.FunctionDataRetriever;
import com.mathworks.mlwidgets.help.functionregistry.FunctionRegistrySearchField;
import com.mathworks.mlwidgets.help.functionregistry.UnlicensedFunction;
import com.mathworks.search.IndexDocument;
import com.mathworks.search.Indexer;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchLanguage;
import com.mathworks.search.lucene.FileSystemIndexLocation;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneBatchIndexer;
import com.mathworks.search.lucene.LuceneIndexer;
import java.io.IOException;
import java.util.Collection;

public class FunctionRegistryIndexer {
    private final FunctionDataRetriever fFuncRetriever;
    private final Indexer fIndexer;

    public static FunctionRegistryIndexer create(String string) throws IOException {
        ReferenceDataRetriever referenceDataRetriever = DocCenterReferenceRetrievalStrategy.createDataRetriever();
        FunctionDataRetriever functionDataRetriever = new FunctionDataRetriever(referenceDataRetriever);
        FileSystemIndexLocation fileSystemIndexLocation = new FileSystemIndexLocation(string);
        LuceneBatchIndexer luceneBatchIndexer = new LuceneBatchIndexer(new LuceneIndexer((IndexLocation)fileSystemIndexLocation, SearchLanguage.ENGLISH));
        return new FunctionRegistryIndexer(functionDataRetriever, (Indexer)luceneBatchIndexer);
    }

    public FunctionRegistryIndexer(FunctionDataRetriever functionDataRetriever, Indexer indexer) {
        this.fFuncRetriever = functionDataRetriever;
        this.fIndexer = indexer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void buildRegistry() throws IOException {
        Collection<UnlicensedFunction> collection = this.getFunctionsToIndex();
        this.fIndexer.openIndex();
        try {
            for (UnlicensedFunction unlicensedFunction : collection) {
                IndexDocument<FunctionRegistrySearchField> indexDocument = FunctionRegistryIndexer.createIndexDocument(unlicensedFunction);
                if (indexDocument == null) continue;
                this.fIndexer.addDocument(indexDocument);
            }
        }
        finally {
            this.fIndexer.closeIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<UnlicensedFunction> getFunctionsToIndex() throws IOException {
        try {
            Collection<UnlicensedFunction> collection = this.fFuncRetriever.getFunctionsForRegistry();
            return collection;
        }
        finally {
            this.fFuncRetriever.close();
        }
    }

    private static IndexDocument<FunctionRegistrySearchField> createIndexDocument(UnlicensedFunction unlicensedFunction) {
        IndexDocument indexDocument = new IndexDocument();
        indexDocument.addFieldValue((SearchField)FunctionRegistrySearchField.FUNCTION_NAME, unlicensedFunction.getName());
        indexDocument.addFieldValue((SearchField)FunctionRegistrySearchField.PRODUCT_NAME, unlicensedFunction.getProductName());
        indexDocument.addFieldValue((SearchField)FunctionRegistrySearchField.RELATIVE_PATH, unlicensedFunction.getHelpPath());
        return indexDocument;
    }
}

