/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.functionregistry;

import com.mathworks.mlwidgets.help.functionregistry.FunctionRegistrySearchField;
import com.mathworks.mlwidgets.help.functionregistry.UnlicensedFunction;
import com.mathworks.search.BooleanSearchOperator;
import com.mathworks.search.ListSearchResultCollector;
import com.mathworks.search.SearchCriteria;
import com.mathworks.search.SearchException;
import com.mathworks.search.SearchExpression;
import com.mathworks.search.SearchField;
import com.mathworks.search.SearchLanguage;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultAdapter;
import com.mathworks.search.SearchResultCollector;
import com.mathworks.search.SearchResults;
import com.mathworks.search.SimpleSearchExpression;
import com.mathworks.search.lucene.FileSystemIndexLocation;
import com.mathworks.search.lucene.IndexLocation;
import com.mathworks.search.lucene.LuceneSearchEngine;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class UnlicensedFunctionRegistry {
    private static final UnlicensedFunction[] EMPTY_RESULTS = new UnlicensedFunction[0];
    private final IndexLocation fIndexLocation;

    public UnlicensedFunctionRegistry(String string) {
        this((IndexLocation)new FileSystemIndexLocation(string));
    }

    public UnlicensedFunctionRegistry(IndexLocation indexLocation) {
        this.fIndexLocation = indexLocation;
    }

    public UnlicensedFunction[] find(String string) {
        SimpleSearchExpression simpleSearchExpression = new SimpleSearchExpression(string, BooleanSearchOperator.MUST_OCCUR);
        simpleSearchExpression.addSearchField((SearchField)FunctionRegistrySearchField.FUNCTION_NAME);
        try {
            return this.doSearch((SearchExpression)simpleSearchExpression);
        }
        catch (Exception exception) {
            return EMPTY_RESULTS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnlicensedFunction[] doSearch(SearchExpression searchExpression) throws IOException, SearchException {
        ListSearchResultCollector listSearchResultCollector = ListSearchResultCollector.createCollector((SearchResultAdapter)new FunctionResultAdapter());
        List<FunctionRegistrySearchField> list = Arrays.asList(FunctionRegistrySearchField.FUNCTION_NAME);
        LuceneSearchEngine luceneSearchEngine = new LuceneSearchEngine(SearchLanguage.ENGLISH, list, new IndexLocation[]{this.fIndexLocation});
        try {
            luceneSearchEngine.search(new SearchCriteria(searchExpression), new SearchResultCollector[]{listSearchResultCollector});
            SearchResults searchResults = listSearchResultCollector.getResults(0, listSearchResultCollector.getNumResults());
            UnlicensedFunction[] unlicensedFunctionArray = UnlicensedFunctionRegistry.toArray((SearchResults<UnlicensedFunction>)searchResults);
            return unlicensedFunctionArray;
        }
        catch (Exception exception) {
            UnlicensedFunction[] unlicensedFunctionArray = EMPTY_RESULTS;
            return unlicensedFunctionArray;
        }
        finally {
            luceneSearchEngine.closeIndex();
        }
    }

    private static UnlicensedFunction[] toArray(SearchResults<UnlicensedFunction> searchResults) {
        int n = searchResults.getFullResultCount();
        UnlicensedFunction[] unlicensedFunctionArray = new UnlicensedFunction[searchResults.getFullResultCount()];
        for (int i = 0; i < n; ++i) {
            unlicensedFunctionArray[i] = (UnlicensedFunction)searchResults.getResult(i);
        }
        return unlicensedFunctionArray;
    }

    private static class FunctionResultAdapter
    implements SearchResultAdapter<UnlicensedFunction> {
        private FunctionResultAdapter() {
        }

        public UnlicensedFunction adaptResult(SearchResult searchResult) {
            String string = searchResult.getFieldValue(FunctionRegistrySearchField.FUNCTION_NAME.getFieldName());
            String string2 = searchResult.getFieldValue(FunctionRegistrySearchField.PRODUCT_NAME.getFieldName());
            String string3 = searchResult.getFieldValue(FunctionRegistrySearchField.RELATIVE_PATH.getFieldName());
            return new UnlicensedFunction(string, string2, string3);
        }
    }
}

