/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.mlwidgets.help.search.DocSearchField;
import com.mathworks.mlwidgets.html.LanguageLocale;
import com.mathworks.search.lucene.LuceneVersion;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.WhitespaceTokenizer;
import org.apache.lucene.analysis.util.CharTokenizer;
import org.apache.lucene.util.Version;

public class AnalyzerSource {
    private Analyzer fAnalyzer;
    private static final Version sVersion = LuceneVersion.CURRENT_VERSION;

    AnalyzerSource(LanguageLocale languageLocale) {
        this.fAnalyzer = AnalyzerSource.getAnalyzer(languageLocale);
    }

    private static Analyzer getAnalyzer(LanguageLocale languageLocale) {
        switch (languageLocale) {
            case JAPANESE: 
            case SIMPLIFIED_CHINESE: 
            case KOREAN: {
                return new HelpAnalyzer((Analyzer)new CJKAnalyzer(sVersion));
            }
        }
        return new HelpAnalyzer(new EnglishAnalyzer(sVersion));
    }

    Analyzer getIndexAnalyzer() {
        return this.fAnalyzer;
    }

    Analyzer getSearchAnalyzer() {
        return this.fAnalyzer;
    }

    private static class LetterDigitTokenizer
    extends CharTokenizer {
        private LetterDigitTokenizer(Version version, Reader reader) {
            super(version, reader);
        }

        protected boolean isTokenChar(int n) {
            return Character.isLetter(n) || Character.isDigit(n);
        }
    }

    private static class EnglishAnalyzer
    extends Analyzer {
        private final Version matchVersion;

        public EnglishAnalyzer(Version version) {
            this.matchVersion = version;
        }

        protected Analyzer.TokenStreamComponents createComponents(String string, Reader reader) {
            LetterDigitTokenizer letterDigitTokenizer = new LetterDigitTokenizer(this.matchVersion, reader);
            LowerCaseFilter lowerCaseFilter = new LowerCaseFilter(this.matchVersion, (TokenStream)letterDigitTokenizer);
            return new Analyzer.TokenStreamComponents((Tokenizer)letterDigitTokenizer, (TokenStream)lowerCaseFilter);
        }
    }

    private static class WhitespaceLowerCaseAnalyzer
    extends Analyzer {
        private final Version matchVersion;

        public WhitespaceLowerCaseAnalyzer(Version version) {
            this.matchVersion = version;
        }

        protected Analyzer.TokenStreamComponents createComponents(String string, Reader reader) {
            WhitespaceTokenizer whitespaceTokenizer = new WhitespaceTokenizer(this.matchVersion, reader);
            LowerCaseFilter lowerCaseFilter = new LowerCaseFilter(this.matchVersion, (TokenStream)whitespaceTokenizer);
            return new Analyzer.TokenStreamComponents((Tokenizer)whitespaceTokenizer, (TokenStream)lowerCaseFilter);
        }
    }

    private static class HelpAnalyzer
    extends AnalyzerWrapper {
        private final Analyzer iBaseAnalyer;

        private HelpAnalyzer(Analyzer analyzer) {
            this.iBaseAnalyer = analyzer;
        }

        protected Analyzer getWrappedAnalyzer(String string) {
            if (string.equals(DocSearchField.REFPAGE_ENTITY.getFieldName())) {
                return new WhitespaceLowerCaseAnalyzer(sVersion);
            }
            return this.iBaseAnalyer;
        }
    }
}

