/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.mlwidgets.help.search.SearchResult;
import com.mathworks.mlwidgets.help.search.SearchResults;
import com.mathworks.mlwidgets.help.search.lucene.MWHitCollector;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;

abstract class LuceneSearchResults<T extends SearchResult>
implements SearchResults<T> {
    private IndexSearcher fSearcher;
    private Map<Integer, T> fResultsCache = new HashMap<Integer, T>();
    private MWHitCollector fCollector;

    protected LuceneSearchResults(MWHitCollector mWHitCollector, IndexSearcher indexSearcher) {
        this.fCollector = mWHitCollector;
        this.fSearcher = indexSearcher;
    }

    @Override
    public Iterator<T> iterator() {
        return new LuceneResultsIterator();
    }

    @Override
    public T getResult(int n) {
        if (this.fResultsCache.containsKey(n)) {
            return (T)((SearchResult)this.fResultsCache.get(n));
        }
        try {
            Document document = this.fCollector.getDocument(this.fSearcher, n);
            T t = this.createResult(this.fCollector.getDocId(n), document, this.fCollector.getScore(n));
            this.fResultsCache.put(n, t);
            return t;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected abstract T createResult(int var1, Document var2, float var3);

    @Override
    public int getNumResults() {
        return this.fCollector.getNumResults();
    }

    IndexSearcher getSearcher() {
        return this.fSearcher;
    }

    private class LuceneResultsIterator
    implements Iterator<T> {
        private int fIndex = -1;

        private LuceneResultsIterator() {
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.fIndex < LuceneSearchResults.this.fCollector.getNumResults() - 1;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return LuceneSearchResults.this.getResult(++this.fIndex);
            }
            throw new NoSuchElementException();
        }
    }
}

