/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.search.lucene.LuceneVersion;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CheckIndex;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

class MWIndexWriter {
    private IndexWriter fUnderlyingWriter;
    private static final String METADATA_FILENAME = "metadata";
    private IndexOutput fMetadataOutput;

    MWIndexWriter(Directory directory, Analyzer analyzer, boolean bl) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(LuceneVersion.CURRENT_VERSION, analyzer);
        indexWriterConfig.setUseCompoundFile(true);
        indexWriterConfig.setOpenMode(bl ? IndexWriterConfig.OpenMode.CREATE : IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        CheckIndex checkIndex = new CheckIndex(directory);
        boolean bl2 = checkIndex.checkIndex().missingSegments;
        if (bl && bl2) {
            MWIndexWriter.cleanDirectory(directory);
        }
        this.createIndexWriter(directory, indexWriterConfig);
    }

    private void createIndexWriter(Directory directory, IndexWriterConfig indexWriterConfig) throws IOException {
        try {
            this.fUnderlyingWriter = new IndexWriter(directory, indexWriterConfig);
        }
        catch (IndexFormatTooOldException indexFormatTooOldException) {
            MWIndexWriter.cleanDirectory(directory);
            this.fUnderlyingWriter = new IndexWriter(directory, indexWriterConfig);
        }
    }

    private static void cleanDirectory(Directory directory) throws IOException {
        if (directory instanceof FSDirectory) {
            File file = ((FSDirectory)directory).getDirectory();
            if (!file.exists()) {
                return;
            }
            FileUtils.cleanDirectory((File)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void addIndex(Directory directory) throws IOException {
        this.fUnderlyingWriter.addIndexes(new Directory[]{directory});
        IndexInput indexInput = directory.openInput(METADATA_FILENAME, new IOContext());
        if (indexInput != null) {
            IndexOutput indexOutput = null;
            try {
                indexOutput = this.fUnderlyingWriter.getDirectory().createOutput(METADATA_FILENAME, new IOContext());
                int n = (int)indexInput.length();
                byte[] byArray = new byte[n];
                indexInput.readBytes(byArray, 0, n);
                indexOutput.writeBytes(byArray, n);
                indexOutput.flush();
            }
            finally {
                if (indexOutput != null) {
                    indexOutput.close();
                }
                indexInput.close();
            }
        }
    }

    synchronized void addMetaData(String string, String string2) throws IOException {
        if (this.fMetadataOutput == null) {
            this.fMetadataOutput = this.fUnderlyingWriter.getDirectory().createOutput(METADATA_FILENAME, new IOContext());
        }
        this.fMetadataOutput.writeString(string + "=" + string2 + "\n");
        this.fMetadataOutput.flush();
    }

    synchronized void optimize() throws IOException {
        this.fUnderlyingWriter.forceMerge(1);
    }

    synchronized void addDocument(Document document) throws IOException {
        this.fUnderlyingWriter.addDocument((Iterable)document);
    }

    public synchronized void close() throws IOException {
        this.fUnderlyingWriter.close();
        if (this.fMetadataOutput != null) {
            this.fMetadataOutput.close();
        }
    }
}

