/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.DummyHtmlComponent;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlComponentIdentifier;
import com.mathworks.html.jxbrowser.BrowserHolder;
import com.mathworks.html.jxbrowser.chromium.JxBrowserChromiumIdentifier;
import com.mathworks.mlwidgets.html.HtmlComponentAdapter;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;

public enum BrowserInfo {
    JXBROWSER_4_CHROMIUM((HtmlComponentIdentifier)JxBrowserChromiumIdentifier.getInstance(), HtmlComponentFactory.HtmlComponentType.CHROMIUM),
    JXBROWSER_3_IE((HtmlComponentIdentifier)BrowserHolder.Type.IE, HtmlComponentFactory.HtmlComponentType.HTMLPANEL),
    JXBROWSER_3_MOZILLA15((HtmlComponentIdentifier)BrowserHolder.Type.Mozilla15, HtmlComponentFactory.HtmlComponentType.HTMLPANEL),
    JXBROWSER_3_MOZILLA((HtmlComponentIdentifier)BrowserHolder.Type.Mozilla, HtmlComponentFactory.HtmlComponentType.HTMLPANEL),
    JXBROWSER_3_SAFARI((HtmlComponentIdentifier)BrowserHolder.Type.Safari, HtmlComponentFactory.HtmlComponentType.HTMLPANEL),
    ICEBROWSER(HtmlComponentAdapter.getHTMLRendererIdentifier(), HtmlComponentFactory.HtmlComponentType.HTMLRENDERER),
    DUMMY(DummyHtmlComponent.ID, HtmlComponentFactory.HtmlComponentType.DUMMY);

    private final HtmlComponentIdentifier fId;
    private final HtmlComponentFactory.HtmlComponentType fHtmlComponentType;

    private BrowserInfo(HtmlComponentIdentifier htmlComponentIdentifier, HtmlComponentFactory.HtmlComponentType htmlComponentType) {
        this.fId = htmlComponentIdentifier;
        this.fHtmlComponentType = htmlComponentType;
    }

    HtmlComponentIdentifier getIdentifier() {
        return this.fId;
    }

    public static BrowserInfo forHtmlComponent(HtmlComponent htmlComponent) {
        HtmlComponentIdentifier htmlComponentIdentifier = htmlComponent.getId();
        if (htmlComponentIdentifier == null) {
            return null;
        }
        for (BrowserInfo browserInfo : BrowserInfo.values()) {
            if (!htmlComponentIdentifier.getUniqueId().equals(browserInfo.getIdentifier().getUniqueId())) continue;
            return browserInfo;
        }
        return null;
    }

    public boolean isSupported() {
        return this.fHtmlComponentType.isSupported() && this.fId.isSupported();
    }

    public boolean makeDefault() {
        if (this.isSupported() && this.fId.beforeSetAsDefault()) {
            HtmlComponentFactory.setDefaultType(this.fHtmlComponentType);
            return true;
        }
        return false;
    }
}

