/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.FindOption;
import com.mathworks.html.HtmlActionGroup;
import com.mathworks.html.HtmlActionGroups;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlComponentIdentifier;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.html.LoadFailureHandlerMap;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.StandardHtmlActionId;
import com.mathworks.html.StatusTextChangedEvent;
import com.mathworks.html.StatusTextListener;
import com.mathworks.html.Url;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HTMLRendererActions;
import com.mathworks.mlwidgets.html.HtmlComponentRegistry;
import com.mathworks.mlwidgets.html.MatlabHtmlActionId;
import com.mathworks.mlwidgets.html.PageChangedListener;
import com.mathworks.mwswing.MJAbstractAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class HtmlComponentAdapter
implements HtmlComponent {
    private static final HtmlComponentIdentifier ID = new HtmlComponentIdentifier(){

        public String getUniqueId() {
            return "HTMLRenderer";
        }

        public boolean isSupported() {
            return true;
        }

        public boolean beforeSetAsDefault() {
            return true;
        }
    };
    private final HTMLRenderer fHTMLRenderer;
    private HtmlActions fActions;
    private final Map<StatusTextListener, ActionListener> fAdaptedStatusTextListeners = new HashMap<StatusTextListener, ActionListener>();
    private final Map<com.mathworks.html.PageChangedListener, PageChangedListener> fAdaptedPageChangedListeners = new HashMap<com.mathworks.html.PageChangedListener, PageChangedListener>();
    private final int fRegistryId;

    public HtmlComponentAdapter(HTMLRenderer hTMLRenderer) {
        this.fHTMLRenderer = hTMLRenderer;
        hTMLRenderer.putClientProperty("mwjavaguitest.instance", this);
        this.fRegistryId = HtmlComponentRegistry.registerHtmlComponent(this);
        this.fHTMLRenderer.setBrowserId(this.fRegistryId);
    }

    public Component getComponent() {
        return this.fHTMLRenderer;
    }

    public boolean isInitialized() {
        return this.fHTMLRenderer.canExecuteScripts();
    }

    public void setCurrentLocation(String string) {
        this.fHTMLRenderer.setCurrentLocation(string);
    }

    public void setCurrentLocation(Url url) {
        this.fHTMLRenderer.setCurrentLocation(url.toString());
    }

    public String getCurrentLocation() {
        return this.fHTMLRenderer.getCurrentLocation();
    }

    public String getTitle() {
        return this.fHTMLRenderer.getCurrentPageTitle();
    }

    public void setHtmlText(String string) {
        this.fHTMLRenderer.setHtmlText(string);
    }

    public void executeScript(String string) {
        this.fHTMLRenderer.executeScript(string);
    }

    public void executeScript(String string, HtmlDataListener<String> htmlDataListener) {
        String string2 = this.fHTMLRenderer.executeScriptWithReturn(string);
        htmlDataListener.dataRetrieved((Object)string2);
    }

    public void getSelectedText(HtmlDataListener<String> htmlDataListener) {
        String string = this.fHTMLRenderer.getSelectedText();
        htmlDataListener.dataRetrieved((Object)string);
    }

    public String getHtmlText() {
        return this.fHTMLRenderer.getHtmlText();
    }

    public boolean canGoBack() {
        return this.fHTMLRenderer.canGoBack();
    }

    public void goBack() {
        this.fHTMLRenderer.goBack();
    }

    public boolean canGoForward() {
        return this.fHTMLRenderer.canGoForward();
    }

    public void goForward() {
        this.fHTMLRenderer.goForward();
    }

    public void reload() {
        this.fHTMLRenderer.reload();
    }

    public String getHomeUrl() {
        return this.fHTMLRenderer.getHomeUrl();
    }

    public boolean isPrintingSupported() {
        return true;
    }

    public void print(HtmlDataListener<Boolean> htmlDataListener) {
        this.fHTMLRenderer.doPrint();
        htmlDataListener.dataRetrieved((Object)true);
    }

    public void saveAs(File file) {
        this.fHTMLRenderer.saveAs();
    }

    public void disableNavigation() {
        this.fHTMLRenderer.disableNavigation();
    }

    public void dispose() {
        HtmlComponentRegistry.removeHtmlComponent(this.fRegistryId);
        this.fHTMLRenderer.dispose();
        this.fAdaptedPageChangedListeners.clear();
        this.fAdaptedStatusTextListeners.clear();
    }

    public void findInPage(String string, Collection<FindOption> collection, HtmlDataListener<Boolean> htmlDataListener) {
        boolean bl = collection.contains(FindOption.SEARCH_BACKWARDS);
        boolean bl2 = collection.contains(FindOption.MATCH_CASE);
        boolean bl3 = collection.contains(FindOption.WHOLE_WORDS);
        boolean bl4 = false;
        boolean bl5 = this.fHTMLRenderer.search(string, bl, bl2, bl3, bl4);
        htmlDataListener.dataRetrieved((Object)bl5);
    }

    public void addPageChangedListener(com.mathworks.html.PageChangedListener pageChangedListener) {
        PageChangedListener pageChangedListener2 = this.adaptPageChangedListener(pageChangedListener, true);
        this.fHTMLRenderer.addPageChangedListener(pageChangedListener2);
    }

    public void removePageChangedListener(com.mathworks.html.PageChangedListener pageChangedListener) {
        PageChangedListener pageChangedListener2 = this.adaptPageChangedListener(pageChangedListener, false);
        if (pageChangedListener2 != null) {
            this.fHTMLRenderer.removePageChangedListener(pageChangedListener2);
        }
    }

    public void addStatusTextListener(StatusTextListener statusTextListener) {
        ActionListener actionListener = this.adaptStatusTextListener(statusTextListener, true);
        this.fHTMLRenderer.addMouseOverLinkListener(actionListener);
    }

    public void removeStatusTextListener(StatusTextListener statusTextListener) {
        ActionListener actionListener = this.adaptStatusTextListener(statusTextListener, false);
        if (actionListener != null) {
            this.fHTMLRenderer.removeMouseOverLinkListener(actionListener);
        }
    }

    public void addTitleChangedListener(HtmlDataListener<String> htmlDataListener) {
    }

    public void removeTitleChangedListener(HtmlDataListener<String> htmlDataListener) {
    }

    public HtmlActions getActions() {
        if (this.fActions == null) {
            this.fActions = new HtmlActionsAdapter(this.fHTMLRenderer.getActions());
        }
        return this.fActions;
    }

    public HtmlActionGroups getBrowserSuppliedActions() {
        return null;
    }

    public HTMLRenderer getHTMLRenderer() {
        return this.fHTMLRenderer;
    }

    private ActionListener adaptStatusTextListener(StatusTextListener statusTextListener, boolean bl) {
        ActionListener actionListener = this.fAdaptedStatusTextListeners.get(statusTextListener);
        if (actionListener != null) {
            if (!bl) {
                this.fAdaptedStatusTextListeners.remove(statusTextListener);
            }
        } else if (bl) {
            actionListener = new StatusTextListenerAdapter(statusTextListener);
            this.fAdaptedStatusTextListeners.put(statusTextListener, actionListener);
        }
        return actionListener;
    }

    private PageChangedListener adaptPageChangedListener(com.mathworks.html.PageChangedListener pageChangedListener, boolean bl) {
        PageChangedListener pageChangedListener2 = this.fAdaptedPageChangedListeners.get(pageChangedListener);
        if (pageChangedListener2 != null) {
            if (!bl) {
                this.fAdaptedPageChangedListeners.remove(pageChangedListener);
            }
        } else if (bl) {
            pageChangedListener2 = new PageChangedListenerAdapter(pageChangedListener);
            this.fAdaptedPageChangedListeners.put(pageChangedListener, pageChangedListener2);
        }
        return pageChangedListener2;
    }

    public void addLoadFailureHandlers(LoadFailureHandlerMap loadFailureHandlerMap) {
    }

    public static HtmlComponentIdentifier getHTMLRendererIdentifier() {
        return ID;
    }

    public HtmlComponentIdentifier getId() {
        return ID;
    }

    private static class HtmlActionsAdapter
    implements HtmlActions {
        private final Map<StandardHtmlActionId, MJAbstractAction> iBasicActions;
        private final Map<MatlabHtmlActionId, MJAbstractAction> iMatlabActions;

        private HtmlActionsAdapter(HTMLRendererActions hTMLRendererActions) {
            this.iBasicActions = HtmlActionsAdapter.buildBasicActionsMap(hTMLRendererActions);
            this.iMatlabActions = HtmlActionsAdapter.buildMatlabActionsMap(hTMLRendererActions);
        }

        private static Map<StandardHtmlActionId, MJAbstractAction> buildBasicActionsMap(HTMLRendererActions hTMLRendererActions) {
            EnumMap<StandardHtmlActionId, MJAbstractAction> enumMap = new EnumMap<StandardHtmlActionId, MJAbstractAction>(StandardHtmlActionId.class);
            for (StandardHtmlActionId standardHtmlActionId : StandardHtmlActionId.values()) {
                MJAbstractAction mJAbstractAction = HtmlActionsAdapter.getStandardAction(hTMLRendererActions, standardHtmlActionId);
                if (mJAbstractAction == null) continue;
                enumMap.put(standardHtmlActionId, mJAbstractAction);
            }
            return enumMap;
        }

        private static MJAbstractAction getStandardAction(HTMLRendererActions hTMLRendererActions, StandardHtmlActionId standardHtmlActionId) {
            switch (standardHtmlActionId) {
                case GO_BACK: {
                    return hTMLRendererActions.fGoBackAction;
                }
                case GO_FORWARD: {
                    return hTMLRendererActions.fGoForwardAction;
                }
                case COPY: {
                    return hTMLRendererActions.fCopyAction;
                }
                case FIND: {
                    return hTMLRendererActions.fFindAction;
                }
                case HOME: {
                    return hTMLRendererActions.fHomeAction;
                }
                case PRINT: {
                    return hTMLRendererActions.fPrintAction;
                }
                case RELOAD: {
                    return hTMLRendererActions.fReloadAction;
                }
                case SAVE_AS: {
                    return hTMLRendererActions.fSaveAsAction;
                }
                case VIEW_SOURCE: {
                    return hTMLRendererActions.fViewSourceAction;
                }
            }
            return null;
        }

        private static Map<MatlabHtmlActionId, MJAbstractAction> buildMatlabActionsMap(HTMLRendererActions hTMLRendererActions) {
            EnumMap<MatlabHtmlActionId, MJAbstractAction> enumMap = new EnumMap<MatlabHtmlActionId, MJAbstractAction>(MatlabHtmlActionId.class);
            for (MatlabHtmlActionId matlabHtmlActionId : MatlabHtmlActionId.values()) {
                MJAbstractAction mJAbstractAction = HtmlActionsAdapter.getMatlabAction(hTMLRendererActions, matlabHtmlActionId);
                if (mJAbstractAction == null) continue;
                enumMap.put(matlabHtmlActionId, mJAbstractAction);
            }
            return enumMap;
        }

        private static MJAbstractAction getMatlabAction(HTMLRendererActions hTMLRendererActions, MatlabHtmlActionId matlabHtmlActionId) {
            switch (matlabHtmlActionId) {
                case EVALUATE_SELECTION: {
                    return hTMLRendererActions.fEvalSelectionAction;
                }
                case OPEN_SELECTION: {
                    return hTMLRendererActions.fOpenSelectionAction;
                }
                case HELP_ON_SELECTION: {
                    return hTMLRendererActions.fHelpSelectionAction;
                }
            }
            return null;
        }

        public Map<StandardHtmlActionId, MJAbstractAction> getBasicActions() {
            return Collections.unmodifiableMap(this.iBasicActions);
        }

        public HtmlActionGroups getCustomActionGroups() {
            LinkedHashMap<String, MJAbstractAction> linkedHashMap = new LinkedHashMap<String, MJAbstractAction>();
            linkedHashMap.put(MatlabHtmlActionId.EVALUATE_SELECTION.toString(), this.iMatlabActions.get((Object)MatlabHtmlActionId.EVALUATE_SELECTION));
            linkedHashMap.put(MatlabHtmlActionId.HELP_ON_SELECTION.toString(), this.iMatlabActions.get((Object)MatlabHtmlActionId.HELP_ON_SELECTION));
            linkedHashMap.put(MatlabHtmlActionId.OPEN_SELECTION.toString(), this.iMatlabActions.get((Object)MatlabHtmlActionId.OPEN_SELECTION));
            HtmlActionGroup htmlActionGroup = new HtmlActionGroup("MatlabActions", linkedHashMap);
            HtmlActionGroups htmlActionGroups = new HtmlActionGroups();
            htmlActionGroups.addCustomActionGroup(htmlActionGroup);
            return htmlActionGroups;
        }

        public void removeNavigationActions() {
            this.iBasicActions.remove(StandardHtmlActionId.GO_BACK);
            this.iBasicActions.remove(StandardHtmlActionId.GO_FORWARD);
            this.iBasicActions.remove(StandardHtmlActionId.RELOAD);
            this.iBasicActions.remove(StandardHtmlActionId.HOME);
        }

        public void dispose() {
        }
    }

    private static class PageChangedListenerAdapter
    implements PageChangedListener {
        private final com.mathworks.html.PageChangedListener iRealListener;
        private Url iLastUrl;

        private PageChangedListenerAdapter(com.mathworks.html.PageChangedListener pageChangedListener) {
            this.iRealListener = pageChangedListener;
        }

        @Override
        public void pageChanged(PageChangedListener.PageChangedEvent pageChangedEvent) {
            String string = pageChangedEvent.getTitle();
            Url url = Url.parseSilently((String)pageChangedEvent.getFullUrl());
            PageChangedEvent pageChangedEvent2 = new PageChangedEvent(string, url, this.iLastUrl);
            this.iLastUrl = url;
            this.iRealListener.pageChanged(pageChangedEvent2);
        }
    }

    private static class StatusTextListenerAdapter
    implements ActionListener {
        private final StatusTextListener iTextListener;

        private StatusTextListenerAdapter(StatusTextListener statusTextListener) {
            this.iTextListener = statusTextListener;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            StatusTextChangedEvent statusTextChangedEvent = new StatusTextChangedEvent(string);
            this.iTextListener.statusChanged(statusTextChangedEvent);
        }
    }
}

