/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.desktop.overlay.impl.DefaultOverlayManager;
import com.mathworks.html.BrowserQueue;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlComponentWrapper;
import com.mathworks.html.HtmlContextMenuBuilder;
import com.mathworks.html.HtmlPanel;
import com.mathworks.html.LoadFailureHandlerMap;
import com.mathworks.html.PopupWindowListener;
import com.mathworks.html.ProxyAuthenticationFailureHandler;
import com.mathworks.html.ProxySettings;
import com.mathworks.html.RequestHandler;
import com.mathworks.mlwidgets.html.DefaultPopupWindowListener;
import com.mathworks.mlwidgets.html.HTMLAcceleratorHelper;
import com.mathworks.mlwidgets.html.HTMLPrefs;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.HtmlComponentRegistry;
import com.mathworks.mlwidgets.html.MJHtmlPanelActions;
import com.mathworks.mlwidgets.html.MLLoadFailureHandlerMap;
import com.mathworks.mlwidgets.html.MatlabRequestHandler;
import com.mathworks.mlwidgets.html.ProxyCredentialsDialog;
import com.mathworks.services.Prefs;
import com.mathworks.widgets.ComponentBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class MJHtmlPanel
extends HtmlComponentWrapper<HtmlPanel>
implements ComponentBuilder {
    private final MJHtmlPanelActions fActions;
    private final HtmlPanel fHtmlPanel;
    private final int fRegistryId;
    private boolean fUsingCustomPopupHandler = false;

    private static void setupProxyListener() {
        MJHtmlPanel.updateProxySettings();
        HTMLPrefs.addProxyListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MJHtmlPanel.updateProxySettings();
            }
        });
    }

    private static void updateProxySettings() {
        if (HTMLPrefs.getUseProxy()) {
            String string = HTMLPrefs.getProxyHost();
            String string2 = HTMLPrefs.getProxyPort();
            String string3 = HTMLPrefs.getUseProxyAuthentication() ? HTMLPrefs.getProxyUsername() : null;
            String string4 = HTMLPrefs.getUseProxyAuthentication() ? HTMLPrefs.getProxyPassword() : null;
            int n = string2 != null ? Integer.parseInt(string2) : 0;
            ProxySettings.configureProxy((String)string, (int)n, (String)string3, (String)string4);
            ProxySettings.setAuthenticationFailureHandler((ProxyAuthenticationFailureHandler)new ProxyCredentialsDialog());
        } else {
            ProxySettings.clearProxySettings();
        }
    }

    public static void setupMozillaDirectory() {
        HtmlComponentFactory.HtmlComponentType.HTMLPANEL.beforeBrowserCreation();
    }

    private static File getResourceDirectory() {
        File file;
        String string = Prefs.getPropertyDirectory();
        if (string != null && (file = new File(string)).exists() && file.canWrite()) {
            File file2 = new File(file, "HtmlPanel");
            if (!file2.exists()) {
                file2.mkdir();
            }
            return file2;
        }
        return null;
    }

    private MJHtmlPanel(HtmlPanel htmlPanel, MJHtmlPanelActions mJHtmlPanelActions) {
        super((HtmlComponent)htmlPanel);
        this.fHtmlPanel = htmlPanel;
        this.fActions = mJHtmlPanelActions;
        this.fHtmlPanel.setActions((HtmlActions)mJHtmlPanelActions);
        this.fHtmlPanel.addLoadFailureHandlers((LoadFailureHandlerMap)new MLLoadFailureHandlerMap());
        DefaultOverlayManager.tagAsHeavyweight((JComponent)htmlPanel.getComponent());
        this.fRegistryId = HtmlComponentRegistry.registerHtmlComponent((HtmlComponent)this);
    }

    public static MJHtmlPanel createBrowser() {
        return MJHtmlPanel.createBrowser(HtmlPanel.BrowserType.JXBROWSER);
    }

    public static MJHtmlPanel createBrowser(HtmlPanel.BrowserType browserType) {
        HtmlPanel htmlPanel = new HtmlPanel(browserType);
        return MJHtmlPanel.createBrowser(htmlPanel);
    }

    static MJHtmlPanel createBrowser(HtmlPanel htmlPanel) {
        MJHtmlPanelActions mJHtmlPanelActions = new MJHtmlPanelActions(htmlPanel);
        final MJHtmlPanel mJHtmlPanel = new MJHtmlPanel(htmlPanel, mJHtmlPanelActions);
        mJHtmlPanel.getComponent().putClientProperty("mwjavaguitest.instance", (Object)mJHtmlPanel);
        BrowserQueue.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                mJHtmlPanel.finishSetup();
            }
        });
        return mJHtmlPanel;
    }

    private synchronized void finishSetup() {
        this.addRequestHandler((RequestHandler)new MatlabRequestHandler((HtmlComponent)this, this.fRegistryId));
        if (!this.fUsingCustomPopupHandler) {
            this.fHtmlPanel.setPopupWindowListener((PopupWindowListener)new DefaultPopupWindowListener());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MJHtmlPanel.this.setUpKeyBindings();
            }
        });
    }

    private void setUpKeyBindings() {
        HTMLAcceleratorHelper hTMLAcceleratorHelper = new HTMLAcceleratorHelper(this.getComponent());
        Collection<Action> collection = this.getActions().getAllActions();
        for (Action action : collection) {
            hTMLAcceleratorHelper.addAction(action);
        }
    }

    public void setHtmlContextMenuBuilder(HtmlContextMenuBuilder htmlContextMenuBuilder) {
        this.fHtmlPanel.setHtmlContextMenuBuilder(htmlContextMenuBuilder);
    }

    public void setHomeUrl(String string) {
        this.fHtmlPanel.setHomeUrl(string);
    }

    public JComponent getComponent() {
        return ((HtmlPanel)this.getWrappedComponent()).getComponent();
    }

    public void dispose() {
        HtmlComponentRegistry.removeHtmlComponent(this.fRegistryId);
        super.dispose();
    }

    public MJHtmlPanelActions getActions() {
        return this.fActions;
    }

    public synchronized void setPopupWindowListener(PopupWindowListener popupWindowListener) {
        this.fUsingCustomPopupHandler = popupWindowListener != null;
        this.fHtmlPanel.setPopupWindowListener(popupWindowListener);
    }

    public HtmlContextMenuBuilder getContextMenuBuilder() {
        return this.fHtmlPanel.getContextMenuBuilder();
    }

    public int getRegistryId() {
        return this.fRegistryId;
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.fHtmlPanel.addRequestHandler(requestHandler);
    }

    static {
        MJHtmlPanel.setupMozillaDirectory();
        File file = MJHtmlPanel.getResourceDirectory();
        if (file != null) {
            HtmlPanel.setResourceDirectory((File)file);
        }
        MJHtmlPanel.setupProxyListener();
    }
}

