/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.html.BrowserRequest;
import com.mathworks.html.CustomProtocolRequestHandler;
import com.mathworks.html.CustomProtocolUrl;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.Url;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlwidgets.html.CommandInfoPanel;
import com.mathworks.mlwidgets.html.ExternalReferrerTransformer;
import com.mathworks.mlwidgets.html.HTMLPrefs;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mwswing.MJOptionPane;
import java.awt.Component;
import java.awt.Window;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;

public class MatlabRequestHandler
extends CustomProtocolRequestHandler {
    private static final Pattern MATLAB_FORM_DATA_PATTERN = Pattern.compile("^([\\w.]+)\\?");
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s");
    private final HtmlComponent fHtmlComponent;
    private final int fRegistryId;

    public MatlabRequestHandler(HtmlComponent htmlComponent, int n) {
        super("matlab", new String[0]);
        this.fHtmlComponent = htmlComponent;
        this.fRegistryId = n;
    }

    protected void handleMatchedRequest(BrowserRequest browserRequest, CustomProtocolUrl customProtocolUrl) {
        new Thread(new MatlabCommandRunnable(customProtocolUrl)).start();
    }

    private boolean allowRequest(CustomProtocolUrl customProtocolUrl) {
        if (this.isReferrerExternal() && !HTMLPrefs.isExternalLinkIsOk()) {
            return this.showSecurityDialog(customProtocolUrl);
        }
        return true;
    }

    public boolean isReferrerExternal() {
        String string = this.fHtmlComponent.getCurrentLocation();
        return MatlabRequestHandler.isReferrerExternal(string);
    }

    public static boolean isReferrerExternal(String string) {
        try {
            Url url = Url.parse((String)string);
            return (Boolean)new ExternalReferrerTransformer().transformUrl(url);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean showSecurityDialog(CustomProtocolUrl customProtocolUrl) {
        String string;
        CommandInfoPanel commandInfoPanel;
        Window window = SwingUtilities.windowForComponent(this.fHtmlComponent.getComponent());
        int n = MJOptionPane.showConfirmDialog((Component)window, (Object)((Object)(commandInfoPanel = new CommandInfoPanel(customProtocolUrl.getCommand()))), (String)(string = HTMLUtils.sRes.getString("alert.security_warning_title")), (int)0, (int)2);
        return n == 0;
    }

    private String buildMatlabEvalString(CustomProtocolUrl customProtocolUrl) {
        String string = MatlabRequestHandler.getMatlabCommandFromUrl(customProtocolUrl);
        string = MatlabRequestHandler.cleanUpMatlabUrlCommand(string);
        int n = MatlabRequestHandler.getMatlabUrlFormDataStart(string = string.replaceAll("\\$browser", "webutils.Browser(" + String.valueOf(this.fRegistryId) + ")"));
        if (n > -1) {
            String string2 = string.substring(n);
            string = string.substring(0, n);
            return MatlabRequestHandler.buildMatlabFormEvalString(string, string2);
        }
        return string;
    }

    private static String getMatlabCommandFromUrl(CustomProtocolUrl customProtocolUrl) {
        String string = customProtocolUrl.getQueryString();
        if (string == null || string.trim().isEmpty()) {
            return customProtocolUrl.getCommand();
        }
        return customProtocolUrl.getCommand() + '?' + string;
    }

    private static int getMatlabUrlFormDataStart(String string) {
        Matcher matcher = MATLAB_FORM_DATA_PATTERN.matcher(string);
        if (matcher.find()) {
            return matcher.end(1);
        }
        return -1;
    }

    private static String buildMatlabFormEvalString(String string, String string2) {
        if (SPACE_PATTERN.matcher(string).find()) {
            return string + " " + string2;
        }
        return MatlabRequestHandler.buildFunctionSyntaxEvalString(string, string2);
    }

    private static String buildFunctionSyntaxEvalString(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append("('").append(string2).append("')");
        return stringBuilder.toString();
    }

    private static String cleanUpMatlabUrlCommand(String string) {
        return string.replaceFirst("^\\s+", "");
    }

    private class MatlabCommandRunnable
    implements Runnable {
        private final CustomProtocolUrl iCommand;

        private MatlabCommandRunnable(CustomProtocolUrl customProtocolUrl) {
            this.iCommand = customProtocolUrl;
        }

        @Override
        public void run() {
            if (MatlabRequestHandler.this.allowRequest(this.iCommand)) {
                String string = MatlabRequestHandler.this.buildMatlabEvalString(this.iCommand);
                new Matlab().evalConsoleOutput(string);
            }
        }
    }
}

