/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ImportToolUtils {
    private static final String RES = "com.mathworks.mlwidgets.importtool.resources.RES_ImportTool";
    private static ResourceBundle sBundle = null;

    public static String getResourceString(String string) {
        if (sBundle == null) {
            sBundle = ResourceBundle.getBundle(RES);
        }
        return sBundle.getString(string);
    }

    public static String toExcelRange(int n, int n2, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ImportToolUtils.intToColumnString(n3));
        stringBuilder.append(Integer.toString(n));
        stringBuilder.append(":");
        stringBuilder.append(ImportToolUtils.intToColumnString(n4));
        stringBuilder.append(Integer.toString(n2));
        return stringBuilder.toString();
    }

    public static int[] fromCell(String string) {
        if (!(string = string.trim()).matches("[a-zA-Z]+\\d+")) {
            return null;
        }
        String string2 = string.replaceAll("[\\d\\s\\W]", "").toUpperCase();
        String string3 = string.replaceAll("[a-zA-Z\\s\\W]", "");
        if (string2.length() == 0 || string3.length() == 0) {
            return null;
        }
        int[] nArray = new int[2];
        nArray[1] = ImportToolUtils.columnStringToInt(string2);
        nArray[0] = Integer.parseInt(string3);
        return nArray;
    }

    public static List<int[]> fromExcelRange(String string) {
        String[] stringArray = string.split("[,\\s]");
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        for (String string2 : stringArray) {
            int[] nArray;
            Object[] objectArray;
            if (string2.trim().length() == 0) continue;
            if (string2.matches(".*:.*")) {
                objectArray = string2.split(":");
                nArray = new int[4];
                if (objectArray.length != 2 || objectArray[0].length() <= 0 || objectArray[1].length() <= 0) continue;
                int[] nArray2 = ImportToolUtils.fromCell(objectArray[0].trim());
                int[] nArray3 = ImportToolUtils.fromCell(objectArray[1].trim());
                if (nArray3 == null || nArray2 == null) continue;
                nArray[0] = nArray2[0];
                nArray[1] = nArray2[1];
                nArray[2] = nArray3[0];
                nArray[3] = nArray3[1];
                arrayList.add(nArray);
                continue;
            }
            objectArray = new int[4];
            nArray = ImportToolUtils.fromCell(string2);
            if (nArray == null) continue;
            objectArray[0] = nArray[0];
            objectArray[1] = nArray[1];
            objectArray[2] = nArray[0];
            objectArray[3] = nArray[1];
            arrayList.add((int[])objectArray);
        }
        return arrayList;
    }

    private static String toMatlabInterval(int n, int n2, int n3) {
        if (n == 1 && n2 == n3) {
            return ":";
        }
        if (n == 1) {
            if (n2 == n) {
                return "1";
            }
            return "1:" + Integer.toString(n2);
        }
        if (n2 == n3) {
            if (n == n2) {
                return "end";
            }
            return Integer.toString(n) + ":end";
        }
        if (n < n2) {
            return Integer.toString(n) + ":" + Integer.toString(n2);
        }
        if (n == n2) {
            return Integer.toString(n);
        }
        return "";
    }

    private static String toMatlabSubsref(List<int[]> list, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list.size() == 1) {
            stringBuilder.append(ImportToolUtils.toMatlabInterval(list.get(0)[0] + 1, list.get(0)[1] + 1, n));
        } else {
            stringBuilder.append("[");
            stringBuilder.append(ImportToolUtils.toMatlabInterval(list.get(0)[0] + 1, list.get(0)[1] + 1, n));
            for (int i = 1; i < list.size(); ++i) {
                stringBuilder.append(",");
                stringBuilder.append(ImportToolUtils.toMatlabInterval(list.get(i)[0] + 1, list.get(i)[1] + 1, n));
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public static String toMatlabSubsref(List<int[]> list, List<int[]> list2, int n, int n2) {
        if (list == null || list2 == null || list.isEmpty() || list2.isEmpty()) {
            return "";
        }
        if (list.size() == 1 && list2.size() == 1 && list.get(0)[0] == 0 && list2.get(0)[0] == 0 && list.get(0)[1] == n - 1 && list2.get(0)[1] == n2 - 1) {
            return "";
        }
        return "(" + ImportToolUtils.toMatlabSubsref(list, n) + "," + ImportToolUtils.toMatlabSubsref(list2, n2) + ")";
    }

    static Icon getResourceIcon(String string) {
        return new ImageIcon(ImportToolUtils.class.getResource("/com/mathworks/mlwidgets/importtool/resources/" + string));
    }

    private static int columnStringToInt(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = cArray.length - 1; i >= 0; --i) {
            int n2 = cArray.length - i;
            n += (int)((double)(cArray[i] - 65 + 1) * Math.pow(26.0, n2 - 1));
        }
        return n;
    }

    public static String intToColumnString(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        if (l <= 26L) {
            stringBuilder.append(new String(new char[]{(char)(l + 65L - 1L)}));
        } else {
            long l2 = l % 26L;
            long l3 = l / 26L;
            if (l2 == 0L) {
                stringBuilder.append(ImportToolUtils.intToColumnString(l3 - 1L));
                stringBuilder.append("Z");
            } else {
                stringBuilder.append(ImportToolUtils.intToColumnString(l3));
                stringBuilder.append(new String(new char[]{(char)(l2 + 65L - 1L)}));
            }
        }
        return stringBuilder.toString();
    }
}

