/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mwswing.MJComponent;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import javax.swing.JRootPane;

public class SnapshotPane
extends MJComponent {
    protected JRootPane fRootPane;
    protected BufferedImage fBufferedImage = null;
    protected boolean fShowBufferedImage = false;
    protected int fBufferedImageCounter = 0;

    public SnapshotPane(JRootPane jRootPane) {
        this.fRootPane = jRootPane;
    }

    public void paintComponent(Graphics graphics) {
        if (this.fBufferedImage == null || !this.fShowBufferedImage) {
            super.paintComponent(graphics);
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.drawImage((Image)this.fBufferedImage, 0, 0, (ImageObserver)((Object)this));
            graphics2D.dispose();
        }
    }

    public void bufferRootPaneImage() {
        this.fBufferedImage = new BufferedImage(this.fRootPane.getWidth(), this.fRootPane.getHeight(), 1);
        this.fRootPane.paintAll(this.fBufferedImage.getGraphics());
    }

    public void bufferScreenUntilTableUpdate() {
        if (this.fBufferedImage == null) {
            this.bufferRootPaneImage();
        }
        this.fShowBufferedImage = true;
        ++this.fBufferedImageCounter;
    }

    public void bufferUpdateEventOccurred() {
        --this.fBufferedImageCounter;
        if (this.fBufferedImageCounter <= 0) {
            this.fBufferedImage = null;
            this.fBufferedImageCounter = 0;
            this.fShowBufferedImage = false;
        }
    }

    public boolean isBufferingImage() {
        return this.fBufferedImage != null && this.fShowBufferedImage;
    }
}

