/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportCodeFactory;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.SpreadsheetImportClient;
import com.mathworks.mlwidgets.importtool.SpreadsheetImportUIState;
import com.mathworks.mlwidgets.importtool.SpreadsheetTableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.widgets.text.matlab.comment.CommentWrappingPreferences;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpreadsheetCodeFactory
extends ImportCodeFactory {
    public static void generateScript(GeneratedCode generatedCode, SpreadsheetImportUIState spreadsheetImportUIState) {
        SpreadsheetCodeFactory.generateMatlabScriptCommentHeader(generatedCode, spreadsheetImportUIState);
        String string = null;
        if (spreadsheetImportUIState.isMatrix() || spreadsheetImportUIState.isCellArray()) {
            string = spreadsheetImportUIState.getGlobalVariableName();
        } else if (spreadsheetImportUIState.isDataset() || spreadsheetImportUIState.isTable()) {
            String[] stringArray = spreadsheetImportUIState.getSelectedColumnNames();
            string = stringArray.length == 1 ? generatedCode.generateUnequalVarNames(stringArray[0], new String[]{spreadsheetImportUIState.getGlobalVariableName()}) : generatedCode.generateUnequalVarNames("data", new String[]{spreadsheetImportUIState.getGlobalVariableName()});
        } else if (spreadsheetImportUIState.isColumnVectors()) {
            String[] stringArray = spreadsheetImportUIState.getSelectedColumnNames();
            string = stringArray.length == 1 ? stringArray[0] : (spreadsheetImportUIState.isColumnVectors() ? generatedCode.generateUnequalVarNames("data", stringArray) : generatedCode.generateUnequalVarNames("data", new String[]{spreadsheetImportUIState.getGlobalVariableName()}));
        }
        generatedCode.setIntermediateImportDataMatrix(string);
        SpreadsheetCodeFactory.generateMatlabContentCode(generatedCode, spreadsheetImportUIState, true);
        generatedCode.addCode("\n");
        SpreadsheetCodeFactory.generateScriptAllocation(generatedCode, spreadsheetImportUIState);
        if (generatedCode.hasVariablesToClear()) {
            generatedCode.addCode("%% ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.clearvars"));
            generatedCode.addCode("\n");
            generatedCode.addClearCode();
        }
    }

    public static void generateFunction(GeneratedCode generatedCode, SpreadsheetImportUIState spreadsheetImportUIState, String string) {
        SpreadsheetCodeFactory.generateMatlabFunctionHeader(generatedCode, spreadsheetImportUIState, string);
        SpreadsheetCodeFactory.generateMatlabFunctionInputHandler(generatedCode, spreadsheetImportUIState);
        SpreadsheetCodeFactory.generateMatlabContentCode(generatedCode, spreadsheetImportUIState, false);
        generatedCode.addCode("\n");
        if (spreadsheetImportUIState.isColumnVectors()) {
            SpreadsheetCodeFactory.generateColumnVariableAllocation(spreadsheetImportUIState.getValidatedSelectedColumnNames(), spreadsheetImportUIState, generatedCode, false);
        } else if (spreadsheetImportUIState.isDataset()) {
            SpreadsheetCodeFactory.generateDatasetVariableAllocation("datasetout", spreadsheetImportUIState.getSelectedColumnNames(), spreadsheetImportUIState, generatedCode, false);
        } else if (spreadsheetImportUIState.isTable()) {
            SpreadsheetCodeFactory.generateTableVariableAllocation("tableout", spreadsheetImportUIState.getSelectedColumnNames(), spreadsheetImportUIState, generatedCode, false);
        }
    }

    public static void generateScriptAllocation(GeneratedCode generatedCode, SpreadsheetImportUIState spreadsheetImportUIState) {
        if (spreadsheetImportUIState.isMatrix() || spreadsheetImportUIState.isCellArray()) {
            String string = spreadsheetImportUIState.getGlobalVariableName();
            generatedCode.addOutputVariableName(string);
            if (string.equals(generatedCode.getIntermediateImportDataMatrix())) {
                return;
            }
            generatedCode.addCode(String.format("%1$s = %2$s;%n%n", string, generatedCode.getIntermediateImportDataMatrix()));
        } else if (spreadsheetImportUIState.isColumnVectors()) {
            SpreadsheetCodeFactory.generateColumnVariableAllocation(spreadsheetImportUIState.getSelectedColumnNames(), spreadsheetImportUIState, generatedCode, true);
        } else if (spreadsheetImportUIState.isDataset()) {
            SpreadsheetCodeFactory.generateDatasetVariableAllocation(spreadsheetImportUIState.getGlobalVariableName(), spreadsheetImportUIState.getSelectedColumnNames(), spreadsheetImportUIState, generatedCode, true);
        } else if (spreadsheetImportUIState.isTable()) {
            SpreadsheetCodeFactory.generateTableVariableAllocation(spreadsheetImportUIState.getGlobalVariableName(), spreadsheetImportUIState.getSelectedColumnNames(), spreadsheetImportUIState, generatedCode, true);
        }
    }

    private static List<Integer>[] getSpreadsheetColumnTargetLists(SpreadsheetImportUIState spreadsheetImportUIState) {
        int n;
        List<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> list = spreadsheetImportUIState.getSelectedColumnTargetTypes();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        Object[] objectArray = new Integer[spreadsheetImportUIState.getSelectedColumnCount()];
        Object[] objectArray2 = new Integer[spreadsheetImportUIState.getSelectedColumnCount()];
        Object[] objectArray3 = new Integer[spreadsheetImportUIState.getSelectedColumnCount()];
        Arrays.fill(objectArray, (Object)-1);
        Arrays.fill(objectArray2, (Object)-1);
        Arrays.fill(objectArray3, (Object)-1);
        List<Object> list2 = Arrays.asList(objectArray);
        List<Object> list3 = Arrays.asList(objectArray2);
        List<Object> list4 = Arrays.asList(objectArray3);
        for (n = 0; n < list.size(); ++n) {
            SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType spreadsheetColumnTargetType = list.get(n);
            if (spreadsheetColumnTargetType == SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.NUMERIC_ARRAY) {
                arrayList.add(n);
                continue;
            }
            if (spreadsheetColumnTargetType == SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.DATETIME_ARRAY) {
                arrayList3.add(n);
                continue;
            }
            arrayList2.add(n);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            list2.set((Integer)arrayList.get(n), n);
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            list3.set((Integer)arrayList2.get(n), n);
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            list4.set((Integer)arrayList3.get(n), n);
        }
        return new List[]{list2, list3, list4};
    }

    static void generateMatlabScriptCommentHeader(GeneratedCode generatedCode, SpreadsheetImportUIState spreadsheetImportUIState) {
        generatedCode.addCode("%% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.scriptcellheader"));
        generatedCode.addCode("\n");
        generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.scriptheading"));
        generatedCode.addCode("\n%\n%    ");
        generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.workbook"));
        generatedCode.addCode(": ");
        generatedCode.addCode(spreadsheetImportUIState.getFile().getPath().replaceAll("'", "''"));
        generatedCode.addCode("\n%    ");
        generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.worksheet"));
        generatedCode.addCode(": ");
        generatedCode.addCode(spreadsheetImportUIState.getSheetName());
        generatedCode.addCode("\n%\n% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.extendcommentline"));
        generatedCode.addCode("\n");
        generatedCode.addCode(SpreadsheetCodeFactory.getTimeStampComment());
        generatedCode.addCode("\n");
    }

    /*
     * WARNING - void declaration
     */
    private static void generateMatlabContentCode(GeneratedCode generatedCode, SpreadsheetImportUIState spreadsheetImportUIState, boolean bl) {
        boolean bl2;
        String string;
        void var10_15;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        ArrayList<WorksheetRule> arrayList = new ArrayList<WorksheetRule>();
        int n = 0;
        List<SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType> list = spreadsheetImportUIState.getSelectedColumnTargetTypes();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).isDatetimeArray()) continue;
            bl3 = true;
            break;
        }
        if (spreadsheetImportUIState.getActiveRules() != null) {
            for (WorksheetRule object2 : spreadsheetImportUIState.getActiveRules()) {
                arrayList.add(object2);
                if (object2.codeGenNeedsNaNConvert()) {
                    bl4 = true;
                }
                if (bl && object2.isRowExcludeType()) {
                    bl5 = true;
                }
                if (!bl || !object2.isColumnExcludeType()) continue;
                ++n;
            }
        }
        List<Object> list2 = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        List<Integer> list3 = new ArrayList<Integer>();
        if (spreadsheetImportUIState.isColumnVectors() || spreadsheetImportUIState.isDataset() || spreadsheetImportUIState.isTable()) {
            list2 = SpreadsheetCodeFactory.getSelectedCellColumnVectorPositions(spreadsheetImportUIState);
            List<Integer> list4 = SpreadsheetCodeFactory.getSelectedNumericColumnVectorPositions(spreadsheetImportUIState);
            list3 = SpreadsheetCodeFactory.getSelectedDatetimeColumnVectorPositions(spreadsheetImportUIState);
        }
        String string2 = null;
        WorksheetRule.setColumnVectorPositions(list3, (List<Integer>)var10_15);
        WorksheetRule.setOnlyDatetimesSelected(spreadsheetImportUIState.getSelectedColumnCount() == list3.size());
        if (spreadsheetImportUIState.isCellArray()) {
            string = generatedCode.getIntermediateImportDataMatrix();
            generatedCode.setRawCellArray(string);
            if (bl) {
                SpreadsheetCodeFactory.generateXLSReadScriptCode(generatedCode, spreadsheetImportUIState, null, string, bl3 ? generatedCode.getDateArray() : null);
            } else {
                SpreadsheetCodeFactory.generateXLSReadFunctionCode(generatedCode, spreadsheetImportUIState, null, string, bl3 ? generatedCode.getDateArray() : null);
            }
        } else {
            bl2 = (spreadsheetImportUIState.isColumnVectors() || spreadsheetImportUIState.isDataset() || spreadsheetImportUIState.isTable()) && !list2.isEmpty();
            string = generatedCode.getRawCellArray();
            String[][] stringArray = spreadsheetImportUIState.getRangeArray();
            if (arrayList.isEmpty() && !bl2 && list3.isEmpty() && (!bl || stringArray != null && stringArray.length == 1 && stringArray[0].length == 1 && SpreadsheetCodeFactory.isRangeEntireTable(stringArray[0][0], spreadsheetImportUIState))) {
                string2 = generatedCode.getIntermediateImportDataMatrix();
                string = null;
            }
            if (bl) {
                SpreadsheetCodeFactory.generateXLSReadScriptCode(generatedCode, spreadsheetImportUIState, string2, string, list3.isEmpty() ? null : generatedCode.getDateArray());
            } else {
                SpreadsheetCodeFactory.generateXLSReadFunctionCode(generatedCode, spreadsheetImportUIState, string2, string, list3.isEmpty() ? null : generatedCode.getDateArray());
            }
        }
        bl2 = false;
        if (!list2.isEmpty() || spreadsheetImportUIState.isCellArray() || bl4 && string != null || bl5) {
            bl2 = true;
            SpreadsheetCodeFactory.generateReplaceNaNsWithEmpty(generatedCode, string);
        }
        if (bl5 && !list3.isEmpty()) {
            bl2 = true;
            SpreadsheetCodeFactory.generateReplaceNaNsWithEmpty(generatedCode, generatedCode.getDateArray());
        }
        if (spreadsheetImportUIState.isColumnVectors() || spreadsheetImportUIState.isDataset() || spreadsheetImportUIState.isTable()) {
            if (!list2.isEmpty() && list3.isEmpty()) {
                if (!bl2 && bl4 && !var10_15.isEmpty() && string != null) {
                    SpreadsheetCodeFactory.generateReplaceNaNsWithEmpty(generatedCode, string);
                }
                if (string != null) {
                    generatedCode.addCode(String.format("%1$s = %2$s(:,%3$s);%n", generatedCode.getCellVectors(), generatedCode.getRawCellArray(), GeneratedCode.createMatlabIntegerArrayString(list2, 1)));
                    if (!var10_15.isEmpty()) {
                        generatedCode.addCode(String.format("%1$s = %1$s(:,%2$s);%n", generatedCode.getRawCellArray(), GeneratedCode.createMatlabIntegerArrayString((List<Integer>)var10_15, 1)));
                    }
                }
                if (bl3 && !var10_15.isEmpty()) {
                    generatedCode.addCode(String.format("%1$s = %1$s(:,%2$s);%n", generatedCode.getDateArray(), GeneratedCode.createMatlabIntegerArrayString((List<Integer>)var10_15, 1)));
                }
            } else if (list2.isEmpty() && !list3.isEmpty()) {
                if (!var10_15.isEmpty()) {
                    generatedCode.addCode(String.format("%1$s = %1$s(:,%2$s);%n", generatedCode.getRawCellArray(), GeneratedCode.createMatlabIntegerArrayString((List<Integer>)var10_15, 1)));
                }
                generatedCode.addCode(String.format("%1$s = %1$s(:,%2$s);%n", generatedCode.getDateArray(), GeneratedCode.createMatlabIntegerArrayString(list3, 1)));
            } else if (!list2.isEmpty() && !list3.isEmpty()) {
                if (!bl2 && bl4 && !var10_15.isEmpty() && string != null) {
                    SpreadsheetCodeFactory.generateReplaceNaNsWithEmpty(generatedCode, string);
                }
                if (string != null) {
                    generatedCode.addCode(String.format("%1$s = %2$s(:,%3$s);%n", generatedCode.getCellVectors(), generatedCode.getRawCellArray(), GeneratedCode.createMatlabIntegerArrayString(list2, 1)));
                    if (!var10_15.isEmpty()) {
                        generatedCode.addCode(String.format("%1$s = %1$s(:,%2$s);%n", generatedCode.getRawCellArray(), GeneratedCode.createMatlabIntegerArrayString((List<Integer>)var10_15, 1)));
                    }
                    generatedCode.addCode(String.format("%1$s = %1$s(:,%2$s);%n", generatedCode.getDateArray(), GeneratedCode.createMatlabIntegerArrayString(list3, 1)));
                }
            }
        }
        int n2 = 0;
        for (WorksheetRule worksheetRule : arrayList) {
            worksheetRule.generateMatlabCode(arrayList, generatedCode);
            if (n < 2) continue;
            generatedCode.addNewVariableName("remainingColumns");
            if (n2 == 0) {
                generatedCode.addCode(String.format("remainingColumns = find(~%s);%n", generatedCode.getColumnExclusionIndex()));
            } else {
                generatedCode.addCode(String.format("remainingColumns(%s) = [];%n", generatedCode.getColumnExclusionIndex()));
            }
            ++n2;
        }
        if (n2 >= 2) {
            generatedCode.addCode(String.format("%1$s = false(%2$d,1);%n", generatedCode.getColumnExclusionIndex(), spreadsheetImportUIState.getSelectedColumnCount()));
            generatedCode.addCode(String.format("%s(remainingColumns) = true;%n", generatedCode.getColumnExclusionIndex()));
            generatedCode.addNewVariableName("remainingColumns");
        }
        SpreadsheetCodeFactory.convertRawCellArrayIfNeeded(generatedCode, spreadsheetImportUIState, bl, (List<Integer>)var10_15, string2);
    }

    private static void convertRawCellArrayIfNeeded(GeneratedCode generatedCode, SpreadsheetImportUIState spreadsheetImportUIState, boolean bl, List<Integer> list, String string) {
        if (string == null && !list.isEmpty() || spreadsheetImportUIState.isMatrix()) {
            generatedCode.addCode("\n%% ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.createoutput"));
            generatedCode.addCode("\n");
            if (!bl) {
                String string2 = generatedCode.getNextExclusionIndex();
                generatedCode.addCode(string2 + " = cellfun(@(x) ischar(x), raw);\n");
                generatedCode.addCode("raw(" + string2 + ") = {NaN};\n");
            }
            generatedCode.addCode(String.format("%1$s = reshape([%2$s{:}],size(%2$s));%n", generatedCode.getIntermediateImportDataMatrix(), generatedCode.getRawCellArray()));
        }
    }

    private static boolean isRangeEntireTable(String string, SpreadsheetImportUIState spreadsheetImportUIState) {
        int[] nArray;
        int[] nArray2 = spreadsheetImportUIState.getDimensions();
        if (string == null) {
            return false;
        }
        List<int[]> list = ImportToolUtils.fromExcelRange(string);
        return list.size() == 1 && (nArray = list.get(0)) != null && nArray.length == 4 && nArray[0] == 1 && nArray[1] == 1 && nArray[2] == nArray2[0] && nArray[3] == nArray2[1];
    }

    private static List<Integer> getSpreadsheetColumnTargetTypePositions(SpreadsheetImportUIState spreadsheetImportUIState, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType spreadsheetColumnTargetType) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        for (int[] nArray : spreadsheetImportUIState.getSelectedColumnIntervals()) {
            for (int i = nArray[0]; i <= nArray[1]; ++i) {
                if (spreadsheetImportUIState.getSelectedColumnTargetTypes().get(n) == spreadsheetColumnTargetType) {
                    arrayList.add(n);
                }
                ++n;
            }
        }
        return arrayList;
    }

    private static List<Integer> getSelectedCellColumnVectorPositions(SpreadsheetImportUIState spreadsheetImportUIState) {
        return SpreadsheetCodeFactory.getSpreadsheetColumnTargetTypePositions(spreadsheetImportUIState, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.CELL_ARRAY);
    }

    private static List<Integer> getSelectedNumericColumnVectorPositions(SpreadsheetImportUIState spreadsheetImportUIState) {
        return SpreadsheetCodeFactory.getSpreadsheetColumnTargetTypePositions(spreadsheetImportUIState, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.NUMERIC_ARRAY);
    }

    private static List<Integer> getSelectedDatetimeColumnVectorPositions(SpreadsheetImportUIState spreadsheetImportUIState) {
        return SpreadsheetCodeFactory.getSpreadsheetColumnTargetTypePositions(spreadsheetImportUIState, SpreadsheetTableHeaderRenderer.SpreadsheetColumnTargetType.DATETIME_ARRAY);
    }

    private static void generateXLSReadFunctionCode(GeneratedCode generatedCode, SpreadsheetImportUIState spreadsheetImportUIState, String string, String string2, String string3) {
        if (spreadsheetImportUIState.isTesting()) {
            if (spreadsheetImportUIState.isBasicModeTesting()) {
                string3 = null;
            }
        } else if (SpreadsheetImportClient.isBasicMode()) {
            string3 = null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("%% ");
        if (string3 != null) {
            stringBuilder.append(ImportToolUtils.getResourceString("codeGen.importdatawithdates"));
        } else {
            stringBuilder.append(ImportToolUtils.getResourceString("codeGen.importdatanodates"));
        }
        stringBuilder.append("\n");
        if (spreadsheetImportUIState.isColumnVectors() || spreadsheetImportUIState.isDataset() || spreadsheetImportUIState.isTable()) {
            if (string != null) {
                stringBuilder.append(String.format("%s = ", string));
                stringBuilder.append(SpreadsheetCodeFactory.getxlsreadDataArrayForFunc(spreadsheetImportUIState.getSelectedColumnIntervals(), "1", ""));
                generatedCode.addNewVariableName("block");
                stringBuilder.append("for block=2:length(startRow)\n");
                generatedCode.addNewVariableName("tmpDataBlock");
                stringBuilder.append("tmpDataBlock = ");
                stringBuilder.append(SpreadsheetCodeFactory.getxlsreadDataArrayForFunc(spreadsheetImportUIState.getSelectedColumnIntervals(), "block", ""));
                stringBuilder.append(String.format("%1$s = [%1$s;tmpDataBlock]; %%#ok<AGROW>%n", string));
                stringBuilder.append("end\n");
            } else if (string3 == null) {
                int n;
                List<String> list = SpreadsheetCodeFactory.getRangeFormatStrings(spreadsheetImportUIState.getSelectedColumnIntervals());
                if (spreadsheetImportUIState.getSelectedColumnIntervals().size() == 1) {
                    stringBuilder.append(String.format("[~, ~, %1$s] = xlsread(workbookFile, sheetName, sprintf(%2$s,startRow(1),endRow(1)));%n", string2, list.get(0)));
                } else {
                    for (n = 0; n < list.size(); ++n) {
                        stringBuilder.append(String.format("[~, ~, %1$s%2$d] = xlsread(workbookFile, sheetName, sprintf(%3$s,startRow(1),endRow(1)));%n", string2, n + 1, list.get(n)));
                    }
                    stringBuilder.append(String.format("%1$s = [%1$s1", string2));
                    for (n = 1; n < list.size(); ++n) {
                        stringBuilder.append(String.format(",%1$s%2$d", string2, n + 1));
                    }
                    stringBuilder.append("];\n");
                }
                generatedCode.addNewVariableName("block");
                stringBuilder.append("for block=2:length(startRow)\n");
                if (spreadsheetImportUIState.getSelectedColumnIntervals().size() == 1) {
                    generatedCode.addNewVariableName("tmpDataBlock");
                    stringBuilder.append(String.format("[~, ~, tmpRawBlock] = xlsread(workbookFile, sheetName, sprintf(%1$s,startRow(block),endRow(block)));%n", list.get(0)));
                    stringBuilder.append(String.format("%1$s = [%1$s;tmpRawBlock]; %%#ok<AGROW>%n", string2));
                } else {
                    for (n = 0; n < list.size(); ++n) {
                        generatedCode.addNewVariableName(String.format("tmpDataBlock%d", n + 1));
                        stringBuilder.append(String.format("[~, ~, tmpRawBlock%1$d] = xlsread(workbookFile, sheetName, sprintf(%2$s,startRow(block),endRow(block)));%n", n + 1, list.get(n)));
                    }
                    stringBuilder.append(String.format("%1$s = [%1$s;tmpRawBlock1", string2));
                    for (n = 1; n < list.size(); ++n) {
                        stringBuilder.append(String.format(",tmpRawBlock%1$d", n + 1));
                    }
                    stringBuilder.append("]; %#ok<AGROW>\n");
                }
                stringBuilder.append("end\n");
            } else {
                int n;
                List<String> list = SpreadsheetCodeFactory.getRangeFormatStrings(spreadsheetImportUIState.getSelectedColumnIntervals());
                if (spreadsheetImportUIState.getSelectedColumnIntervals().size() == 1) {
                    stringBuilder.append(String.format("[~, ~, %1$s, %2$s] = xlsread(workbookFile, sheetName, sprintf(%3$s,startRow(1),endRow(1)),'' , @convertSpreadsheetExcelDates);%n", string2, string3, list.get(0)));
                } else {
                    for (n = 0; n < list.size(); ++n) {
                        stringBuilder.append(String.format("[~, ~, %1$s%2$d, %3$s%2$d] = xlsread(workbookFile, sheetName, sprintf(%4$s,startRow(1),endRow(1)),'' , @convertSpreadsheetExcelDates);%n", string2, n + 1, string3, list.get(n)));
                    }
                    stringBuilder.append(String.format("%1$s = [%1$s1", string2));
                    for (n = 1; n < list.size(); ++n) {
                        stringBuilder.append(String.format(",%1$s%2$d", string2, n + 1));
                    }
                    stringBuilder.append("];\n");
                    stringBuilder.append(String.format("%1$s = [%1$s1", string3));
                    for (n = 1; n < list.size(); ++n) {
                        stringBuilder.append(String.format(",%1$s%2$d", string3, n + 1));
                    }
                    stringBuilder.append("];\n");
                }
                generatedCode.addNewVariableName("block");
                stringBuilder.append("for block=2:length(startRow)\n");
                if (spreadsheetImportUIState.getSelectedColumnIntervals().size() == 1) {
                    generatedCode.addNewVariableName("tmpDataBlock");
                    generatedCode.addNewVariableName("tmpDateNumBlock");
                    stringBuilder.append(String.format("[~, ~, tmpRawBlock,tmpDateNumBlock] = xlsread(workbookFile, sheetName, sprintf(%1$s,startRow(block),endRow(block)),'' , @convertSpreadsheetExcelDates);%n", list.get(0)));
                    stringBuilder.append(String.format("%1$s = [%1$s;tmpRawBlock]; %%#ok<AGROW>%n", string2));
                    stringBuilder.append(String.format("%1$s = [%1$s;tmpDateNumBlock]; %%#ok<AGROW>%n", string3));
                } else {
                    for (n = 0; n < list.size(); ++n) {
                        generatedCode.addNewVariableName(String.format("tmpDataBlock%d", n + 1));
                        generatedCode.addNewVariableName(String.format("tmpDateNumBlock%d", n + 1));
                        stringBuilder.append(String.format("[~, ~, tmpRawBlock%1$d, tmpDateNumBlock%1$d] = xlsread(workbookFile, sheetName, sprintf(%2$s,startRow(block),endRow(block)),'' , @convertSpreadsheetExcelDates);%n", n + 1, list.get(n)));
                    }
                    stringBuilder.append(String.format("%1$s = [%1$s;tmpRawBlock1", string2));
                    for (n = 1; n < list.size(); ++n) {
                        stringBuilder.append(String.format(",tmpRawBlock%1$d", n + 1));
                    }
                    stringBuilder.append("]; %#ok<AGROW>\n");
                    stringBuilder.append(String.format("%1$s = [%1$s;tmpDateNumBlock1", string3));
                    for (n = 1; n < list.size(); ++n) {
                        stringBuilder.append(String.format(",tmpDateNumBlock%1$d", n + 1));
                    }
                    stringBuilder.append("]; %#ok<AGROW>\n");
                }
                stringBuilder.append("end\n");
            }
        } else if (string != null) {
            stringBuilder.append(String.format("%s = xlsread(workbookFile, sheetName, range);%n", string));
        } else if (string3 == null) {
            stringBuilder.append(String.format("[~, ~, %s] = xlsread(workbookFile, sheetName, range);%n", string2));
        } else {
            stringBuilder.append(String.format("[~, ~, %s, %s] = xlsread(workbookFile, sheetName, range, '', @convertSpreadsheetExcelDates);%n", string2, string3));
        }
        generatedCode.addCode(stringBuilder.toString());
    }

    private static void generateXLSReadScriptCode(GeneratedCode generatedCode, SpreadsheetImportUIState spreadsheetImportUIState, String string, String string2, String string3) {
        int n;
        int n2;
        if (spreadsheetImportUIState.isTesting()) {
            if (spreadsheetImportUIState.isBasicModeTesting()) {
                string3 = null;
            }
        } else if (SpreadsheetImportClient.isBasicMode()) {
            string3 = null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("%% ");
        if (string3 != null) {
            stringBuilder.append(ImportToolUtils.getResourceString("codeGen.importdatawithdates"));
        } else {
            stringBuilder.append(ImportToolUtils.getResourceString("codeGen.importdatanodates"));
        }
        stringBuilder.append("\n");
        String[][] stringArray = spreadsheetImportUIState.getRangeArray();
        int n3 = stringArray[0].length;
        int n4 = stringArray.length;
        int n5 = spreadsheetImportUIState.getSelectedRowIntervals().get(0)[0];
        int n6 = spreadsheetImportUIState.getSelectedColumnIntervals().get(0)[0];
        boolean bl = false;
        if (spreadsheetImportUIState.isTesting()) {
            bl = true;
        } else if (SpreadsheetImportClient.isBasicMode()) {
            bl = true;
        }
        if (bl || n5 == 0 && n6 == 0 && n4 == 1 && n3 == 1 && spreadsheetImportUIState.isRangeDefaultSelection()) {
            stringBuilder.append(SpreadsheetCodeFactory.generateXLSReadScriptSingleBlock(spreadsheetImportUIState.getFile().getPath(), spreadsheetImportUIState.getSheetName(), "", string, string2, string3));
            String string4 = ImportToolUtils.toMatlabSubsref(spreadsheetImportUIState.getSelectedRowIntervals(), spreadsheetImportUIState.getSelectedColumnIntervals(), spreadsheetImportUIState.getDimensions()[0], spreadsheetImportUIState.getDimensions()[1]);
            if (!string4.isEmpty()) {
                if (string != null) {
                    stringBuilder.append(String.format("%1$s = %1$s%2$s;%n", string, string4));
                }
                if (string2 != null) {
                    stringBuilder.append(String.format("%1$s = %1$s%2$s;%n", string2, string4));
                }
                if (string3 != null) {
                    stringBuilder.append(String.format("%1$s = %1$s%2$s;%n", string3, string4));
                }
            }
            generatedCode.addCode(stringBuilder.toString());
            return;
        }
        if (n4 == 1 && n3 == 1) {
            if (SpreadsheetCodeFactory.isRangeEntireTable(stringArray[0][0], spreadsheetImportUIState)) {
                stringBuilder.append(SpreadsheetCodeFactory.generateXLSReadScriptSingleBlock(spreadsheetImportUIState.getFile().getPath(), spreadsheetImportUIState.getSheetName(), "", string, string2, string3));
            } else {
                stringBuilder.append(SpreadsheetCodeFactory.generateXLSReadScriptSingleBlock(spreadsheetImportUIState.getFile().getPath(), spreadsheetImportUIState.getSheetName(), stringArray[0][0], string, string2, string3));
            }
            generatedCode.addCode(stringBuilder.toString());
            return;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n3; ++n) {
                String string5 = string != null ? generatedCode.getBlockVariable(string, n2, n) : null;
                String string6 = string2 != null ? generatedCode.getBlockVariable(string2, n2, n) : null;
                String string7 = string3 != null ? generatedCode.getBlockVariable(string3, n2, n) : null;
                stringBuilder.append(SpreadsheetCodeFactory.generateXLSReadScriptSingleBlock(spreadsheetImportUIState.getFile().getPath(), spreadsheetImportUIState.getSheetName(), stringArray[n2][n], string5, string6, string7));
            }
        }
        if (string != null) {
            stringBuilder.append(string);
            stringBuilder.append(" = [");
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < n3; ++n) {
                    stringBuilder.append(generatedCode.getBlockVariable(string, n2, n));
                    if (n < n3 - 1) {
                        stringBuilder.append(",");
                        continue;
                    }
                    if (n4 <= 1) continue;
                    stringBuilder.append(";");
                }
            }
            stringBuilder.append("];\n");
        } else {
            stringBuilder.append(string2);
            stringBuilder.append(" = [");
            for (n2 = 0; n2 < n4; ++n2) {
                for (n = 0; n < n3; ++n) {
                    stringBuilder.append(generatedCode.getBlockVariable(string2, n2, n));
                    if (n < n3 - 1) {
                        stringBuilder.append(",");
                        continue;
                    }
                    if (n4 <= 1) continue;
                    stringBuilder.append(";");
                }
            }
            stringBuilder.append("];\n");
            if (string3 != null) {
                stringBuilder.append(string3);
                stringBuilder.append(" = [");
                for (n2 = 0; n2 < n4; ++n2) {
                    for (n = 0; n < n3; ++n) {
                        stringBuilder.append(generatedCode.getBlockVariable(string3, n2, n));
                        if (n < n3 - 1) {
                            stringBuilder.append(",");
                            continue;
                        }
                        if (n4 <= 1) continue;
                        stringBuilder.append(";");
                    }
                }
                stringBuilder.append("];\n");
            }
        }
        generatedCode.addCode(stringBuilder.toString());
    }

    private static String generateXLSReadScriptSingleBlock(String string, String string2, String string3, String string4, String string5, String string6) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string4 != null) {
            stringBuilder.append(string4);
            stringBuilder.append(" = xlsread(");
        } else if (string6 == null) {
            stringBuilder.append("[~, ~, ");
            stringBuilder.append(string5);
            stringBuilder.append("] = xlsread(");
        } else {
            stringBuilder.append("[~, ~, ");
            stringBuilder.append(string5);
            stringBuilder.append(", ");
            stringBuilder.append(string6);
            stringBuilder.append("] = xlsread(");
        }
        stringBuilder.append("'");
        stringBuilder.append(string.replaceAll("'", "''"));
        stringBuilder.append("','");
        stringBuilder.append(string2);
        if (string3.isEmpty() && string6 == null) {
            stringBuilder.append("'");
        } else {
            stringBuilder.append("','");
            stringBuilder.append(string3);
            stringBuilder.append("'");
        }
        if (string6 != null) {
            stringBuilder.append(",'',@convertSpreadsheetExcelDates);\n");
        } else {
            stringBuilder.append(");\n");
        }
        return stringBuilder.toString();
    }

    private static void generateReplaceNaNsWithEmpty(GeneratedCode generatedCode, String string) {
        generatedCode.addCode(string);
        generatedCode.addCode("(cellfun(@(x) ~isempty(x) && isnumeric(x) && isnan(x),");
        generatedCode.addCode(string);
        generatedCode.addCode(")) = {''};\n");
    }

    static void generateMatlabFunctionHeader(GeneratedCode generatedCode, SpreadsheetImportUIState spreadsheetImportUIState, String string) {
        int n;
        String[][] stringArray = spreadsheetImportUIState.getRangeArray();
        String[] stringArray2 = spreadsheetImportUIState.isColumnVectors() ? spreadsheetImportUIState.getValidatedSelectedColumnNames() : spreadsheetImportUIState.getSelectedColumnNames();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "";
        if (spreadsheetImportUIState.isColumnVectors()) {
            StringBuilder stringBuilder2 = new StringBuilder();
            generatedCode.addCode("function ");
            if (stringArray2.length == 1) {
                stringBuilder2.append(String.format("%1$s = %2$s(workbookFile,sheetName,startRow,endRow)%n", stringArray2[0], string));
            } else {
                stringBuilder2.append(String.format("[%s", stringArray2[0]));
                for (n = 1; n < stringArray2.length; ++n) {
                    stringBuilder2.append(String.format(",%s", stringArray2[n]));
                }
                stringBuilder2.append(String.format("] = %s(workbookFile,sheetName,startRow,endRow)%n", string));
            }
            stringBuilder.append(String.format("%1$s = %2$s(", SpreadsheetCodeFactory.stringArrayToOutputArray(stringArray2), string));
            string2 = String.format("%s = ", SpreadsheetCodeFactory.stringArrayToOutputArray(stringArray2));
            generatedCode.addCode(stringBuilder2.toString());
        } else if (spreadsheetImportUIState.isDataset()) {
            generatedCode.addCode(String.format("function datasetout = %s(workbookFile,sheetName,startRow,endRow)%n", string));
            stringBuilder.append(String.format("%1$s = %2$s(", spreadsheetImportUIState.getGlobalVariableName(), string));
            string2 = "DATA = ";
        } else if (spreadsheetImportUIState.isTable()) {
            generatedCode.addCode(String.format("function tableout = %s(workbookFile,sheetName,startRow,endRow)%n", string));
            stringBuilder.append(String.format("%1$s = %2$s(", spreadsheetImportUIState.getGlobalVariableName(), string));
            string2 = "DATA = ";
        } else {
            generatedCode.addCode(String.format("function data = %s(workbookFile, sheetName, range)%n", string));
            stringBuilder.append(String.format("%1$s = %2$s(", spreadsheetImportUIState.getGlobalVariableName(), string));
            string2 = "DATA = ";
        }
        generatedCode.addCode("%");
        generatedCode.addCode(string.toUpperCase());
        generatedCode.addCode(" ");
        generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.h1line"));
        boolean bl = false;
        if (spreadsheetImportUIState.isColumnVectors() || spreadsheetImportUIState.isDataset() || spreadsheetImportUIState.isTable()) {
            if (stringArray.length > 1 || stringArray[0].length > 1) {
                bl = stringArray2.length >= 2;
            } else {
                boolean bl2 = bl = stringArray2.length >= 2 && spreadsheetImportUIState.getActiveColumnExclusionRuleCount() > 0;
            }
        }
        if (bl) {
            string2 = "";
        }
        if (stringArray != null && stringArray.length >= 1 && stringArray[0].length >= 1) {
            generatedCode.addCode("\n");
            generatedCode.addCode(String.format("%%   %1$s%2$s(FILE) ", string2, string.toUpperCase()));
            if (spreadsheetImportUIState.isColumnVectors()) {
                generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.functionhelpfilecolvectorsarg"));
            } else if (spreadsheetImportUIState.isDataset()) {
                generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.functionhelpfiledatasetarg"));
            } else if (spreadsheetImportUIState.isTable()) {
                generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.functionhelpfiletablearg"));
            } else if (spreadsheetImportUIState.isCellArray()) {
                generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.functionhelpfilecellarrayarg"));
            } else {
                generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.functionhelpfilearg"));
            }
            generatedCode.addCode("\n%\n");
            generatedCode.addCode(String.format("%%   %1$s%2$s(FILE,SHEET) ", string2, string.toUpperCase()));
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.functionhelpfilesheetarg"));
            generatedCode.addCode("\n%\n");
            if (spreadsheetImportUIState.isColumnVectors() || spreadsheetImportUIState.isDataset() || spreadsheetImportUIState.isTable()) {
                generatedCode.addCode(String.format("%%   %1$s%2$s(FILE,SHEET,STARTROW,ENDROW) ", string2, string.toUpperCase()));
                generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.functionhelpfilerowintarg"));
            } else {
                generatedCode.addCode(String.format("%%   DATA = %s(FILE,SHEET,RANGE) ", string.toUpperCase()));
                generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.functionhelpfilesheetrangearg"));
            }
            if (spreadsheetImportUIState.getActiveRules() != null && !spreadsheetImportUIState.getActiveRules().isEmpty()) {
                generatedCode.addCode("\n%\n");
                for (n = 0; n < spreadsheetImportUIState.getActiveRules().size(); ++n) {
                    if (n % 2 == 0) {
                        generatedCode.addCode("%\t");
                    } else {
                        generatedCode.addCode("%   ");
                    }
                    generatedCode.addCode(spreadsheetImportUIState.getActiveRules().get(n).getSummaryComment());
                    generatedCode.addCode("\n");
                }
            }
            generatedCode.addCode("%\n% ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.example"));
            generatedCode.addCode("\r");
            if (!bl) {
                generatedCode.addCode(String.format("%%   %s'", stringBuilder.toString()));
            } else {
                generatedCode.addCode(String.format("%%   %s('", string));
            }
            n = spreadsheetImportUIState.getFile().getPath().lastIndexOf(File.separator);
            if (n >= 0) {
                generatedCode.addCode(spreadsheetImportUIState.getFile().getPath().substring(n + 1).replaceAll("'", "''"));
            } else {
                generatedCode.addCode(spreadsheetImportUIState.getFile().getPath().replaceAll("'", "''"));
            }
            generatedCode.addCode("','");
            generatedCode.addCode(spreadsheetImportUIState.getSheetName());
            generatedCode.addCode("',");
            if (spreadsheetImportUIState.isColumnVectors() || spreadsheetImportUIState.isDataset() || spreadsheetImportUIState.isTable()) {
                generatedCode.addCode(SpreadsheetCodeFactory.getStartRowString(spreadsheetImportUIState.getSelectedRowIntervals()));
                generatedCode.addCode(",");
                generatedCode.addCode(SpreadsheetCodeFactory.getEndRowString(spreadsheetImportUIState.getSelectedRowIntervals()));
            } else {
                generatedCode.addCode(String.format("'%s'", spreadsheetImportUIState.getRangeArray()[0][0]));
            }
            generatedCode.addCode(");\n");
            generatedCode.addCode("%\n%   ");
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.seealso"));
            generatedCode.addCode("\n");
            generatedCode.addCode(SpreadsheetCodeFactory.getTimeStampComment());
            generatedCode.addCode("\n");
        }
    }

    static void generateMatlabFunctionInputHandler(GeneratedCode generatedCode, SpreadsheetImportUIState spreadsheetImportUIState) {
        generatedCode.addCode("%% ");
        generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.inputhandling"));
        generatedCode.addCode("\n\n");
        generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.readfirstsheet"));
        generatedCode.addCode("\nif nargin == 1 || isempty(sheetName)\nsheetName = 1;\nend\n\n");
        if (spreadsheetImportUIState.isColumnVectors() || spreadsheetImportUIState.isDataset() || spreadsheetImportUIState.isTable()) {
            generatedCode.addCode(String.format("%% %s%n", ImportToolUtils.getResourceString("codeGen.initrowintervals")));
            generatedCode.addCode("if nargin <= 3\n");
            generatedCode.addCode(String.format("startRow = %s;%n", SpreadsheetCodeFactory.getStartRowString(spreadsheetImportUIState.getSelectedRowIntervals())));
            generatedCode.addCode(String.format("endRow = %s;%n", SpreadsheetCodeFactory.getEndRowString(spreadsheetImportUIState.getSelectedRowIntervals())));
            generatedCode.addCode("end\n\n");
        } else {
            generatedCode.addCode(ImportToolUtils.getResourceString("codeGen.readalldata"));
            generatedCode.addCode("\nif nargin <= 2 || isempty(range)\nrange = '';\nend\n\n");
        }
    }

    private static List<String> getRangeFormatStrings(List<int[]> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int[] nArray : list) {
            String string = ImportToolUtils.intToColumnString(nArray[0] + 1);
            String string2 = ImportToolUtils.intToColumnString(nArray[1] + 1);
            arrayList.add(String.format("'%1$s%%d:%2$s%%d'", string, string2));
        }
        return arrayList;
    }

    private static String getxlsreadDataArrayForFunc(List<int[]> list, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list2 = SpreadsheetCodeFactory.getRangeFormatStrings(list);
        if (list2.size() == 1) {
            stringBuilder.append(String.format("xlsread(workbookFile, sheetName, sprintf(%1$s,startRow(%2$s),endRow(%2$s))%3$s);%n", list2.get(0), string, string2));
        } else {
            stringBuilder.append(String.format("[xlsread(workbookFile, sheetName, sprintf(%s,startRow(%2$s),endRow(%2$s))%3$s),...%n", list2.get(0), string, string2));
            for (int i = 1; i < list2.size() - 1; ++i) {
                stringBuilder.append(String.format("xlsread(workbookFile, sheetName, sprintf(%s,startRow(%2$s),endRow(%2$s))%3$s),...%n", list2.get(i), string, string2));
            }
            stringBuilder.append(String.format("xlsread(workbookFile, sheetName, sprintf(%s,startRow(%2$s),endRow(%2$s))%3$s)];%n", list2.get(list2.size() - 1), string, string2));
        }
        return stringBuilder.toString();
    }

    private static void generateColumnVariableAllocation(String[] stringArray, SpreadsheetImportUIState spreadsheetImportUIState, GeneratedCode generatedCode, boolean bl) {
        if (stringArray.length == 1 && stringArray[0].equals(generatedCode.getIntermediateImportDataMatrix()) && SpreadsheetCodeFactory.getSelectedNumericColumnVectorPositions(spreadsheetImportUIState).size() == 1) {
            generatedCode.addOutputVariableName(stringArray[0]);
            return;
        }
        boolean bl2 = spreadsheetImportUIState.getActiveColumnExclusionRuleCount() > 0;
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("codeGen.allocheading")));
        List<Integer> list = SpreadsheetCodeFactory.getSelectedDatetimeColumnVectorPositions(spreadsheetImportUIState);
        if (bl2) {
            generatedCode.addNewVariableName("columnIndices");
            generatedCode.addCode(String.format("columnIndices = cumsum(~%s);%n", generatedCode.getColumnExclusionIndex()));
            if (!list.isEmpty()) {
                generatedCode.addNewVariableName("datetimeColumnIndices");
                generatedCode.addCode(String.format("datetimeColumnIndices = cumsum(~%s);%n", generatedCode.getDatetimeColumnExclusionIndex()));
            }
        }
        List<Integer>[] listArray = SpreadsheetCodeFactory.getSpreadsheetColumnTargetLists(spreadsheetImportUIState);
        List<Integer> list2 = listArray[0];
        List<Integer> list3 = listArray[1];
        List<Integer> list4 = listArray[2];
        List<String> list5 = SpreadsheetCodeFactory.getSpreadsheetColumnDateFormats(spreadsheetImportUIState);
        boolean bl3 = true;
        StringBuilder stringBuilder = new StringBuilder();
        int n = CommentWrappingPreferences.getMaximumCommentWidth();
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl2) {
                if (list2.get(i) >= 0) {
                    generatedCode.addCode(String.format("if ~%1$s(%2$s)%n", generatedCode.getColumnExclusionIndex(), Integer.toString(list2.get(i) + 1)));
                } else if (list4.get(i) >= 0) {
                    generatedCode.addCode(String.format("if ~%1$s(%2$s)%n", generatedCode.getDatetimeColumnExclusionIndex(), Integer.toString(list4.get(i) + 1)));
                }
            }
            if (!bl && bl3 && list4.get(i) >= 0) {
                generatedCode.addCode("dates(~cellfun(@(x) isnumeric(x) || islogical(x), dates)) = {NaN};\n");
                bl3 = false;
            }
            generatedCode.addOutputVariableName(stringArray[i]);
            generatedCode.addCode(String.format("%s = ", stringArray[i]));
            if (list2.get(i) >= 0) {
                generatedCode.addCode(generatedCode.getIntermediateImportDataMatrix());
                generatedCode.addCode("(:,");
                if (bl2) {
                    generatedCode.addNewVariableName("columnIndices");
                    generatedCode.addCode(String.format("columnIndices(%s)", Integer.toString(list2.get(i) + 1)));
                } else {
                    generatedCode.addCode(Integer.toString(list2.get(i) + 1));
                }
            } else if (list3.get(i) >= 0) {
                generatedCode.addCode(String.format("%1$s(:,%2$s", generatedCode.getCellVectors(), Integer.toString(list3.get(i) + 1)));
            } else if (list4.get(i) >= 0) {
                if (bl2) {
                    if (i < list5.size() && !list5.get(i).isEmpty()) {
                        generatedCode.addCode(String.format("datetime([%1$s{:,datetimeColumnIndices(%2$s)}].', 'ConvertFrom', 'Excel', 'Format', '%3$s'", generatedCode.getDateArray(), Integer.toString(list4.get(i) + 1), list5.get(i)));
                    } else {
                        generatedCode.addCode(String.format("datetime([%1$s{:,datetimeColumnIndices(%2$s)}].', 'ConvertFrom', 'Excel'", generatedCode.getDateArray(), Integer.toString(list4.get(i) + 1)));
                    }
                } else if (i < list5.size() && !list5.get(i).isEmpty()) {
                    generatedCode.addCode(String.format("datetime([%1$s{:,%2$s}].', 'ConvertFrom', 'Excel', 'Format', '%3$s'", generatedCode.getDateArray(), Integer.toString(list4.get(i) + 1), list5.get(i)));
                } else {
                    generatedCode.addCode(String.format("datetime([%1$s{:,%2$s}].', 'ConvertFrom', 'Excel'", generatedCode.getDateArray(), Integer.toString(list4.get(i) + 1)));
                }
                stringBuilder.append(SpreadsheetCodeFactory.getDatenumFormattedComment(stringArray[i], n));
            }
            generatedCode.addCode(");\n");
            if (!bl2 || list2.get(i) < 0 && list4.get(i) < 0) continue;
            if (!bl) {
                generatedCode.addCode(String.format("else%n%s = [];%nend%n", stringArray[i]));
                continue;
            }
            generatedCode.addCode("end\n");
        }
        generatedCode.addCode("\n");
        if (stringBuilder.length() != 0) {
            SpreadsheetCodeFactory.addDatenumCommentToGeneratedCode(generatedCode, stringBuilder);
        }
    }

    private static void generateDatasetVariableAllocation(String string, String[] stringArray, SpreadsheetImportUIState spreadsheetImportUIState, GeneratedCode generatedCode, boolean bl) {
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("codeGen.createdataset")));
        SpreadsheetCodeFactory.generateObjectVariableAllocation("dataset", string, stringArray, spreadsheetImportUIState, generatedCode, bl);
    }

    private static void generateTableVariableAllocation(String string, String[] stringArray, SpreadsheetImportUIState spreadsheetImportUIState, GeneratedCode generatedCode, boolean bl) {
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("codeGen.createtable")));
        SpreadsheetCodeFactory.generateObjectVariableAllocation("table", string, stringArray, spreadsheetImportUIState, generatedCode, bl);
    }

    private static void generateObjectVariableAllocation(String string, String string2, String[] stringArray, SpreadsheetImportUIState spreadsheetImportUIState, GeneratedCode generatedCode, boolean bl) {
        generatedCode.addOutputVariableName(string2);
        generatedCode.addCode(String.format("%s = %s;%n%n", string2, string));
        boolean bl2 = spreadsheetImportUIState.getActiveColumnExclusionRuleCount() > 0;
        generatedCode.addCode(String.format("%%%% %s%n", ImportToolUtils.getResourceString("codeGen.allocheading")));
        List<Integer> list = SpreadsheetCodeFactory.getSelectedDatetimeColumnVectorPositions(spreadsheetImportUIState);
        if (bl2) {
            generatedCode.addNewVariableName("columnIndices");
            generatedCode.addCode(String.format("columnIndices = cumsum(~%s);%n", generatedCode.getColumnExclusionIndex()));
            if (!list.isEmpty()) {
                generatedCode.addNewVariableName("datetimeColumnIndices");
                generatedCode.addCode(String.format("datetimeColumnIndices = cumsum(~%s);%n", generatedCode.getDatetimeColumnExclusionIndex()));
            }
        }
        List<String> list2 = SpreadsheetCodeFactory.getSpreadsheetColumnDateFormats(spreadsheetImportUIState);
        List<Integer>[] listArray = SpreadsheetCodeFactory.getSpreadsheetColumnTargetLists(spreadsheetImportUIState);
        List<Integer> list3 = listArray[0];
        List<Integer> list4 = listArray[1];
        List<Integer> list5 = listArray[2];
        boolean bl3 = true;
        StringBuilder stringBuilder = new StringBuilder();
        int n = CommentWrappingPreferences.getMaximumCommentWidth();
        for (int i = 0; i < stringArray.length; ++i) {
            if (bl2) {
                if (list3.get(i) >= 0) {
                    generatedCode.addCode(String.format("if ~%1$s(%2$s)%n", generatedCode.getColumnExclusionIndex(), Integer.toString(list3.get(i) + 1)));
                } else if (list5.get(i) >= 0) {
                    generatedCode.addCode(String.format("if ~%1$s(%2$s)%n", generatedCode.getDatetimeColumnExclusionIndex(), Integer.toString(list5.get(i) + 1)));
                }
            }
            if (!bl && bl3 && list5.get(i) >= 0) {
                generatedCode.addCode("dates(~cellfun(@(x) isnumeric(x) || islogical(x), dates)) = {NaN};\n");
                bl3 = false;
            }
            generatedCode.addCode(String.format("%1$s.%2$s = ", string2, stringArray[i]));
            if (list3.get(i) >= 0) {
                generatedCode.addCode(generatedCode.getIntermediateImportDataMatrix());
                generatedCode.addCode("(:,");
                if (bl2) {
                    generatedCode.addNewVariableName("columnIndices");
                    generatedCode.addCode(String.format("columnIndices(%s)", Integer.toString(list3.get(i) + 1)));
                } else {
                    generatedCode.addCode(Integer.toString(list3.get(i) + 1));
                }
            } else if (list4.get(i) >= 0) {
                generatedCode.addCode(String.format("%1$s(:,%2$s", generatedCode.getCellVectors(), Integer.toString(list4.get(i) + 1)));
            } else if (list5.get(i) >= 0) {
                if (bl2) {
                    if (i < list2.size() && !list2.get(i).isEmpty()) {
                        generatedCode.addCode(String.format("datetime([%1$s{:,datetimeColumnIndices(%2$s)}].', 'ConvertFrom', 'Excel', 'Format', '%3$s'", generatedCode.getDateArray(), Integer.toString(list5.get(i) + 1), list2.get(i)));
                    } else {
                        generatedCode.addCode(String.format("datetime([%1$s{:,datetimeColumnIndices(%2$s)}].', 'ConvertFrom', 'Excel'", generatedCode.getDateArray(), Integer.toString(list5.get(i) + 1)));
                    }
                } else if (i < list2.size() && !list2.get(i).isEmpty()) {
                    generatedCode.addCode(String.format("datetime([%1$s{:,%2$s}].', 'ConvertFrom', 'Excel', 'Format', '%3$s'", generatedCode.getDateArray(), Integer.toString(list5.get(i) + 1), list2.get(i)));
                } else {
                    generatedCode.addCode(String.format("datetime([%1$s{:,%2$s}].', 'ConvertFrom', 'Excel'", generatedCode.getDateArray(), Integer.toString(list5.get(i) + 1)));
                }
                stringBuilder.append(SpreadsheetCodeFactory.getDatenumFormattedComment(string2 + "." + stringArray[i], n));
            }
            generatedCode.addCode(");\n");
            if (!bl2 || list3.get(i) < 0 && list5.get(i) < 0) continue;
            generatedCode.addCode("end\n");
        }
        generatedCode.addCode("\n");
        if (stringBuilder.length() != 0) {
            SpreadsheetCodeFactory.addDatenumCommentToGeneratedCode(generatedCode, stringBuilder);
        }
    }

    private static List<String> getSpreadsheetColumnDateFormats(SpreadsheetImportUIState spreadsheetImportUIState) {
        List<String> list = spreadsheetImportUIState.getDateFormats();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int[] nArray : spreadsheetImportUIState.getSelectedColumnIntervals()) {
            for (int i = nArray[0]; i <= nArray[1]; ++i) {
                if (i < list.size() && list.get(i) != null && !list.get(i).isEmpty()) {
                    arrayList.add(list.get(i));
                    continue;
                }
                arrayList.add("");
            }
        }
        return arrayList;
    }
}

