/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mlwidgets.importtool.AbstractFileTableModel;
import com.mathworks.mlwidgets.importtool.DateParsingRule;
import com.mathworks.mlwidgets.importtool.FixedWidthPane;
import com.mathworks.mlwidgets.importtool.FixedWidthUndoableEdit;
import com.mathworks.mlwidgets.importtool.GeneratedCode;
import com.mathworks.mlwidgets.importtool.ImportCellRenderer;
import com.mathworks.mlwidgets.importtool.ImportClient;
import com.mathworks.mlwidgets.importtool.ImportCodeFactory;
import com.mathworks.mlwidgets.importtool.ImportColumnModel;
import com.mathworks.mlwidgets.importtool.ImportDataSource;
import com.mathworks.mlwidgets.importtool.ImportTable;
import com.mathworks.mlwidgets.importtool.ImportToolFind;
import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mlwidgets.importtool.ImportToolstripTab;
import com.mathworks.mlwidgets.importtool.IntervalSelectionModel;
import com.mathworks.mlwidgets.importtool.NumericParsingRule;
import com.mathworks.mlwidgets.importtool.ParseRule;
import com.mathworks.mlwidgets.importtool.TextCellRenderer;
import com.mathworks.mlwidgets.importtool.TextCodeFactory;
import com.mathworks.mlwidgets.importtool.TextFileTableModel;
import com.mathworks.mlwidgets.importtool.TextHeaderMouseAdapter;
import com.mathworks.mlwidgets.importtool.TextImportUIState;
import com.mathworks.mlwidgets.importtool.TextTableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.TextscanTextParser;
import com.mathworks.mlwidgets.importtool.VariableHeaderRenderer;
import com.mathworks.mlwidgets.importtool.WorksheetRule;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.undo.MUndoManager;
import com.mathworks.services.binding.MatlabKeyBindings;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.spreadsheet.AbstractSpreadsheetTable;
import com.mathworks.widgets.spreadsheet.HeaderRenderer;
import com.mathworks.widgets.spreadsheet.IHeaderRenderer;
import com.mathworks.widgets.spreadsheet.IHeaderRendererProvider;
import com.mathworks.widgets.spreadsheet.UndoActionFactory;
import com.mathworks.widgets.text.mcode.MFoldType;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.CellEditor;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;

public class TextTable
extends ImportTable
implements IHeaderRendererProvider {
    private ImportTable.ZoomInAction fZoomInAction;
    private ImportTable.ZoomOutAction fZoomOutAction;
    private ImportTable.ClearAllSelectionAction fClearAllSelectionAction;
    private boolean fCleanedUp = false;
    private boolean fSetInitialSelection = false;
    private boolean fFixedWidth = false;
    private int[] fColumnCharacterCounts;
    private int fMaxFixedCharacters = -1;
    private AddColumnSplitterAction fAddSplitterAction;
    private MergeColumnsAction fMergeColumnsAction;
    private SplitColumnAction fSplitColumnAction;
    private JPopupMenu.Separator fAddSplitterSeparator = new JPopupMenu.Separator();
    private TableColumnModelListener fTableHeaderAdjustementListener;
    private int fCurrentlyExpandedColumn = -1;
    private FixedWidthTextTableFocusListener fFixedWidthTextTableFocusListener = new FixedWidthTextTableFocusListener();
    private ImportTable.VarNameUpdateWorker fVarNameUpdateWorker = null;
    private FixedWidthPane fParentGlassPane = null;
    private MJAbstractAction fUndoAction;
    private MJAbstractAction fRedoAction;
    private MUndoManager fUndoManager = new MUndoManager();
    private FixedWidthUndoableEdit fLastEdit;
    ImportToolFind fFindDialogObj;
    private int fFocusedRow;
    private int fFocusedCol;

    public TextTable(TableModel tableModel) {
        super(tableModel);
        this.setName("ImportTool.TextTable");
        this.initUndoManagement();
        this.fFocusedRow = this.getSelectionModel().getAnchorSelectionIndex();
        this.fFocusedCol = this.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
        TextHeaderMouseAdapter textHeaderMouseAdapter = new TextHeaderMouseAdapter(this.getTableHeader(), (TextTableHeaderRenderer)this.fHeaderRenderer);
        this.getTableHeader().addMouseListener(textHeaderMouseAdapter);
        this.getTableHeader().addMouseMotionListener(textHeaderMouseAdapter);
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                TextTable.access$002(TextTable.this, null);
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TextTable.this.focusedRowChangedListener();
            }
        });
        this.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                TextTable.this.focusedColumnChangedListener();
            }
        });
        this.fFindDialogObj = new ImportToolFind(this);
    }

    private void initUndoManagement() {
        this.fUndoAction = UndoActionFactory.getUndoAction((MUndoManager)this.fUndoManager);
        this.fRedoAction = UndoActionFactory.getRedoAction((MUndoManager)this.fUndoManager);
        if (Matlab.isMatlabAvailable()) {
            MatlabKeyBindings.getManager().clearKeyBinding((ExtendedAction)this.fUndoAction);
            MatlabKeyBindings.getManager().clearKeyBinding((ExtendedAction)this.fRedoAction);
            if (this.useDeprecatedKeybindingManager()) {
                this.doKeybindingSetup(this.fUndoAction, "undo");
                this.fUndoAction.setComponentName("Undo");
                this.doKeybindingSetup(this.fRedoAction, "redo");
                this.fRedoAction.setComponentName("Redo");
            } else {
                this.doDeprecatedKeybindingSetup(this.fUndoAction, 90, true);
                this.doDeprecatedKeybindingSetup(this.fRedoAction, 89, true);
            }
        }
        MJMenu mJMenu = new MJMenu();
        MJMenuItem mJMenuItem = new MJMenuItem((Action)this.fUndoAction);
        DTMenuMergeTag.UNDO.setTag((JMenuItem)mJMenuItem);
        mJMenu.add((JMenuItem)mJMenuItem);
        MJMenuItem mJMenuItem2 = new MJMenuItem((Action)this.fRedoAction);
        DTMenuMergeTag.REDO.setTag((JMenuItem)mJMenuItem2);
        mJMenu.add((JMenuItem)mJMenuItem2);
        DTMenuMergeTag.EDIT.setTag((JMenuItem)mJMenu);
    }

    public final Action getUndoAction() {
        return this.fUndoAction;
    }

    public final Action getRedoAction() {
        return this.fRedoAction;
    }

    List<Integer> getFixedWidthColumnPositions() {
        if (this.fFixedWidth) {
            if (this.fColumnCharacterCounts == null) {
                this.updateCharacterCounts();
            }
            int n = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this.fColumnCharacterCounts.length - 1; ++i) {
                arrayList.add(n += this.fColumnCharacterCounts[i]);
            }
            return arrayList;
        }
        return null;
    }

    void setFixedWidthColumnPositions(final List<Integer> list) {
        this.tryScreenBuffer();
        if (Matlab.isMatlabAvailable()) {
            MatlabWorker matlabWorker = new MatlabWorker(){

                public Object runOnMatlabThread() {
                    ((TextFileTableModel)TextTable.this.getModel()).setFixedWidthColumnPositions(list);
                    return null;
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    TextTable.this.rebuild();
                    TextTable.this.updateCharacterCounts();
                }
            };
            matlabWorker.start();
        } else {
            ((TextFileTableModel)this.getModel()).setFixedWidthColumnPositions(list);
            this.rebuild();
            this.updateCharacterCounts();
        }
    }

    public int getCharacterPositionForLocation(Point point) {
        if (this.fFixedWidth) {
            int n;
            int n2;
            if (this.fColumnCharacterCounts == null) {
                this.updateCharacterCounts();
            }
            Font font = ((TextCellRenderer)this.fCellRenderer).getRenderedFont();
            int n3 = this.columnAtPoint(point);
            int n4 = 0;
            for (n2 = 0; n2 < n3; ++n2) {
                n4 += this.fColumnCharacterCounts[n2];
            }
            n2 = ((TextCellRenderer)this.fCellRenderer).getFixedWidthCharacterWidth();
            int n5 = this.getIntercellSpacing().width;
            int n6 = this.getColumnPoint((int)n3).x;
            if (n6 < 0) {
                n6 = 0;
            }
            int n7 = (point.x - n6 - n5 + n2 / 2) / n2;
            if (n3 >= 0 && n3 < this.fColumnCharacterCounts.length && n7 >= this.fColumnCharacterCounts[n3]) {
                n7 = this.fColumnCharacterCounts[n3];
            }
            if ((n = n4 + n7) > this.fMaxFixedCharacters) {
                n = this.fMaxFixedCharacters;
            }
            return n;
        }
        return -1;
    }

    private void updateCharacterCounts() {
        this.fColumnCharacterCounts = ((TextFileTableModel)this.getWorksheetTableModel()).getCharacterCounts();
        if (this.fColumnCharacterCounts == null) {
            return;
        }
        int n = 0;
        for (int i = 0; i < this.fColumnCharacterCounts.length; ++i) {
            n += this.fColumnCharacterCounts[i];
        }
        this.fMaxFixedCharacters = n;
    }

    int getMaxFixedCharacters() {
        if (!this.fFixedWidth) {
            return -1;
        }
        if (this.fColumnCharacterCounts == null) {
            this.updateCharacterCounts();
        }
        return this.fMaxFixedCharacters;
    }

    int getTotalNumCharactersForColumn(int n) {
        if (!this.fFixedWidth) {
            return -1;
        }
        if (this.fColumnCharacterCounts == null) {
            this.updateCharacterCounts();
        }
        if (n >= this.fColumnCharacterCounts.length) {
            return this.getMaxFixedCharacters();
        }
        int n2 = 0;
        for (int i = 0; i <= n; ++i) {
            n2 += this.fColumnCharacterCounts[i];
        }
        return n2;
    }

    int getNumCharactersForColumn(int n) {
        if (!this.fFixedWidth) {
            return -1;
        }
        if (this.fColumnCharacterCounts == null) {
            this.updateCharacterCounts();
        }
        if (n >= this.fColumnCharacterCounts.length) {
            return this.getMaxFixedCharacters();
        }
        return this.fColumnCharacterCounts[n];
    }

    public int getCharacterPositionForLocationOnScreen(Point point) {
        Point point2 = new Point(point.x, point.y);
        SwingUtilities.convertPointFromScreen(point2, (Component)((Object)this));
        return this.getCharacterPositionForLocation(point2);
    }

    public Point getLocationForCharacterPosition(int n) {
        if (this.fFixedWidth) {
            if (this.fColumnCharacterCounts == null) {
                this.updateCharacterCounts();
            }
            Font font = ((TextCellRenderer)this.fCellRenderer).getRenderedFont();
            int n2 = 0;
            int n3 = 0;
            for (n3 = 0; n3 < this.fColumnCharacterCounts.length && n2 < n; n2 += this.fColumnCharacterCounts[n3], ++n3) {
            }
            if (n3 > 0) {
                --n3;
            }
            if (n2 > 0) {
                n2 -= this.fColumnCharacterCounts[n3];
            }
            int n4 = ((TextCellRenderer)this.fCellRenderer).getFixedWidthCharacterWidth();
            int n5 = this.getIntercellSpacing().width;
            int n6 = this.getColumnPoint((int)n3).x;
            if (n6 < 0) {
                n6 = 0;
            }
            int n7 = n4 * (n - n2);
            int n8 = n6 + n5 + n7;
            return new Point(n8, 0);
        }
        return null;
    }

    public Point getLocationOnScreenForCharacterPosition(int n) {
        Point point = this.getLocationForCharacterPosition(n);
        Point point2 = this.getTableHeader().getLocationOnScreen();
        return new Point(point2.x + point.x, point2.y + point.y);
    }

    public Rectangle getRulerScreenBounds(int n) {
        Rectangle rectangle = ((TextTableHeaderRenderer)((Object)this.getTableHeader().getDefaultRenderer())).getRulerDropDownBounds(n, this.getColumnModel().getColumn(n).getHeaderValue());
        Point point = new Point(rectangle.x, rectangle.y);
        SwingUtilities.convertPointToScreen(point, this.getTableHeader());
        rectangle.x = point.x;
        rectangle.y = point.y;
        return rectangle;
    }

    public boolean characterPositionSplitExists(int n) {
        if (this.fColumnCharacterCounts == null) {
            this.updateCharacterCounts();
        }
        if (n <= 0 || n >= this.getMaxFixedCharacters()) {
            return false;
        }
        int n2 = 0;
        for (int i = 0; i < this.fColumnCharacterCounts.length; ++i) {
            if ((n2 += this.fColumnCharacterCounts[i]) != n) continue;
            return true;
        }
        return false;
    }

    public int getColumnForCharacterPosition(int n) {
        if (this.fFixedWidth) {
            if (this.fColumnCharacterCounts == null) {
                this.updateCharacterCounts();
            }
            if (n <= 0 || n > this.fMaxFixedCharacters) {
                return -1;
            }
            int n2 = 0;
            int n3 = 0;
            for (n3 = 0; n3 < this.fColumnCharacterCounts.length && n2 < n; n2 += this.fColumnCharacterCounts[n3], ++n3) {
            }
            if (n3 > 0) {
                --n3;
            }
            return n3;
        }
        return -1;
    }

    public void addColumnSplitter(final int n) {
        if (this.characterPositionSplitExists(n)) {
            return;
        }
        this.setupSelectionAdjustmentListener(n, false);
        List<Integer> list = this.createAddCharacterPositions(n, this.getFixedWidthColumnPositions());
        this.fLastEdit = this.enableUndo(list, "Add Splitter");
        if (n != 0 && n != this.getMaxFixedCharacters()) {
            if (Matlab.isMatlabAvailable()) {
                MatlabWorker matlabWorker = new MatlabWorker(){

                    public Object runOnMatlabThread() {
                        ((TextFileTableModel)TextTable.this.getModel()).addColumnSplitter(n);
                        return null;
                    }

                    public void runOnAWTEventDispatchThread(Object object) {
                        TextTable.this.rebuild();
                        TextTable.this.updateCharacterCounts();
                    }
                };
                matlabWorker.start();
            } else {
                ((TextFileTableModel)this.getModel()).addColumnSplitter(n);
                this.rebuild();
                this.updateCharacterCounts();
            }
        }
    }

    private FixedWidthUndoableEdit enableUndo(List<Integer> list, String string) {
        List<Integer> list2 = this.getFixedWidthColumnPositions();
        FixedWidthUndoableEdit fixedWidthUndoableEdit = new FixedWidthUndoableEdit(this, list2, list, string);
        UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, fixedWidthUndoableEdit);
        this.fUndoManager.undoableEditHappened(undoableEditEvent);
        this.fUndoAction.setEnabled(true);
        return fixedWidthUndoableEdit;
    }

    private List<Integer> createAddCharacterPositions(int n, List<Integer> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = false;
        for (Integer n2 : list) {
            if (n2 > n && !bl) {
                arrayList.add(n);
                bl = true;
            }
            arrayList.add(n2);
        }
        return arrayList;
    }

    private List<Integer> createDeleteCharacterPositions(int n, List<Integer> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Integer n2 : list) {
            if (n2 == n) continue;
            arrayList.add(n2);
        }
        return arrayList;
    }

    private void setupSelectionAdjustmentListener(final int n, final boolean bl) {
        if (this.fFixedWidth) {
            final int[] nArray = this.getSelectedColumns();
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (TextTable.this.getSelectedColumnCount() != 0 && !listSelectionEvent.getValueIsAdjusting() || nArray.length == 0) {
                        TextTable.this.getSelectionModel().removeListSelectionListener(this);
                        TextTable.this.adjustSelection(nArray, n, bl);
                        if (TextTable.this.fLastEdit != null) {
                            TextTable.this.fLastEdit.setNewSelectionRange(TextTable.this.getSelectedRange());
                        }
                    }
                }
            });
        }
    }

    private void focusedRowChangedListener() {
        this.setFocusedRow(this.getSelectionModel().getAnchorSelectionIndex());
    }

    private void focusedColumnChangedListener() {
        this.setFocusedCol(this.getColumnModel().getSelectionModel().getAnchorSelectionIndex());
    }

    private void adjustSelection(int[] nArray, int n, boolean bl) {
        int n2;
        int n3 = this.getColumnForCharacterPosition(n) + 1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            arrayList.add(nArray[n2]);
        }
        if (!bl) {
            for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                int n4 = (Integer)arrayList.get(n2);
                if (n4 < n3 || n4 + 1 >= this.getColumnCount()) continue;
                this.removeColumnSelectionInterval(n4, n4);
                this.addColumnSelectionInterval(n4 + 1, n4 + 1);
            }
            if (arrayList.contains(n3 - 1)) {
                this.addColumnSelectionInterval(n3, n3);
            }
        } else {
            for (n2 = 0; n2 <= this.getColumnCount(); ++n2) {
                if (n2 < n3) continue;
                if (n2 < this.getColumnCount()) {
                    this.removeColumnSelectionInterval(n2, n2);
                }
                if (!arrayList.contains(n2)) continue;
                this.addColumnSelectionInterval(n2 - 1, n2 - 1);
            }
        }
    }

    public void deleteColumnSplitter(int n) {
        this.deleteColumnSplitter(n, true);
    }

    public void deleteColumnSplitter(final int n, boolean bl) {
        Object object;
        if (!this.characterPositionSplitExists(n)) {
            return;
        }
        if (bl) {
            this.setupSelectionAdjustmentListener(n, true);
            object = this.createDeleteCharacterPositions(n, this.getFixedWidthColumnPositions());
            this.fLastEdit = this.enableUndo((List<Integer>)object, "Delete Splitter");
        }
        if (Matlab.isMatlabAvailable()) {
            object = new MatlabWorker(){

                public Object runOnMatlabThread() {
                    ((TextFileTableModel)TextTable.this.getModel()).deleteColumnSplitter(n);
                    return null;
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    TextTable.this.rebuild();
                    TextTable.this.updateCharacterCounts();
                }
            };
            object.start();
        } else {
            ((TextFileTableModel)this.getModel()).deleteColumnSplitter(n);
            this.rebuild();
            this.updateCharacterCounts();
        }
    }

    public void moveColumnSplitter(final int n, final int n2) {
        if (this.characterPositionSplitExists(n2)) {
            this.deleteColumnSplitter(n);
            return;
        }
        if (n2 == 0 || n2 == this.getMaxFixedCharacters()) {
            this.deleteColumnSplitter(n);
            return;
        }
        if (n == 0 || n == this.getMaxFixedCharacters() || !this.characterPositionSplitExists(n)) {
            this.addColumnSplitter(n2);
            return;
        }
        List<Integer> list = this.createDeleteCharacterPositions(n, this.getFixedWidthColumnPositions());
        list = this.createDeleteCharacterPositions(n2, list);
        this.fLastEdit = this.enableUndo(list, "Move Splitter");
        if (Matlab.isMatlabAvailable()) {
            MatlabWorker matlabWorker = new MatlabWorker(){

                public Object runOnMatlabThread() {
                    ((TextFileTableModel)TextTable.this.getModel()).moveColumnSplitter(n, n2);
                    return null;
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    TextTable.this.rebuild();
                    TextTable.this.updateCharacterCounts();
                }
            };
            matlabWorker.start();
        } else {
            ((TextFileTableModel)this.getModel()).moveColumnSplitter(n, n2);
            this.rebuild();
            this.updateCharacterCounts();
        }
    }

    public void splitColumnAtPoint(Point point) {
        if (point == null) {
            return;
        }
        int n = this.columnAtPoint(point);
        this.splitColumn(n);
    }

    public void splitColumn(int n) {
        if (this.fColumnCharacterCounts == null) {
            this.updateCharacterCounts();
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.fColumnCharacterCounts[i];
        }
        this.tryScreenBuffer();
        this.addColumnSplitter(n2 += this.fColumnCharacterCounts[n] / 2);
    }

    public FixedWidthPane getParentGlassPane() {
        return this.fParentGlassPane;
    }

    public void setParentGlassPane(FixedWidthPane fixedWidthPane) {
        this.fParentGlassPane = fixedWidthPane;
    }

    private void tryScreenBuffer() {
        if (this.fParentGlassPane != null) {
            this.fParentGlassPane.bufferScreenUntilTableUpdate();
        }
    }

    public void mergeSelectedFixedWidthColumns() {
        if (!this.isFixedWidth() || !this.isContiguousColumnSelection()) {
            return;
        }
        if (this.fColumnCharacterCounts == null) {
            this.updateCharacterCounts();
        }
        int[] nArray = this.getSelectedColumns();
        this.mergeFixedWidthColumns(nArray);
    }

    public void mergeFixedWidthColumns(int[] nArray) {
        int n;
        int n2;
        if (!this.isFixedWidth() || !this.isContiguousRange(nArray)) {
            return;
        }
        final ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = this.getColumnCount();
        for (int i = 1; i < nArray.length; ++i) {
            n2 = 0;
            for (n = 0; n < nArray[i]; ++n) {
                n2 += this.fColumnCharacterCounts[n];
            }
            arrayList.add(n2);
        }
        this.tryScreenBuffer();
        final int[] nArray2 = this.getSelectedColumns();
        n2 = this.getColumnCount();
        n = nArray[0];
        final int n4 = nArray[nArray.length - 1];
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (TextTable.this.getSelectedColumns().length != 0 && !listSelectionEvent.getValueIsAdjusting() && TextTable.this.getColumnCount() == n2 - arrayList.size()) {
                    TextTable.this.getSelectionModel().removeListSelectionListener(this);
                    TextTable.this.restoreMergeSelection(n, nArray2, n4, arrayList);
                    if (TextTable.this.fLastEdit != null) {
                        TextTable.this.fLastEdit.setNewSelectionRange(TextTable.this.getSelectedRange());
                    }
                }
            }
        });
        List<Integer> list = this.getFixedWidthColumnPositions();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n5 = (Integer)iterator.next();
            list = this.createDeleteCharacterPositions(n5, list);
        }
        this.fLastEdit = this.enableUndo(list, "Merge Splitter");
        this.setFixedWidthColumnPositions(list);
    }

    private void restoreMergeSelection(int n, int[] nArray, int n2, ArrayList<Integer> arrayList) {
        this.getColumnModel().getSelectionModel().clearSelection();
        this.addColumnSelectionInterval(n, n);
    }

    @Override
    public void setTargetType(ImportClient.TargetType targetType) {
        super.setTargetType(targetType);
        if (this.fHeaderRenderer instanceof TextTableHeaderRenderer) {
            this.getTableHeader().revalidate();
            this.getTableHeader().repaint();
        }
        if (this.getModel() instanceof TextFileTableModel) {
            ((TextFileTableModel)this.getModel()).setTargetType(targetType);
            this.updateColumnHeader();
        }
        this.updateWarningIcon();
        this.getVariableNamePanel().updateBorders();
        this.getVariableNamePanel().repaint();
    }

    @Override
    public void updateColumnHeader() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof TextFileTableModel && tableModel.getColumnCount() > 0) {
            Object object;
            Object object2;
            int n;
            List<ParseRule> list = ((TextFileTableModel)tableModel).getColumnParseRules();
            if (list == null) {
                list = new ArrayList<ParseRule>();
            }
            List<DateParsingRule[]> list2 = ((TextFileTableModel)tableModel).getDateParsingRules();
            int n2 = 0;
            if (this.getColumnCount() < TextscanTextParser.LARGECOLUMNTHRESHOLD) {
                for (n = 0; n < this.getColumnCount(); ++n) {
                    object2 = this.getNonConflictingColumnVariableNamesArray();
                    if (object2 == null) {
                        return;
                    }
                    String string = n < ((String[])object2).length ? object2[n] : "VarName" + Integer.toString(n + 1);
                    object = null;
                    if (n < list.size()) {
                        object = list.get(n);
                    }
                    DateParsingRule[] dateParsingRuleArray = null;
                    if (list2 != null && n < list2.size()) {
                        dateParsingRuleArray = list2.get(n);
                    }
                    this.getColumnModel().getColumn(n).setHeaderValue(new TextTableHeaderRenderer.TextImportDataHeader(n, string, (ParseRule)object, dateParsingRuleArray));
                    int n3 = 0;
                    if (this.fHeaderRenderer != null) {
                        ((TextTableHeaderRenderer)this.fHeaderRenderer).getPreferredHeaderWidth(n, this.getColumnModel().getColumn(n).getHeaderValue());
                    }
                    if (n2 >= n3) continue;
                    n2 = n3;
                }
            }
            if (this.getColumnCount() == 1) {
                int n4;
                n = this.getRowCount() < 10 ? this.getRowCount() : 10;
                for (n4 = 0; n4 < n; ++n4) {
                    object2 = this.getCellRenderer(n4, 0);
                    object = object2.getTableCellRendererComponent((JTable)((Object)this), this.getValueAt(n4, 0), false, false, n4, 0);
                    if (object == null || ((Component)object).getPreferredSize().width <= n2) continue;
                    n2 = ((Component)object).getPreferredSize().width;
                }
                if (!this.fFixedWidth) {
                    this.suspendColumnAdjustmentListener();
                    for (n4 = 0; n4 < this.getColumnCount(); ++n4) {
                        if (this.getColumnModel().getColumn(n4).getPreferredWidth() >= n2 || this.fFixedWidth) continue;
                        this.getColumnModel().getColumn(n4).setPreferredWidth(n2);
                    }
                    this.restoreColumnAdjustmentListener();
                }
            }
            this.updateColumnWidths();
        }
    }

    public String getColumnDataTypeName(int n) {
        ParseRule parseRule = ((TextTableHeaderRenderer.TextImportDataHeader)this.getColumnModel().getColumn(n).getHeaderValue()).getParseRule();
        if (parseRule == null) {
            return ImportToolUtils.getResourceString("datatypes.text");
        }
        return parseRule.getParseTargetType();
    }

    void addColumnAdjustmentListener(TableColumnModelListener tableColumnModelListener) {
        this.getColumnModel().removeColumnModelListener(this.fTableHeaderAdjustementListener);
        this.fTableHeaderAdjustementListener = tableColumnModelListener;
        this.getColumnModel().addColumnModelListener(this.fTableHeaderAdjustementListener);
    }

    void removeColumnAdjustmentListener(TableColumnModelListener tableColumnModelListener) {
        this.getColumnModel().removeColumnModelListener(this.fTableHeaderAdjustementListener);
    }

    void suspendColumnAdjustmentListener() {
        if (this.fTableHeaderAdjustementListener == null) {
            return;
        }
        this.getColumnModel().removeColumnModelListener(this.fTableHeaderAdjustementListener);
    }

    void restoreColumnAdjustmentListener() {
        if (this.fTableHeaderAdjustementListener == null) {
            return;
        }
        this.fTableHeaderAdjustementListener.columnAdded(new TableColumnModelEvent(this.getColumnModel(), 0, this.getColumnCount()));
        this.getColumnModel().addColumnModelListener(this.fTableHeaderAdjustementListener);
    }

    void setParseRules(ParseRule parseRule, int[] nArray) {
        Object object;
        for (int n : nArray) {
            Object object2 = this.getColumnModel().getColumn(n).getHeaderValue();
            if (object2 instanceof VariableHeaderRenderer.ImportDataHeader) continue;
            return;
        }
        int n = 0;
        for (int n2 : nArray) {
            TextTableHeaderRenderer.TextImportDataHeader textImportDataHeader = (TextTableHeaderRenderer.TextImportDataHeader)this.getColumnModel().getColumn(n2).getHeaderValue();
            if ((textImportDataHeader.getParseRule() != null || parseRule != null) && (textImportDataHeader.getParseRule() == null || !textImportDataHeader.getParseRule().equals(parseRule))) continue;
            ++n;
        }
        Object object3 = this.getWorksheetTableModel();
        List<ParseRule> list = ((TextFileTableModel)object3).getColumnParseRules();
        if (n == nArray.length || !(object3 instanceof TextFileTableModel) || list == null) {
            return;
        }
        for (int n3 : nArray) {
            TextTableHeaderRenderer.TextImportDataHeader textImportDataHeader = (TextTableHeaderRenderer.TextImportDataHeader)this.getColumnModel().getColumn(n3).getHeaderValue();
            textImportDataHeader.setParseRule(parseRule);
            this.getColumnModel().getColumn(n3).setHeaderValue(textImportDataHeader);
        }
        if (nArray.length == 1) {
            int n3;
            object = this.getVisibleRect();
            int n4 = this.rowAtPoint(new Point(((Rectangle)object).x, ((Rectangle)object).y));
            int n5 = this.rowAtPoint(new Point(((Rectangle)object).x, ((Rectangle)object).y + ((Rectangle)object).height));
            if (n5 < 0) {
                n5 = this.getRowCount() - 1;
            }
            n3 = this.columnAtPoint(new Point(((Rectangle)object).x, ((Rectangle)object).y));
            int n6 = this.columnAtPoint(new Point(((Rectangle)object).x + ((Rectangle)object).width, ((Rectangle)object).y));
            if (n6 < 0) {
                n6 = this.getColumnCount() - 1;
            }
            Rectangle rectangle = new Rectangle(n3, n4, n6 - n3 + 1, n5 - n4 + 1);
            ((TextFileTableModel)object3).reset(nArray[0], parseRule, rectangle);
        } else {
            object = ((TextFileTableModel)object3).getColumnParseRules();
            for (int n7 : nArray) {
                if (parseRule != null) {
                    object.set(n7, (ParseRule)parseRule.clone());
                    continue;
                }
                object.set(n7, parseRule);
            }
            ((TextFileTableModel)object3).setColumnParseRules((List<ParseRule>)object);
            ((AbstractFileTableModel)object3).reset();
        }
    }

    public void setHeaderRenderer(int n) {
        if (this.fHeaderRenderer == null) {
            this.fHeaderRenderer = this.createColumnHeaderRenderer((JTable)((Object)this));
        }
        this.tableHeader.setDefaultRenderer((TableCellRenderer)this.fHeaderRenderer);
    }

    public TableColumnModel createDefaultColumnModel() {
        if (this.getModel() instanceof TextFileTableModel) {
            List<DateParsingRule[]> list = ((TextFileTableModel)this.getModel()).getDateParsingRules();
            DateParsingRule[] dateParsingRuleArray = null;
            if (list != null) {
                dateParsingRuleArray = list.get(0);
            }
            if (this.getColumnModel() instanceof ImportColumnModel) {
                ((ImportColumnModel)((Object)this.getColumnModel())).init(this.getModel().getColumnCount(), new NumericParsingRule(), dateParsingRuleArray);
                return this.getColumnModel();
            }
            return new ImportColumnModel(this.getModel().getColumnCount(), new NumericParsingRule(), dateParsingRuleArray);
        }
        if (this.getModel() != null) {
            return new ImportColumnModel(this.getModel().getColumnCount());
        }
        return new ImportColumnModel(0);
    }

    public void createDefaultColumnsFromModel() {
        if (this.fImportSelectionModel == null) {
            super.createDefaultColumnsFromModel();
            return;
        }
        this.suspendColumnAdjustmentListener();
        ImportColumnModel importColumnModel = (ImportColumnModel)((Object)this.createDefaultColumnModel());
        importColumnModel.setSelectionModel(this.fImportSelectionModel.getColumnSelectionModel());
        this.setColumnModel((TableColumnModel)((Object)importColumnModel));
        this.updateColumnHeader();
        this.restoreColumnAdjustmentListener();
    }

    public IHeaderRenderer createRowHeaderRenderer(JTable jTable) {
        return new HeaderRenderer(1, 0, jTable);
    }

    @Override
    public IHeaderRenderer createColumnHeaderRenderer(JTable jTable) {
        this.fHeaderRenderer = new TextTableHeaderRenderer((TextTable)((Object)jTable));
        if (PlatformInfo.isMacintosh() && Matlab.isMatlabAvailable()) {
            jTable.setGridColor(this.fHeaderRenderer.getPreferredGridColor());
        }
        ((CellEditor)this.fHeaderRenderer).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent changeEvent) {
            }

            @Override
            public void editingStopped(ChangeEvent changeEvent) {
                Object object = ((CellEditor)TextTable.this.fHeaderRenderer).getCellEditorValue();
                if (!(object instanceof VariableHeaderRenderer.ImportDataHeader)) {
                    return;
                }
                TextTableHeaderRenderer.TextImportDataHeader textImportDataHeader = (TextTableHeaderRenderer.TextImportDataHeader)object;
                int n = textImportDataHeader.getColumn();
                if (n < 0 || TextTable.this.getColumnModel().getColumn(n).getHeaderValue().equals(textImportDataHeader)) {
                    return;
                }
                String string = textImportDataHeader.getName();
                TextTable.this.processVarNameEdit(string, n, textImportDataHeader);
                TextTable.this.getColumnModel().getColumn(n).setHeaderValue(new TextTableHeaderRenderer.TextImportDataHeader(n, string, textImportDataHeader.getParseRule(), textImportDataHeader.getDateParseRules()));
            }
        });
        return this.fHeaderRenderer;
    }

    private void commitVariableNameEdits(Runnable runnable) {
        this.stopHeaderEditing();
        if (this.fVarNameUpdateWorker != null && this.fVarNameUpdateWorker.isProcessing()) {
            this.fVarNameUpdateWorker.queueEditCompletionRunnable(runnable);
        } else {
            runnable.run();
        }
    }

    @Override
    public void importData(final ImportDataSource importDataSource) {
        this.commitVariableNameEdits(new Runnable(){

            @Override
            public void run() {
                TextTable.this.runnableInportData(importDataSource);
            }
        });
    }

    private void runnableInportData(ImportDataSource importDataSource) {
        super.importData(importDataSource);
    }

    @Override
    public void worksheetCachedDataChanged(EventObject eventObject) {
        if (this.fCleanedUp) {
            return;
        }
        this.fireWorksheetCachedDataListeners(eventObject);
        RepaintManager repaintManager = RepaintManager.currentManager((JComponent)((Object)this));
        Rectangle rectangle = this.getVisibleRect();
        repaintManager.addDirtyRegion((JComponent)((Object)this), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.updateCharacterCounts();
        this.repaint();
        this.requestFocusInWindow();
    }

    @Override
    ImportCellRenderer getRenderer() {
        return (ImportCellRenderer)this.getDefaultRenderer(Object.class);
    }

    @Override
    void setupAdditionalFonts() {
        if (this.fFixedWidth) {
            ((TextCellRenderer)this.getDefaultRenderer(Object.class)).setFixedWidth(true);
        }
    }

    @Override
    void updateTableBeforeRepaint() {
        this.updateColumnHeader();
        this.getTableHeader().repaint();
    }

    @Override
    protected void installEditorsAndRenderersForFormat() {
        this.fCellRenderer = new TextCellRenderer();
        this.setDefaultRenderer(Object.class, this.fCellRenderer);
    }

    @Override
    protected void initActions() {
        if (Matlab.isMatlabAvailable()) {
            this.fSelectAllAction = new AbstractSpreadsheetTable.SelectAllAction((AbstractSpreadsheetTable)this);
            this.fCopyAction = new ImportTable.CopyAction();
        }
        this.fClearAllSelectionAction = new ImportTable.ClearAllSelectionAction();
        this.fZoomInAction = new ImportTable.ZoomInAction();
        this.fZoomOutAction = new ImportTable.ZoomOutAction();
        this.fAddSplitterAction = new AddColumnSplitterAction(this);
        this.fMergeColumnsAction = new MergeColumnsAction(this);
        this.fSplitColumnAction = new SplitColumnAction(this);
        this.fImportAction = new ImportTable.ImportAction(this);
    }

    @Override
    protected void setupContextMenu() {
        this.fSelectionPopupMenu = new MJPopupMenu();
        this.addAddSplitterMenuItems();
        this.fSelectionPopupMenu.add((Action)((Object)this.fClearAllSelectionAction));
        if (Matlab.isMatlabAvailable()) {
            this.fSelectionPopupMenu.add((Component)new JPopupMenu.Separator());
            this.fSelectionPopupMenu.add((Action)((Object)this.fCopyAction));
        }
        this.fSelectionPopupMenu.add((Component)new JPopupMenu.Separator());
        this.fSelectionPopupMenu.add((Action)((Object)this.fZoomInAction));
        this.fSelectionPopupMenu.add((Action)((Object)this.fZoomOutAction));
        this.addImportContextMenuItem();
        this.fTmel = new TableMouseEventListener();
        this.addMouseListener(this.fTmel);
    }

    private void addAddSplitterMenuItems() {
        if (this.isFixedWidth()) {
            this.fSelectionPopupMenu.add((Action)((Object)this.fAddSplitterAction));
            this.fSelectionPopupMenu.add((Action)((Object)this.fSplitColumnAction));
            this.fSelectionPopupMenu.add((Action)((Object)this.fMergeColumnsAction));
            this.fSelectionPopupMenu.add((Component)this.fAddSplitterSeparator);
            this.fSelectionPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    int n;
                    if (TextTable.this.fMouseReleasedLocation == null) {
                        TextTable.this.fAddSplitterAction.setName(ImportToolUtils.getResourceString("ActionNames.addcolumnsplitter"));
                        TextTable.this.fAddSplitterAction.setEnabled(false);
                    } else {
                        n = TextTable.this.getCharacterPositionForLocation(TextTable.this.fMouseReleasedLocation);
                        TextTable.this.fAddSplitterAction.setName(ImportToolUtils.getResourceString("ActionNames.addcolumnsplitter") + n);
                        TextTable.this.fAddSplitterAction.setEnabled(true);
                    }
                    if (TextTable.this.getSelectedColumnCount() > 1 && TextTable.this.isContiguousColumnSelection()) {
                        TextTable.this.fMergeColumnsAction.setEnabled(true);
                    } else {
                        TextTable.this.fMergeColumnsAction.setEnabled(false);
                    }
                    if (TextTable.this.fHeaderMouseReleaseLocation == null && TextTable.this.fMouseReleasedLocation == null) {
                        TextTable.this.fSplitColumnAction.setEnabled(false);
                    } else {
                        n = TextTable.this.columnAtPoint(TextTable.this.fHeaderMouseReleaseLocation != null ? TextTable.this.fHeaderMouseReleaseLocation : TextTable.this.fMouseReleasedLocation);
                        if (n >= 0 && TextTable.this.fColumnCharacterCounts[n] > 1) {
                            TextTable.this.fSplitColumnAction.setEnabled(true);
                        } else {
                            TextTable.this.fAddSplitterAction.setEnabled(false);
                            TextTable.this.fSplitColumnAction.setEnabled(false);
                        }
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    TextTable.this.fMouseReleasedLocation = null;
                    TextTable.this.fHeaderMouseReleaseLocation = null;
                }
            });
        }
    }

    public boolean isContiguousColumnSelection() {
        int[] nArray = this.getSelectedColumns();
        return this.isContiguousRange(nArray);
    }

    public boolean isContiguousRange(int[] nArray) {
        if (nArray == null || nArray.length <= 0) {
            return false;
        }
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            n = Math.max(n, nArray[i]);
            n2 = Math.min(n2, nArray[i]);
        }
        return n - n2 == nArray.length - 1;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    protected JTableHeader createDefaultTableHeader() {
        return new ArrayTableHeader(this.columnModel);
    }

    public void doLayout() {
        if (this.getColumnModel() instanceof ImportColumnModel) {
            ((ImportColumnModel)((Object)this.getColumnModel())).doLayout();
        } else {
            super.doLayout();
        }
    }

    public void setTableHeader(JTableHeader jTableHeader) {
        super.setTableHeader(this.createDefaultTableHeader());
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        Object object;
        if (this.fImportSelectionModel == null) {
            super.tableChanged(tableModelEvent);
            return;
        }
        if (this.getModel().getColumnCount() != this.getColumnModel().getColumnCount()) {
            this.createDefaultColumnsFromModel();
        }
        if (this.getTableHeader() != null) {
            object = new TableColumnModelEvent(this.getColumnModel(), 0, this.getColumnModel().getColumnCount() - 1);
            this.getTableHeader().columnRemoved((TableColumnModelEvent)object);
            this.getTableHeader().columnAdded((TableColumnModelEvent)object);
            this.getTableHeader().revalidate();
        }
        object = this.getSelectedRange();
        super.tableChanged(tableModelEvent);
        if (this.fSetInitialSelection) {
            this.setInitialSelection();
            this.fSetInitialSelection = false;
        } else if (object != null && ((String)object).length() > 0) {
            this.setSelectedRanges((String)object);
        }
        this.updateColumnHeader();
        this.revalidate();
    }

    void addInitialSelectionListener() {
        this.fSetInitialSelection = true;
    }

    void setInitialSelection() {
        int[] nArray;
        AbstractFileTableModel abstractFileTableModel = this.getWorksheetTableModel();
        if (this.getImportSelectionModel() != null && (nArray = abstractFileTableModel.getInitialSelection()) != null && nArray.length == 4) {
            this.getImportSelectionModel().setSelection(nArray[0], nArray[2], nArray[1], nArray[3]);
        }
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = this.getRowCount();
        if (n2 > 0 && this.getColumnCount() > 0) {
            Rectangle rectangle = this.getCellRect(n2 - 1, 0, true);
            n = rectangle.y + rectangle.height;
        }
        if (this.getColumnModel() instanceof ImportColumnModel) {
            return new Dimension(this.getColumnModel().getTotalColumnWidth(), n);
        }
        return super.getPreferredSize();
    }

    public Rectangle getCellRect(int n, int n2, boolean bl) {
        if (!(this.getColumnModel() instanceof ImportColumnModel) || n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getColumnCount()) {
            return super.getCellRect(n, n2, bl);
        }
        int[] nArray = ((ImportColumnModel)((Object)this.getColumnModel())).getColumnPosition(n2);
        Rectangle rectangle = new Rectangle(nArray[0], n * this.getRowHeight(n), nArray[1] - nArray[0], this.getRowHeight(n));
        if (!bl) {
            int n3 = Math.min(this.getRowMargin(), rectangle.height);
            int n4 = Math.min(this.getColumnModel().getColumnMargin(), rectangle.width);
            rectangle.setBounds(rectangle.x + n4 / 2, rectangle.y + n3 / 2, rectangle.width - n4, rectangle.height - n3);
        }
        return rectangle;
    }

    void rebuild() {
        Rectangle rectangle = this.getVisibleRect();
        this.getWorksheetTableModel().rebuild(this.rowAtPoint(new Point(rectangle.x, rectangle.y)), this.columnAtPoint(new Point(rectangle.x, rectangle.y)));
        this.updateColumnHeader();
        this.revalidate();
    }

    private void updateColumnWidths() {
        if (this.fFixedWidth) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                int n = this.getPreferredColumnWidths(i);
                String string = String.valueOf(this.getValueAt(0, i));
                if (n <= 4 && (string == null || string.length() <= 0)) continue;
                this.getColumnModel().getColumn(i).setPreferredWidth(n);
                this.getColumnModel().getColumn(i).setMinWidth(0);
            }
            ((ImportColumnModel)((Object)this.getColumnModel())).doLayout();
        }
    }

    private int getPreferredColumnWidths(int n) {
        if (this.fFixedWidth) {
            if (this.fColumnCharacterCounts == null) {
                this.updateCharacterCounts();
            }
            if (n < this.fColumnCharacterCounts.length) {
                TextCellRenderer textCellRenderer = (TextCellRenderer)this.getCellRenderer(0, 0);
                return this.fColumnCharacterCounts[n] * textCellRenderer.getFixedWidthCharacterWidth() + 4;
            }
        }
        return this.getColumnModel().getColumn(n).getPreferredWidth();
    }

    public void expandAndCollapseFixedWidthColumns(int n) {
        if (!this.fFixedWidth) {
            return;
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.fFixedWidthTextTableFocusListener);
        JTableHeader jTableHeader = this.getTableHeader();
        int n2 = -1;
        int n3 = -1;
        if (n != -1) {
            n2 = Math.max(((TextTableHeaderRenderer)this.fHeaderRenderer).getPreferredHeaderWidth(n, this.getColumnModel().getColumn(n).getHeaderValue()), this.getPreferredColumnWidths(n));
            n3 = this.getPreferredColumnWidths(n);
            long l = 16L;
            Toolkit.getDefaultToolkit().addAWTEventListener(this.fFixedWidthTextTableFocusListener, l);
        }
        int n4 = -1;
        int n5 = -1;
        if (this.fCurrentlyExpandedColumn >= jTableHeader.getTable().getColumnCount()) {
            this.fCurrentlyExpandedColumn = -1;
        }
        if (this.fCurrentlyExpandedColumn != -1) {
            n4 = Math.max(((TextTableHeaderRenderer)this.fHeaderRenderer).getPreferredHeaderWidth(n, this.getColumnModel().getColumn(this.fCurrentlyExpandedColumn).getHeaderValue()), this.getPreferredColumnWidths(this.fCurrentlyExpandedColumn));
            n5 = this.getPreferredColumnWidths(this.fCurrentlyExpandedColumn);
        }
        int n6 = n3;
        for (int i = n4; n6 <= n2 || i >= n5; n6 += 15, i -= 15) {
            if (this.fCurrentlyExpandedColumn != n && n != -1) {
                if (n6 >= n3 && n6 <= n2) {
                    this.getColumnModel().getColumn(n).setPreferredWidth(n6);
                } else {
                    this.getColumnModel().getColumn(n).setPreferredWidth(n2);
                }
            }
            if (this.fCurrentlyExpandedColumn != -1) {
                if (i >= n5 && i <= n4) {
                    this.getColumnModel().getColumn(this.fCurrentlyExpandedColumn).setPreferredWidth(i);
                } else {
                    this.getColumnModel().getColumn(this.fCurrentlyExpandedColumn).setPreferredWidth(n5);
                }
            }
            this.paintImmediately(this.getBounds());
            jTableHeader.paintImmediately(jTableHeader.getBounds());
            try {
                Thread.sleep(5L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fCurrentlyExpandedColumn != -1) {
            this.getColumnModel().getColumn(this.fCurrentlyExpandedColumn).setPreferredWidth(n5);
        }
        if (this.fCurrentlyExpandedColumn != n && n != -1) {
            this.getColumnModel().getColumn(n).setPreferredWidth(n2);
            this.fCurrentlyExpandedColumn = n;
        } else {
            this.fCurrentlyExpandedColumn = -1;
        }
        this.paintImmediately(this.getBounds());
        jTableHeader.paintImmediately(jTableHeader.getBounds());
    }

    public void collapseAllFixedWidthColumns() {
        this.expandAndCollapseFixedWidthColumns(-1);
    }

    public int getCurrentlyExpandedColumn() {
        return this.fCurrentlyExpandedColumn;
    }

    @Override
    boolean isRowExcluded(int n) {
        AbstractFileTableModel abstractFileTableModel = this.getWorksheetTableModel();
        AbstractFileTableModel.ExcludedState excludedState = abstractFileTableModel.isRowExcluded(n, this.getSelectionModel(), this.getColumnModel().getSelectionModel());
        return excludedState == AbstractFileTableModel.ExcludedState.EXCLUDED;
    }

    @Override
    boolean isColumnExcluded(int n) {
        AbstractFileTableModel abstractFileTableModel = this.getWorksheetTableModel();
        AbstractFileTableModel.ExcludedState excludedState = abstractFileTableModel.isColumnExcluded(n, this.getSelectionModel(), this.getColumnModel().getSelectionModel());
        return excludedState == AbstractFileTableModel.ExcludedState.EXCLUDED;
    }

    void setWorksheetRules(List<WorksheetRule> list) {
        AbstractFileTableModel abstractFileTableModel = this.getWorksheetTableModel();
        abstractFileTableModel.setWorksheetRules(list);
        abstractFileTableModel.reset();
    }

    @Override
    public void cleanup() {
        if (this.fCleanedUp) {
            return;
        }
        this.fCleanedUp = true;
        if (this.getModel() instanceof TextFileTableModel) {
            ((TextFileTableModel)this.getModel()).cleanup();
        }
        this.removeMouseListener(this.fTmel);
        this.fTmel = null;
        this.getTableHeader().removeMouseListener(this.fThmel);
        this.getTableHeader().removeMouseMotionListener(this.fThmel);
        this.fThmel = null;
        this.removeFocusListener((FocusListener)this.fAFD);
        this.fAFD = null;
        this.getActionMap().clear();
        this.fSelectionPopupMenu.dispose();
        this.fSelectionPopupMenu = null;
        this.fSelectAllAction = null;
        this.fHeaderRenderer.cleanup();
        this.fHeaderRenderer = null;
        super.cleanup();
    }

    @Override
    public String getToolTipString(int n, int n2) {
        Object object;
        if ((this.getTargetType() == ImportClient.TargetType.COLUMNVECTORS || this.getTargetType() == ImportClient.TargetType.CELLARRAY || this.getTargetType() == ImportClient.TargetType.DATASET || this.getTargetType() == ImportClient.TargetType.TABLE) && this.getWorksheetTableModel() instanceof TextFileTableModel && n2 >= (object = ((TextFileTableModel)this.getWorksheetTableModel()).getColumnParseRules()).size()) {
            return null;
        }
        if (this.isRowExcluded(n)) {
            return this.getWorksheetTableModel().getRowExclusionRule(n).getSummaryComment();
        }
        if (this.isColumnExcluded(n2)) {
            return this.getWorksheetTableModel().getColumnExclusionRule(n2).getSummaryComment();
        }
        object = this.getWorksheetTableModel().getReplacedValueAt(n, n2);
        Object object2 = this.getWorksheetTableModel().getParsedValueAt(n, n2);
        if (object != null && object2 == null) {
            String string;
            if (object instanceof Double) {
                string = Double.toString((Double)object);
                string = TextTable.truncateString(string);
            } else {
                string = (String)object;
            }
            return ImportToolUtils.getResourceString("RuleType.replacedby") + string;
        }
        if (this.getWorksheetTableModel() instanceof TextFileTableModel && !this.getWorksheetTableModel().isUntreatedAt(n, n2)) {
            List<ParseRule> list = ((TextFileTableModel)this.getWorksheetTableModel()).getColumnParseRules();
            Object object3 = this.getWorksheetTableModel().getValueAt(n, n2);
            if (object3 == null) {
                return null;
            }
            String string = TextTable.truncateString(object3.toString());
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append(" ");
            stringBuilder.append(ImportToolUtils.getResourceString("datatypes.convertedto"));
            stringBuilder.append("[");
            stringBuilder.append(ImportToolUtils.getResourceString("datatypes.type"));
            if (list != null && n2 < list.size() && list.get(n2) != null && this.getWorksheetTableModel().getParsedValueAt(n, n2) != null) {
                stringBuilder.append(list.get(n2).getParseTargetType());
                stringBuilder.append(", ");
                stringBuilder.append(ImportToolUtils.getResourceString("datatypes.value"));
                Object object4 = this.getWorksheetTableModel().getParsedValueAt(n, n2);
                String string2 = TextTable.truncateString(object4.toString());
                stringBuilder.append(string2);
            } else {
                stringBuilder.append(ImportToolUtils.getResourceString("datatypes.text"));
                stringBuilder.append(", ");
                stringBuilder.append(ImportToolUtils.getResourceString("datatypes.value"));
                stringBuilder.append(string);
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        if (this.getWorksheetTableModel() instanceof TextFileTableModel && this.getWorksheetTableModel().isUntreatedAt(n, n2)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ImportToolUtils.getResourceString("datatypes.unimportable"));
            return stringBuilder.toString();
        }
        return null;
    }

    String getSelectedRange() {
        if (this.fImportSelectionModel != null) {
            return this.fImportSelectionModel.getSelectedRange();
        }
        return null;
    }

    int[] getSelectionSizeAfterExclusion() {
        return this.fImportSelectionModel.getSelectionSizeAfterExclusion();
    }

    private static void collpaseForFolds(FoldHierarchy foldHierarchy) {
        List list = FoldUtilities.childrenAsList((Fold)foldHierarchy.getRootFold());
        TextTable.collpaseForFolds(foldHierarchy, list.toArray(new Fold[1]));
    }

    private static void collpaseForFolds(FoldHierarchy foldHierarchy, Fold[] foldArray) {
        for (Fold fold : foldArray) {
            if (!fold.getType().toString().equals(MFoldType.FOR.getName())) continue;
            foldHierarchy.collapse(fold);
        }
    }

    private void utGenerateCode(final TextCodeFactory.CodeType codeType, final String string) {
        String[] stringArray = this.getSelectedColumnVariableNames();
        boolean bl = this.validateUniqueNames(stringArray);
        if (!bl) {
            return;
        }
        final GeneratedCode generatedCode = new GeneratedCode(GeneratedCode.DATE_FORMAT.MATLAB_DATETIME);
        MatlabWorker<TextImportUIState> matlabWorker = new MatlabWorker<TextImportUIState>(){

            public TextImportUIState runOnMatlabThread() {
                TextImportUIState textImportUIState = new TextImportUIState();
                textImportUIState.setDelimiters(((TextFileTableModel)TextTable.this.getWorksheetTableModel()).getDelimiters());
                textImportUIState.setFixedWidth(((TextFileTableModel)TextTable.this.getWorksheetTableModel()).isFixedWidth());
                textImportUIState.setFixedWidthColumnPositions(((TextFileTableModel)TextTable.this.getWorksheetTableModel()).getFixedWidthColumnPositions());
                textImportUIState.setEmptyRowCount(((TextFileTableModel)TextTable.this.getWorksheetTableModel()).getEmptyRowCount());
                textImportUIState.setDecimalSeparator(((TextFileTableModel)TextTable.this.getWorksheetTableModel()).getDecimalSeparator());
                boolean bl = ((TextFileTableModel)TextTable.this.getWorksheetTableModel()).useFastPath(TextTable.this.fImportSelectionModel.getSelectedRangeArray());
                textImportUIState.setUseFastPath(bl);
                textImportUIState.setMultipleDelimsAsOne(((TextFileTableModel)TextTable.this.getWorksheetTableModel()).isMultipleDelimsAsOne());
                if (bl) {
                    textImportUIState.setTextscanFormat(((TextFileTableModel)TextTable.this.getWorksheetTableModel()).getTextscanFormat(TextTable.this.getSelectedColumns()));
                } else {
                    textImportUIState.setTextscanFormat(((TextFileTableModel)TextTable.this.getWorksheetTableModel()).getSlowPathTextscanFormat(TextTable.this.getSelectedColumns()));
                }
                if (TextTable.this.getTargetType() == ImportClient.TargetType.COLUMNVECTORS || TextTable.this.getTargetType() == ImportClient.TargetType.DATASET || TextTable.this.getTargetType() == ImportClient.TargetType.TABLE) {
                    textImportUIState.setSelectedColumnNames(TextTable.this.getSelectedColumnVariableNames());
                    textImportUIState.setValidatedSelectedColumnNames(ImportCodeFactory.validateVariableNames(TextTable.this.getSelectedColumnVariableNames()));
                }
                if (TextTable.this.getTargetType() == ImportClient.TargetType.MATRIX || TextTable.this.getTargetType() == ImportClient.TargetType.DATASET || TextTable.this.getTargetType() == ImportClient.TargetType.CELLARRAY || TextTable.this.getTargetType() == ImportClient.TargetType.TABLE) {
                    textImportUIState.setGlobalVariableName(TextTable.this.getMatrixVariableName());
                    textImportUIState.setValidatedGlobalVariableName(ImportCodeFactory.validateVariableName(TextTable.this.getMatrixVariableName()));
                }
                textImportUIState.setValidatedSelectedColumnNames(ImportCodeFactory.validateVariableNames(TextTable.this.getSelectedColumnVariableNames()));
                return textImportUIState;
            }

            public void runOnAWTEventDispatchThread(TextImportUIState textImportUIState) {
                WorksheetRule worksheetRule2;
                List<int[]> list = ((IntervalSelectionModel)TextTable.this.getSelectionModel()).getSelectedIntervals();
                textImportUIState.setSelectedColumns(TextTable.this.getSelectedColumns());
                textImportUIState.setSelectedRowIntervals(list);
                if (TextTable.this.getTargetType().usesColumnNames()) {
                    textImportUIState.setSelectedColumnNames(TextTable.this.getSelectedColumnVariableNames());
                }
                if (TextTable.this.getTargetType().usesGroupName()) {
                    textImportUIState.setGlobalVariableName(TextTable.this.getMatrixVariableName());
                }
                textImportUIState.setTarget(TextTable.this.getTargetType());
                ((TextFileTableModel)TextTable.this.getWorksheetTableModel()).populateTextImportUIState(textImportUIState);
                ArrayList<WorksheetRule> arrayList = new ArrayList<WorksheetRule>();
                int n = 0;
                if (TextTable.this.getWorksheetTableModel().getWorksheetRules() != null) {
                    for (WorksheetRule worksheetRule2 : TextTable.this.getWorksheetTableModel().getWorksheetRules()) {
                        if (!TextTable.this.isRuleClassAppliedToSelection(worksheetRule2.getClass())) continue;
                        arrayList.add(worksheetRule2);
                        if (!worksheetRule2.isColumnExcludeType()) continue;
                        ++n;
                    }
                }
                textImportUIState.setActiveRules(arrayList);
                textImportUIState.setActiveColumnExclusionRuleCount(n);
                if (codeType == TextCodeFactory.CodeType.SCRIPT) {
                    TextCodeFactory.generateScript(generatedCode, textImportUIState);
                } else {
                    TextCodeFactory.generateFunction(generatedCode, textImportUIState, string);
                }
                Editor editor = ImportToolstripTab.editGeneratedCode(generatedCode.getCode());
                worksheetRule2 = FoldHierarchy.get((JTextComponent)editor.getTextComponent());
                if (worksheetRule2.getRootFold() == null || worksheetRule2.getRootFold().getFoldCount() == 0) {
                    worksheetRule2.addFoldHierarchyListener(new FoldHierarchyListener((FoldHierarchy)worksheetRule2){
                        final /* synthetic */ FoldHierarchy val$hierarchy;
                        {
                            this.val$hierarchy = foldHierarchy;
                        }

                        public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
                            if (foldHierarchyEvent.getAddedFoldCount() == 0 || this.val$hierarchy.getRootFold().equals(foldHierarchyEvent.getSource())) {
                                return;
                            }
                            Fold[] foldArray = new Fold[foldHierarchyEvent.getAddedFoldCount()];
                            for (int i = 0; i < foldArray.length; ++i) {
                                foldArray[i] = foldHierarchyEvent.getAddedFold(i);
                            }
                            TextTable.collpaseForFolds(this.val$hierarchy, foldArray);
                        }
                    });
                } else {
                    TextTable.collpaseForFolds((FoldHierarchy)worksheetRule2);
                }
            }
        };
        matlabWorker.start();
    }

    @Override
    public void generateMatlabScript() {
        this.utGenerateCode(TextCodeFactory.CodeType.SCRIPT, "");
    }

    @Override
    public void generateMatlabFunction(String string) {
        this.utGenerateCode(TextCodeFactory.CodeType.FUNCTION, string);
    }

    boolean isUntreatedDataInSelection() {
        IntervalSelectionModel intervalSelectionModel = (IntervalSelectionModel)this.getSelectionModel();
        IntervalSelectionModel intervalSelectionModel2 = (IntervalSelectionModel)this.getColumnModel().getSelectionModel();
        return this.getWorksheetTableModel().containsUntreatedCells(intervalSelectionModel, intervalSelectionModel2);
    }

    public boolean isFixedWidth() {
        return this.fFixedWidth;
    }

    public void setFixedWidthView(boolean bl) {
        if (this.fFixedWidth == bl) {
            return;
        }
        this.fFixedWidth = bl;
        if (this.fCellRenderer != null) {
            TextFileTableModel textFileTableModel = (TextFileTableModel)this.getModel();
            ((TextCellRenderer)this.fCellRenderer).setHasHalfWidthChars(textFileTableModel.hasHalfWidthChars());
            ((TextCellRenderer)this.fCellRenderer).setHasFullWidthChars(textFileTableModel.hasFullWidthChars());
            ((TextCellRenderer)this.fCellRenderer).setFixedWidth(bl);
        }
        if (this.getTableHeader().getDefaultRenderer() instanceof TextTableHeaderRenderer) {
            ((TextTableHeaderRenderer)((Object)this.getTableHeader().getDefaultRenderer())).setFixedWidth(bl);
        }
        if (this.fFixedWidth) {
            this.getTableHeader().setResizingAllowed(false);
            this.setAutoResizeMode(0);
        } else {
            this.getTableHeader().setResizingAllowed(true);
        }
        this.removeMouseListener(this.fTmel);
        this.setupContextMenu();
        this.updateColumnHeader();
        this.revalidate();
    }

    public void showDataTypeDropDown(int n) {
        ((TextTableHeaderRenderer)((Object)this.getTableHeader().getDefaultRenderer())).showListItemPopup(n, this.getTargetType());
    }

    public void hideDataTypeDropDown() {
        ((TextTableHeaderRenderer)((Object)this.getTableHeader().getDefaultRenderer())).hideListItemPopup();
    }

    @Override
    synchronized String getAllocationFcn() {
        return this.getTargetType().getAllocationFcn();
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (TextTable.isFindKeyEvent(keyEvent)) {
            keyEvent.consume();
            this.fFindDialogObj.invokeFindDialog();
        }
        super.processKeyEvent(keyEvent);
    }

    public static boolean isFindKeyEvent(KeyEvent keyEvent) {
        boolean bl = false;
        if (PlatformInfo.isMacintosh()) {
            if (keyEvent != null && !keyEvent.isConsumed() && keyEvent.getID() == 401 && keyEvent.isMetaDown() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() && keyEvent.getKeyCode() == 70 && !TextTable.shiftKeyDown(keyEvent)) {
                bl = true;
            }
        } else if (keyEvent != null && !keyEvent.isConsumed() && keyEvent.getID() == 401 && (keyEvent.getModifiersEx() & 0x80) == 128 && keyEvent.getKeyCode() == 70 && !TextTable.shiftKeyDown(keyEvent)) {
            bl = true;
        }
        return bl;
    }

    public void setFocusedRow(int n) {
        this.fFocusedRow = n;
    }

    public int getFocusedRow() {
        return this.fFocusedRow;
    }

    public void setFocusedCol(int n) {
        this.fFocusedCol = n;
    }

    public int getFocusedCol() {
        return this.fFocusedCol;
    }

    public void checkIfScrollingRequired(int n, int n2, boolean bl) {
        if (this.getRowCount() < 29) {
            return;
        }
        Rectangle rectangle = this.getCellRect(n >= 5 ? n - 5 : 0, n2, bl);
        rectangle = rectangle.union(this.getCellRect(n < this.getRowCount() - 29 ? n + 29 : this.getRowCount() - 1, n2, bl));
        this.scrollRectToVisible(rectangle);
    }

    public TextFileTableModel getTextFileTableModelObj() {
        return (TextFileTableModel)this.getModel();
    }

    public void unregisterFind() {
        TextTable textTable = this;
        textTable.fFindDialogObj.unregisterClient();
    }

    public void registerFind() {
        this.fFindDialogObj.registerWithFindDialog();
    }

    public void invokeFindFromPanelKeyStroke() {
        this.fFindDialogObj.invokeFindDialog();
    }

    static /* synthetic */ int[] access$002(TextTable textTable, int[] nArray) {
        textTable.fColumnCharacterCounts = nArray;
        return nArray;
    }

    private static class ArrayTableHeader
    extends AbstractSpreadsheetTable.SpreadsheetTableHeader {
        ArrayTableHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            this.setOpaque(false);
            this.setReorderingAllowed(false);
        }

        public Rectangle getHeaderRect(int n) {
            if (!(this.getColumnModel() instanceof ImportColumnModel) || n < 0 || n >= this.getColumnModel().getColumnCount()) {
                return super.getHeaderRect(n);
            }
            int[] nArray = ((ImportColumnModel)((Object)this.getColumnModel())).getColumnPosition(n);
            return new Rectangle(nArray[0], 0, nArray[1] - nArray[0], this.getHeaderHeight());
        }

        public Dimension getPreferredSize() {
            TableColumnModel tableColumnModel = this.getColumnModel();
            if (tableColumnModel instanceof ImportColumnModel) {
                return new Dimension(tableColumnModel.getTotalColumnWidth(), this.getHeaderHeight());
            }
            return super.getPreferredSize();
        }

        private int getHeaderHeight() {
            int n = HEADER_HEIGHT;
            if (this.getDefaultRenderer() instanceof VariableHeaderRenderer) {
                n = (int)((VariableHeaderRenderer)((Object)this.getDefaultRenderer())).getPanel().getPreferredSize().getHeight();
            }
            return n;
        }
    }

    public class FixedWidthTextTableFocusListener
    implements AWTEventListener {
        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            try {
                if (aWTEvent instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                    if (TextTable.this.isVisible() && mouseEvent.getClickCount() > 0 && mouseEvent.getID() == 501) {
                        Point point = mouseEvent.getLocationOnScreen();
                        Rectangle rectangle = TextTable.this.getTableHeader().getBounds();
                        Point point2 = TextTable.this.getTableHeader().getLocationOnScreen();
                        rectangle.x = point2.x;
                        rectangle.y = point2.y;
                        if (!rectangle.contains(point) && TextTable.this.isVisible() && !((TextTableHeaderRenderer)((Object)TextTable.this.getTableHeader().getDefaultRenderer())).clickInListPopup(point)) {
                            TextTable.this.collapseAllFixedWidthColumns();
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class SplitColumnAction
    extends MJAbstractAction {
        TextTable fTable = null;

        SplitColumnAction(TextTable textTable2) {
            this.fTable = textTable2;
            this.setComponentName("SplitColumnAction");
            this.setName(ImportToolUtils.getResourceString("ActionNames.splitcolumn"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Point point = TextTable.this.fMouseReleasedLocation == null ? TextTable.this.fHeaderMouseReleaseLocation : TextTable.this.fMouseReleasedLocation;
            TextTable.this.splitColumnAtPoint(point);
            TextTable.this.fMouseReleasedLocation = null;
            TextTable.this.fHeaderMouseReleaseLocation = null;
        }
    }

    private class MergeColumnsAction
    extends MJAbstractAction {
        TextTable fTable = null;

        MergeColumnsAction(TextTable textTable2) {
            this.fTable = textTable2;
            this.setComponentName("MergeColumnsAction");
            this.setName(ImportToolUtils.getResourceString("ActionNames.mergecolumns"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TextTable.this.mergeSelectedFixedWidthColumns();
                TextTable.this.fMouseReleasedLocation = null;
                TextTable.this.fHeaderMouseReleaseLocation = null;
            }
            catch (Exception exception) {
                MJOptionPane.showMessageDialog((Component)SwingUtilities.getRoot((Component)((Object)this.fTable)), (Object)exception.getMessage());
            }
        }
    }

    private class AddColumnSplitterAction
    extends MJAbstractAction {
        TextTable fTable = null;

        AddColumnSplitterAction(TextTable textTable2) {
            this.fTable = textTable2;
            this.setComponentName("AddColumnSplitterAction");
            this.setName(ImportToolUtils.getResourceString("ActionNames.addcolumnsplitter"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = TextTable.this.getCharacterPositionForLocation(TextTable.this.fMouseReleasedLocation);
            TextTable.this.tryScreenBuffer();
            TextTable.this.addColumnSplitter(n);
            TextTable.this.fMouseReleasedLocation = null;
            TextTable.this.fHeaderMouseReleaseLocation = null;
        }
    }

    protected class TableMouseEventListener
    extends MouseAdapter {
        protected TableMouseEventListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            TextTable.this.processPossiblePopup(mouseEvent);
            TextTable.this.collapseAllFixedWidthColumns();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            TextTable.this.processPossiblePopup(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
        }
    }
}

