/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool;

import com.mathworks.mlwidgets.importtool.ImportCellRenderer;
import com.mathworks.mlwidgets.importtool.ImportTable;
import com.mathworks.mlwidgets.importtool.IntervalSelectionModel;
import com.mathworks.mlwidgets.importtool.TextTable;
import com.mathworks.mwswing.MJTable;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

class WorksheetMouseListener
extends MouseAdapter {
    private ImportTable fTable;
    private int[] fAnchorCellForResize;
    private ResizeDirection fResizingDirection = ResizeDirection.NONE;
    private boolean fMouseDown = false;
    private Component fFocusOwner;
    private static final int BORDERHITWIDTH = 5;

    WorksheetMouseListener(ImportTable importTable) {
        this.fTable = importTable;
    }

    private ImportCellRenderer getWorksheetCellRenderer() {
        if (this.fTable == null) {
            return null;
        }
        return (ImportCellRenderer)this.fTable.getDefaultRenderer(Object.class);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        mouseWheelEvent.consume();
        MouseWheelEvent mouseWheelEvent2 = new MouseWheelEvent((Component)((Object)this.fTable), mouseWheelEvent.getID(), mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), mouseWheelEvent.getX(), mouseWheelEvent.getY(), mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation());
        for (MouseWheelListener mouseWheelListener : this.fTable.getMouseWheelListeners()) {
            mouseWheelListener.mouseWheelMoved(mouseWheelEvent2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        super.mouseEntered(mouseEvent);
        if (!this.fTable.hasFocus()) {
            Window window = SwingUtilities.getWindowAncestor((Component)((Object)this.fTable));
            if (window == null) {
                return;
            }
            this.fFocusOwner = window.getFocusOwner();
            if (this.fFocusOwner == null) {
                this.fFocusOwner = window;
            }
            this.fFocusOwner.addMouseWheelListener(this);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.fFocusOwner != null) {
            this.fFocusOwner.removeMouseWheelListener(this);
            this.fFocusOwner = null;
        }
        if (this.fMouseDown) {
            this.selectToEnd(mouseEvent);
        }
        if (this.fTable.getVisibleRect().contains(mouseEvent.getPoint())) {
            return;
        }
        ImportCellRenderer importCellRenderer = this.getWorksheetCellRenderer();
        if (importCellRenderer == null) {
            return;
        }
        importCellRenderer.setHighlightLocation(-1, -1, -1, -1);
        importCellRenderer.setGlowBorderLocation(-1, -1, -1, -1);
        importCellRenderer.setHoverCell(-1, -1);
        this.fTable.setCursor(null);
        if (this.fTable.getTableHeader().getCursor() != null && this.fTable.getTableHeader().getCursor().getType() == 3) {
            this.fTable.getTableHeader().setCursor(null);
        }
        if (this.fTable instanceof TextTable) {
            ((TextTable)this.fTable).hideToolTip();
        }
        this.fTable.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.fMouseDown) {
            return;
        }
        int n = this.fTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.fTable.columnAtPoint(mouseEvent.getPoint());
        ImportCellRenderer importCellRenderer = this.getWorksheetCellRenderer();
        if (this.fTable.isCellSelected(n, n2)) {
            Rectangle rectangle = this.fTable.getCellRect(n, n2, true);
            Point point = mouseEvent.getPoint();
            Cursor cursor = null;
            int[] nArray = WorksheetMouseListener.getSelectedCellBlock((MJTable)this.fTable, n, n2);
            if (n2 == nArray[2] && point.x <= rectangle.x + 5) {
                this.fResizingDirection = ResizeDirection.HORIZONTAL_LEFT;
                cursor = new Cursor(10);
            } else if (n2 == nArray[3] && point.x >= rectangle.x + rectangle.width - 5) {
                this.fResizingDirection = ResizeDirection.HORIZONTAL_RIGHT;
                cursor = new Cursor(11);
            } else if (n == nArray[0] && point.y <= rectangle.y + 5) {
                this.fResizingDirection = ResizeDirection.VERTICAL_TOP;
                cursor = new Cursor(8);
            } else if (n == nArray[1] && point.y >= rectangle.y + rectangle.height - 5) {
                this.fResizingDirection = ResizeDirection.VERTICAL_BOTTOM;
                cursor = new Cursor(9);
            } else {
                this.fResizingDirection = ResizeDirection.NONE;
            }
            if (this.fTable.isRowExcluded(n)) {
                importCellRenderer.setBorderedRow(n);
            } else if (this.fTable.isColumnExcluded(n2)) {
                importCellRenderer.setBorderedColumn(n2);
            } else {
                importCellRenderer.setBorderedRow(-1);
            }
            this.fTable.setCursor(cursor);
        } else {
            this.getWorksheetCellRenderer().setBorderedRow(-1);
            this.getWorksheetCellRenderer().setBorderedColumn(-1);
            this.fTable.setCursor(null);
            this.fResizingDirection = ResizeDirection.NONE;
        }
        this.fTable.refreshSelectionEffects(mouseEvent.getPoint());
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        int n;
        this.fMouseDown = true;
        int n2 = this.fTable.rowAtPoint(mouseEvent.getPoint());
        if (!this.fTable.isCellSelected(n2, n = this.fTable.columnAtPoint(mouseEvent.getPoint()))) {
            return;
        }
        if (this.fResizingDirection == ResizeDirection.NONE) {
            if (mouseEvent.isControlDown()) {
                ListSelectionModel listSelectionModel = this.fTable.getColumnModel().getSelectionModel();
                if (listSelectionModel.getMaxSelectionIndex() == n && listSelectionModel.getMinSelectionIndex() == n) {
                    this.fTable.getSelectionModel().removeSelectionInterval(n2, n2);
                } else {
                    listSelectionModel.removeSelectionInterval(n, n);
                }
                mouseEvent.consume();
            } else {
                this.fTable.clearSelection();
            }
        } else {
            int[] nArray = WorksheetMouseListener.getSelectedCellBlock((MJTable)this.fTable, n2, n);
            if (this.fResizingDirection == ResizeDirection.VERTICAL_BOTTOM) {
                this.fTable.getSelectionModel().setAnchorSelectionIndex(nArray[0]);
                ((DefaultListSelectionModel)this.fTable.getSelectionModel()).moveLeadSelectionIndex(nArray[1]);
                this.fTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(nArray[2]);
                ((DefaultListSelectionModel)this.fTable.getColumnModel().getSelectionModel()).moveLeadSelectionIndex(nArray[3]);
            } else if (this.fResizingDirection == ResizeDirection.VERTICAL_TOP) {
                this.fTable.getSelectionModel().setAnchorSelectionIndex(nArray[1]);
                ((DefaultListSelectionModel)this.fTable.getSelectionModel()).moveLeadSelectionIndex(nArray[0]);
                this.fTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(nArray[2]);
                ((DefaultListSelectionModel)this.fTable.getColumnModel().getSelectionModel()).moveLeadSelectionIndex(nArray[3]);
            } else if (this.fResizingDirection == ResizeDirection.HORIZONTAL_LEFT) {
                this.fTable.getSelectionModel().setAnchorSelectionIndex(nArray[0]);
                ((DefaultListSelectionModel)this.fTable.getSelectionModel()).moveLeadSelectionIndex(nArray[1]);
                this.fTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(nArray[3]);
                ((DefaultListSelectionModel)this.fTable.getColumnModel().getSelectionModel()).moveLeadSelectionIndex(nArray[2]);
            } else if (this.fResizingDirection == ResizeDirection.HORIZONTAL_RIGHT) {
                this.fTable.getSelectionModel().setAnchorSelectionIndex(nArray[0]);
                ((DefaultListSelectionModel)this.fTable.getSelectionModel()).moveLeadSelectionIndex(nArray[1]);
                this.fTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(nArray[2]);
                ((DefaultListSelectionModel)this.fTable.getColumnModel().getSelectionModel()).moveLeadSelectionIndex(nArray[3]);
            }
            this.fAnchorCellForResize = new int[]{this.fTable.getSelectionModel().getAnchorSelectionIndex(), this.fTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex()};
            mouseEvent.consume();
            this.fTable.setPreventDefaultSelection(true);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fResizingDirection == ResizeDirection.NONE) {
            if (this.fTable.rowAtPoint(mouseEvent.getPoint()) < 0 || this.fTable.columnAtPoint(mouseEvent.getPoint()) < 0) {
                this.selectToEnd(mouseEvent);
            }
            return;
        }
        int[] nArray = new int[]{this.fTable.getSelectionModel().getLeadSelectionIndex(), this.fTable.getColumnModel().getSelectionModel().getLeadSelectionIndex()};
        mouseEvent.consume();
        int n = this.fTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.fTable.columnAtPoint(mouseEvent.getPoint());
        if (n < 0 || n2 < 0) {
            this.fTable.setCursor(null);
            return;
        }
        this.fTable.getColumnModel().getSelectionModel().setValueIsAdjusting(true);
        this.fTable.getSelectionModel().setValueIsAdjusting(true);
        if (this.fResizingDirection == ResizeDirection.VERTICAL_BOTTOM || this.fResizingDirection == ResizeDirection.VERTICAL_TOP) {
            boolean bl;
            n = n > this.fTable.getRowCount() ? this.fTable.getRowCount() : n;
            int n3 = n - nArray[0];
            boolean bl2 = bl = this.fResizingDirection == ResizeDirection.VERTICAL_BOTTOM && n3 < 0 || this.fResizingDirection == ResizeDirection.VERTICAL_TOP && n3 > 0;
            if (bl) {
                this.fTable.removeRowSelectionInterval(nArray[0], n);
                this.fTable.addRowSelectionInterval(this.fAnchorCellForResize[0], n);
                Rectangle rectangle = this.fTable.getCellRect(n, n2, false);
                this.fTable.refreshSelectionEffects(new Point(mouseEvent.getPoint().x, rectangle.y));
            } else {
                this.fTable.addRowSelectionInterval(this.fAnchorCellForResize[0], n);
                Rectangle rectangle = this.fTable.getCellRect(n, n2, false);
                this.fTable.refreshSelectionEffects(new Point(mouseEvent.getPoint().x, rectangle.y + rectangle.height));
            }
            if (this.fResizingDirection == ResizeDirection.VERTICAL_BOTTOM) {
                this.fTable.setCursor(new Cursor(9));
            } else {
                this.fTable.setCursor(new Cursor(8));
            }
        } else if (this.fResizingDirection == ResizeDirection.HORIZONTAL_LEFT || this.fResizingDirection == ResizeDirection.HORIZONTAL_RIGHT) {
            boolean bl;
            n2 = n2 >= 0 ? n2 : 0;
            n2 = n2 > this.fTable.getColumnCount() ? this.fTable.getColumnCount() : n2;
            int n4 = n2 - nArray[1];
            boolean bl3 = bl = this.fResizingDirection == ResizeDirection.HORIZONTAL_LEFT && n4 > 0 || this.fResizingDirection == ResizeDirection.HORIZONTAL_RIGHT && n4 < 0;
            if (bl) {
                this.fTable.removeColumnSelectionInterval(nArray[1], n2);
                this.fTable.addColumnSelectionInterval(this.fAnchorCellForResize[1], n2);
                Rectangle rectangle = this.fTable.getCellRect(n, n2, false);
                this.fTable.refreshSelectionEffects(new Point(mouseEvent.getPoint().x, rectangle.y));
            } else {
                this.fTable.addColumnSelectionInterval(this.fAnchorCellForResize[1], n2);
                Rectangle rectangle = this.fTable.getCellRect(n, n2, false);
                this.fTable.refreshSelectionEffects(new Point(mouseEvent.getPoint().x, rectangle.y + rectangle.height));
            }
            if (this.fResizingDirection == ResizeDirection.HORIZONTAL_LEFT) {
                this.fTable.setCursor(new Cursor(10));
            } else {
                this.fTable.setCursor(new Cursor(11));
            }
        } else {
            this.fTable.setCursor(null);
        }
        this.fTable.scrollRectToVisible(new Rectangle(mouseEvent.getPoint().x, mouseEvent.getPoint().y, 1, 1));
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.fTable.setPreventDefaultSelection(false);
        this.fMouseDown = false;
        this.fTable.getColumnModel().getSelectionModel().setValueIsAdjusting(false);
        this.fTable.getSelectionModel().setValueIsAdjusting(false);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.fResizingDirection != ResizeDirection.NONE) {
            mouseEvent.consume();
            return;
        }
        this.fTable.requestFocus();
    }

    static int[] getSelectedCellBlock(MJTable mJTable, int n, int n2) {
        if (!mJTable.isCellSelected(n, n2)) {
            return null;
        }
        int[] nArray = ((IntervalSelectionModel)mJTable.getSelectionModel()).getSelectedCellBlock(n);
        int[] nArray2 = ((IntervalSelectionModel)mJTable.getColumnModel().getSelectionModel()).getSelectedCellBlock(n2);
        if (nArray == null || nArray2 == null) {
            return null;
        }
        return new int[]{nArray[0], nArray[1], nArray2[0], nArray2[1]};
    }

    public void selectToEnd(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        Rectangle rectangle = this.fTable.getVisibleRect();
        if (point.x > rectangle.x + rectangle.width) {
            point.x = rectangle.x + rectangle.width - 1;
        }
        if (point.x < rectangle.x) {
            point.x = rectangle.x + 1;
        }
        if (point.y > rectangle.y + rectangle.height) {
            point.y = rectangle.y + rectangle.height - 1;
        }
        if (point.y < rectangle.y) {
            point.y = rectangle.y + 1;
        }
        int n = this.fTable.getSelectionModel().getLeadSelectionIndex();
        int n2 = this.fTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        int n3 = this.fTable.getSelectionModel().getAnchorSelectionIndex();
        int n4 = this.fTable.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
        int n5 = this.fTable.rowAtPoint(point);
        int n6 = this.fTable.columnAtPoint(point);
        if (n6 > 0 && point.x < rectangle.x || n6 < this.fTable.getColumnCount() && point.x > rectangle.x + rectangle.width) {
            return;
        }
        if (n5 >= 0 && n6 >= 0) {
            if (this.fResizingDirection == ResizeDirection.VERTICAL_BOTTOM || this.fResizingDirection == ResizeDirection.VERTICAL_TOP) {
                this.fTable.getSelectionModel().addSelectionInterval(n3, n5);
            } else if (this.fResizingDirection == ResizeDirection.HORIZONTAL_LEFT || this.fResizingDirection == ResizeDirection.HORIZONTAL_RIGHT) {
                this.fTable.getColumnModel().getSelectionModel().addSelectionInterval(n4, n6);
            } else {
                this.fTable.getSelectionModel().removeSelectionInterval(n, n3);
                this.fTable.getColumnModel().getSelectionModel().removeSelectionInterval(n2, n4);
                this.fTable.getSelectionModel().addSelectionInterval(n3, n5);
                this.fTable.getColumnModel().getSelectionModel().addSelectionInterval(n4, n6);
            }
        }
        this.fTable.getSelectionModel().setAnchorSelectionIndex(n3);
        this.fTable.getColumnModel().getSelectionModel().setAnchorSelectionIndex(n4);
        if (this.fTable.columnAtPoint(mouseEvent.getPoint()) < 0 && this.fTable.rowAtPoint(mouseEvent.getPoint()) > 0) {
            this.fTable.changeSelection(this.fTable.rowAtPoint(mouseEvent.getPoint()), this.fTable.columnAtPoint(point), true, true);
        }
    }

    private static enum ResizeDirection {
        HORIZONTAL_LEFT,
        HORIZONTAL_RIGHT,
        VERTICAL_TOP,
        VERTICAL_BOTTOM,
        NONE;

    }
}

