/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.importtool.popuplist;

import com.mathworks.mlwidgets.importtool.ImportToolUtils;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.util.LanguageUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class EditablePopupListItem
extends MJPanel {
    static final ImageIcon radioUnselected = EditablePopupListItem.getResourceIcon("radio-unchecked.png");
    static final ImageIcon radioSelected = EditablePopupListItem.getResourceIcon("radio-checked.png");
    static final ImageIcon checkUnselected = EditablePopupListItem.getResourceIcon("checkbox-unchecked.png");
    static final ImageIcon checkSelected = EditablePopupListItem.getResourceIcon("checkbox-checked.png");
    public static final Cursor DEFAULT_CURSOR = new Cursor(0);
    public static final Cursor EDIT_CURSOR = new Cursor(2);
    public static final Cursor WAIT_CURSOR = new Cursor(3);
    public static final Color DEFAULT_BLUE = new Color(0xC5C5C5);
    public static final Color TITLE_COLOR = new Color(17, 74, 125);
    public static final Color DESCRIPTION_COLOR = new Color(64, 64, 64);
    public static final Color SELECTED_PLAIN_COLOR = new Color(187, 230, 255);
    public static final Color TEMPORARY_SELECTED_COLOR = new Color(0, 0, 255, 75);
    public static final Color LINE_HEADER_COLOR = Color.GRAY;
    public static final Font TITLE_FONT = LanguageUtils.isCJK() ? FontUtils.getSystemUIFont() : new Font("Arial", 0, 12);
    public static final Font EDIT_TITLE_FONT = LanguageUtils.isCJK() ? FontUtils.getSystemUIFont() : new Font("Arial", 2, 12);
    public static final Font HEADER_FONT = LanguageUtils.isCJK() ? FontUtils.getSystemUIFont() : new Font("Arial", 1, 11);
    public static final Font DESCRIPTION_FONT = LanguageUtils.isCJK() ? FontUtils.getSystemUIFont() : new Font("Arial", 0, 10);
    public static final Font LINE_HEADER_FONT = LanguageUtils.isCJK() ? FontUtils.getSystemUIFont() : new Font("Arial", 0, 10);
    private ITEM_TYPE fType;
    private EditablePopupListItemLabel fLabel;
    private MJTextField fTextField;
    private EditablePopupListItemLabel fDescriptionLabel;
    private MJTextField fDescriptionTextField;
    private Object fValue;
    private String fCurrentDisplayName;
    private String fDescription;
    private boolean fWaitCursorEnabled = false;
    private boolean fTemporarilySelected = false;
    private Color fDefaultColor;
    protected boolean fIsAdjusting = false;
    private boolean fIsEditable = false;
    private boolean fDescriptionEditable = false;
    private boolean fIsSelected = false;
    private boolean fAllowBlanks = false;
    private boolean fBlankOnEdit = false;
    private boolean fHighlightOnHoverEnabled = true;
    private ArrayList<EditablePopupListItemSelectionListener> fSelectionListeners = new ArrayList();
    private ArrayList<EditablePopupListItemNameListener> fNameListeners = new ArrayList();
    private ArrayList<EditablePopupListItemDescriptionListener> fDescriptionListeners = new ArrayList();
    private ArrayList<EditablePopupListItemEditListener> fEditListeners = new ArrayList();
    private Component fActionComponent = null;
    private boolean fShowToolTip = true;
    private MouseAdapter fActionMouseAdapter = new MouseAdapter(){

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            EditablePopupListItem.this.setTemporarilySelected(true);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            EditablePopupListItem.this.setTemporarilySelected(false);
        }
    };

    public EditablePopupListItem(String string, Object object, ITEM_TYPE iTEM_TYPE, boolean bl) {
        this(string, object, null, iTEM_TYPE, bl);
    }

    public EditablePopupListItem(String string, Object object, String string2, ITEM_TYPE iTEM_TYPE, boolean bl) {
        this.fCurrentDisplayName = string;
        this.fValue = object;
        this.fType = iTEM_TYPE;
        this.fDescriptionEditable = this.fIsEditable = bl & (iTEM_TYPE != ITEM_TYPE.HEADER && iTEM_TYPE != ITEM_TYPE.LINE_HEADER);
        this.fDescription = string2;
        this.setName("ListItem");
        this.setLayout(new BorderLayout());
        this.fTextField = new MJTextField(string);
        this.fTextField.setName("ListItemTextField");
        this.fTextField.setEditable(true);
        this.fTextField.setEnabled(true);
        this.fTextField.setFocusable(true);
        this.fTextField.setFont(EDIT_TITLE_FONT);
        if (iTEM_TYPE == ITEM_TYPE.PLAIN) {
            this.fLabel = new EditablePopupListItemLabel(string, null, 2);
            this.setAllBackgrounds(Color.WHITE);
            this.fLabel.setForeground(TITLE_COLOR);
            this.fLabel.setFont(TITLE_FONT);
            this.fLabel.setOpaque(true);
        } else if (iTEM_TYPE == ITEM_TYPE.CHECKBOX) {
            this.fLabel = new EditablePopupListItemLabel(string, checkUnselected, 2);
            this.setAllBackgrounds(Color.WHITE);
            this.fLabel.setForeground(TITLE_COLOR);
            this.fLabel.setFont(TITLE_FONT);
            this.fLabel.setOpaque(true);
        } else if (iTEM_TYPE == ITEM_TYPE.RADIOBUTTON) {
            this.fLabel = new EditablePopupListItemLabel(string, radioUnselected, 2);
            this.setAllBackgrounds(Color.WHITE);
            this.fLabel.setForeground(TITLE_COLOR);
            this.fLabel.setFont(TITLE_FONT);
            this.fLabel.setOpaque(true);
        } else if (iTEM_TYPE == ITEM_TYPE.HEADER) {
            this.fLabel = new EditablePopupListItemLabel(string, null, 2);
            this.setAllBackgrounds(DEFAULT_BLUE);
            this.fLabel.setForeground(Color.WHITE);
            this.fLabel.setFont(HEADER_FONT);
            this.fLabel.setOpaque(true);
        } else if (iTEM_TYPE == ITEM_TYPE.LINE_HEADER) {
            this.fLabel = new EditablePopupListItemLabel(string, null, 2);
            this.setAllBackgrounds(Color.WHITE);
            this.fLabel.setForeground(LINE_HEADER_COLOR);
            this.fLabel.setFont(LINE_HEADER_FONT);
            this.fLabel.setOpaque(true);
        }
        this.fLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.fLabel.setName("ListItemLabel");
        this.add((Component)((Object)this.fLabel), "Center");
        this.fLabel.setToolTipText(string);
        this.setToolTipText(string);
        this.setupSize();
        this.setDescription(string2);
        this.fLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!EditablePopupListItem.this.isEnabled()) {
                    return;
                }
                if (EditablePopupListItem.this.fIsEditable && mouseEvent.getPoint().x > radioSelected.getIconWidth()) {
                    EditablePopupListItem.this.enableEditor();
                } else {
                    if (EditablePopupListItem.this.fIsSelected && EditablePopupListItem.this.fType == ITEM_TYPE.RADIOBUTTON) {
                        return;
                    }
                    if (EditablePopupListItem.this.fIsSelected) {
                        EditablePopupListItem.this.fIsSelected = false;
                        if (EditablePopupListItem.this.fType == ITEM_TYPE.CHECKBOX) {
                            EditablePopupListItem.this.fLabel.setIcon(checkUnselected);
                        } else if (EditablePopupListItem.this.fType == ITEM_TYPE.PLAIN) {
                            EditablePopupListItem.this.setAllBackgrounds(Color.WHITE);
                        }
                    } else {
                        EditablePopupListItem.this.fIsSelected = true;
                        if (EditablePopupListItem.this.fType == ITEM_TYPE.CHECKBOX) {
                            EditablePopupListItem.this.fLabel.setIcon(checkSelected);
                        } else if (EditablePopupListItem.this.fType == ITEM_TYPE.RADIOBUTTON) {
                            EditablePopupListItem.this.fLabel.setIcon(radioSelected);
                        } else if (EditablePopupListItem.this.fType == ITEM_TYPE.PLAIN) {
                            EditablePopupListItem.this.setAllBackgrounds(SELECTED_PLAIN_COLOR);
                        }
                    }
                    EditablePopupListItem.this.fLabel.requestFocusInWindow();
                    if (EditablePopupListItem.this.fType != ITEM_TYPE.HEADER && EditablePopupListItem.this.fType != ITEM_TYPE.LINE_HEADER) {
                        EditablePopupListItem.this.fireSelectionChangedEvent();
                    }
                }
                EditablePopupListItem.this.validate();
                EditablePopupListItem.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (!EditablePopupListItem.this.isEnabled()) {
                    return;
                }
                EditablePopupListItem.this.setTemporarilySelected(true);
                if (!EditablePopupListItem.this.fWaitCursorEnabled) {
                    if (EditablePopupListItem.this.fIsEditable && mouseEvent.getPoint().x > radioSelected.getIconWidth()) {
                        EditablePopupListItem.this.setCursor(EDIT_CURSOR);
                        if (EditablePopupListItem.this.fDefaultColor == null) {
                            EditablePopupListItem.this.fDefaultColor = EditablePopupListItem.this.fLabel.getBackground();
                        }
                        EditablePopupListItem.this.fLabel.setBackground(EditablePopupListItem.this.fDefaultColor == Color.WHITE ? Color.LIGHT_GRAY : Color.WHITE);
                    } else {
                        EditablePopupListItem.this.setCursor(DEFAULT_CURSOR);
                    }
                } else {
                    EditablePopupListItem.this.setCursor(WAIT_CURSOR);
                }
                EditablePopupListItem.this.fLabel.repaint();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (!EditablePopupListItem.this.isEnabled()) {
                    return;
                }
                EditablePopupListItem.this.setTemporarilySelected(false);
                if (EditablePopupListItem.this.fDefaultColor == null) {
                    EditablePopupListItem.this.fDefaultColor = EditablePopupListItem.this.fLabel.getBackground();
                }
                if (EditablePopupListItem.this.fType != ITEM_TYPE.PLAIN) {
                    EditablePopupListItem.this.setAllBackgrounds(EditablePopupListItem.this.fDefaultColor);
                }
                if (!EditablePopupListItem.this.fWaitCursorEnabled) {
                    EditablePopupListItem.this.setCursor(DEFAULT_CURSOR);
                } else {
                    EditablePopupListItem.this.setCursor(WAIT_CURSOR);
                }
                EditablePopupListItem.this.fLabel.repaint();
            }
        });
        this.fTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = EditablePopupListItem.this.saveAndDisableEditor();
                EditablePopupListItem.this.setSelected(true);
            }
        });
        this.fTextField.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    EditablePopupListItem.this.cancelAndDisableEditor();
                    EditablePopupListItem.this.fireNameChangedEvent(EditablePopupListItem.this.fCurrentDisplayName, EditablePopupListItem.this.fCurrentDisplayName);
                }
            }
        });
        this.fTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string = EditablePopupListItem.this.saveAndDisableEditor();
            }
        });
    }

    public boolean isEditing() {
        if (this.getComponentCount() > 0) {
            for (Component component : this.getComponents()) {
                if (!component.equals(this.fTextField)) continue;
                return true;
            }
        }
        return false;
    }

    private void enableEditor() {
        this.remove((Component)((Object)this.fLabel));
        this.fCurrentDisplayName = this.fLabel.getText();
        this.fLabel.setText("");
        this.fLabel.setToolTipText(this.fShowToolTip ? "" : null);
        this.add((Component)this.fTextField, "Center");
        if (this.fBlankOnEdit) {
            this.fTextField.setText("");
        } else {
            this.fTextField.setText(this.fCurrentDisplayName);
        }
        this.fTextField.selectAll();
        this.fTextField.requestFocusInWindow();
        this.fTextField.requestFocus();
        this.validate();
        this.repaint();
        this.fireEditStateChanged(EditState.EDITING);
    }

    public void cancelAndDisableEditor() {
        if (!this.isEditing()) {
            return;
        }
        this.fTextField.setText(this.fCurrentDisplayName);
        this.fLabel.setText(this.fCurrentDisplayName);
        this.fLabel.setToolTipText(this.fShowToolTip ? this.fCurrentDisplayName : null);
        this.remove((Component)this.fTextField);
        this.remove((Component)((Object)this.fLabel));
        this.add((Component)((Object)this.fLabel), "Center");
        this.validate();
        this.repaint();
        this.fireEditStateChanged(EditState.CANCELED);
    }

    public String saveAndDisableEditor() {
        if (!this.fIsAdjusting) {
            this.fIsAdjusting = true;
            if (this.fTextField.getText().length() == 0 && !this.fAllowBlanks) {
                this.cancelAndDisableEditor();
                this.fIsAdjusting = false;
                return this.fCurrentDisplayName;
            }
            String string = this.fCurrentDisplayName;
            this.fCurrentDisplayName = this.fTextField.getText();
            this.fLabel.setText(this.fCurrentDisplayName);
            this.fLabel.setToolTipText(this.fShowToolTip ? this.fCurrentDisplayName : null);
            this.remove((Component)((Object)this.fLabel));
            this.remove((Component)this.fTextField);
            this.add((Component)((Object)this.fLabel), "Center");
            this.validate();
            this.repaint();
            this.fIsAdjusting = false;
            this.fireEditStateChanged(EditState.SAVED);
            this.fireNameChangedEvent(string, this.fCurrentDisplayName);
            return string;
        }
        return this.fCurrentDisplayName;
    }

    public void edit() {
        if (this.fIsEditable) {
            this.enableEditor();
        }
    }

    public void setTemporarilySelected(boolean bl) {
        this.fTemporarilySelected = bl;
        this.fireTemporarySelectionChangedEvent();
        this.repaint();
    }

    public boolean isTemporarilySelected() {
        return this.fTemporarilySelected;
    }

    private void enableDescriptionEditor() {
        this.remove((Component)((Object)this.fDescriptionLabel));
        this.fDescription = this.fDescriptionLabel.getText();
        this.add((Component)this.fDescriptionTextField, "South");
        if (this.fBlankOnEdit) {
            this.fDescriptionTextField.setText("");
        } else {
            this.fDescriptionTextField.setText(this.fDescription);
        }
        this.fDescriptionTextField.selectAll();
        this.fDescriptionTextField.requestFocusInWindow();
        this.fDescriptionTextField.requestFocus();
        this.fireEditStateChanged(EditState.DESCRIPTION_EDITING);
    }

    private void cancelAndDisableDescriptionEditor() {
        this.fDescriptionTextField.setText(this.fDescription);
        this.fDescriptionLabel.setText(this.fDescription);
        this.remove((Component)this.fDescriptionTextField);
        this.add((Component)((Object)this.fDescriptionLabel), "South");
        this.validate();
        this.repaint();
        this.fireEditStateChanged(EditState.DESCRIPTION_CANCELED);
    }

    private String saveAndDisableDescriptionEditor() {
        if (!this.fIsAdjusting) {
            this.fIsAdjusting = true;
            if (this.fDescriptionTextField.getText().length() == 0 && !this.fAllowBlanks) {
                this.cancelAndDisableDescriptionEditor();
                this.fIsAdjusting = false;
                return this.fDescription;
            }
            String string = this.fDescription;
            this.fDescription = this.fDescriptionTextField.getText();
            this.fDescriptionLabel.setText(this.fDescription);
            this.remove((Component)this.fDescriptionTextField);
            this.add((Component)((Object)this.fDescriptionLabel), "South");
            this.validate();
            this.repaint();
            this.fIsAdjusting = false;
            this.fireEditStateChanged(EditState.DESCRIPTION_SAVED);
            this.fireDescriptionChangedEvent(string, this.fDescription);
            return string;
        }
        return this.fDescription;
    }

    public void editDescription() {
        this.enableDescriptionEditor();
    }

    private void fireSelectionChangedEvent() {
        for (int i = 0; i < this.fSelectionListeners.size(); ++i) {
            this.fSelectionListeners.get(i).selectionChanged(this);
        }
    }

    private void fireTemporarySelectionChangedEvent() {
        for (int i = 0; i < this.fSelectionListeners.size(); ++i) {
            this.fSelectionListeners.get(i).temporarySelectionChanged(this);
        }
    }

    private void fireNameChangedEvent(String string, String string2) {
        for (int i = 0; i < this.fNameListeners.size(); ++i) {
            this.fNameListeners.get(i).nameChanged(this, string, string2);
        }
    }

    private void fireDescriptionChangedEvent(String string, String string2) {
        for (int i = 0; i < this.fDescriptionListeners.size(); ++i) {
            this.fDescriptionListeners.get(i).descriptionChanged(this, string, string2);
        }
    }

    private void fireEditStateChanged(EditState editState) {
        for (int i = 0; i < this.fEditListeners.size(); ++i) {
            this.fEditListeners.get(i).editStateChanged(this, editState);
        }
    }

    public void addSelectionListener(EditablePopupListItemSelectionListener editablePopupListItemSelectionListener) {
        this.fSelectionListeners.add(editablePopupListItemSelectionListener);
    }

    public void removeSelectionListener(EditablePopupListItemSelectionListener editablePopupListItemSelectionListener) {
        this.fSelectionListeners.remove(editablePopupListItemSelectionListener);
    }

    public void addNameListener(EditablePopupListItemNameListener editablePopupListItemNameListener) {
        this.fNameListeners.add(editablePopupListItemNameListener);
    }

    public void removeNameListener(EditablePopupListItemNameListener editablePopupListItemNameListener) {
        this.fNameListeners.remove(editablePopupListItemNameListener);
    }

    public void addDescriptionListener(EditablePopupListItemDescriptionListener editablePopupListItemDescriptionListener) {
        this.fDescriptionListeners.add(editablePopupListItemDescriptionListener);
    }

    public void removeDescriptionListener(EditablePopupListItemDescriptionListener editablePopupListItemDescriptionListener) {
        this.fDescriptionListeners.remove(editablePopupListItemDescriptionListener);
    }

    public void addEditListener(EditablePopupListItemEditListener editablePopupListItemEditListener) {
        this.fEditListeners.add(editablePopupListItemEditListener);
    }

    public void removeEditListener(EditablePopupListItemEditListener editablePopupListItemEditListener) {
        this.fEditListeners.remove(editablePopupListItemEditListener);
    }

    public MJLabel getLabel() {
        return this.fLabel;
    }

    public MJLabel getDescriptionLabel() {
        return this.fDescriptionLabel;
    }

    public MJTextField getTextField() {
        return this.fTextField;
    }

    public MJTextField getDescriptionTextField() {
        return this.fDescriptionTextField;
    }

    public ITEM_TYPE getType() {
        return this.fType;
    }

    public void setType(ITEM_TYPE iTEM_TYPE) {
        this.fType = iTEM_TYPE;
    }

    public String getDisplayName() {
        return this.fCurrentDisplayName;
    }

    public void setDisplayName(String string) {
        String string2 = this.fCurrentDisplayName;
        this.fCurrentDisplayName = string;
        this.fLabel.setText(string);
        this.setToolTipText(this.fShowToolTip ? string : null);
        this.fLabel.setToolTipText(this.fShowToolTip ? string : null);
        this.fTextField.setText(string);
        this.setupSize();
        this.fireNameChangedEvent(string2, string);
    }

    public Object getValue() {
        return this.fValue;
    }

    public void setValue(Object object) {
        this.fValue = object;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public void setDescription(String string) {
        String string2 = this.fDescription;
        this.fDescription = string;
        this.fireDescriptionChangedEvent(string2, string);
        if (this.fDescription != null) {
            this.fDescriptionLabel = new EditablePopupListItemLabel(this.fDescription, null, 2);
            this.fDescriptionLabel.setToolTipText(string);
            this.setAllBackgrounds(this.fLabel != null ? this.fLabel.getBackground() : Color.WHITE);
            this.fDescriptionLabel.setForeground(DESCRIPTION_COLOR);
            this.fDescriptionLabel.setFont(DESCRIPTION_FONT);
            this.fDescriptionLabel.setOpaque(true);
            this.fDescriptionTextField = new MJTextField(this.fDescription);
            this.fDescriptionTextField.setEditable(true);
            this.fDescriptionTextField.setEnabled(true);
            this.fDescriptionTextField.setFocusable(true);
            this.fDescriptionTextField.setFont(DESCRIPTION_FONT);
            this.fDescriptionLabel.setName("ListItemDescriptionLabel");
            this.fDescriptionTextField.setName("ListItemDescriptionTextField");
            this.add((Component)((Object)this.fDescriptionLabel), "South");
            this.setupSize();
            this.fDescriptionLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (EditablePopupListItem.this.fDescriptionEditable) {
                        EditablePopupListItem.this.enableDescriptionEditor();
                    } else {
                        if (EditablePopupListItem.this.fIsSelected) {
                            EditablePopupListItem.this.fIsSelected = false;
                            if (EditablePopupListItem.this.fType == ITEM_TYPE.CHECKBOX) {
                                EditablePopupListItem.this.fLabel.setIcon(checkUnselected);
                            } else if (EditablePopupListItem.this.fType == ITEM_TYPE.PLAIN) {
                                EditablePopupListItem.this.setAllBackgrounds(Color.WHITE);
                            }
                        } else {
                            EditablePopupListItem.this.fIsSelected = true;
                            if (EditablePopupListItem.this.fType == ITEM_TYPE.CHECKBOX) {
                                EditablePopupListItem.this.fLabel.setIcon(checkSelected);
                            } else if (EditablePopupListItem.this.fType == ITEM_TYPE.RADIOBUTTON) {
                                EditablePopupListItem.this.fLabel.setIcon(radioSelected);
                            } else if (EditablePopupListItem.this.fType == ITEM_TYPE.PLAIN) {
                                EditablePopupListItem.this.setAllBackgrounds(SELECTED_PLAIN_COLOR);
                            }
                        }
                        EditablePopupListItem.this.fLabel.requestFocusInWindow();
                        if (EditablePopupListItem.this.fType != ITEM_TYPE.HEADER && EditablePopupListItem.this.fType != ITEM_TYPE.LINE_HEADER) {
                            EditablePopupListItem.this.fireSelectionChangedEvent();
                        }
                    }
                    EditablePopupListItem.this.validate();
                    EditablePopupListItem.this.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    if (!EditablePopupListItem.this.fWaitCursorEnabled) {
                        if (EditablePopupListItem.this.fDescriptionEditable && mouseEvent.getPoint().x > radioSelected.getIconWidth()) {
                            EditablePopupListItem.this.setCursor(EDIT_CURSOR);
                            if (EditablePopupListItem.this.fDefaultColor == null) {
                                EditablePopupListItem.this.fDefaultColor = EditablePopupListItem.this.fDescriptionLabel.getBackground();
                            }
                            EditablePopupListItem.this.fDescriptionLabel.setBackground(EditablePopupListItem.this.fDefaultColor == Color.WHITE ? Color.LIGHT_GRAY : Color.WHITE);
                            EditablePopupListItem.this.fDescriptionLabel.repaint();
                        } else {
                            EditablePopupListItem.this.setCursor(DEFAULT_CURSOR);
                        }
                    } else {
                        EditablePopupListItem.this.setCursor(WAIT_CURSOR);
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (EditablePopupListItem.this.fDefaultColor == null) {
                        EditablePopupListItem.this.fDefaultColor = EditablePopupListItem.this.fDescriptionLabel.getBackground();
                    }
                    EditablePopupListItem.this.fDescriptionLabel.setBackground(EditablePopupListItem.this.fDefaultColor);
                    if (!EditablePopupListItem.this.fWaitCursorEnabled) {
                        EditablePopupListItem.this.setCursor(DEFAULT_CURSOR);
                    } else {
                        EditablePopupListItem.this.setCursor(WAIT_CURSOR);
                    }
                    EditablePopupListItem.this.fDescriptionLabel.repaint();
                }
            });
            this.fDescriptionTextField.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 27) {
                        EditablePopupListItem.this.cancelAndDisableDescriptionEditor();
                        EditablePopupListItem.this.fireDescriptionChangedEvent(EditablePopupListItem.this.fDescription, EditablePopupListItem.this.fDescription);
                    } else if (keyEvent.getKeyCode() == 10) {
                        String string = EditablePopupListItem.this.saveAndDisableDescriptionEditor();
                    }
                }
            });
            this.fDescriptionTextField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = EditablePopupListItem.this.saveAndDisableDescriptionEditor();
                }
            });
            this.fDescriptionTextField.addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    String string = EditablePopupListItem.this.saveAndDisableDescriptionEditor();
                }
            });
        } else {
            if (this.fDescriptionLabel != null) {
                this.remove((Component)((Object)this.fDescriptionLabel));
            }
            if (this.fDescriptionTextField != null) {
                this.remove((Component)this.fDescriptionTextField);
            }
            this.fDescriptionLabel = null;
            this.fDescriptionTextField = null;
        }
        this.validate();
        this.repaint();
    }

    private void setupSize() {
        int n = 0;
        int n2 = 0;
        if (this.fDescription != null && this.fDescriptionLabel != null && this.fDescriptionTextField != null) {
            n = this.fDescriptionLabel.getPreferredSize().width;
            n2 = this.fDescriptionLabel.getPreferredSize().height;
            if (this.fDescriptionEditable) {
                n = this.fDescriptionTextField.getPreferredSize().width;
                n2 = this.fDescriptionTextField.getPreferredSize().height;
            }
        }
        int n3 = Math.max(this.getPreferredSize().width, Math.max(this.fLabel.getPreferredSize().width, n));
        int n4 = this.fLabel.getPreferredSize().height + n2;
        if (this.fIsEditable) {
            n3 = Math.max(this.getPreferredSize().width, Math.max(this.fTextField.getPreferredSize().width, n));
            n4 = this.fTextField.getPreferredSize().height + n2;
        }
        this.setPreferredSize(new Dimension(n3, n4));
    }

    public boolean isEditable() {
        return this.fIsEditable;
    }

    public void setEditable(boolean bl) {
        this.fIsEditable = bl & (this.fType != ITEM_TYPE.HEADER && this.fType != ITEM_TYPE.LINE_HEADER);
    }

    public boolean isDescriptionEditable() {
        return this.fDescriptionEditable;
    }

    public void setDescriptionEditable(boolean bl) {
        this.fDescriptionEditable = bl;
    }

    public boolean isSelected() {
        if (this.fType == ITEM_TYPE.HEADER || this.fType == ITEM_TYPE.LINE_HEADER) {
            return false;
        }
        return this.fIsSelected;
    }

    public void setSelected(boolean bl) {
        this.fIsSelected = bl;
        if (!this.fIsSelected) {
            if (this.fType == ITEM_TYPE.CHECKBOX) {
                this.fLabel.setIcon(checkUnselected);
            } else if (this.fType == ITEM_TYPE.RADIOBUTTON) {
                this.fLabel.setIcon(radioUnselected);
            } else if (this.fType == ITEM_TYPE.PLAIN) {
                this.setAllBackgrounds(Color.WHITE);
            }
        } else if (this.fType == ITEM_TYPE.CHECKBOX) {
            this.fLabel.setIcon(checkSelected);
        } else if (this.fType == ITEM_TYPE.RADIOBUTTON) {
            this.fLabel.setIcon(radioSelected);
        } else if (this.fType == ITEM_TYPE.PLAIN) {
            this.setAllBackgrounds(SELECTED_PLAIN_COLOR);
        }
        this.fireSelectionChangedEvent();
    }

    private void setAllBackgrounds(Color color) {
        this.setBackground(color);
        if (this.fLabel != null) {
            this.fLabel.setBackground(color);
        }
        if (this.fDescriptionLabel != null) {
            this.fDescriptionLabel.setBackground(color);
        }
    }

    public boolean getAllowBlanks() {
        return this.fAllowBlanks;
    }

    public void setAllowBlanks(boolean bl) {
        this.fAllowBlanks = bl;
    }

    public boolean getBlankOnEdit() {
        return this.fBlankOnEdit;
    }

    public void setBlankOnEdit(boolean bl) {
        this.fBlankOnEdit = bl;
    }

    public void setEditText(String string) {
        this.fTextField.setText(string);
        this.fTextField.repaint();
    }

    public void setDescriptionEditText(String string) {
        this.fDescriptionTextField.setText(string);
        this.fDescriptionTextField.repaint();
    }

    static ImageIcon getResourceIcon(String string) {
        return new ImageIcon(ImportToolUtils.class.getResource("/com/mathworks/toolstrip/resources/" + string));
    }

    public Component getActionComponent() {
        return this.fActionComponent;
    }

    public void setActionComponent(Component component) {
        if (this.fActionComponent != null) {
            this.remove(this.fActionComponent);
            this.fActionComponent.removeMouseListener(this.fActionMouseAdapter);
        }
        this.fActionComponent = component;
        if (this.fActionComponent != null) {
            this.add(this.fActionComponent, "East");
            this.fActionComponent.addMouseListener(this.fActionMouseAdapter);
        }
        this.validate();
        this.repaint();
    }

    public boolean hasFocus() {
        boolean bl = super.hasFocus();
        bl |= this.fLabel.hasFocus();
        return bl |= this.fTextField.hasFocus();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public boolean isHighlightOnHoverEnabled() {
        return this.fHighlightOnHoverEnabled;
    }

    public void setHighlightOnHoverEnabled(boolean bl) {
        this.fHighlightOnHoverEnabled = bl;
    }

    public void setWaitCursorEnabled(boolean bl) {
        this.fWaitCursorEnabled = bl;
        if (this.fWaitCursorEnabled) {
            this.setCursor(WAIT_CURSOR);
        } else {
            this.setCursor(null);
        }
    }

    public boolean isWaitCursorEnabled() {
        return this.fWaitCursorEnabled;
    }

    public boolean equals(Object object) {
        if (object instanceof EditablePopupListItem) {
            EditablePopupListItem editablePopupListItem = (EditablePopupListItem)((Object)object);
            return editablePopupListItem.getDisplayName().equals(this.getDisplayName()) && (editablePopupListItem.getValue() == null && this.getValue() == null || editablePopupListItem.getValue().equals(this.getValue()));
        }
        if (object instanceof String) {
            String string = (String)object;
            return this.getDisplayName() != null && this.getDisplayName().equals(string) || this.getValue() != null && this.getValue().toString().equals(string);
        }
        if (this.getValue() != null) {
            return this.getValue().equals(object);
        }
        return false;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.fLabel.setEnabled(bl);
        this.fTextField.setEnabled(bl);
        if (this.fDescriptionLabel != null) {
            this.fDescriptionLabel.setEnabled(bl);
        }
        if (this.fDescriptionTextField != null) {
            this.fDescriptionTextField.setEnabled(bl);
        }
    }

    public void disableToolTips() {
        this.fShowToolTip = false;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.fTemporarilySelected && !this.fIsEditable && this.fHighlightOnHoverEnabled && this.fType != ITEM_TYPE.HEADER && this.fType != ITEM_TYPE.LINE_HEADER) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getWidth();
            int n2 = this.getHeight();
            graphics2D.setColor(TEMPORARY_SELECTED_COLOR);
            graphics2D.fillRect(0, 0, n, n2);
        }
    }

    private class EditablePopupListItemLabel
    extends MJLabel {
        public EditablePopupListItemLabel(String string, Icon icon, int n) {
            super(string, icon, n);
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (EditablePopupListItem.this.fType == ITEM_TYPE.HEADER) {
                graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, new Color(42, 93, 147), 0.0f, n2, new Color(9, 58, 111)));
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.setColor(DEFAULT_BLUE);
                graphics2D.drawLine(0, n2 - 1, n, n2 - 1);
                this.setOpaque(false);
                super.paintComponent(graphics);
                this.setOpaque(true);
            } else if (EditablePopupListItem.this.fType == ITEM_TYPE.LINE_HEADER) {
                graphics2D.setColor(this.getBackground());
                graphics2D.fillRect(0, 0, n, n2);
                graphics2D.setColor(this.getForeground());
                graphics2D.setFont(this.getFont());
                int n3 = this.getFontMetrics(this.getFont()).getHeight();
                int n4 = this.getFontMetrics(this.getFont()).stringWidth(this.getText());
                graphics2D.drawString(this.getText(), 5, n2 / 2 + (n2 - n3) / 4);
                graphics2D.drawLine(10 + n4, n2 / 2, n - 5, n2 / 2);
            } else {
                graphics.setFont(this.getFont());
                super.paintComponent(graphics);
                if (EditablePopupListItem.this.fTemporarilySelected && !EditablePopupListItem.this.fIsEditable && EditablePopupListItem.this.fHighlightOnHoverEnabled) {
                    graphics2D.setColor(TEMPORARY_SELECTED_COLOR);
                    graphics2D.fillRect(0, 0, n, n2);
                }
            }
        }
    }

    public static interface EditablePopupListItemEditListener {
        public void editStateChanged(EditablePopupListItem var1, EditState var2);
    }

    public static enum EditState {
        EDITING,
        SAVED,
        CANCELED,
        DESCRIPTION_EDITING,
        DESCRIPTION_SAVED,
        DESCRIPTION_CANCELED;

    }

    public static interface EditablePopupListItemDescriptionListener {
        public void descriptionChanged(EditablePopupListItem var1, String var2, String var3);
    }

    public static interface EditablePopupListItemNameListener {
        public void nameChanged(EditablePopupListItem var1, String var2, String var3);
    }

    public static interface EditablePopupListItemSelectionListener {
        public void selectionChanged(EditablePopupListItem var1);

        public void temporarySelectionChanged(EditablePopupListItem var1);
    }

    public static enum ITEM_TYPE {
        PLAIN,
        CHECKBOX,
        RADIOBUTTON,
        HEADER,
        LINE_HEADER;

    }
}

