/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.NativeMatlab;
import com.mathworks.mlwidgets.inspector.IPropertyTreeTableNode;
import com.mathworks.mlwidgets.inspector.PropertyRootNode;
import com.mathworks.mlwidgets.inspector.PropertyTarget;
import com.mathworks.mlwidgets.inspector.PropertyView;
import com.mathworks.mlwidgets.inspector.TreeTableModelUpdateListener;
import com.mathworks.mwswing.AbstractTreeTableModel;
import com.mathworks.mwswing.TreeTableModel;
import com.mathworks.services.ObjectRegistry;
import java.util.EventListener;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public final class PropertyTreeTableModel
extends AbstractTreeTableModel
implements TreeTableModel {
    private static String[] cNames = new String[]{"Property", "Value"};
    private static Class[] cTypes = new Class[]{TreeTableModel.class, IPropertyTreeTableNode.class};
    private IPropertyTreeTableNode fRootNode;
    private PropertyTarget fTarget;
    private JTable fView;
    private ObjectRegistry fRegistry;
    private EventListenerList fListenerList = new EventListenerList();

    public PropertyTreeTableModel(ObjectRegistry objectRegistry) {
        super(null);
        this.fRegistry = objectRegistry;
        assert (this.fRegistry != null);
    }

    void doRefresh() {
        if (this.fRootNode instanceof PropertyRootNode) {
            ((PropertyRootNode)this.fRootNode).refresh();
        }
    }

    void removeListeners() {
        if (this.fRootNode instanceof PropertyRootNode) {
            ((PropertyRootNode)this.fRootNode).removeListeners();
        }
    }

    String getRenderedTextForTesting(String string) {
        if (this.fRootNode instanceof PropertyRootNode) {
            return ((PropertyRootNode)this.fRootNode).getRenderedTextForTesting(string);
        }
        return null;
    }

    public void addInspectorUpdateListener(TreeTableModelUpdateListener treeTableModelUpdateListener) {
        this.fListenerList.add(TreeTableModelUpdateListener.class, treeTableModelUpdateListener);
    }

    public void fireTreeTableUpdateEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PropertyView.DEBUG) {
                    System.out.println("PropertyTreeTableModel: fireTreeTableUpdateEvent: " + PropertyView.debugGetSeconds());
                }
                EventListener[] eventListenerArray = PropertyTreeTableModel.this.fListenerList.getListeners(TreeTableModelUpdateListener.class);
                for (int i = 0; i < eventListenerArray.length; ++i) {
                    ((TreeTableModelUpdateListener)eventListenerArray[i]).treeTableUpdated();
                }
            }
        });
    }

    private ObjectRegistry getRegistry() {
        return this.fRegistry;
    }

    boolean targetHasPropertyGroups() {
        if (this.fRootNode != null) {
            return ((PropertyRootNode)this.fRootNode).targetHasPropertyGroups();
        }
        return false;
    }

    void setObjects_MatlabThread(JTable jTable, Object[] objectArray) {
        assert (NativeMatlab.nativeIsMatlabThread());
        this.fView = jTable;
        PropertyTreeTableModel propertyTreeTableModel = this;
        if (PropertyView.DEBUG) {
            System.out.println("PropertyTreeTableModel: setObjects_MatlabThread: " + PropertyView.debugGetSeconds());
        }
        this.fRootNode = new PropertyRootNode(propertyTreeTableModel, jTable, this.getRegistry(), objectArray);
        propertyTreeTableModel.setRoot(this.fRootNode);
    }

    void setObjects_AnyThread(final JTable jTable, final Object[] objectArray) {
        if (NativeMatlab.nativeIsMatlabThread()) {
            this.setObjects_MatlabThread(jTable, objectArray);
        } else {
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    PropertyTreeTableModel.this.setObjects_MatlabThread(jTable, objectArray);
                }
            });
        }
    }

    void refreshValues_MatlabThread() {
        if (this.fRootNode != null) {
            this.fRootNode.refreshChildren_MatlabThread();
        }
    }

    public int getChildCount(Object object) {
        Object[] objectArray = this.getChildren(object);
        return objectArray == null ? 0 : objectArray.length;
    }

    public Object getChild(Object object, int n) {
        Object[] objectArray = this.getChildren(object);
        if (objectArray != null) {
            return objectArray[n];
        }
        return null;
    }

    private Object[] getChildren(Object object) {
        Object[] objectArray = null;
        assert (SwingUtilities.isEventDispatchThread());
        if (object instanceof IPropertyTreeTableNode) {
            final IPropertyTreeTableNode iPropertyTreeTableNode = (IPropertyTreeTableNode)object;
            if (iPropertyTreeTableNode.hasQueriedChildren()) {
                return iPropertyTreeTableNode.getChildren();
            }
            Matlab.whenMatlabIdle((Runnable)new Runnable(){

                @Override
                public void run() {
                    iPropertyTreeTableNode.loadChildrenMatlabThread();
                    PropertyTreeTableModel.this.fireTreeTableUpdateEvent();
                }
            });
        }
        return objectArray;
    }

    public boolean isLeaf(Object object) {
        return ((IPropertyTreeTableNode)object).isLeaf();
    }

    public int getColumnCount() {
        return cNames.length;
    }

    public String getColumnName(int n) {
        return cNames[n];
    }

    public Class getColumnClass(int n) {
        return cTypes[n];
    }

    public Object getValueAt(Object object, int n) {
        if (n == 0) {
            return ((IPropertyTreeTableNode)object).getName();
        }
        return object;
    }
}

