/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.prefs.FontPrefsPanel;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.services.AntialiasedFontPrefs;
import com.mathworks.services.FontPrefs;
import com.mathworks.widgets.fonts.FontPicker;
import com.mathworks.widgets.fonts.FontSamplePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontCustomPrefsPanel
extends MJPanel {
    private static FontCustomPrefsPanel sPrefsPanel = null;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private MJList fComponentList;
    private MJRadioButton fCodeButton;
    private MJRadioButton fTextButton;
    private MJRadioButton fCustomButton;
    private Vector<FontPrefs.FontItem> fFontItems;
    private FontPicker fCustomFontPicker;
    private FontSamplePanel fSamplePanel;
    private boolean fSomebodysFontChanged = false;

    public FontCustomPrefsPanel(Dimension dimension) {
        FontPrefs.FontItem fontItem2;
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(BUNDLE.getString("cfp.explanation"), true);
        mJMultilineLabel.setBorder((Border)new EmptyBorder(0, 4, 0, 0));
        mJMultilineLabel.setMaxWidth(dimension.width);
        mJMultilineLabel.getAccessibleContext().setAccessibleName(BUNDLE.getString("cfp.acc.explanation"));
        this.setName("FontCustomPrefsPanel");
        List list = FontPrefs.getRegisteredComponents();
        this.fFontItems = new Vector();
        for (FontPrefs.FontItem fontItem2 : list) {
            this.fFontItems.add(new FontPrefs.FontItem(fontItem2.getComponentName(), fontItem2.getPrefsTag(), fontItem2.getFontType(), fontItem2.getCustomFont()));
        }
        this.fComponentList = new MJList(this.fFontItems);
        this.fComponentList.setSelectionMode(0);
        this.fComponentList.addListSelectionListener((ListSelectionListener)new ComponentListSelectionListener());
        this.fComponentList.getAccessibleContext().setAccessibleName(BUNDLE.getString("cfp.acc.componentList"));
        this.fComponentList.setName("customComponentList");
        JScrollPane jScrollPane = new JScrollPane((Component)this.fComponentList);
        fontItem2 = new MJPanel((LayoutManager)new BorderLayout());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BUNDLE.getString("cfp.desktop_tools"));
        fontItem2.setBorder((Border)titledBorder);
        fontItem2.add((Component)jScrollPane, (Object)"Center");
        this.fCodeButton = new MJRadioButton(BUNDLE.getString("cfp.code"));
        this.fCodeButton.setName("customDesktopCode");
        this.fTextButton = new MJRadioButton(BUNDLE.getString("cfp.text"));
        this.fTextButton.setName("customDesktopText");
        this.fCustomButton = new MJRadioButton(BUNDLE.getString("cfp.custom"));
        this.fCustomButton.setName("Custom");
        FontTypeItemListener fontTypeItemListener = new FontTypeItemListener();
        this.fCodeButton.addItemListener((ItemListener)fontTypeItemListener);
        this.fTextButton.addItemListener((ItemListener)fontTypeItemListener);
        this.fCustomButton.addItemListener((ItemListener)fontTypeItemListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.fCodeButton);
        buttonGroup.add((AbstractButton)this.fTextButton);
        buttonGroup.add((AbstractButton)this.fCustomButton);
        MJPanel mJPanel = new MJPanel((LayoutManager)new MGridLayout(4, 1, 8, 8, 131072));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(BUNDLE.getString("cfp.font_to_use"));
        mJPanel.setBorder((Border)titledBorder2);
        mJPanel.add((Component)this.fCodeButton);
        mJPanel.add((Component)this.fTextButton);
        mJPanel.add((Component)this.fCustomButton);
        this.fCustomFontPicker = new FontPicker(new Font("SansSerif", 0, 10), FontPicker.Layout.COMPACT);
        this.fCustomFontPicker.setNamesWithPrefix("custom");
        CustomFontTypeListener customFontTypeListener = new CustomFontTypeListener();
        this.fCustomFontPicker.addItemListener((ItemListener)customFontTypeListener);
        mJPanel.add((Component)this.fCustomFontPicker.getComponent());
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel2.add((Component)fontItem2, (Object)"Center");
        mJPanel2.add((Component)mJPanel, (Object)"East");
        this.fSamplePanel = new FontSamplePanel();
        this.fSamplePanel.setLabelName("customSampleText");
        this.enableCustomFontPicker(false, FontPrefs.getTextFont());
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel3.add((Component)mJPanel2, (Object)"Center");
        mJPanel3.add((Component)this.fSamplePanel.getPanel(), (Object)"South");
        this.setLayout((LayoutManager)new MGridLayout(2, 1, 8, 8, 131072));
        this.add((Component)mJMultilineLabel, "North");
        this.add((Component)mJPanel3, "Center");
        if (this.fComponentList.getComponentCount() > 0) {
            this.fComponentList.setSelectedIndex(0);
        }
    }

    private static void notifyFontPrefsPanel() {
        FontPrefsPanel fontPrefsPanel = FontPrefsPanel.getPanel();
        if (fontPrefsPanel != null) {
            fontPrefsPanel.setFontLabels();
        }
    }

    private void setSampleAntialiasedProperty() {
        FontPrefsPanel fontPrefsPanel = FontPrefsPanel.getPanel();
        if (fontPrefsPanel != null) {
            this.fSamplePanel.setAntialiased(fontPrefsPanel.isAntialiasedCheckboxOn());
        } else {
            this.fSamplePanel.setAntialiased(AntialiasedFontPrefs.isDesktopFontAntialiased());
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setSampleAntialiasedProperty();
        }
        super.setVisible(bl);
    }

    private void enableCustomFontPicker(boolean bl, Font font) {
        this.fCustomFontPicker.setEnabled(bl);
        this.fCustomFontPicker.setSelectedFont(font);
        this.fSamplePanel.setSampleFont(font);
    }

    public static MJPanel createPrefsPanel(Dimension dimension) {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sPrefsPanel = new FontCustomPrefsPanel(dimension);
        return sPrefsPanel;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            sPrefsPanel.saveOptions();
        }
    }

    private void saveOptions() {
        FontPrefs.saveCustomFonts(this.fFontItems);
        if (this.fSomebodysFontChanged) {
            FontCustomPrefsPanel.notifyFontPrefsPanel();
        }
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_customfonts_prefs"};
    }

    private class ComponentListSelectionListener
    implements ListSelectionListener {
        private ComponentListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object object = FontCustomPrefsPanel.this.fComponentList.getSelectedValue();
            if (object instanceof FontPrefs.FontItem) {
                FontPrefs.FontItem fontItem = (FontPrefs.FontItem)object;
                if (fontItem.getFontType() == FontPrefs.FontType.CODE) {
                    FontCustomPrefsPanel.this.fCodeButton.setSelected(true);
                } else if (fontItem.getFontType() == FontPrefs.FontType.TEXT) {
                    FontCustomPrefsPanel.this.fTextButton.setSelected(true);
                } else if (fontItem.getFontType() == FontPrefs.FontType.CUSTOM) {
                    FontCustomPrefsPanel.this.enableCustomFontPicker(true, fontItem.getCustomFont());
                    FontCustomPrefsPanel.this.fCustomButton.setSelected(true);
                }
            }
        }
    }

    private class CustomFontTypeListener
    implements ItemListener {
        private CustomFontTypeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = FontCustomPrefsPanel.this.fComponentList.getSelectedValue();
            if (object instanceof FontPrefs.FontItem && FontCustomPrefsPanel.this.fCustomButton.isSelected()) {
                FontPrefs.FontItem fontItem = (FontPrefs.FontItem)object;
                Font font = FontCustomPrefsPanel.this.fCustomFontPicker.getSelectedFont();
                fontItem.setFontType(FontPrefs.FontType.CUSTOM);
                fontItem.setCustomFont(font);
                FontCustomPrefsPanel.this.enableCustomFontPicker(true, fontItem.getCustomFont());
            }
        }
    }

    private class FontTypeItemListener
    implements ItemListener {
        private FontTypeItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = FontCustomPrefsPanel.this.fComponentList.getSelectedValue();
            if (object instanceof FontPrefs.FontItem) {
                FontPrefs.FontItem fontItem = (FontPrefs.FontItem)object;
                if (FontCustomPrefsPanel.this.fCodeButton.isSelected()) {
                    fontItem.setFontType(FontPrefs.FontType.CODE);
                    FontCustomPrefsPanel.this.enableCustomFontPicker(false, FontPrefs.getCodeFont());
                    FontCustomPrefsPanel.this.fSomebodysFontChanged = true;
                } else if (FontCustomPrefsPanel.this.fTextButton.isSelected()) {
                    fontItem.setFontType(FontPrefs.FontType.TEXT);
                    FontCustomPrefsPanel.this.enableCustomFontPicker(false, FontPrefs.getTextFont());
                    FontCustomPrefsPanel.this.fSomebodysFontChanged = true;
                } else if (FontCustomPrefsPanel.this.fCustomButton.isSelected()) {
                    fontItem.setFontType(FontPrefs.FontType.CUSTOM);
                    FontCustomPrefsPanel.this.enableCustomFontPicker(true, fontItem.getCustomFont());
                }
            }
        }
    }
}

