/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.services.AntialiasedFontPrefs;
import com.mathworks.services.FontPrefs;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.fonts.FontPicker;
import com.mathworks.widgets.prefs.PrefsEditorPanelV1;
import com.mathworks.widgets.prefs.PrefsHelp;
import com.mathworks.widgets.prefs.PrefsNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class FontPrefsPanel
extends MJPanel
implements PrefsEditorPanelV1 {
    private static FontPrefsPanel sPrefsPanel = null;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private FontPicker fCodeFontPicker;
    private FontPicker fTextFontPicker;
    private MJMultilineLabel fCodeFontLabel;
    private MJMultilineLabel fTextFontLabel;
    private MJMultilineLabel fCustomFontLabel;
    private MJCheckBox fSystemCheckbox;
    private MJCheckBox fAntialiasedFontCheckbox;
    private Font fTextFont;

    static FontPrefsPanel getPanel() {
        return sPrefsPanel;
    }

    public static void setPanel(FontPrefsPanel fontPrefsPanel) {
        sPrefsPanel = fontPrefsPanel;
    }

    private static String getFontLabel(FontPrefs.FontType fontType) {
        String string = FontPrefs.getComponentsUsingDesktopFont((FontPrefs.FontType)fontType);
        if (string.length() != 0) {
            Object[] objectArray = new Object[]{string};
            return MessageFormat.format(BUNDLE.getString("tlfp.font_explanation"), objectArray);
        }
        if (fontType == FontPrefs.FontType.CUSTOM) {
            return BUNDLE.getString("tlfp.no_custom");
        }
        return BUNDLE.getString("tlfp.none");
    }

    void setFontLabels() {
        this.fCodeFontLabel.setText(FontPrefsPanel.getFontLabel(FontPrefs.FontType.CODE));
        this.fTextFontLabel.setText(FontPrefsPanel.getFontLabel(FontPrefs.FontType.TEXT));
        this.fCustomFontLabel.setText(FontPrefsPanel.getFontLabel(FontPrefs.FontType.CUSTOM));
    }

    boolean isAntialiasedCheckboxOn() {
        boolean bl = false;
        if (this.fAntialiasedFontCheckbox != null) {
            bl = this.fAntialiasedFontCheckbox.isSelected();
        }
        return bl;
    }

    public FontPrefsPanel(Dimension dimension) {
        boolean bl;
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout(3, 3));
        this.setName("FontPrefsPanel");
        mJPanel.setBorder((Border)BorderFactory.createTitledBorder(BUNDLE.getString("tlfp.code_font")));
        Insets insets = mJPanel.getInsets();
        this.fCodeFontLabel = new MJMultilineLabel(FontPrefsPanel.getFontLabel(FontPrefs.FontType.CODE), true);
        this.fCodeFontLabel.getAccessibleContext().setAccessibleName(BUNDLE.getString("tlfp.acc.codeComponents"));
        this.fCodeFontLabel.setBorder((Border)new EmptyBorder(0, 2, 0, 0));
        this.fCodeFontLabel.setMaxWidth(dimension.width - (insets.left + insets.right));
        mJPanel.add((Component)this.fCodeFontLabel, (Object)"North");
        this.fCodeFontPicker = new FontPicker(FontPrefs.getCodeFont(), FontPicker.Layout.WIDE_WITH_SAMPLE);
        this.fCodeFontPicker.setNamesWithPrefix("code");
        mJPanel.add((Component)this.fCodeFontPicker.getComponent(), (Object)"Center");
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new BorderLayout(3, 3));
        mJPanel2.setBorder((Border)BorderFactory.createTitledBorder(BUNDLE.getString("tlfp.text_font")));
        this.fTextFontLabel = new MJMultilineLabel(FontPrefsPanel.getFontLabel(FontPrefs.FontType.TEXT), true);
        this.fTextFontLabel.getAccessibleContext().setAccessibleName(BUNDLE.getString("tlfp.acc.textComponents"));
        this.fTextFontLabel.setBorder((Border)new EmptyBorder(0, 2, 0, 0));
        this.fTextFontLabel.setMaxWidth(dimension.width - (insets.left + insets.right));
        mJPanel2.add((Component)this.fTextFontLabel, (Object)"North");
        this.fTextFont = FontPrefs.getTextFont();
        this.fSystemCheckbox = new MJCheckBox(BUNDLE.getString("tlfp.checkbox.sysfont"), FontPrefs.isTextFontSystemFont());
        this.fSystemCheckbox.setName("UseSystemFontCheckbox");
        this.fSystemCheckbox.addItemListener((ItemListener)new SystemCheckboxListener());
        mJPanel2.add((Component)this.fSystemCheckbox, (Object)"Center");
        this.fTextFontPicker = new FontPicker(this.fTextFont, FontPicker.Layout.WIDE_WITH_SAMPLE);
        this.fTextFontPicker.setNamesWithPrefix("text");
        this.fTextFontPicker.setEnabled(!this.fSystemCheckbox.isSelected());
        mJPanel2.add((Component)this.fTextFontPicker.getComponent(), (Object)"South");
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout(3, 3));
        mJPanel3.setBorder((Border)BorderFactory.createTitledBorder(BUNDLE.getString("tlfp.hb_font")));
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(BUNDLE.getString("tlfp.hb_explanation"), true);
        mJMultilineLabel.getAccessibleContext().setAccessibleName(BUNDLE.getString("tlfp.acc.hb_explanation"));
        mJMultilineLabel.setBorder((Border)new EmptyBorder(0, 2, 0, 0));
        mJMultilineLabel.setMaxWidth(dimension.width - (insets.left + insets.right));
        mJPanel3.add((Component)mJMultilineLabel, (Object)"North");
        MJPanel mJPanel4 = new MJPanel((LayoutManager)new BorderLayout(3, 3));
        mJPanel4.setBorder((Border)BorderFactory.createTitledBorder(BUNDLE.getString("tlfp.custom_font")));
        Insets insets2 = mJPanel4.getInsets();
        this.fCustomFontLabel = new MJMultilineLabel(FontPrefsPanel.getFontLabel(FontPrefs.FontType.CUSTOM), true);
        this.fCustomFontLabel.getAccessibleContext().setAccessibleName(BUNDLE.getString("tlfp.acc.customComponents"));
        this.fCustomFontLabel.setBorder((Border)new EmptyBorder(0, 2, 0, 0));
        this.fCustomFontLabel.setMaxWidth(dimension.width - (insets2.left + insets2.right));
        mJPanel4.add((Component)this.fCustomFontLabel, (Object)"North");
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(BUNDLE.getString("tlfp.custom_explanation"), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                MLPrefsDialogServices.showPrefsDialog((String)(BUNDLE.getString("area.fonts") + "." + BUNDLE.getString("area.fontscustom")));
            }
        });
        hyperlinkTextLabel.setMargin(new Insets(3, 3, 3, 3));
        mJPanel4.add((Component)hyperlinkTextLabel.getComponent(), (Object)"Center");
        this.setLayout((LayoutManager)new MGridLayout(0, 1, 2, 2, 131072));
        this.add((Component)mJPanel);
        this.add((Component)mJPanel2);
        this.add((Component)mJPanel3);
        this.add((Component)mJPanel4);
        boolean bl2 = bl = !AntialiasedFontPrefs.isJavaUsingSystemAntialiasing();
        if (bl) {
            boolean bl3 = AntialiasedFontPrefs.isDesktopFontAntialiased();
            this.fAntialiasedFontCheckbox = new MJCheckBox(BUNDLE.getString("tlfp.checkbox.aa"), bl3);
            this.fAntialiasedFontCheckbox.setName("AntialiasedFont");
            this.fTextFontPicker.setSampleAntialiased(bl3);
            this.fCodeFontPicker.setSampleAntialiased(bl3);
            this.fAntialiasedFontCheckbox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    boolean bl = FontPrefsPanel.this.fAntialiasedFontCheckbox.isSelected();
                    FontPrefsPanel.this.fTextFontPicker.setSampleAntialiased(bl);
                    FontPrefsPanel.this.fCodeFontPicker.setSampleAntialiased(bl);
                }
            });
            MJPanel mJPanel5 = new MJPanel();
            mJPanel5.setLayout((LayoutManager)new BorderLayout(3, 3));
            mJPanel5.setBorder((Border)new EmptyBorder(0, 2, 0, 0));
            mJPanel5.add((Component)this.fAntialiasedFontCheckbox, (Object)"West");
            this.add((Component)mJPanel5);
        }
        FontPrefsPanel.setPanel(this);
    }

    public static MJPanel createPrefsPanel(Dimension dimension) {
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        FontPrefsPanel.setPanel(new FontPrefsPanel(dimension));
        return FontPrefsPanel.getPanel();
    }

    public void commitChanges(PrefsNode prefsNode) {
        this.saveOptions();
    }

    public boolean validateChanges(PrefsNode prefsNode) {
        return true;
    }

    public void cancelChanges(PrefsNode prefsNode) {
    }

    public boolean canDetectPendingEdits(PrefsNode prefsNode) {
        return false;
    }

    public boolean hasPendingEdits(PrefsNode prefsNode) {
        throw new UnsupportedOperationException();
    }

    public JComponent getComponent(PrefsNode prefsNode) {
        return this;
    }

    private void saveOptions() {
        if (this.fAntialiasedFontCheckbox != null && AntialiasedFontPrefs.isDesktopFontAntialiased() != this.fAntialiasedFontCheckbox.isSelected()) {
            AntialiasedFontPrefs.setDesktopFontAntialiased((boolean)this.fAntialiasedFontCheckbox.isSelected());
        }
        FontPrefs.setTextUseSystemFont((boolean)this.fSystemCheckbox.isSelected());
        FontPrefs.setCodeFont((Font)this.fCodeFontPicker.getSelectedFont());
        FontPrefs.setTextFont((Font)this.fTextFontPicker.getSelectedFont());
    }

    public PrefsHelp getHelp() {
        return new PrefsHelp(MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_fonts_prefs");
    }

    public void doHelp() {
        PrefsHelp prefsHelp = this.getHelp();
        MLHelpServices.displayTopic((String)prefsHelp.getHelpMapPath(), (String)prefsHelp.getHelpTopicKey());
    }

    public void dispose() {
    }

    private class SystemCheckboxListener
    implements ItemListener {
        private SystemCheckboxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            boolean bl = FontPrefsPanel.this.fSystemCheckbox.isSelected();
            FontPrefsPanel.this.fTextFontPicker.setEnabled(!bl);
            if (bl) {
                Font font = FontUtils.getSystemUIFont();
                FontPrefsPanel.this.fTextFont = FontPrefsPanel.this.fTextFontPicker.getSelectedFont();
                FontPrefsPanel.this.fTextFontPicker.setSelectedFont(font);
            } else {
                FontPrefsPanel.this.fTextFontPicker.setSelectedFont(FontPrefsPanel.this.fTextFont);
            }
        }
    }
}

