/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs;

import com.mathworks.matlab.api.editor.SyntaxHighlightingColor;
import com.mathworks.mlwidgets.prefs.ColorItem;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.color.ColorPicker;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

public class SyntaxHighlightingColorPanel
extends MJPanel {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private int fNumEntries = 0;
    private final List<ColorItem<?>> fColorVector = new Vector();
    private final MJPanel fColorPickersPanel = new MJPanel();

    public SyntaxHighlightingColorPanel(String string) {
        this.fColorPickersPanel.setLayout((LayoutManager)new MGridLayout(0, 2, 20, 3, 131072));
        this.setLayout(new BorderLayout());
        this.add((Component)this.fColorPickersPanel, "Center");
        if (string != null) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(string);
            this.setBorder(titledBorder);
        }
    }

    private static ColorPicker createPicker(String string, String string2) {
        ColorPicker colorPicker = new ColorPicker(ColorPicker.PickerIcon.NONE);
        colorPicker.setName(string2 + "Picker");
        colorPicker.getAccessibleContext().setAccessibleName(string + " " + BUNDLE.getString("gpcp.acc.ColorPicker"));
        return colorPicker;
    }

    ColorItem<MJLabel> addLabelItem(String string, SyntaxHighlightingColor syntaxHighlightingColor, ActionListener actionListener) {
        return this.addLabelItem(string, syntaxHighlightingColor.getPreferenceKey(), syntaxHighlightingColor.getCurrentColor(), actionListener);
    }

    public ColorItem<MJLabel> addLabelItem(String string, String string2, Color color, ActionListener actionListener) {
        ColorPicker colorPicker = SyntaxHighlightingColorPanel.createPicker(string, string2);
        MJLabel mJLabel = new MJLabel(string);
        mJLabel.setName(string2 + "Label");
        ColorItem<MJLabel> colorItem = new ColorItem<MJLabel>(mJLabel, colorPicker, string2);
        this.addItem(colorItem, color, actionListener);
        return colorItem;
    }

    ColorItem<MJCheckBox> addCheckBoxColorItem(String string, String string2, Color color, ActionListener actionListener) {
        return this.addCheckBoxColorItem(string, string2, color, actionListener, true);
    }

    ColorItem<MJCheckBox> addCheckBoxColorItem(String string, String string2, Color color, ActionListener actionListener, boolean bl) {
        final ColorPicker colorPicker = SyntaxHighlightingColorPanel.createPicker(string, string2);
        final MJCheckBox mJCheckBox = new MJCheckBox(string);
        if (bl) {
            mJCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    colorPicker.setEnabled(mJCheckBox.isSelected());
                }
            });
        }
        mJCheckBox.setName(string2 + "CheckBox");
        ColorItem<MJCheckBox> colorItem = new ColorItem<MJCheckBox>(mJCheckBox, colorPicker, string2);
        this.addItem(colorItem, color, actionListener);
        return colorItem;
    }

    MJCheckBox addCheckBox(String string, String string2) {
        MJCheckBox mJCheckBox = new MJCheckBox(string);
        mJCheckBox.setName(string2 + "CheckBox");
        this.fColorPickersPanel.add((Component)mJCheckBox);
        ++this.fNumEntries;
        return mJCheckBox;
    }

    private void addItem(ColorItem<?> colorItem, Color color, ActionListener actionListener) {
        this.fColorVector.add(colorItem);
        colorItem.getColorPicker().setValue((Object)color);
        colorItem.getColorPicker().addActionListener(actionListener);
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add(colorItem.getComponent(), (Object)"Center");
        mJPanel.add((Component)colorItem.getColorPicker(), (Object)"East");
        this.fColorPickersPanel.add((Component)mJPanel);
        ++this.fNumEntries;
    }

    int getNumEntries() {
        return this.fNumEntries;
    }

    Color getColor(int n) {
        ColorItem<?> colorItem = this.fColorVector.get(n);
        ColorPicker colorPicker = colorItem.getColorPicker();
        return (Color)colorPicker.getValue();
    }

    void setColor(int n, Color color) {
        ColorItem<?> colorItem = this.fColorVector.get(n);
        ColorPicker colorPicker = colorItem.getColorPicker();
        colorPicker.setValue((Object)color);
    }

    String getPrefsKey(int n) {
        ColorItem<?> colorItem = this.fColorVector.get(n);
        return colorItem.getPrefsKey();
    }

    public void setEnabled(boolean bl) {
        for (ColorItem<?> colorItem : this.fColorVector) {
            colorItem.setEnabled(bl);
        }
    }

    JTextComponent addLabel(String string) {
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(string, true);
        this.add((Component)mJMultilineLabel, "South");
        return mJMultilineLabel;
    }
}

