/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.shortcuts;

import com.mathworks.mlwidgets.shortcuts.ShortcutEditor;
import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.util.Log;
import java.awt.Component;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;

public class ShortcutDropListener
implements DropTargetListener {
    private final String fCategory;
    private final boolean fPreselectQuickAccess;
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.shortcuts.resources.RES_Shortcuts");

    public ShortcutDropListener() {
        this(null);
    }

    public ShortcutDropListener(String string) {
        this(string, false);
    }

    public ShortcutDropListener(String string, boolean bl) {
        this.fPreselectQuickAccess = bl;
        this.fCategory = string;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor) || dropTargetDragEvent.isDataFlavorSupported(DataFlavor.plainTextFlavor)) {
            dropTargetDragEvent.acceptDrag(1);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.stringFlavor) || dropTargetDragEvent.isDataFlavorSupported(DataFlavor.plainTextFlavor)) {
            dropTargetDragEvent.acceptDrag(1);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            Window window;
            dropTargetDropEvent.acceptDrop(3);
            Transferable transferable = dropTargetDropEvent.getTransferable();
            String string = null;
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
            Window window2 = window = dropTargetDropEvent.getSource() instanceof Component ? SwingUtilities.windowForComponent((Component)dropTargetDropEvent.getSource()) : null;
            if (window != null) {
                GlobalCursor.setWait((Window)window);
            }
            ShortcutEditor.invoke(sRes.getString("shortcut.AddTitle"), null, string, null, this.fCategory, true, this.fPreselectQuickAccess);
            if (window != null) {
                GlobalCursor.clear((Window)window);
            }
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }
}

