/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.shortcuts;

import com.mathworks.common.icons.IconEnumerationUtils;
import com.mathworks.common.icons.ShortcutIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.shortcuts.Shortcut;
import com.mathworks.mlwidgets.shortcuts.ShortcutDropListener;
import com.mathworks.mlwidgets.shortcuts.ShortcutEditor;
import com.mathworks.mlwidgets.shortcuts.ShortcutUtils;
import com.mathworks.mlwidgets.shortcuts.ShortcutsOrganizer;
import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.IconSet;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripSection;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.accessories.QuickAccessToolBar;
import com.mathworks.toolstrip.accessories.TSContextMenuContributor;
import com.mathworks.toolstrip.accessories.TSRobot;
import com.mathworks.toolstrip.components.TSUtil;
import com.mathworks.toolstrip.factory.QuickAccessConfiguration;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.factory.TSRegistry;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolPath;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.toolstrip.factory.TSToolSetContents;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTToolBarCustomizationPanel;
import com.mathworks.widgets.desk.ToolstripInfoRegistrar;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ShortcutsToolstripTabFactory {
    private static final ResourceBundle sRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.shortcuts.resources.RES_Shortcuts");
    public static final String TAB_NAME = "shortcuts";
    public static final String TOOL_SET_NAME = "matlab_shortcut_toolset";
    public static final String NEW_SHORTCUT_TOOL_NAME = "new_shortcut";
    public static final String ORGANIZE_TOOL_NAME = "organize_shortcuts";
    public static final String QUICK_ACCESS_TOOL_NAME = "quick_access";
    public static final String MANAGE_SECTION_NAME = "house_keeping";
    private static final String GENERAL_SECTION_NAME = "general";
    private static final String NO_CATEGORY = sRes.getString("node.category.None");
    private static final String MATLAB_TOOLBAR_CATEGORY = sRes.getString("xml.Toolbar");
    private static final String HELP_CATEGORY = sRes.getString("xml.Help");
    private static final String[] SUPRESSED_LABELS = new String[]{sRes.getString("toolbar.Default"), sRes.getString("toolbar.WhatsNew"), sRes.getString("invisible.Default")};
    private static final Matlab sMatlab = Matlab.isMatlabAvailable() ? new Matlab() : null;
    private static TSToolSet sToolSet = ShortcutsToolstripTabFactory.createToolSet();
    private static TSTabConfiguration sTabConfig = ShortcutsToolstripTabFactory.createTabConfig();
    private static TSRegistry sRegistry;
    private static ToolstripTab sTab;
    private static List<ChangeListener> sChangeListeners;

    private ShortcutsToolstripTabFactory() {
    }

    public static ToolstripTab getTab() {
        if (sTab == null) {
            sTab = ShortcutsToolstripTabFactory.createTab();
        }
        return sTab;
    }

    public static boolean isTabEmpty() {
        String[] stringArray;
        for (String string : stringArray = ShortcutUtils.getShortcutCategories()) {
            if (!ShortcutsToolstripTabFactory.isCategoryIncluded(string) || ShortcutsToolstripTabFactory.getShortcutsInCategory(string).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static void addChangeListener(ChangeListener changeListener) {
        sChangeListeners.add(changeListener);
    }

    public static void removeChangeListener(ChangeListener changeListener) {
        sChangeListeners.remove(changeListener);
    }

    private static void fireChangeListeners() {
        ChangeEvent changeEvent = new ChangeEvent(ShortcutsToolstripTabFactory.class);
        for (ChangeListener changeListener : sChangeListeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private static ToolstripTab createTab() {
        ToolstripTab toolstripTab = TSFactory.createTab((TSTabConfiguration)sTabConfig, (TSToolSet[])new TSToolSet[]{sToolSet});
        for (ToolstripSection toolstripSection : toolstripTab.getModel()) {
            String string = toolstripSection.getName();
            if (MANAGE_SECTION_NAME.equals(string) || GENERAL_SECTION_NAME.equals(string)) {
                string = null;
            }
            new DropTarget(toolstripSection.getComponent(), new ShortcutDropListener(string));
        }
        return toolstripTab;
    }

    private static TSToolSet createToolSet() {
        TSToolSetContents tSToolSetContents = new TSToolSetContents(TOOL_SET_NAME, sRes);
        TSToolSet tSToolSet = new TSToolSet(tSToolSetContents);
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters(NEW_SHORTCUT_TOOL_NAME).setIcon((Icon)new IconSet(new Icon[]{ShortcutIcon.NEW_16.getIcon(), ShortcutIcon.NEW_24.getIcon()})), new TSToolSetContents.Dependency[0]);
        tSToolSet.configureAndAdd(NEW_SHORTCUT_TOOL_NAME, (Action)((Object)new CreateAction()));
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters(ORGANIZE_TOOL_NAME).setIcon((Icon)new IconSet(new Icon[]{ShortcutIcon.ORGANIZE_16.getIcon(), ShortcutIcon.ORGANIZE_24.getIcon()})), new TSToolSetContents.Dependency[0]);
        tSToolSet.configureAndAdd(ORGANIZE_TOOL_NAME, (Action)((Object)new OrganizeAction()));
        tSToolSetContents.addTool(new TSToolSetContents.ToolParameters(QUICK_ACCESS_TOOL_NAME).setIcon((Icon)new IconSet(new Icon[]{IconEnumerationUtils.getIcon((String)"settings_ts_16.png"), IconEnumerationUtils.getIcon((String)"settings_ts_24.png")})), new TSToolSetContents.Dependency[0]);
        tSToolSet.configureAndAdd(QUICK_ACCESS_TOOL_NAME, (Action)((Object)new AddToQuickAccessAction()));
        ShortcutsToolstripTabFactory.addShortcutsToToolSet(tSToolSet);
        return tSToolSet;
    }

    private static TSTabConfiguration createTabConfig() {
        TSTabConfiguration tSTabConfiguration = new TSTabConfiguration(TAB_NAME, sRes, TOOL_SET_NAME);
        tSTabConfiguration.addSection(MANAGE_SECTION_NAME, null, TSTabConfiguration.SectionLayoutType.FIXED);
        tSTabConfiguration.addTool(MANAGE_SECTION_NAME, new TSTabConfiguration.ToolParameters(NEW_SHORTCUT_TOOL_NAME));
        tSTabConfiguration.addTool(MANAGE_SECTION_NAME, new TSTabConfiguration.ToolParameters(ORGANIZE_TOOL_NAME));
        tSTabConfiguration.addTool(MANAGE_SECTION_NAME, new TSTabConfiguration.ToolParameters(QUICK_ACCESS_TOOL_NAME));
        ShortcutsToolstripTabFactory.addShortcutsToTabConfig(tSTabConfiguration);
        return tSTabConfiguration;
    }

    private static void addShortcutsToToolSet(TSToolSet tSToolSet) {
        String[] stringArray;
        int n = 0;
        for (String string : stringArray = ShortcutUtils.getShortcutCategories()) {
            if (!ShortcutsToolstripTabFactory.isCategoryIncluded(string)) continue;
            List<Shortcut> list = ShortcutsToolstripTabFactory.getShortcutsInCategory(string);
            for (Shortcut shortcut : list) {
                ShortcutsToolstripTabFactory.addShortcutToToolSet(tSToolSet, shortcut, string, n++);
            }
        }
    }

    private static void addShortcutToToolSet(TSToolSet tSToolSet, Shortcut shortcut, String string, int n) {
        String string2 = shortcut.getLabel();
        String string3 = TSUtil.getSequentialMnemonic((int)n);
        if (string3 != null && string3.length() > 0) {
            string2 = string2 + "[" + string3 + "]";
        }
        tSToolSet.getContents().addTool(new TSToolSetContents.ToolParameters(shortcut.getLabel()).setLabel(string2).setIcon((Icon)shortcut.getIcon()).setDescription(shortcut.getToolTip()), new TSToolSetContents.Dependency[0]);
        tSToolSet.configureAndAdd(shortcut.getLabel(), (Action)((Object)new ShortcutAction(shortcut, string)));
    }

    private static void addShortcutsToTabConfig(TSTabConfiguration tSTabConfiguration) {
        String[] stringArray;
        List<Shortcut> list = ShortcutsToolstripTabFactory.getShortcutsInCategory(MATLAB_TOOLBAR_CATEGORY);
        list.addAll(ShortcutsToolstripTabFactory.getShortcutsInCategory(NO_CATEGORY));
        if (!list.isEmpty()) {
            tSTabConfiguration.addSection(GENERAL_SECTION_NAME, null, TSTabConfiguration.SectionLayoutType.FIXED);
            ShortcutsToolstripTabFactory.addShortcutsToSection(tSTabConfiguration, GENERAL_SECTION_NAME, list);
        }
        for (String string : stringArray = ShortcutUtils.getShortcutCategories()) {
            if (string.equals(MATLAB_TOOLBAR_CATEGORY) || string.equals(NO_CATEGORY) || string.equals(HELP_CATEGORY) || (list = ShortcutsToolstripTabFactory.getShortcutsInCategory(string)).isEmpty()) continue;
            tSTabConfiguration.addSection(string, string, TSTabConfiguration.SectionLayoutType.FIXED);
            ShortcutsToolstripTabFactory.addShortcutsToSection(tSTabConfiguration, string, list);
        }
    }

    private static boolean isCategoryIncluded(String string) {
        return !string.equals(HELP_CATEGORY);
    }

    private static List<Shortcut> getShortcutsInCategory(String string) {
        Vector vector = ShortcutUtils.getShortcutsByCategory(string);
        if (vector == null) {
            return new ArrayList<Shortcut>();
        }
        ArrayList<Shortcut> arrayList = new ArrayList<Shortcut>(vector.size());
        for (Object e : vector) {
            Shortcut shortcut = (Shortcut)e;
            boolean bl = false;
            for (String string2 : SUPRESSED_LABELS) {
                if (!string2.equals(shortcut.getLabel())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(shortcut);
        }
        return arrayList;
    }

    private static void addShortcutsToSection(TSTabConfiguration tSTabConfiguration, String string, List<Shortcut> list) {
        int n = 0;
        for (Shortcut shortcut : list) {
            if (n == 3) {
                tSTabConfiguration.addSeparator(string);
                n = 0;
            }
            if (tSTabConfiguration.findTool(string, shortcut.getLabel(), TOOL_SET_NAME) != null) continue;
            tSTabConfiguration.addTool(string, new TSTabConfiguration.ToolParameters(shortcut.getLabel()));
            ++n;
        }
    }

    static boolean isQuickAccessToolBarPresent() {
        return true;
    }

    static boolean isOnQuickAccessToolBar(String string, String string2) {
        return string != null && ShortcutsToolstripTabFactory.getQuickAccessConfiguration().containsTool(ShortcutsToolstripTabFactory.getPathToShortcut(string, string2));
    }

    static boolean isLabelVisible(String string, String string2) {
        return string != null && ShortcutsToolstripTabFactory.getQuickAccessConfiguration().isLabelVisible(ShortcutsToolstripTabFactory.getPathToShortcut(string, string2));
    }

    private static TSToolPath getPathToShortcut(String string, String string2) {
        String string3 = string2 == null || string2.length() == 0 || string2.equals(NO_CATEGORY) || string2.equals(MATLAB_TOOLBAR_CATEGORY) ? GENERAL_SECTION_NAME : string2;
        TSToolPath tSToolPath = new TSToolPath(TAB_NAME, string3);
        return tSToolPath.appendTool(string, TOOL_SET_NAME);
    }

    static void updateQuickAccessToolBar(String string, String string2, boolean bl, boolean bl2) {
        if (string == null) {
            return;
        }
        TSToolPath tSToolPath = ShortcutsToolstripTabFactory.getPathToShortcut(string, string2);
        QuickAccessConfiguration quickAccessConfiguration = ShortcutsToolstripTabFactory.getQuickAccessConfiguration();
        boolean bl3 = quickAccessConfiguration.containsTool(tSToolPath);
        if (bl != bl3) {
            if (bl) {
                QuickAccessToolBar quickAccessToolBar = ShortcutsToolstripTabFactory.getQuickAccessToolBar();
                if (quickAccessToolBar == null || quickAccessToolBar.getGrowthEnd() == 2) {
                    quickAccessConfiguration.insertTool(0, tSToolPath);
                } else {
                    quickAccessConfiguration.addTool(tSToolPath);
                }
            } else {
                quickAccessConfiguration.removeTool(tSToolPath);
            }
        }
        if (bl) {
            quickAccessConfiguration.setLabelVisible(tSToolPath, bl2);
        }
    }

    private static QuickAccessConfiguration getQuickAccessConfiguration() {
        return MatlabDesktopServices.getDesktop().getQuickAccessConfiguration();
    }

    private static QuickAccessToolBar getQuickAccessToolBar() {
        DTFrame dTFrame = MatlabDesktopServices.getDesktop().getMainFrame();
        if (dTFrame == null) {
            return null;
        }
        Toolstrip toolstrip = dTFrame.getToolstrip();
        return toolstrip == null ? null : TSRobot.getQuickAccessToolBar((Toolstrip)toolstrip);
    }

    static {
        sChangeListeners = new ArrayList<ChangeListener>();
        ShortcutUtils.addFavoritesListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShortcutUtils.ShortcutEvent shortcutEvent = (ShortcutUtils.ShortcutEvent)actionEvent;
                if (HELP_CATEGORY.equals(shortcutEvent.getCategory()) && (shortcutEvent.getOldCategory() == null || HELP_CATEGORY.equals(shortcutEvent.getOldCategory()))) {
                    return;
                }
                if (shortcutEvent.getType() == 1) {
                    String string = shortcutEvent.getName();
                    String string2 = shortcutEvent.getCategory();
                    if (MATLAB_TOOLBAR_CATEGORY.equals(string2) || NO_CATEGORY.equals(string2)) {
                        string2 = ShortcutsToolstripTabFactory.GENERAL_SECTION_NAME;
                    }
                    sTabConfig.removeTool(string2, string, ShortcutsToolstripTabFactory.TOOL_SET_NAME);
                    TSTabConfiguration.Section section = sTabConfig.getSection(string2);
                    if (section != null && section.isEmpty()) {
                        sTabConfig.removeSection(string2);
                    }
                    sToolSet.getContents().removeTool(string, new TSToolSetContents.Dependency[0]);
                    sToolSet.removeAction(string);
                } else {
                    sToolSet = ShortcutsToolstripTabFactory.createToolSet();
                    sTabConfig = ShortcutsToolstripTabFactory.createTabConfig();
                }
                if (sRegistry != null) {
                    sRegistry.replaceTabConfiguration(sTabConfig);
                    sRegistry.replaceToolSetContents(sToolSet.getContents());
                    sRegistry.replaceToolSet(sToolSet);
                }
                sTab = null;
                ShortcutsToolstripTabFactory.fireChangeListeners();
            }
        });
    }

    private static class DeleteAction
    extends MJAbstractAction {
        private final Shortcut iShortcut;
        private final String iCategory;

        DeleteAction(Shortcut shortcut, String string) {
            super(sRes.getString("action.RemoveFav"));
            this.iShortcut = shortcut;
            this.iCategory = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.iShortcut.getLabel();
            Object[] objectArray = new String[]{string};
            String string2 = MessageFormat.format(sRes.getString("shortcut.ConfirmDelete"), objectArray);
            Component component = actionEvent.getSource() instanceof Component ? (Component)actionEvent.getSource() : null;
            int n = JOptionPane.showConfirmDialog(component, string2, sRes.getString("shortcut.ConfirmDeleteTitle"), 2);
            if (n == 0) {
                ShortcutUtils.removeShortcut(this.iCategory, string);
            }
        }
    }

    private static class EditAction
    extends MJAbstractAction {
        private final Shortcut iShortcut;
        private final String iCategory;

        EditAction(Shortcut shortcut, String string) {
            super(sRes.getString("action.EditFav"));
            this.iShortcut = shortcut;
            this.iCategory = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = null;
            Window window = null;
            if (actionEvent.getSource() instanceof Component) {
                component = (Component)actionEvent.getSource();
                window = SwingUtilities.windowForComponent(component);
            }
            if (window != null) {
                GlobalCursor.setWait(window);
            }
            ShortcutEditor.setInvoker(component);
            ShortcutEditor.invoke(null, this.iShortcut.getLabel(), this.iShortcut.getCallback(), this.iShortcut.getIconPath(), this.iCategory, false, false);
            if (window != null) {
                GlobalCursor.clear((Window)window);
            }
        }
    }

    private static class AddToQuickAccessAction
    extends MJAbstractAction {
        private AddToQuickAccessAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MatlabDesktopServices.getDesktop().showToolBarCustomizationPanel("QUICK_ACCESS_PANEL");
            DTToolBarCustomizationPanel.getQuickAccessCustomizationPanel().expandNode(sRes.getString("Tab.shortcuts.Label"));
        }
    }

    private static class OrganizeAction
    extends MJAbstractAction {
        private OrganizeAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Frame frame = null;
            if (actionEvent.getSource() instanceof Component) {
                frame = WindowUtils.getFrameForComponent((Component)((Component)actionEvent.getSource()));
            }
            ShortcutsOrganizer.invoke(frame);
        }
    }

    public static class CreateAction
    extends MJAbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            Component component = null;
            if (actionEvent.getSource() instanceof Component) {
                component = (Component)actionEvent.getSource();
                QuickAccessToolBar quickAccessToolBar = ShortcutsToolstripTabFactory.getQuickAccessToolBar();
                if (quickAccessToolBar != null) {
                    bl = SwingUtilities.isDescendingFrom(component, (Component)quickAccessToolBar.getComponent());
                }
            }
            ShortcutEditor.setInvoker(component);
            ShortcutEditor.invoke(null, null, "", null, "", true, bl);
        }
    }

    private static class ShortcutAction
    extends MJAbstractAction
    implements TSContextMenuContributor {
        private final Shortcut iShortcut;
        private final String iCategory;

        ShortcutAction(Shortcut shortcut, String string) {
            this.iShortcut = shortcut;
            this.iCategory = string;
            this.putValue("toolstrip-context-menu-contributor", (Object)this);
            this.putValue("cash_ts_component", false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (sMatlab != null) {
                sMatlab.evalConsoleOutput(this.iShortcut.getCallback());
            }
        }

        public void contributeToToolsripContextMenu(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
            jPopupMenu.insert((Action)((Object)new DeleteAction(this.iShortcut, this.iCategory)), 0);
            jPopupMenu.insert((Action)((Object)new EditAction(this.iShortcut, this.iCategory)), 0);
        }
    }

    public static class Registrar
    implements ToolstripInfoRegistrar {
        public void registerToolstripInfo(TSRegistry tSRegistry) {
            tSRegistry.addTabConfiguration(sTabConfig);
            tSRegistry.addToolSetContents(sToolSet.getContents());
            tSRegistry.addToolSet(sToolSet);
            sRegistry = tSRegistry;
        }
    }
}

