/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.workspace;

import com.mathworks.widgets.recordlist.IRecordFilter;

public final class WorkspaceFilter
implements IRecordFilter {
    private static final int CLASS_DOUBLE = 1;
    private static final int CLASS_NUMERIC = 50;
    private static final int CLASS_LOGICAL = 2;
    private static final int CLASS_COMPLEX = 51;
    private static final int CLASS_SPARSE = 52;
    private static final int SIZE_SCALAR = 100;
    private static final int SIZE_ROW = 101;
    private static final int SIZE_COLUMN = 102;
    private static final int SIZE_2D = 103;
    private static final int SIZE_EMPTY = 104;
    private static IRecordFilter sNumericFilter = null;
    private static IRecordFilter sDoubleFilter = null;
    private static IRecordFilter sLogicalFilter = null;
    private static IRecordFilter sComplexFilter = null;
    private static IRecordFilter sSparseFilter = null;
    private static IRecordFilter sScalarFilter = null;
    private static IRecordFilter sRowFilter = null;
    private static IRecordFilter sColumnFilter = null;
    private static IRecordFilter s2DFilter = null;
    private static IRecordFilter sEmptyFilter = null;
    private int fCode = 0;
    public static final int ROWS = 1;
    public static final int COLUMNS = 2;
    public static final int PAGES = 3;

    private WorkspaceFilter(int n) {
        this.fCode = n;
    }

    public final boolean accept(Object object) {
        boolean bl = false;
        if (object instanceof String) {
            String string = (String)object;
            switch (this.fCode) {
                case 1: {
                    bl = WorkspaceFilter.pDouble(string);
                    break;
                }
                case 2: {
                    bl = WorkspaceFilter.pLogical(string);
                    break;
                }
                case 51: {
                    bl = WorkspaceFilter.pComplex(string);
                    break;
                }
                case 52: {
                    bl = WorkspaceFilter.pSparse(string);
                    break;
                }
                case 50: {
                    bl = WorkspaceFilter.pNumeric(string);
                    break;
                }
                case 100: {
                    bl = WorkspaceFilter.pScalar(string);
                    break;
                }
                case 101: {
                    bl = WorkspaceFilter.pRow(string);
                    break;
                }
                case 102: {
                    bl = WorkspaceFilter.pColumn(string);
                    break;
                }
                case 103: {
                    bl = WorkspaceFilter.p2D(string);
                    break;
                }
                case 104: {
                    bl = WorkspaceFilter.pEmpty(string);
                }
            }
        }
        return bl;
    }

    public static IRecordFilter getDoubleFilter() {
        if (sDoubleFilter == null) {
            sDoubleFilter = new WorkspaceFilter(1);
        }
        return sDoubleFilter;
    }

    public static IRecordFilter getLogicalFilter() {
        if (sLogicalFilter == null) {
            sLogicalFilter = new WorkspaceFilter(2);
        }
        return sLogicalFilter;
    }

    public static IRecordFilter getComplexFilter() {
        if (sComplexFilter == null) {
            sComplexFilter = new WorkspaceFilter(51);
        }
        return sComplexFilter;
    }

    public static IRecordFilter getSparseFilter() {
        if (sSparseFilter == null) {
            sSparseFilter = new WorkspaceFilter(52);
        }
        return sSparseFilter;
    }

    public static IRecordFilter getNumericFilter() {
        if (sNumericFilter == null) {
            sNumericFilter = new WorkspaceFilter(50);
        }
        return sNumericFilter;
    }

    public static IRecordFilter getScalarFilter() {
        if (sScalarFilter == null) {
            sScalarFilter = new WorkspaceFilter(100);
        }
        return sScalarFilter;
    }

    public static IRecordFilter getRowFilter() {
        if (sRowFilter == null) {
            sRowFilter = new WorkspaceFilter(101);
        }
        return sRowFilter;
    }

    public static IRecordFilter getColumnFilter() {
        if (sColumnFilter == null) {
            sColumnFilter = new WorkspaceFilter(102);
        }
        return sColumnFilter;
    }

    public static IRecordFilter get2DFilter() {
        if (s2DFilter == null) {
            s2DFilter = new WorkspaceFilter(103);
        }
        return s2DFilter;
    }

    public static IRecordFilter getLengthDimensionFilter(int n, int n2) {
        return new LengthDimensionFilter(n, n2);
    }

    public static IRecordFilter getEmptyFilter() {
        if (sEmptyFilter == null) {
            sEmptyFilter = new WorkspaceFilter(104);
        }
        return sEmptyFilter;
    }

    private static int getNumOfXs(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != 'x') continue;
            ++n;
        }
        return n;
    }

    private static boolean pDouble(String string) {
        return string.startsWith("double");
    }

    private static boolean pLogical(String string) {
        return string.startsWith("logical");
    }

    private static boolean pComplex(String string) {
        return string.contains("(complex)");
    }

    private static boolean pSparse(String string) {
        return string.contains("(sparse)");
    }

    private static boolean pNumeric(String string) {
        return WorkspaceFilter.pDouble(string) || string.startsWith("uint8") || string.startsWith("uint16") || string.startsWith("uint32") || string.startsWith("uint64") || string.startsWith("int8") || string.startsWith("int16") || string.startsWith("int32") || string.startsWith("int64") || string.startsWith("single");
    }

    private static boolean pScalar(String string) {
        return "1x1".equals(string);
    }

    private static boolean pColumn(String string) {
        return string.endsWith("x1") && !WorkspaceFilter.pScalar(string) && WorkspaceFilter.getNumOfXs(string) == 1 && !WorkspaceFilter.pEmpty(string);
    }

    private static boolean pRow(String string) {
        return string.startsWith("1x") && !WorkspaceFilter.pScalar(string) && WorkspaceFilter.getNumOfXs(string) == 1 && !WorkspaceFilter.pEmpty(string);
    }

    private static boolean p2D(String string) {
        return WorkspaceFilter.getNumOfXs(string) == 1 && !string.startsWith("1x") && !string.endsWith("x1") && !WorkspaceFilter.pEmpty(string);
    }

    private static boolean pEmpty(String string) {
        return string.startsWith("0x") || string.endsWith("x0") || string.contains("x0x");
    }

    private static class LengthDimensionFilter
    implements IRecordFilter {
        private int iLength;
        private int iDimension;

        private LengthDimensionFilter(int n, int n2) {
            if (n2 < 1) {
                throw new IllegalArgumentException(Integer.toString(n2) + " is not a legal MATLAB array dimension specification.");
            }
            if (n2 > 3) {
                throw new IllegalArgumentException("MATLAB array dimension specifiers supplied to this class must be < 4. " + Integer.toString(n2) + " is not an allowed value.");
            }
            this.iLength = n;
            this.iDimension = n2;
        }

        public boolean accept(Object object) {
            if (object instanceof String) {
                String string = (String)object;
                int n = WorkspaceFilter.getNumOfXs(string) + 1;
                if (n == 0) {
                    return false;
                }
                if (this.iDimension > n) {
                    return false;
                }
                switch (this.iDimension) {
                    case 1: {
                        return string.startsWith(Integer.toString(this.iLength) + "x");
                    }
                    case 2: {
                        if (n == 2) {
                            return string.endsWith("x" + Integer.toString(this.iLength));
                        }
                        return string.contains("x" + Integer.toString(this.iLength) + "x");
                    }
                    case 3: {
                        return string.endsWith("x" + Integer.toString(this.iLength));
                    }
                }
                return false;
            }
            return false;
        }

        public String toString() {
            return this.getClass().getName() + "(length " + this.iLength + " along dimension " + this.iDimension + ")";
        }
    }
}

