/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.state;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.scenario.effect.impl.state.GaussianBlurState;
import com.sun.scenario.effect.impl.state.LinearConvolveKernel;
import java.nio.FloatBuffer;

public class MotionBlurState
extends LinearConvolveKernel {
    private float radius;
    private float angle;
    private FloatBuffer weights;

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float f) {
        if (f < 0.0f || f > 63.0f) {
            throw new IllegalArgumentException("Radius must be in the range [1,63]");
        }
        this.radius = f;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setAngle(float f) {
        this.angle = f;
    }

    public int getHPad() {
        return (int)Math.ceil(Math.abs(Math.cos(this.angle)) * (double)this.radius);
    }

    public int getVPad() {
        return (int)Math.ceil(Math.abs(Math.sin(this.angle)) * (double)this.radius);
    }

    @Override
    public int getNumberOfPasses() {
        return 1;
    }

    @Override
    public boolean isNop() {
        return this.radius == 0.0f;
    }

    @Override
    public boolean isNop(int n) {
        return n > 0 || this.radius == 0.0f;
    }

    @Override
    public int getKernelSize(int n) {
        return (int)Math.ceil(this.radius) * 2 + 1;
    }

    @Override
    public final Rectangle getResultBounds(Rectangle rectangle, int n) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.grow(this.getHPad(), this.getVPad());
        return rectangle2;
    }

    @Override
    public float[] getVector(Rectangle rectangle, BaseTransform baseTransform, int n) {
        float[] fArray = new float[4];
        float f = (float)Math.cos(this.angle);
        float f2 = (float)Math.sin(this.angle);
        if (!baseTransform.isTranslateOrIdentity()) {
            fArray[0] = f;
            fArray[1] = f2;
            try {
                baseTransform.inverseDeltaTransform(fArray, 0, fArray, 0, 1);
                f = fArray[0];
                f2 = fArray[1];
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                f = 0.0f;
                f2 = 0.0f;
            }
        }
        float f3 = f / (float)rectangle.width;
        float f4 = f2 / (float)rectangle.height;
        int n2 = this.getScaledKernelSize(n);
        int n3 = n2 / 2;
        fArray[0] = f3;
        fArray[1] = f4;
        fArray[2] = (float)(-n3) * f3;
        fArray[3] = (float)(-n3) * f4;
        return fArray;
    }

    @Override
    public FloatBuffer getWeights(int n) {
        int n2 = (int)Math.ceil(this.radius);
        this.weights = GaussianBlurState.getGaussianWeights(this.weights, n2, this.radius, 0.0f);
        return this.weights;
    }
}

