/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.tools.ant.util.FileUtils;

public class StreamPumper
implements Runnable {
    private static final int SMALL_BUFFER_SIZE = 128;
    private final InputStream is;
    private final OutputStream os;
    private volatile boolean finish;
    private volatile boolean finished;
    private final boolean closeWhenExhausted;
    private boolean autoflush = false;
    private Exception exception = null;
    private int bufferSize = 128;
    private boolean started = false;
    private final boolean useAvailable;
    private static final long POLL_INTERVAL = 100L;

    public StreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted) {
        this(is, os, closeWhenExhausted, false);
    }

    public StreamPumper(InputStream is, OutputStream os, boolean closeWhenExhausted, boolean useAvailable) {
        this.is = is;
        this.os = os;
        this.closeWhenExhausted = closeWhenExhausted;
        this.useAvailable = useAvailable;
    }

    public StreamPumper(InputStream is, OutputStream os) {
        this(is, os, false);
    }

    void setAutoflush(boolean autoflush) {
        this.autoflush = autoflush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StreamPumper streamPumper = this;
        synchronized (streamPumper) {
            this.started = true;
        }
        this.finished = false;
        this.finish = false;
        byte[] buf = new byte[this.bufferSize];
        try {
            while (true) {
                int length;
                this.waitForInput(this.is);
                if (this.finish || Thread.interrupted() || (length = this.is.read(buf)) <= 0 || this.finish || Thread.interrupted()) break;
                this.os.write(buf, 0, length);
                if (!this.autoflush) continue;
                this.os.flush();
            }
            this.os.flush();
        }
        catch (InterruptedException ie2) {
            if (this.closeWhenExhausted) {
                FileUtils.close(this.os);
            }
            this.finished = true;
            StreamPumper ie2 = this;
            synchronized (ie2) {
                this.notifyAll();
            }
        }
        catch (Exception e) {
            StreamPumper streamPumper2 = this;
            synchronized (streamPumper2) {
                this.exception = e;
            }
        }
        finally {
            if (this.closeWhenExhausted) {
                FileUtils.close(this.os);
            }
            this.finished = true;
            StreamPumper streamPumper3 = this;
            synchronized (streamPumper3) {
                this.notifyAll();
            }
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public synchronized void waitFor() throws InterruptedException {
        while (!this.isFinished()) {
            this.wait();
        }
    }

    public synchronized void setBufferSize(int bufferSize) {
        if (this.started) {
            throw new IllegalStateException("Cannot set buffer size on a running StreamPumper");
        }
        this.bufferSize = bufferSize;
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    public synchronized Exception getException() {
        return this.exception;
    }

    synchronized void stop() {
        this.finish = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInput(InputStream is) throws IOException, InterruptedException {
        if (this.useAvailable) {
            while (!this.finish && is.available() == 0) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                StreamPumper streamPumper = this;
                synchronized (streamPumper) {
                    this.wait(100L);
                }
            }
        }
    }
}

