/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.storage.hdfs;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public final class ConfigurationSingleton {
    public static final String HADOOP_USERNAME_CONFIGURATION_NAME = "mathworks.hdfs.username";
    private static final String HADOOP_USERNAME_VARIABLE = "HADOOP_USER_NAME";
    private static Configuration fConfiguration;

    private static void disableLog4JLogging(String classname) {
        try {
            Log log = LogFactory.getLog((String)classname);
            if (log instanceof Log4JLogger) {
                Logger log4jLogger = ((Log4JLogger)log).getLogger();
                log4jLogger.setLevel(Level.FATAL);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Configuration get() {
        if (fConfiguration == null) {
            ConfigurationSingleton.createDefaultConfiguration();
        }
        return fConfiguration;
    }

    public static void set(Configuration conf) {
        if (conf != null) {
            ConfigurationSingleton.initializeConfigurationForHDFS(conf);
        }
        fConfiguration = conf;
    }

    public static FileSystem getFileSystem(URI uri) throws IOException, InterruptedException {
        String username = ConfigurationSingleton.getAuthUsername();
        if (username == null || username.isEmpty()) {
            return FileSystem.get((URI)uri, (Configuration)ConfigurationSingleton.get());
        }
        return FileSystem.get((URI)uri, (Configuration)ConfigurationSingleton.get(), (String)username);
    }

    private static String getAuthUsername() {
        Configuration conf = ConfigurationSingleton.get();
        String username = conf.get(HADOOP_USERNAME_CONFIGURATION_NAME);
        if (username == null) {
            username = System.getenv(HADOOP_USERNAME_VARIABLE);
        }
        return username;
    }

    private static void createDefaultConfiguration() {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.group.mapping", "org.apache.hadoop.security.JniBasedUnixGroupsMappingWithFallback");
        ConfigurationSingleton.set(conf);
    }

    private static void initializeConfigurationForHDFS(Configuration conf) {
        conf.setClassLoader(Configuration.class.getClassLoader());
        conf.set("fs.file.impl", "org.apache.hadoop.fs.LocalFileSystem");
        conf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.hadoop.util", "fatal");
        ConfigurationSingleton.disableLog4JLogging("org.apache.hadoop.util.NativeCodeLoader");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.hadoop.io.compress.CodecPool", "error");
        ConfigurationSingleton.disableLog4JLogging("org.apache.hadoop.io.compress.CodecPool");
        fConfiguration = null;
    }
}

