/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.ext.awt.image.spi.ImageWriter;
import org.apache.batik.ext.awt.image.spi.ImageWriterParams;
import org.apache.batik.ext.awt.image.spi.ImageWriterRegistry;
import org.apache.batik.svggen.AbstractImageHandlerEncoder;
import org.apache.batik.svggen.SVGGraphics2DIOException;

public class ImageHandlerJPEGEncoder
extends AbstractImageHandlerEncoder {
    public ImageHandlerJPEGEncoder(String string, String string2) throws SVGGraphics2DIOException {
        super(string, string2);
    }

    @Override
    public final String getSuffix() {
        return ".jpg";
    }

    @Override
    public final String getPrefix() {
        return "jpegImage";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeImage(BufferedImage bufferedImage, File file) throws SVGGraphics2DIOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            ImageWriter imageWriter = ImageWriterRegistry.getInstance().getWriterFor("image/jpeg");
            ImageWriterParams imageWriterParams = new ImageWriterParams();
            imageWriterParams.setJPEGQuality(1.0f, false);
            imageWriter.writeImage((RenderedImage)bufferedImage, (OutputStream)fileOutputStream, imageWriterParams);
        }
        catch (IOException iOException) {
            throw new SVGGraphics2DIOException("could not write image File " + file.getName());
        }
    }

    @Override
    public BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 1);
    }
}

