// Copyright 2014 MathWorks, Inc.

var webWidgetsLocation = "/ui/webwidgets/src/";
var webWidgetsJsMwLocation = webWidgetsLocation + "js/MW";
var webWidgetsL10nLocation = webWidgetsLocation + "l10n";

var addonsLocation = "/toolbox/matlab/addons/";
var addonsJsLocation = addonsLocation + "js";
var addonsL10nLocation = addonsLocation + "l10n-addons";
var addonsTemplatesLocation = addonsLocation + "templates-addons";
var addonsImagesLocation = addonsLocation + "images-addons";

var dojoConfig = {
    cacheBust: false,
    packages: [
        {name: "MW", location: webWidgetsJsMwLocation},
        {name: "l10n", location: webWidgetsL10nLocation},
        {name: "addons", location: addonsJsLocation},
        {name: "l10n-addons", location: addonsL10nLocation},
        {name: "templates-addons", location: addonsTemplatesLocation},
        {name: "images-addons", location: addonsImagesLocation}
    ],

    locale: function () {
        var localesSupported = ['en-us', 'ja-jp','zh-cn', 'ko-kr'];
        var locale = (navigator.language || navigator.userLanguage).toLowerCase();
        var splitLocale = locale.split('-',2);
        var i = localesSupported.indexOf(locale);
        if (i >= 0) {
            return localesSupported[i];
        }
        for(var splitIndex = 0;  splitIndex  < 2; splitIndex ++) {
            var testLocale = splitLocale[splitIndex] || splitLocale[0];
            for(i = 0; i < localesSupported.length; i++) {
                if (localesSupported[i].split('-')[splitIndex] === testLocale) {
                    return localesSupported[i];
                }
            }
        }
        return localesSupported[0];
    }()
};