/* Copyright 2014 The MathWorks, Inc. */
define([
    "addons/AddonsManager/AddonType"
],
    function (AddonType) {

        return {
            getAddonTypeFor: function (value) {
                for (var addonType in AddonType) {
                    if (AddonType.hasOwnProperty(addonType)) {
                        if (AddonType[addonType] === value) {
                            return addonType;
                        }
                    }
                }
            },

            _getFormattedDate: function (date) {
                if (date === "") {
                    return ""
                }
                else {
                    var m_names = new Array("January", "February", "March",
                        "April", "May", "June", "July", "August", "September",
                        "October", "November", "December");

                    var d = new Date(date);
                    var curr_date = d.getDate();
                    var curr_month = d.getMonth();
                    var curr_year = d.getFullYear();
                    var formattedDate = curr_date + " " + m_names[curr_month] + " " + curr_year;
                    return formattedDate;
                }
            }
        }
    });