% Specialized graphs.
%
% Specialized 2-D graphs.
%   area         - Filled area plot.
%   bar          - Bar graph.
%   barh         - Horizontal bar graph.
%   comet        - Comet-like trajectory.
%   compass      - Compass plot.
%   errorbar     - Error bar plot.
%   ezplot       - Easy to use function plotter.
%   ezpolar      - Easy to use polar coordinate plotter.
%   feather      - Feather plot.
%   fill         - Filled 2-D polygons.
%   fplot        - Plot function.
%   histogram    - Histogram.
%   pareto       - Pareto chart.
%   pie          - Pie chart.
%   plotmatrix   - Scatter plot matrix.
%   rose         - Angle histogram plot.
%   scatter      - Scatter plot.
%   stem         - Discrete sequence or "stem" plot.
%   stairs       - Stairstep plot.
% 
% Contour and 2-1/2 D graphs.
%   contour      - Contour plot.
%   contourc     - Contour computation.
%   contourf     - Filled contour plot.
%   contour3     - 3-D Contour plot.
%   clabel       - Contour plot elevation labels.
%   ezcontour    - Easy to use contour plotter.
%   ezcontourf   - Easy to use filled contour plotter.
%   pcolor       - Pseudocolor (checkerboard) plot.
%   voronoi      - Voronoi diagram.
%
% Specialized 3-D graphs.
%   bar3         - 3-D bar graph.
%   bar3h        - Horizontal 3-D bar graph.
%   comet3       - 3-D comet-like trajectories.
%   ezgraph3     - General purpose surface plotter.
%   ezmesh       - Easy to use 3-D mesh plotter.
%   ezmeshc      - Easy to use combination mesh/contour plotter.
%   ezplot3      - Easy to use 3-D parametric curve plotter.
%   ezsurf       - Easy to use 3-D colored surface plotter.
%   ezsurfc      - Easy to use combination surf/contour plotter.
%   meshc        - Combination mesh/contour plot.
%   meshz        - 3-D mesh with curtain.
%   pie3         - 3-D pie chart.
%   ribbon       - Draw 2-D lines as ribbons in 3-D.
%   scatter3     - 3-D scatter plot.
%   stem3        - 3-D stem plot.
%   surfc        - Combination surf/contour plot.
%   trisurf      - Triangular surface plot.
%   trimesh      - Triangular mesh plot.
%   waterfall    - Waterfall plot.
%
% Volume and vector visualization.
%   vissuite     - Visualization suite.
%   isosurface   - Isosurface extractor.
%   isonormals   - Isosurface normals.
%   isocaps      - Isosurface end caps.
%   isocolors    - Isosurface and patch colors.
%   contourslice - Contours in slice planes.
%   slice        - Volumetric slice plot.
%   streamline   - Streamlines from 2D or 3D vector data.
%   stream3      - 3D streamlines.
%   stream2      - 2D streamlines.
%   quiver3      - 3D quiver plot.
%   quiver       - 2D quiver plot.
%   divergence   - Divergence of a vector field.
%   curl         - Curl and angular velocity of a vector field.
%   coneplot     - 3D cone plot.
%   streamtube   - 3D stream tube.
%   streamribbon - 3D stream ribbon.
%   streamslice  - Streamlines in slice planes.
%   streamparticles   - Display stream particles.
%   interpstreamspeed - Interpolate streamline vertices from speed.
%   subvolume    - Extract subset of volume dataset.
%   reducevolume - Reduce volume dataset.
%   volumebounds - Returns x,y,z and color limits for volume data.
%   smooth3      - Smooth 3D data.
%   reducepatch  - Reduce number of patch faces.
%   shrinkfaces  - Reduce size of patch faces.
%
% Images display and file I/O.
%   image        - Display image.
%   imagesc      - Scale data and display as image.
%   colormap     - Color look-up table.
%   gray         - Linear gray-scale color map.
%   contrast     - Gray scale color map to enhance image contrast.
%   brighten     - Brighten or darken color map.
%   colorbar     - Display color bar (color scale).
%   imread       - Read image from graphics file.
%   imwrite      - Write image to graphics file.
%   imfinfo      - Information about graphics file.
%   im2java      - Convert image to Java image.
%
% Movies and animation.
%   getframe     - Get movie frame.
%   movie        - Play recorded movie frames.
%   rotate       - Rotate object about specified origin and direction.
%   frame2im     - Convert movie frame to indexed image.
%   im2frame     - Convert index image into movie format.
%
% Color related functions.
%   spinmap      - Spin color map.
%   rgbplot      - Plot color map.
%   colstyle     - Parse color and style from string.
%   ind2rgb      - Convert indexed image to RGB image.
%   rgb2ind      - Convert RGB image to indexed image.
%   dither       - Convert image using dithering.
%
% Solid modeling.
%   cylinder     - Generate cylinder.
%   sphere       - Generate sphere.
%   ellipsoid    - Generate ellipsoid.
%   patch        - Create patch.
%   surf2patch   - Convert surface data to patch data.
%
% See also GRAPH2D, GRAPH3D.

%   hist         - Histogram.

% Utilities.
%   makebars     - Make data for bar charts.
%   contours     - Contouring over non-rectangular surface (used by contour).
%

%   Copyright 1984-2014 The MathWorks, Inc. 
